## 03-安装

### 本节目录


- [1.安装python](#1安装python)
- [2.安装Miniconda/Anaconda](#2安装minicondaanaconda)
  - [2.1 安装Miniconda](#21-安装miniconda)
  - [2.2 Miniconda环境操作](#22-miniconda环境操作)
- [3.安装Pytorch, d2l, jupyter包](#3安装pytorch-d2l-jupyter包)
- [4. 总结](#4-总结)

### 1.安装python
首先前提是安装python，这里推荐安装python3.8 输入命令 ***sudo apt install python3.8*** 即可

### 2.安装Miniconda/Anaconda
- 然后第二步，安装 Miniconda（如果已经安装conda或者Miniconda，则可以跳过该步骤)。
  #### 2.1 安装Miniconda
  - 安装MIniconda的好处是可以创建很多虚拟环境，并且不同环境之间互相不会有依赖关系，对日后的项目有帮助，如果只想在本地安装的话，不装Miniconda只使用pip即可，第二步可以跳过。
  - 如果是Windows系统，输入命令 ***wget https://repo.anaconda.com/miniconda/Miniconda3-py38_4.10.3-Windows-x86_64.exe***
  - 如果是macOS，输入命令 ***wget https://repo.anaconda.com/miniconda/Miniconda3-py38_4.10.3-MacOSX-x86_64.sh*** 之后要输入命令 ***sh Miniconda3-py38_4.10.3-MacOSX-x86_64.sh -b***
  - 如果是Linux系统，输入命令 ***wget https://repo.anaconda.com/miniconda/Miniconda3-py38_4.10.3-Linux-x86_64.sh*** 之后输入命令 ***sh Miniconda3-py38_4.10.3-Linux-x86_64.sh -b***
  - 以上都是基于python3.8版本，对于其他版本，可以访问 ***https://docs.conda.io/en/latest/miniconda.html*** ，下载对应版本即可。

  #### 2.2 Miniconda环境操作
  - 对于第一次安装Miniconda的，要初始化终端shell，输入命令 ***~/miniconda3/bin/conda init***
  - 这样我们就可以使用 ***conda create --name d2l python=3.8 -y*** 来创建一个名为xxx的环境，这里命名为d2l
  - 打开xxx环境命令: ***conda activate xxx*** ；关闭命令：***conda deactivate xxx***。对于基础conda环境不用添加名

### 3.安装Pytorch, d2l, jupyter包
- 第三步，安装深度学习框架和`d2l`软件包

  在安装深度学习框架之前，请先检查你的计算机上是否有可用的GPU（为笔记本电脑上显示器提供输出的GPU不算）。 例如，你可以查看计算机是否装有NVIDIA GPU并已安装[CUDA](https://developer.nvidia.com/cuda-downloads)。 如果你的机器没有任何GPU，没有必要担心，因为你的CPU在前几章完全够用。 但是，如果你想流畅地学习全部章节，请提早获取GPU并且安装深度学习框架的GPU版本。

  - 你可以按如下方式安装PyTorch的CPU或GPU版本：

    ```
    pip install torch==1.8.1
    pip install torchvision==0.9.1
    ```

  - 也可以访问官网 ***https://pytorch.org/get-started/locally/*** 选择适合自己电脑pytorch版本下载![03-01](../imgs/02/03-01.png)

  - 本课程的jupyter notebook代码详见 ***https://zh-v2.d2l.ai/d2l-zh.zip***

  - 下载jupyter notebook ：输入命令 ***pip install jupyter notebook*** （若pip失灵可以尝试pip3），输入密命令 ***jupyter notebook*** 即可打开。

### 4. 总结
- 本节主要介绍**安装Miniconda**、**CPU环境下的Pytorch**和其它课程所需**软件包**(d2l, jupyter)。对于前面几节来说，CPU已经够用了。
  - 如果您**已经安装**了Miniconda/Anaconda, Pytorch框架和jupyter记事本, 您只需再安装**d2l包**，就可以跳过本节视频了**开启深度学习之旅**了; 如果希望后续章节在**GPU下跑深度学习**, 可以**新建环境**安装**CUDA版本的Pytorch**。
  - 如果需要在Windows下**安装CUDA和Pytorch**(cuda版本)，用**本地GPU跑深度学习**，可以参考李沐老师[Windows下安装CUDA和Pytorch跑深度学习](https://www.zhihu.com/zvideo/1363284223420436480)，如果网慢总失败的同学可以参考[cuda11.0如何安装pytorch？ - Glenn1Q84的回答 - 知乎](https://www.zhihu.com/question/425647129/answer/2278290137)。当然，如果不方便在本地进行配置(如无GPU, GPU显存过低等)，也可以选择[Colab](https://colab.research.google.com/)(需要科学上网)，或其它**云服务器**GPU跑深度学习。
 - 如果pip安装比较慢，可以用镜像源安装：
  ```bash
  pip install torch torchvision -i http://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
  ```
- 如果安装时经常报错, 可以参考课程评论区部分。
