<div dir="ltr">

## 🥇Professional REST API design with ASP.NET Core 3.1 and WebAPI

This project is lightweight and extensible infrastructure for building RESTful Web API with ASP.NET Core.

## Testing it out
1. Clone or download this repository
2. Build the solution using command line with `dotnet build`
3. Go to **MyApi** directory and run project using command line with `dotnet run`
4. Browse to this url https://localhost:44339/swagger to see SwaggerUI page

## Techniques and Features
- JWT Authentication
- Secure JWT using Encryption (JWE)
- Logging to File, Console and Database using Elmah & NLog
- Logging to sentry.io (Log Management System)
- Exception Handling using Custom Middleware
- Automatic Validation
- Standard API Resulting
- Dependency Injection using Autofac
- Map resources using AutoMapper
- Async/Await Best Practices
- Versioning Management
- Using Swagger (Swashbuckle)
- Auto Document Generator for Swagger
- Integrate Swagger and Versioning
- Integrate Swagger and JWT/OAuth Authentication
- Best Practices for Performance and Security

</div>
