/******************************************************************************
 *
 * This file is part of Log4Qt library.
 *
 * Copyright (C) 2007 - 2020 Log4Qt contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/

#include "helpers/binaryclasslogger.h"

#include "logmanager.h"
#include "binarylogger.h"

#include <QString>

namespace Log4Qt
{

BinaryClassLogger::BinaryClassLogger()
    : mLogger(nullptr)
{
}

BinaryLogger *BinaryClassLogger::logger(const QObject *object)
{
    Q_ASSERT_X(object, "BinaryClassLogger::logger()", "object must not be null");
    QString loggename(object->metaObject()->className());
    loggename += QStringLiteral("@@binary@@");
    if (!mLogger.loadAcquire())
        mLogger.testAndSetOrdered(nullptr, qobject_cast<BinaryLogger *>(LogManager::logger(loggename)));
    return mLogger.loadAcquire();
}

} // namespace Log4Qt
