/******************************************************************************
 *
 * This file is part of Log4Qt library.
 *
 * Copyright (C) 2007 - 2020 Log4Qt contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/

#include "binarylayout.h"
#include "binaryloggingevent.h"

namespace Log4Qt
{

BinaryLayout::BinaryLayout(QObject *parent)
    : Layout(parent)
{
}

QByteArray BinaryLayout::binaryFormat(const BinaryLoggingEvent &event) const
{
    return event.binaryMessage();
}

QString BinaryLayout::format(const LoggingEvent &event)
{
    Q_UNUSED(event)
    return QString{};
}

QString BinaryLayout::contentType() const
{
    return QStringLiteral("application/octet-stream");
}

} // namespace Log4Qt

#include "moc_binarylayout.cpp"

