﻿using RIS.Cryptography.Hash;
using RIS.Cryptography.Hash.Methods;

namespace Memenim.Framework.Cryptography
{
    public static class HashManager
    {
        private static SHA512iCSP SHA512Provider { get; }



        public static HashService Service { get; }



        static HashManager()
        {
            SHA512Provider = new SHA512iCSP();
            Service = new HashService(SHA512Provider);
        }



        public static string GetLibrariesHash()
        {
            return Service.GetDirectoryHash(Environment.ExecAppDirectoryName,false, new[]
            {
                "special_events",
                "scripts",
                "localizations",
                "downloads",
                "storage",
                "temp",
                "logs",
                "hash",
                AppSettings.SettingsFileName,
                PersistentSettings.SettingsFileName,
                Path.ChangeExtension(Path.GetFileName(
                    Environment.ExecProcessFilePath), "exe"),
                Path.ChangeExtension(Path.GetFileName(
                    Environment.ExecProcessFilePath), "pdb"),
                //dev
                "publish",
                "win-x64",
                "win-x86",
                Path.ChangeExtension(Path.GetFileName(
                    Environment.ExecProcessFilePath), "runtimeconfig.dev.json")
            });
        }

        public static string GetExeHash()
        {
            return Service.GetFileHash(Path.ChangeExtension(
                Environment.ExecProcessFilePath, "exe"));
        }

        public static string GetExePdbHash()
        {
            return Service.GetFileHash(Path.ChangeExtension(
                Environment.ExecProcessFilePath, "pdb"));
        }
    }
}
