﻿using System.Windows.Data;

namespace Memenim.Framework.Converters
{
    public sealed class InvertedBooleanConverter : IValueConverter
    {
        public object Convert(object value, Type targetType,
            object parameter, CultureInfo culture)
        {
            var result = true;

            if (value is bool boolValue)
                result = boolValue;

            return !result;
        }

        public object ConvertBack(object value, Type targetType,
            object parameter, CultureInfo culture)
        {
            if (value is bool boolValue)
                return !boolValue;

            return true;
        }
    }
}
