# Project History

## MAIF Origins

Melusine, an open-source email processing library, was born at [MAIF](https://www.maif.fr/), a French mutual insurance company founded in 1934 and headquartered in Niort, France. 
MAIF is committed to social and environmental responsibility, operating as a [Société à mission](https://www.economie.gouv.fr/cedef/societe-mission) (link in French) (label given to companies with social and environmental matters).

## Project Motivation 

MAIF handles a vast volume of emails daily, necessitating an efficient processing solution to ensure timely and accurate handling while maximizing customer satisfaction. Automated email processing plays a crucial role in this endeavor, enabling tasks such as:

- **Email routing**: Redirecting emails to the most appropriate service for processing.
- **Email prioritization**: Prioritizing urgent emails for prompt attention.
- **Email summarization**: Extracting key information from emails for quick comprehension.

## Open-Source Journey

After successfully implementing and testing the email processing code in production, MAIF made the strategic decision to open-source Melusine. 

This decision stems from multiple compelling reasons:

- **Transparency**: Open-sourcing the code fosters transparency with MAIF's customers, enabling them to understand how their emails are handled.
- **Code quality**: Adopting open-source quality standards promotes a culture of excellence and upskilling among MAIF developers.
- **Benefiting from External Contributions**: Open-source initiatives often attract contributions from external developers, expanding the pool of expertise and enhancing Melusine's capabilities.
- **Building a Community**: Engaging with Melusine users fosters a community of shared knowledge, best practices, and use-cases.
- **Demonstrating Expertise**: Open-sourcing Melusine showcases the MAIF DataFactory's technical expertise and commitment to innovation.

## Refactoring and Advancement

The initial release of Melusine in 2019 followed its successful deployment at MAIF. 
Since then, Melusine has evolved to meet the growing demands of MAIF's business needs. 
In 2024, based on extensive feedback gained from Melusine's production usage, a complete refactoring effort resulted in the release of Melusine V3. 
This latest version boasts enhanced modularity, customization options, seamless integration, robust monitoring capabilities, and simplified maintenance.




