﻿namespace UniversityStudentSystem.Common.Extensions
{
    using System.Text;

    public static class StringExtensions
    {
        // https://github.com/NikolayIT/OpenJudgeSystem/blob/master/Open%20Judge%20System/OJS.Common/Extensions/StringExtensions.cs
        public static string ToUrl(this string uglyString)
        {
            var resultString = new StringBuilder(uglyString.Length);
            bool isLastCharacterDash = false;

            uglyString = uglyString.Replace("C#", "CSharp");
            uglyString = uglyString.Replace("C++", "CPlusPlus");

            foreach (var character in uglyString)
            {
                if (char.IsLetterOrDigit(character))
                {
                    resultString.Append(character);
                    isLastCharacterDash = false;
                }
                else if (!isLastCharacterDash)
                {
                    resultString.Append('-');
                    isLastCharacterDash = true;
                }
            }

            return resultString.ToString().Trim('-');
        }
    }
}
