﻿namespace UniversityStudentSystem.Common.Extensions.ChainOfResponsibility
{
    using System;

    internal class DaysHandler : Handler
    {
        public override string HandleDateSpan(TimeSpan span, string timeString)
        {
            if (span.Days > 0)
            {
                timeString = span.Days == 1 ? "day" : "days";
                return $"{ span.Days } { timeString } ago";
            }
            else
            {
                return this.Successor.HandleDateSpan(span, timeString);
            }
        }
    }
}
