# ORIGINAL CREATOR: Luca Garofalo (Lucksi)
# AUTHOR: Luca Garofalo (Lucksi)
# Copyright (C) 2023 Lucksi <lukege287@gmail.com>
# License: GNU General Public License v3.0

import os
import pdfkit
import base64
from time import sleep
from Core.Support import Font
from Core.Support import Language
from Core.Support import DateFormat
from Core.Support import Clear
from Core.Support import Creds
from Core.Support import FileTransfer
from Core.Support import Banner_Selector as banner
from datetime import datetime
from bs4 import BeautifulSoup as soup

langfile = Language.Translation.Get_Language()
langfile

class Menu:

    @staticmethod
    def Banner(Mode):
        Clear.Screen.Clear()
        Folder = "Banners/Pdf"
        banner.Random.Get_Banner(Folder, Mode)

    @staticmethod
    def CreateTemplate(Template,Content,filename,htmlcontent,username):
        now = datetime.now()
        dataformat = DateFormat.Get.Format()
        dt_string = now.strftime(dataformat)
        Date = str(dt_string)
        if Template == 1:
            style = '<link rel = "stylesheet" href= "../../Css/Light/Pdf.css">'
            theme = "LIGHT"
        elif Template == 2:
            style = '<link rel = "stylesheet" href= "../../Css/Dark/Pdf.css">'
            theme = "DARK"
        else:
            style = '<link rel = "stylesheet" href= "../../Css/High-Contrast/Pdf.css">'
            theme = "HIGH-CONTRAST"
        print(Font.Color.GREEN + "\n[+]" + Font.Color.WHITE + Language.Translation.Translate_Language(
                        langfile, "PDF", "Selected", "None").format(Font.Color.GREEN + theme + Font.Color.WHITE))
        print(Font.Color.GREEN + "\n[+]" + Font.Color.WHITE + Language.Translation.Translate_Language(
                        langfile, "PDF", "Creation", "None"))
        sleep(3)
        header = '''<html>
        <head>
        {}
        <meta charset = "utf-8">
        </head>
        <body>
         <p>PDF REPORT FOR {} GRAPH</p>
          <div class = "Metadata">
            <p id = "Bold">METADATA:</p>
            <p>PDF GENERATED BY MR.HOLMES</p>
            <p>GENERATED ON: {}</p>
            <p>MR.HOLMES DOWNLOAD LINK: https//github.com/Lucksi/Mr.Holmes</p>
           </div>
            <br>
            {}
        </body>
        </html>'''.format(style,username,Date,str(Content)).replace("../Reports","GUI/Reports").replace("../Icon","GUI/Icon").replace("\n","").replace("''","")
        filename = filename.replace(".mh",".html")
        f = open(filename,"w")
        f.write(header)
        f.close()
        reader = open(filename,"r",newline=None)
        htmlcontent = reader.read()
        reader.close()
        parser = soup(htmlcontent,"html.parser")
        List = []
        Encoded = []
        Links = []
        images = parser.find_all("img")
        links = parser.find_all("a")
        print(Font.Color.GREEN + "\n[+]" + Font.Color.WHITE + Language.Translation.Translate_Language(
                        langfile, "PDF", "Image", "None"))
        sleep(4)
        for image in images:
            img = image["src"]
            List.append(img) 
            print(Font.Color.GREEN + "\n[+]" + Font.Color.WHITE + "IMAGE FOUND: {}".format(img))
            for element in List:
                if "https://" in element:
                    image["src"]=element
                else:
                    with open(element, "rb") as img_file:
                        encoded = base64.b64encode(img_file.read())
                    enco = "data:image/png;base64, " + str(encoded).replace("b'","").strip("'")
                    Encoded.append(enco)
                    image["src"]=enco
                    for link in links:
                        Link = link["href"]
                        Links.append(Link)
                        for element in Links:
                            if "https://" in element:
                                link["href"]=element
                            else:
                                link["href"]=""

            print(Font.Color.YELLOW + "[v]" + Font.Color.WHITE + "IMAGE ENCODED...")
            sleep(2)
        html = parser.contents
        with open(filename, "w+") as file:
            file.write(str(html).replace("[","").strip("]"))
        pdf_name = "GUI/PDF/{}.pdf".format(username)
        try:
            pdfkit.from_file(filename, pdf_name)
        except Exception as e:
            print(Font.Color.RED + "[!]" + Font.Color.WHITE + "SOMETHING WENT WRONG PDF TEMPLETE MAY BE INCOMPLETE: " + str(e))
        print(Font.Color.WHITE + Language.Translation.Translate_Language(langfile, "Default", "Report", "None") +
              pdf_name)
        Creds.Sender.mail(pdf_name, username)
        choice = int(input(
                Font.Color.BLUE + "\n[?]" + Font.Color.WHITE + Language.Translation.Translate_Language(langfile, "Transfer", "Question", "None") + Font.Color.GREEN + "[#MR.HOLMES#]" + Font.Color.WHITE + "-->"))
        if choice == 1:
            FileTransfer.Transfer.File(pdf_name,username,".pdf") 
        os.remove(filename)


    @staticmethod
    def Main(username,Mode):
        if os.name == "nt":
            print(Font.Color.RED + "\n[!]" + Font.Color.WHITE + Language.Translation.Translate_Language(
                        langfile, "PDF", "WinError", "None"))
        else:
            Menu.Banner(Mode)
            print(Font.Color.BLUE + "\n[I]" + Font.Color.WHITE + "INFO:" + "[{}]".format(Font.Color.GREEN + Language.Translation.Translate_Language(langfile,"PDF","Explanation","None") + Font.Color.WHITE) )
            username2 = username.replace(" ","_")
            encoded = "GUI/Graphs/{}/encode.mh".format(username2)
            filename = "GUI/Graphs/{}/{}.mh".format(username2,username)
            encode = open(encoded,"r")
            mode = encode.read()
            encode.close()
            reader = open(filename,"r+",encoding="utf-8")
            f = reader.read()
            reader.close()
            print(Font.Color.GREEN + "\n[+]" + Font.Color.WHITE + Language.Translation.Translate_Language(
                            langfile, "PDF", "Check", "None"))
            sleep(3)
            if mode == "Encoded":
                encodingString = f.encode("utf-8")
                Base64_Byte = base64.b64decode(encodingString)
                FinalString = Base64_Byte.decode("utf-8")
                f = FinalString
            else:
                pass
            template = int(input(Font.Color.GREEN + "\n[+]" + Font.Color.WHITE + Language.Translation.Translate_Language(
                            langfile, "PDF", "Template", "None") +  Font.Color.GREEN + "\n\n[#MR.HOLMES#]" + Font.Color.WHITE + "-->"))
            htmlcontent = ""
            Menu.CreateTemplate(template,f,filename,htmlcontent,username)
        inp = input(Language.Translation.Translate_Language(
                        langfile, "Default", "Continue", "None"))
