
# Compatibility

## Your Hardware

While **OpenGloves** is capable of handling <br>
inputs from a variety of VR controllers, <br>
it is primarily designed for VR Gloves.

<br>

#### Custom Hardware

To make your own hardware compatible with **OpenGloves**, <br>
please refer to the **[Driver Input]** page, which provides relevant <br>
information like `Encoding Schemes` & `Communication Methods`.

<br>

#### LucidVR

This is our own **[Firmware]** that is compatible with <br>
**OpenGloves** and runs on `Arduino` / `ESP32` devices.

---

## Games

**OpenGloves** is strictly compatible with **OpenVR** compatible games.

<br>

##### Finger Curling

Is supported in games which have finger tracking support for the **Index** controllers, or other controllers.

<br>

##### Force Feedback

Unfortunately, game compatibility <br>
with Force Feedback is **[More Limited][Game Compatibility]**.

If you'd like to make your **Game** / **Mod** compatible <br>
with `Force Feedback`, please refer to the **[Wiki][Integration]**.


<!----------------------------------------------------------------------------->

[LucidGloves]: https://github.com/LucidVR/lucidgloves
[Lucas VRTech]: https://github.com/lucas-vrtech

[Fngrs]: https://github.com/danwillm/Fngrs/
[danwillm]: https://github.com/danwillm

[Driver Input]: https://github.com/LucidVR/opengloves-driver/wiki/Driver-Input

[Firmware]: https://github.com/LucidVR/lucidgloves/tree/main/firmware/lucidgloves-firmware

[Game Compatibility]: https://github.com/LucidVR/opengloves-driver/wiki/Game-Compatibility-List

[Integration]: https://github.com/LucidVR/opengloves-driver/wiki/Integrating-Force-Feedback
