# OpenGloves Driver [![Steam Badge]][Steam] [![Discord Badge]][Discord]

A **SteamVR (OpenVR)** driver for VR Gloves and DIY Hardware.<br>

## Download
[![Steam Badge]][Steam]

OpenGloves is available on **[Steam]**,<br>
where it comes with additional tools for configuring driver related features.

## Features

### Driver Features

- **Force Feedback**

- **Full Finger Tracking** <br>
    *Splay Support* <br>
    *Individual Joint Support*

- **Tracker / Controller Positioning & Offsetting** <br>

- **Button / Joystick Inputs** <br>
    *➜ Trigger | A | B* <br>
    *➜ Joystick | X | Y | Click*

- **Multiple Communication Methods** <br>
    *- Bluetooth Serial* <br>
    *- Named Pipes* <br>
    *- Serial USB*

### Additional Tools

#### OpenGloves UI
**[OpenGloves UI]** is an application that ships with the driver on Steam. <br>
It provides additional features for configuring driver related features, such as:<br>
- Managing driver settings
- Force Feedback Testing
- Automatically calibrating Controller ⟷ Glove offsets

## Custom Hardware

To make your own hardware compatible with **OpenGloves**, refer to the **[Driver Input]** page. <br>

## Contributing

**Pull requests are very welcome.**

*For major changes, please open an* <br>
***[Issue]*** *or contact us first to discuss* <br>
*what you would like to change.*

---

## Credits

| Author | Discord |
|:------:|:-------:|
| **[danwillm]** | `danwillm#8254` |
| **[Lucas VRTech]** | `LucidVR#0001` |

---

**⸢ [Manual Installation] ⸥  ⸢ [Building] ⸥  ⸢ [Limitations] ⸥  ⸢ [Compatibility] ⸥**

---


<!----------------------------------------------------------------------------->

[Steam Badge]: https://img.shields.io/badge/Steam-000000?style=for-the-badge&logo=steam&logoColor=white
[Discord Badge]: https://img.shields.io/badge/Discord-7289DA?style=for-the-badge&logo=discord&logoColor=white

[Discord]: https://discord.gg/lucidvr
[Steam]: https://store.steampowered.com/app/1574050/OpenGloves
[Steam Page]: https://store.steampowered.com/app/1574050/OpenGloves

[Manual Installation]: docs/Installation.md
[Building]: docs/Building.md
[Limitations]: docs/Limitations.md
[Compatibility]: docs/Compatibility.md

[UI]: https://github.com/lucidVR/opengloves-ui
[OpenGloves UI]: https://github.com/lucidVR/opengloves-ui

[Driver Input]: https://github.com/LucidVR/opengloves-driver/wiki/Driver-Input

[Issue]: https://github.com/LucidVR/opengloves-driver/issues

[Danwillm]: https://github.com/danwillm
[Lucas VRTech]: https://github.com/lucas-vrtech
