# Data

Since Kotsu was developed to handle large websites and data is a backbone of well-organized and maintainable product, we've kept an special eye on how Kotsu deals with data.

Built-in data and how it is implemented within templates (and even styles) should provide suffice framework for dealing with all future difficulties of challenging sites.

For cases when it isn't enough, Kotsu has wide side of ways and entry points, at which can be defined additional data.

## Data source

Kotsu implies centralized approach and encourages to store all data within `source/data` directory. Note, that it intended for _data_, not configuration. Though, in some cases configuration can serve as quite legible data (for instance, project paths).

Since large websites usually demands large datasets, it is advisable to place those datasets into standalone reasonably named files within `source/data` directory.

All those datasets should be imported then and defined as part of `index` file, which can be found in `source/data`. This makes `index` a single accumulator of all "public" project data and makes it easier to control which data passed to Kotsu components. Kind-of text database.

To use it, just import it or it's required slice. Kotsu already does it for Nunjucks, by passing all data to Nunjucks, and some of data properties passed to Sass.

Note, that while usually most part of data should be gathered within `source/data`, it might not always serve as full source. For instance, `index` refers to `package.json` to gather some crucial project information, and it also relies on `gruntfile` config values to populate some properties. This implies that sometimes modules are linked to each other and it is okey to feed upon their data.

Besides, some data might come from middleware. For instance, page filepaths or locale information can be obtained only during rendering task, thus it injected during `nunjucks` and `grayMatter` tasks.


## Defining custom data

When predefined data simply doesn't cut, Kotsu provides handy ways to configurate any additional data, which will became available to templates:

1. With Front Matter (Gray Matter) header in the beginning of each page. 

   Any defined with Front Matter content will end up available to current template under `{{ PAGE }}` property. It will also make content of page accessible to other pages with `{{ getPage('/path/to/you/page') }}` Nunjucks function.

   Front Matter data has highest priority and will almost always override any already provided to page defaults or configured properties with mentioned methods below.

2. With `{{ config() }}` function, which allows to set any variables, including page-ones with `{{ config('PAGE.myVar', 'value') }}`

   Defined this way variables isn't available for inter-page accessing via `{{ getPage('/path/to/you/page') }}`, however, it will chain within Nunjucks extends.

   For instance, you can have one layout (base), which extended by another (product) layout, which is, finally, chained by your specific page.

   `{{ config() }}` function is a convenient way to provide defaults for base or product layouts, which will be used in place of any unspecified with Front Matter or `{{ config() }}` data on final page.

3. By specifing page default in `source/data/index.js`, `PAGE_DEFAULTS` property.

    Any specified in `PAGE_DEFAULTS` properties will end up as defaults for all pages, which extending `_base.nj` layout, unless pages has assigned specific values to those properties.

4. `nunjucks-task` module injects some variables which can be determined only while running Nunjucks task. For instance, those are all i18n-specific variables, like `PAGE.locale`.
 
   In rare cases it is convenient place to inject your own variables. But do it this way only if they are indeed runtime-dependable.

   Though, not advised, but those properties can be overridden with page Front Matter header whenever needed.

5. Finally, `grayMatter` task hydrates extracted from pages Front Matter data with some additional properties, like `PAGE.url`, which also can be discovered only when running task.
  
## Predefined global variables

Those variables available on all pages

|     property    |                               description                                |
|-----------------|--------------------------------------------------------------------------|
| `PATH`          | Stores important for templates paths, which were configured in Gruntfile |
| `SITE`          | Stores site-related properties                                           |
| `PAGE`          | Stores page-specific variables                                           |
| `PAGE_DEFAULTS` | Stores defaults for all pages                                            |
| `SOCIAL`        | Stores information about social services used on website                 |
| `ENV`           | Stores environment state                                                 |

### `SITE` properties

Those predefined properties can be changed by either editing `source/data/index.js` file, or by redefining them with `{{ config('SITE.myVar', 'value') }}` function.

Note, that most of predefined properties taken from `package.json`, or `gruntfile`.

`[]` marks optional variables, which can leave without assigned value.

|          property          |         type        |                                                                                    default value                                                                                    |                                                                                                                                  description                                                                                                                                  |
|----------------------------|---------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `[SITE.name]`              | `String`            | `package.json` `name` property                                                                                                                                                      | Name of website. By default used for page titles, if no specific for page title provided, in footer, for Open Graph and Twitter meta data.                                                                                                                                    |
| `[SITE.shortName]`         | `String`            | `package.json` `name` property                                                                                                                                                      | Short name of website (max 12 chars according to Chrome requirements). Can be used to refer website in short form. By default used in `manifest.json` `short_name`.                                                                                                           |
| `[SITE.description]`       | `String`            | `package.json` `description` property                                                                                                                                               | Description of the website. By default used for Open Graph and Twitter meta data.                                                                                                                                                                                             |
| `[SITE.viewport]`          | `String`            | `width=device-width, initial-scale=1`                                                                                                                                               | Site-wide `<meta name='viewport' content='...'>` content.                                                                                                                                                                                                                     |
| `[SITE.themeColor]`        | `String`            | `#a593e0`                                                                                                                                                                           | Color of bar on Android devices. Some other browsers can use this property too. By default, used as primary color in styles.                                                                                                                                                  |
| `SITE.homepage`            | `String`            | Defined with `$SITENAME` env variable value, otherwise `package.json` `homepage`                                                                                                    | Used to built varius full, absolute urls to current website. Due to that fact is mandatory, especially for built-in SEO optimizations.                                                                                                                                        |
| `[SITE.logo]`              | `String`            | `/${imagesPath}/logo.svg`                                                                                                                                                           | Path to site logo file                                                                                                                                                                                                                                                        |
| `SITE.locales`             | `Object`            | Defined in `gruntfile` locales                                                                                                                                                      | List of locales which uses website. It should always match defines in `gruntfile` locales list. It used to build some crucial website features, like alternate urls, page `lang` property and assembling proper page urls. Any website should have at least 1 defined locale. |
| `SITE.baseLocale`          | `String`            | Defined in `gruntfile` base locale                                                                                                                                                  | Base locale of website. Should match defined in `gruntfile` base locale, and should be among defines locales. It is mandatory for all websites, since it is crucial to built at least proper alternate urls and define page `lang`.                                           |
| `SITE.matter`              | `Function` `Object` | Front Matter data for each page. Should be an object with specific format or a function, which returns such object. By default it is collected by `grunt-gray-matter` Grunt task    | Base locale of website. Should match defined in `gruntfile` base locale, and should be among defines locales. It is mandatory for all websites, since it is crucial to built at least proper alternate urls and define page `lang`.                                           |
| `SITE.images`              | `Function` `Object` | Data for each image used in project. Should be an object with specific format or a function, which returns such object. By default it is collected by `grunt-image-size` Grunt task | Base locale of website. Should match defined in `gruntfile` base locale, and should be among defines locales. It is mandatory for all websites, since it is crucial to built at least proper alternate urls and define page `lang`.                                           |
| `[SITE.googleAnalyticsId]` | `String` `false`    | `false`                                                                                                                                                                             | Id of Google Analytics counter. Set to `false` to disable.                                                                                                                                                                                                                    |
| `[SITE.yandexMetrikaId]`   | `String` `false`    | `false`                                                                                                                                                                             | Id of Yandex.Metrika counter. Set to `false` to disable.                                                                                                                                                                                                                      |

### `PAGE` properties

_Remember, that all defined within Front Matter custom properties will be also available under `PAGE` variable._

Note, that a lot of those properties implemented by supplied `_base.nj` and `_main.nj` layouts. If you opt to implement your completely new layout, large portion of properties above, while still will be available, won't work same way as was intended by original Kotsu layouts and you might need to replicate that functionality in your own layouts.

Because of it, usually it is recommended to extend `_base.nj` or `_main.nj` layout, or edit `_main.nj` to your needs.

Non-optional variables (without `[]`) are mandatory to be defined in Front Matter, via `{{ config() }}` or any other allowed within Kotsu method.

|            property            |       type       |                             default value                              |                                                                                                                                                                                                       description                                                                                                                                                                                                        |
|--------------------------------|------------------|------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `[PAGE.url]`                   | `String`         | Filepath, injected by `grayMatter` task                                | Absolute url to page, without `SITE.homepage`. It is not recommended to override this value, since it used internally to accomplish a lot of dark deeds. Can be overridden to make page think that it's another page.                                                                                                                                                                                                    |
| `[PAGE.breadcrumb]`            | `String[]`       | Based on filepath, injected by `grayMatter` task                       | Same as `PAGE.url`, used internally, so not recommended to override without need. Also, used to build pages breadcrumb, as namge suggests.                                                                                                                                                                                                                                                                               |
| `[PAGE.depth]`                 | `Number`         | Filepath depth, injected by `grayMatter` task                          | Current page depth from root.                                                                                                                                                                                                                                                                                                                                                                                            |
| `[PAGE.basename]`              | `String`         | File name, injected by `grayMatter` task                               | Current page file name, without extensions.                                                                                                                                                                                                                                                                                                                                                                              |
| `[PAGE.locale]`                | `String`         | Current task locale, injected by `nunjucks-task` module                | Page locale in following format: `languagecode-REGIONCODE`. Defined in `gruntfile`                                                                                                                                                                                                                                                                                                                                       |
| `[PAGE.isoLocale]`             | `String`         | Current task ISO locale, injected by `nunjucks-task` module            | Page locale in ISO format: `languagecode_REGIONCODE`.                                                                                                                                                                                                                                                                                                                                                                    |
| `[PAGE.language]`              | `String`         | Current task language, injected by `nunjucks-task` module              | Page language code.                                                                                                                                                                                                                                                                                                                                                                                                      |
| `[PAGE.region]`                | `String`         | Current task region, injected by `nunjucks-task` module                | Page region code.                                                                                                                                                                                                                                                                                                                                                                                                        |
| `[PAGE.rtl]`                   | `Boolean`        | Current task locale read direction, injected by `nunjucks-task` module | Page read direction. If `false`, means left-to-right, otherwise right-to-left (used in, for instance, arabic language).                                                                                                                                                                                                                                                                                                  |
| `PAGE.title`                   | `String`         | none                                                                   | How page title will appear in browser tab (`<title></title>`)                                                                                                                                                                                                                                                                                                                                                            |
| `PAGE.contentTitle`            | `String`         | none                                                                   | Page main content title. Used by `_main.nj` layout, but it's good format to follow. Note, while it might be tempting to leave it empty on pages, which doesn't display content title, it is strongly advised not to do so, since other pages for their reasons might rely on this title to generated some dynamic content.                                                                                               |
| `PAGE.navTitle`                | `String`         | none                                                                   | How page title will appear in navigation components                                                                                                                                                                                                                                                                                                                                                                      |
| `PAGE.breadcrumbTitle`         | `String`         | none                                                                   | How page title will appear in breadcrumb                                                                                                                                                                                                                                                                                                                                                                                 |
| `[PAGE.description]`           | `String`         | none                                                                   | Page meta description. Though, not optional, strongly recommended to fill for SEO purposes.                                                                                                                                                                                                                                                                                                                              |
| `[PAGE.viewport]`              | `String`         | none                                                                   | Page specific `<meta name='viewport' content='...'>` content. If unspecified, `SITE.viewport` will be used instead.                                                                                                                                                                                                                                                                                                      |
| `[PAGE.themeColor]`            | `String`         | none                                                                   | Page specific bar color for Android. May be used by other browsers too.                                                                                                                                                                                                                                                                                                                                                  |
| `[PAGE.og.type]`               | `String`         | none                                                                   | Facebook Open Graph type. If unspecified, `PAGE.og.type` or `website` will be used instead.                                                                                                                                                                                                                                                                                                                              |
| `[PAGE.og.site_name]`          | `String`         | none                                                                   | Facebook Open Graph sitename. If unspecified, `PAGE.og.site_name` or `SITE.name` will be used instead.                                                                                                                                                                                                                                                                                                                   |
| `[PAGE.og.url]`                | `String`         | none                                                                   | Facebook Open Graph url. Should be full url, including site homepage. If unspecified, `PAGE.og.url` or full `PAGE.url` will be used instead.                                                                                                                                                                                                                                                                             |
| `[PAGE.og.title]`              | `String`         | none                                                                   | Facebook Open Graph title. If unspecified, `PAGE.og.title` or `PAGE.title` or `SITE.name` will be used instead.                                                                                                                                                                                                                                                                                                          |
| `[PAGE.og.description]`        | `String`         | none                                                                   | Facebook Open Graph description. If unspecified, `PAGE.og.description` or `PAGE.description` or `SITE.description` will be used instead.                                                                                                                                                                                                                                                                                 |
| `[PAGE.og.image]`              | `String`         | none                                                                   | Facebook Open Graph image url. Should be full url, including site homepage. If unspecified, `PAGE.og.image` or `PAGE.image` or `SITE.facebookImage` will be used instead.                                                                                                                                                                                                                                                |
| `[PAGE.og.locale]`             | `String`         | none                                                                   | Facebook Open Graph locale. Should be in ISO format. If unspecified, `PAGE.og.locale` or `PAGE.isoLocale` will be used instead.                                                                                                                                                                                                                                                                                          |
| `[PAGE.og.locale:alternate]`   | `array`          | none                                                                   | Facebook Open Graph alternate locales for page. Should be in ISO format. By default, uses `SITE.locales`.                                                                                                                                                                                                                                                                                                                |
| `[PAGE.twitter.card]`          | `String`         | none                                                                   | Twitter card type. If unspecified, `PAGE.twitter.card` or `summary` will be used instead.                                                                                                                                                                                                                                                                                                                                |
| `[PAGE.twitter.site]`          | `String`         | none                                                                   | Twitter card site (twitter account). If unspecified, `PAGE.twitter.site` or `SITE.twitter` will be used instead.                                                                                                                                                                                                                                                                                                         |
| `[PAGE.twitter.creator]`       | `String`         | none                                                                   | Twitter card creator (twitter account. If unspecified, `PAGE.twitter.creator` or `SITE.twitter` will be used instead.                                                                                                                                                                                                                                                                                                    |
| `[PAGE.twitter.url]`           | `String`         | none                                                                   | Twitter card url. Should be full url, including site homepage. If unspecified, `PAGE.twitter.url` or full `PAGE.url` will be used instead.                                                                                                                                                                                                                                                                               |
| `[PAGE.twitter.title]`         | `String`         | none                                                                   | Twitter card title. If unspecified, `PAGE.twitter.title` or `PAGE.title` or `SITE.name` will be used instead.                                                                                                                                                                                                                                                                                                            |
| `[PAGE.twitter.description]`   | `String`         | none                                                                   | Twitter card description. If unspecified, `PAGE.twitter.description` or `PAGE.description` or `SITE.description` will be used instead.                                                                                                                                                                                                                                                                                   |
| `[PAGE.twitter.image]`         | `String`         | none                                                                   | Twitter card image url. Should be full url, including site homepage. If unspecified, `PAGE.twitter.image` or `PAGE.image` or `SITE.twitterImage` will be used instead.                                                                                                                                                                                                                                                   |
| `[PAGE.twitter.image:alt]`     | `String`         | none                                                                   | Twitter card image alt (description). If unspecified, `PAGE.twitter['image:alt']` or `PAGE.title` or `SITE.name` will be used instead.                                                                                                                                                                                                                                                                                   |
| `[PAGE.alternate]`             | `Object[]`       | none                                                                   | Array of objects, which define alternate urls for page. Each object should contain `locale` property with locale, to which link this alternate url, and `url` property with url, which can be remote url, relative or absolute url (those will be automatically converted to full urls, using `SITE.homepage`). Note, that by default Kotsu generates alternate urls for you based on locales, specified in `gruntfile`. |
| `[PAGE.canonical]`             | `String` `false` | current page URL                                                       | Canonical url for this page. Should be remote url, relative or absolute url (last one will be converted to full urls using `SITE.homepage`). For understanding why each page has canonical to itself by default see [#326](https://github.com/LotusTM/Kotsu/issues/326).                                                                                                                                                 |
| `[PAGE.image]`                 | `String`         | `PAGE_DEFAULTS.image`                                                  | Url to generic image, associated with page. Out of box used only to assign Open Graph and Twitter meta data, unless page has defined `PAGE.og.image` or `PAGE.twitter.image`. It also can be used by other pages to generate any sorts of cards.                                                                                                                                                                         |
| `[PAGE.excerpt]`               | `String`         | none                                                                   | Short summary of page. Out of box used for blog posts preview card.                                                                                                                                                                                                                                                                                                                                                      |
| `[PAGE.author]`                | `String`         | none                                                                   | Page content author name. Out of box used for blog posts.                                                                                                                                                                                                                                                                                                                                                                |
| `[PAGE.date]`                  | `String`         | none                                                                   | Page publication date in ISO 8601 format. Out of box used for blog posts.                                                                                                                                                                                                                                                                                                                                                |
| `[PAGE.class]`                 | `String`         | `PAGE_DEFAULTS.class`                                                  | Page class, applied to `<html>` tag. Needed, since in                                                                                                                                                                                                                                                                                                                                                                    |
| `[PAGE.bodyClass]`             | `String`         | `PAGE_DEFAULTS.bodyClass`                                              | Page class, applied to `<body>` tag.                                                                                                                                                                                                                                                                                                                                                                                     |
| `[PAGE.applyWrapper]`          | `Boolean`        | `PAGE_DEFAULTS.applyWrapper`                                           | Whether built-in max and min site width constrain class `.Wrapper` should be applied. Disable on pages, where you need to implement non-standard, full-width content.                                                                                                                                                                                                                                                    |
| `[PAGE.showContentTitle]`      | `Boolean`        | `PAGE_DEFAULTS.showContentTitle`                                       | Whether `PAGE.contentTitle` should be displayed. Useful for pages like index page, where content title isn't desired.                                                                                                                                                                                                                                                                                                    |
| `[PAGE.showBreadcrumb]`        | `Boolean`        | `PAGE_DEFAULTS.showBreadcrumb`                                         | Whether `Breadcrumb` component be displayed.                                                                                                                                                                                                                                                                                                                                                                             |
| `[PAGE.showSidebar]`           | `Boolean`        | `PAGE_DEFAULTS.showSidebar`                                            | Whether `{% block sidebar %}` content should be displayed.                                                                                                                                                                                                                                                                                                                                                               |
| `[PAGE.excludeFromBreadcrumb]` | `Boolean`        | none                                                                   | Whether page should be part of `Breadcrumb()` Nunjucks component output. Excluding page from breadcrumb will also hide it in search snippets' breadcrumb.                                                                                                                                                                                                                                                                |

### `SOCIAL` properties

By default Kotsu comes with preconfigured socials for Twitter and Facebook.

Based on this data generated `Organization` structured data which points with `sameAs` properties to those services.

Also, this data used to generate Open Graph and Twitter Cards data.

This data can be used in projects to output information about projects' social networks whenever needed.

|             property             |   type   | default value |                                           description                                            |
|----------------------------------|----------|---------------|--------------------------------------------------------------------------------------------------|
| `[SOCIAL.{service_name}.handle]` | `String` | `none`        | Handle with leading `@`. Most often used for Twitter meta data.                                  |
| `[SOCIAL.{service_name}.image]`  | `String` | `none`        | Image to associated with social service image. By default used for Open Graph and Twitter Cards. |
| `[SOCIAL.{service_name}.url]`    | `String` | `none`        | Url, leading to service. By default used for `Organization` `sameAs` property.                   |

### `ENV` properties

Some useful for project environment variables.

|          property         |    type   |      default value      |                           description                            |
|---------------------------|-----------|-------------------------|------------------------------------------------------------------|
| `[ENV.production]`        | `Boolean` | `env.production`        | Denotes production build.                                        |
| `[ENV.staging]`           | `Boolean` | `env.staging`           | Denotes staging build.                                           |
| `[ENV.build]`             | `Boolean` | `env.build`             | Denotes fully optimized build. Usually same as production build. |
| `[ENV.buildSHA1]`         | `String`  | `env.buildSHA1`         | Commit SHA1, which caused Circle CI build.                       |
| `[ENV.buildNumber]`       | `String`  | `env.buildNumber`       | Current Circle CI build.                                         |
| `[ENV.hotModuleRloading]` | `Boolean` | `env.hotModuleRloading` | Is Hot Module Reloading used right now.                          |
