# @lottiefiles/dotlottie-react

## 0.12.0

### Minor Changes

- 2c48dbf: refactor: abstract common functionality between `DotLottieReact` and `DotLottieReactWorker` to reduce bundle
  size
- 003e7b1: feat: React v19 upgrade

### Patch Changes

- 2c48dbf: fix: dotLottie instance instantiation and cleanup in React `StrictMode` for both `DotLottieReact` and
  `DotLottieReactWorker` components

## 0.11.1

### Patch Changes

- Updated dependencies [fa72f98]
  - @lottiefiles/dotlottie-web@0.38.2

## 0.11.0

### Minor Changes

- fb3ba0f: chore(react): update JSX transform to "react-jsx" and drop React 16 support

### Patch Changes

- Updated dependencies [898084e]
- Updated dependencies [de079cc]
- Updated dependencies [30ff412]
  - @lottiefiles/dotlottie-web@0.38.1

## 0.10.1

### Patch Changes

- Updated dependencies [4be7253]
- Updated dependencies [4be7253]
- Updated dependencies [4be7253]
  - @lottiefiles/dotlottie-web@0.38.0

## 0.10.0

### Minor Changes

- 0d65643: feat: updated dotLottie-rs wasm bindings to v0.1.33 which includes the new v2 dotLottiespecs and theming
  support. feat: Added `setSlots` methods to `DotLottie` class to set lottie slots in runtime. feat: Added `themeId`
  prop to the `DotLottie` class config to initially load a .lottie with a specific theme. feat: Added `resetTheme`
  method to the `DotLottie` class to reset the theme to the default one.

  BREAKING CHANGE:

  - DotLottie's `loadTheme` method is no longer supported, use `setTheme` instead.
  - DotLottie's `setThemeData` method is no longer supported, use `setThemeData` instead.

### Patch Changes

- Updated dependencies [0d65643]
  - @lottiefiles/dotlottie-web@0.37.0

## 0.9.3-beta.9

### Patch Changes

- Updated dependencies [9ed1a99]
  - @lottiefiles/dotlottie-web@0.37.0-beta.9

## 0.9.3-beta.8

### Patch Changes

- Updated dependencies [c0927ea]
  - @lottiefiles/dotlottie-web@0.37.0-beta.8

## 0.9.3-beta.7

### Patch Changes

- Updated dependencies [989a447]
  - @lottiefiles/dotlottie-web@0.37.0-beta.7

## 0.9.3-beta.6

### Patch Changes

- Updated dependencies [6a6db41]
  - @lottiefiles/dotlottie-web@0.37.0-beta.6

## 0.9.3-beta.5

### Patch Changes

- Updated dependencies [5192b23]
  - @lottiefiles/dotlottie-web@0.37.0-beta.5

## 0.9.3-beta.4

### Patch Changes

- Updated dependencies [7ef3025]
  - @lottiefiles/dotlottie-web@0.37.0-beta.4

## 0.9.3-beta.3

### Patch Changes

- Updated dependencies [0dcc26c]
  - @lottiefiles/dotlottie-web@0.37.0-beta.3

## 0.9.3

### Patch Changes

- 10670ee: added provenance to all packages
- Updated dependencies [10670ee]
  - @lottiefiles/dotlottie-web@0.36.1

## 0.9.2

### Patch Changes

- Updated dependencies [26f4be4]
  - @lottiefiles/dotlottie-web@0.36.0

## 0.9.1

### Patch Changes

- Updated dependencies [f0e751d]
  - @lottiefiles/dotlottie-web@0.35.0

## 0.9.0

### Minor Changes

- 40b19ef: chore: update build target from ES2020 to ES2015

### Patch Changes

- Updated dependencies [40b19ef]
  - @lottiefiles/dotlottie-web@0.34.0

## 0.8.12

### Patch Changes

- Updated dependencies [8540831]
  - @lottiefiles/dotlottie-web@0.33.0

## 0.8.11

### Patch Changes

- Updated dependencies [1900885]
- Updated dependencies [b7148b9]
  - @lottiefiles/dotlottie-web@0.32.0

## 0.8.10

### Patch Changes

- Updated dependencies [dd70edf]
  - @lottiefiles/dotlottie-web@0.31.1

## 0.8.9

### Patch Changes

- Updated dependencies [03311db]
- Updated dependencies [e34ac54]
- Updated dependencies [8e6f572]
  - @lottiefiles/dotlottie-web@0.31.0

## 0.8.8

### Patch Changes

- Updated dependencies [04fc781]
  - @lottiefiles/dotlottie-web@0.30.3

## 0.8.7

### Patch Changes

- 18f8015: fix(react): 🐛 "Worker is not defined" error in Next.js SSR

## 0.8.6

### Patch Changes

- Updated dependencies [8419a48]
  - @lottiefiles/dotlottie-web@0.30.2

## 0.8.5

### Patch Changes

- Updated dependencies [78bb656]
  - @lottiefiles/dotlottie-web@0.30.1

## 0.8.4

### Patch Changes

- Updated dependencies [77a56bc]
  - @lottiefiles/dotlottie-web@0.30.0

## 0.8.3

### Patch Changes

- b4c4c6b: fix: 🐛 temporarily disable unstable partial canvas rendering optimization in dotLottie-web wrappers

## 0.8.2

### Patch Changes

- Updated dependencies [d942dd2]
  - @lottiefiles/dotlottie-web@0.29.2

## 0.8.1

### Patch Changes

- Updated dependencies [dc66e8e]
  - @lottiefiles/dotlottie-web@0.29.1

## 0.8.0

### Minor Changes

- eebb307: feat(react): 🎸 add DotLottieWorkerReact component

### Patch Changes

- Updated dependencies [400c333]
- Updated dependencies [ca7bb5a]
  - @lottiefiles/dotlottie-web@0.29.0

## 0.7.2

### Patch Changes

- Updated dependencies [1d26a93]
  - @lottiefiles/dotlottie-web@0.28.0

## 0.7.1

### Patch Changes

- e7a7829: fix: 🐛 remove the unncessary intersection observer debounce
- 8cdff81: fix(react): 🐛 container gap at the bottom
- Updated dependencies [6e15246]
  - @lottiefiles/dotlottie-web@0.27.0

## 0.7.0

### Minor Changes

- f0226ec: **Feature Update: 🎸 Add optional `animationId`, `themeId`, and `themeData` props to `DotLottieReact`
  component**

  We are excited to introduce new optional props to the `DotLottieReact` component: `animationId`, `themeId`, and
  `themeData`.

  **New Features:**

  - **`animationId`**: Allows you to specify and render a particular animation from a `.lottie` file containing multiple
    animations.
  - **`themeId`**: Enables the application of a particular theme from the loaded `.lottie` file to the currently active
    animation.
  - **`themeData`**: Allows you to pass custom theme data to the currently active animation.

  **Usage Example:**

  ```jsx
  import { DotLottieReact } from '@lottiefiles/dotlottie-react';
  import React, { useState, useEffect } from 'react';

  const App = () => {
    const [dotLottie, setDotLottie] = useState(null);
    const [animations, setAnimations] = useState([]);
    const [themes, setThemes] = useState([]);
    const [currentThemeId, setCurrentThemeId] = useState('');
    const [currentAnimationId, setCurrentAnimationId] = useState('');

    useEffect(() => {
      const onLoad = () => {
        if (dotLottie) {
          setAnimations(dotLottie.manifest.animations || []);
          setThemes(dotLottie.manifest.themes || []);
          setCurrentAnimationId(dotLottie.activeAnimationId);
          setCurrentThemeId(dotLottie.activeThemeId);
        }
      };

      dotLottie?.addEventListener('load', onLoad);

      return () => {
        dotLottie?.removeEventListener('load', onLoad);
      };
    }, [dotLottie]);

    return (
      <div>
        <DotLottieReact dotLottieRefCallback={setDotLottie} animationId={currentAnimationId} />
        <label>Theme:</label>
        {currentThemeId && (
          <select value={currentThemeId} onChange={(e) => setCurrentThemeId(e.target.value)}>
            {themes.map((theme) => (
              <option key={theme.id} value={theme.id}>
                {theme.id}
              </option>
            ))}
          </select>
        )}
        <label>Animation:</label>
        {currentAnimationId && (
          <select value={currentAnimationId} onChange={(e) => setCurrentAnimationId(e.target.value)}>
            {animations.map((animation) => (
              <option key={animation.id} value={animation.id}>
                {animation.id}
              </option>
            ))}
          </select>
        )}
      </div>
    );
  };
  ```

- a564ff0: perf(react): ⚡️ render only visible canvas area

  This update optimizes the rendering performance by ensuring that only the visible portion of the canvas is rendered,
  utilizing the dotlottie-web `setViewport` API.

  > Note: No changes are required for existing usage. The optimization is applied internally within the `DotLottieReact`
  > component.

### Patch Changes

- Updated dependencies [ba46fd1]
- Updated dependencies [d7c2c20]
  - @lottiefiles/dotlottie-web@0.26.0

## 0.6.5

### Patch Changes

- Updated dependencies [5b942aa]
  - @lottiefiles/dotlottie-web@0.25.0

## 0.6.4

### Patch Changes

- a79c540: fix(react): 🐛 dotlottieRefCallback null instance in strict mode
- Updated dependencies [663fab2]
- Updated dependencies [b72a4d7]
  - @lottiefiles/dotlottie-web@0.24.0

## 0.6.3

### Patch Changes

- Updated dependencies [6bb8561]
  - @lottiefiles/dotlottie-web@0.23.2

## 0.6.2

### Patch Changes

- Updated dependencies [91be7a1]
  - @lottiefiles/dotlottie-web@0.23.1

## 0.6.1

### Patch Changes

- 2913555: fix(react): 🐛 avoid creating browser-specific objects in SSR environment
- Updated dependencies [6d7673a]
- Updated dependencies [274868e]
- Updated dependencies [64214f7]
- Updated dependencies [274868e]
  - @lottiefiles/dotlottie-web@0.23.0

## 0.6.0

### Minor Changes

- e739e6e: feat: 🎸 enable self-hosting of WASM in dotlottie-web wrappers
- f879652: feat(react): 🎸 optimize animation playback based on initial visibility

## 0.5.9

### Patch Changes

- Updated dependencies [80fe2f1]
  - @lottiefiles/dotlottie-web@0.22.0

## 0.5.8

### Patch Changes

- Updated dependencies [6b394ca]
  - @lottiefiles/dotlottie-web@0.21.1

## 0.5.7

### Patch Changes

- Updated dependencies [fe68ad3]
  - @lottiefiles/dotlottie-web@0.21.0

## 0.5.6

### Patch Changes

- Updated dependencies [9e7a046]
  - @lottiefiles/dotlottie-web@0.20.2

## 0.5.5

### Patch Changes

- f91a4d6: chore: 🤖 remove node version check from package.json
- Updated dependencies [f91a4d6]
  - @lottiefiles/dotlottie-web@0.20.1

## 0.5.4

### Patch Changes

- Updated dependencies [aa102b0]
- Updated dependencies [aa102b0]
  - @lottiefiles/dotlottie-web@0.20.0

## 0.5.3

### Patch Changes

- Updated dependencies [0672481]
  - @lottiefiles/dotlottie-web@0.19.0

## 0.5.2

### Patch Changes

- Updated dependencies [bcd014b]
  - @lottiefiles/dotlottie-web@0.18.1

## 0.5.1

### Patch Changes

- Updated dependencies [65c0b29]
  - @lottiefiles/dotlottie-web@0.18.0

## 0.5.0

### Minor Changes

- 27174c5: feat: 🎸 add `marker` prop

## 0.4.0

### Minor Changes

- 51ff0e9: refactor: 💡 rename `segments` to `segment`

### Patch Changes

- Updated dependencies [51ff0e9]
- Updated dependencies [51ff0e9]
  - @lottiefiles/dotlottie-web@0.17.0

## 0.3.2

### Patch Changes

- Updated dependencies [0e521aa]
- Updated dependencies [0e521aa]
- Updated dependencies [0e521aa]
  - @lottiefiles/dotlottie-web@0.16.0

## 0.3.1

### Patch Changes

- Updated dependencies [7f659f7]
  - @lottiefiles/dotlottie-web@0.15.0

## 0.3.0

### Minor Changes

- 5d4f3ea: feat: 🎸 Added `autoResizeCanvas` prop to enable control over the canvas resizing behavior

## 0.2.6

### Patch Changes

- Updated dependencies [b5463d5]
  - @lottiefiles/dotlottie-web@0.14.1

## 0.2.5

### Patch Changes

- Updated dependencies [7e0890a]
- Updated dependencies [7e0890a]
  - @lottiefiles/dotlottie-web@0.14.0

## 0.2.4

### Patch Changes

- Updated dependencies [e2da7cf]
- Updated dependencies [e2da7cf]
- Updated dependencies [e2da7cf]
  - @lottiefiles/dotlottie-web@0.13.0

## 0.2.4-beta.1

### Patch Changes

- Updated dependencies [e9fdc3a]
  - @lottiefiles/dotlottie-web@0.13.0-beta.1

## 0.2.4

### Patch Changes

- Updated dependencies [09116cb]
  - @lottiefiles/dotlottie-web@0.12.4

## 0.2.4-beta.0

### Patch Changes

- Updated dependencies [4810361]
- Updated dependencies [4810361]
  - @lottiefiles/dotlottie-web@0.13.0-beta.0

## 0.2.3

### Patch Changes

- Updated dependencies [cd3292e]
  - @lottiefiles/dotlottie-web@0.12.3

## 0.2.2

### Patch Changes

- Updated dependencies [7b2b596]
  - @lottiefiles/dotlottie-web@0.12.2

## 0.2.1

### Patch Changes

- Updated dependencies [1ed6c7c]
- Updated dependencies [b0ca50e]
  - @lottiefiles/dotlottie-web@0.12.1

## 0.2.0

### Minor Changes

- 121474d: feat: add `playOnHover` prop
- 121474d: feat: reactivity of DotLottieReact component props

### Patch Changes

- 121474d: chore: bundle the esm build artifacts to work with webpack
- 121474d: fix: debounce resize\&intersection observers callbacks
- 121474d: fix: stability of dotLottieRefCallback prop using useStableCallback hooks
- Updated dependencies [121474d]
- Updated dependencies [121474d]
- Updated dependencies [121474d]
- Updated dependencies [121474d]
  - @lottiefiles/dotlottie-web@0.12.0

## 0.1.2

### Patch Changes

- Updated dependencies [63333c5]
- Updated dependencies [c135278]
- Updated dependencies [11c7ae5]
- Updated dependencies [fb3eeeb]
  - @lottiefiles/dotlottie-web@0.11.1

## 0.1.1

### Patch Changes

- Updated dependencies [495a3d5]
- Updated dependencies [13a5217]
- Updated dependencies [495a3d5]
- Updated dependencies [495a3d5]
  - @lottiefiles/dotlottie-web@0.11.0

## 0.1.0

### Minor Changes

- a255b96: \* feat: 🎸 freeze animation when hidden
  - feat: 🎸 automatically resize the canvas drawing surface when the canvas element is resized

### Patch Changes

- Updated dependencies [e57fbac]
- Updated dependencies [8732113]
  - @lottiefiles/dotlottie-web@0.10.0
