/******************************************************************************
 * @file    ble_l2cap_aci.h
 * @author  MCD Application Team
 * @brief   STM32WB BLE API (l2cap_aci)
 *          Auto-generated file: do not edit!
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under Ultimate Liberty license
 * SLA0044, the "License"; You may not use this file except in compliance with
 * the License. You may obtain a copy of the License at:
 *                             www.st.com/SLA0044
 *
 ******************************************************************************
 */

#ifndef BLE_L2CAP_ACI_H__
#define BLE_L2CAP_ACI_H__


#include "ble_types.h"

/**
 * @brief ACI_L2CAP_CONNECTION_PARAMETER_UPDATE_REQ
 * Send an L2CAP connection parameter update request from the slave to the
 * master.
 * An ACI_L2CAP_CONNECTION_UPDATE_RESP_EVENT event is raised when the master
 * responds to the request (accepts or rejects).
 * 
 * @param Connection_Handle Connection handle for which the command is given.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max.
 *        Time = N * 1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms)
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min.
 *        Time = N * 1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms)
 * @param Slave_latency Slave latency for the connection in number of
 *        connection events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Timeout_Multiplier Defines connection timeout parameter in the
 *        following manner: Timeout Multiplier * 10ms.
 * @return Value indicating success or error code.
 */
tBleStatus aci_l2cap_connection_parameter_update_req( uint16_t Connection_Handle,
                                                      uint16_t Conn_Interval_Min,
                                                      uint16_t Conn_Interval_Max,
                                                      uint16_t Slave_latency,
                                                      uint16_t Timeout_Multiplier );

/**
 * @brief ACI_L2CAP_CONNECTION_PARAMETER_UPDATE_RESP
 * Accept or reject a connection update. This command should be sent in
 * response to a ACI_L2CAP_CONNECTION_UPDATE_REQ_EVENT event from the
 * controller. The accept parameter has to be set if the connection parameters
 * given in the event are acceptable.
 * 
 * @param Connection_Handle Connection handle for which the command is given.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max.
 *        Time = N * 1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms)
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min.
 *        Time = N * 1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms)
 * @param Slave_latency Slave latency for the connection in number of
 *        connection events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Timeout_Multiplier Defines connection timeout parameter in the
 *        following manner: Timeout Multiplier * 10ms.
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection.
 *        Time = N * 0.625 msec.
 *        Values:
 *        - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms)
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection.
 *        Time = N * 0.625 msec.
 *        Values:
 *        - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms)
 * @param Identifier Identifier received in ACI_L2CAP_Connection_Update_Req
 *        event.
 * @param Accept Specify if connection update parameters are acceptable or not.
 *        Values:
 *        - 0x00: Reject
 *        - 0x01: Accept
 * @return Value indicating success or error code.
 */
tBleStatus aci_l2cap_connection_parameter_update_resp( uint16_t Connection_Handle,
                                                       uint16_t Conn_Interval_Min,
                                                       uint16_t Conn_Interval_Max,
                                                       uint16_t Slave_latency,
                                                       uint16_t Timeout_Multiplier,
                                                       uint16_t Minimum_CE_Length,
                                                       uint16_t Maximum_CE_Length,
                                                       uint8_t Identifier,
                                                       uint8_t Accept );


#endif /* BLE_L2CAP_ACI_H__ */
