﻿namespace LoginRadiusSDK.V2
{
    /// <summary>
    /// Configuration Constants that are used by the LoginRadius SDK.
    /// </summary>
    public static class LRConfigConstants
    {
        /// <summary>
        /// Configuration key for HTTP Proxy Address
        /// </summary>
        public const string HttpProxyAddressConfig = "proxyAddress";

        /// <summary>
        /// Configuration key for HTTP Proxy Credential
        /// </summary>
        public const string HttpProxyCredentialConfig = "proxyCredentials";

        /// <summary>
        /// Configuration key for HTTP Connection Timeout
        /// </summary>
        public const string HttpConnectionTimeoutConfig = "connectionTimeout";

        /// <summary>
        /// Configuration key for HTTP Connection Retry
        /// </summary>
        public const string HttpConnectionRetryConfig = "requestRetries";

        /// <summary>
        /// Configuration LoginRadius API Key
        /// </summary>
        public const string LoginRadiusApiKey = "apiKey";

        /// <summary>
        /// Configuration LoginRadius APP Name
        /// </summary>
        public const string LoginRadiusAppName = "appName";

        /// <summary>
        /// Configuration LoginRadius API Secret
        /// </summary>
        public const string LoginRadiusApiSecret = "apiSecret";

        /// <summary>
        /// Configuration LoginRadius ApiRequestSigning Key
        /// </summary>
        public const string ApiRequestSigning = "apiRequestSigning";

        /// <summary>
        /// Configuration and Credentials of LoginRadius App 
        /// </summary>
        public const string ConfigSection = "loginradius";


        /// <summary>
        /// The new domain name
        /// </summary>
        public const string DomainName = "domainName";

        /// <summary>
        /// The region name
        /// </summary>
        public const string ApiRegion = "apiRegion";

        /// <summary>
        /// The OriginIp name
        /// </summary>
        public const string OriginIp = "originIp";


    }
}