[![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)
[![License](https://img.shields.io/badge/LICENSE-CC_BY_4.0-00a2ff?&style=flat-square)](https://creativecommons.org/licenses/by/4.0/)

# Hardware for Protecting Privacy and Security
A curated list of (DIY and pre-built) devices, to help preserve privacy and improve physical cyber security 🔐

**Too long? 🦒** See the [TLDR version](/2_TLDR_Short_List.md#security-hardware) instead.

See Also, [The Hackers Hardware Toolkit](https://raw.githubusercontent.com/yadox666/The-Hackers-Hardware-Toolkit/master/TheHackersHardwareToolkit.pdf) by [@yadox666](https://github.com/yadox666)- Ultimate guide of gadgets for Red Team pentesters and security researchers

**Note**: This section is intended just to be a bit of fun, it is entirely possible to stay secure and anonymous, without having to build or buy anything. Now that more devices have been added, it's not been possible to test everything here, so these products should not be taken as recommendations, just interesting ideas, and a bit of fun


---

#### Contents
- [Basics](#basics)
- [DIY Security Products](#diy-security-products)
- [Paranoid Security Gadgets](#paranoid-security-gadgets)
- [Network Security](#network-security)
- [Secure Computing Devices](#secure-computing-devices)
- [Hardware Encrypted Storage](#hardware-encrypted-storage)
- [USB Data Blockers](#usb-data-blockers)
- [FIDO U2F Keys](#fido-u2f-keys)
- [Crypto Wallets](#crypto-wallets)


## Basics
(All products in this section have been tested.)

**Item** | **Description**
--- | ---
**USB Data Blocker**<br>[![Data Blocker](https://i.ibb.co/jG3dpGW/1.jpg)](https://amzn.to/2HDArRP) | There are many exploits that allow an attacker to infect your device with malware and/ or steal data, when you plug it in to what appears to be a USB power outlet. If you are charging your phone while travelling, a USB data blocker will prevent anything other than power from getting to your device, by removing the connection between the 2 data wires. The PortaPower brand, also comes with a fast charging chip, since without the data connection your device would otherwise charge at minimum speed
**Microphone Blocker**<br>[![__](https://i.ibb.co/BKQTCbQ/2.jpg)](https://amzn.to/2uQ3r5L) | A microphone blocker is a device that prohibits audio hacking, in the form of a hardware accessory for a smartphones, laptops etc. It functions as a dummy mic jack, so the device thinks it has a microphone plugged in, and hence disables the internal one
**Faraday Pouch**<br>[![__](https://i.ibb.co/HBBG0QL/3.jpg)](https://amzn.to/3bIkfw4) | [Faraday Shield](https://en.wikipedia.org/wiki/Faraday_cage) is an enclosure that blocks electromagnetic fields. It is useful to keep any device which could be hacked through sending or receiving signals in such a case, such as car keys, or a smart phone. [Larger](https://amzn.to/2UTZOGM) versions are availible for tablets and latops.
**RFID Blocking Cards**<br>[![__](https://i.ibb.co/m4GtMdj/4.jpg)](https://amzn.to/38ycMxN) | If you are concerned about card skimming, you can use an RFID blocking sleeve to protect your contactless payment and identity cards. However there are proportionately very few RFID-skimmer crimes reported, and most credit cards have a low contactless limit
**Web Cam Covers**<br>[![__](https://i.ibb.co/X7B1WsH/5.jpg)](https://amzn.to/2uEz16H) | Web cam covers are quite self-explanatory, they physically conceal the lenses on your laptop or phone camera, to prevent a malicious actor (hacker, government, corporation etc) from watching you through the camera. It may sound paranoid, but unfortunately it happens, and it is a relatively simple process for someone to gain remote access to a webcam. Even Mark Zuckerberg [covers his webcam](https://www.geek.com/tech/mark-zuckerberg-tapes-up-his-webcam-and-snowden-says-you-should-too-1659083/)! Of course you could just use some tape, rather than buying a cover
**Prokey Wallet**<br>[![__](https://i.ibb.co/m53MmCL/prokey.jpg)](https://prokey.io/?reflink=67e4a39bc5cd4c04bd7f38b50b041c1f) | Prokey Optimum is a secure, easy-to-use offline hardware wallet, that works directly through the browser (on Windows, Mac, Linux and Android), without the need for installing any apps. Both the firmware and browser app is [open source](https://github.com/prokey-io), and it natively supports [over 1000 coins and tokens](https://prokey.io/all-coins). It's affordably priced at £42/ $59, with free world-wide shipping and customer support
**Port Blockers**<br>[![__](https://i.ibb.co/fYPVnK5/6.jpg)](https://amzn.to/327Yn9n) | There are many attacks that involve an attacker inserting a USB device (such as a BadUSB/ Rubber Ducky/ Malduino) to an open USB port. Adding a port blocker doesn't render you safe from this, since the attacker could take the time to try and remove it, but it could protect you for an opportunistic attack
**Privacy Filter**<br>[![__](https://i.ibb.co/KjkTbGN/7.jpg)](https://amzn.to/3bAa9xv) | Privacy filters are polarized sheets of plastic, that when placed over a computer screen prevent screen visibility from any angle other than straight on. They make it harder for anyone to look over your shoulder and see your data confidential
**YubiKey**<br>[![__](https://i.ibb.co/PGtbwxN/8.jpg)](https://amzn.to/38wcG9R) | The YubiKey is a small hardware device used to secure access on mobile devices, computers, and servers to all of your online accounts. It allows for second-factor authentication, hence protecting anyone other than you from logging in. It is said to be more convenient and more secure than using a mobile authenticator, but there are reasons for and against
**Encrypted Kingston Data Traveler**<br>[![__](https://i.ibb.co/ScRFhdt/9.jpg)](https://amzn.to/38xsnO5) | Good value, easy-to-use with no installation required. Built-in hardware encryption and high password protection. Also optionally allows for automatic cloud backup option to protect against data loss (which doesn't say much about their faith in this USB device, but jokes aside-) this is a very affordable and well rated little device
**Hardware Encrypted USB 3.0 Drive**<br>[![__](https://i.ibb.co/p3MzFHF/11.jpg)](https://amzn.to/2vD32Ug) | OS & Platform independent, with 100% hardware encryption, so it works perfectly with all operating systems. USB 3.0 with Read/Write Speeds of 116/43 MBps. GDPR complient and FIPS 140-2 Level 3, NLNCSA DEP-V & NATO Restricted Level Certified with real time military grade AES-XTS 256-bit hardware encryption
**Hardware Encrypted External Hard Drive**<br>[![__](https://i.ibb.co/BV5k29v/12.jpg)](https://amzn.to/37pTmK8) | Similar to the iStorage hardware encrypted USB 3.1 drive, this external hard drive has high capacity and strong hardware encryption. Data is encrypted with FIPS PUB 197 Validated Encryption Algorithm, and against a 7 - 15 digit alpha-numeric pin, with erasing capabilities for multiple failed login attempts
**Fingbox - Home Network Monitoring**<br>[![__](https://i.ibb.co/nkMxwz9/14.jpg)](https://amzn.to/2V5gATx) | Fing Box is an optional companion to the [Fing App](https://www.fing.com/products/fing-app). It provides network monitoring and security capabilities, to protect your home/ work network. As well as the functionality of the app, the FingBox allows you to block intruders and notify you about unknown devices as well as analyse your network for vulnerabilities, such as open ports. You can also see which devises are near your home at what time (even if they're not connected to your WiFi), and improve network speed with scheduled analysis and bandwidth allocation. Best to try out the Fing app alone, before buying the FindBox, but both are great products for netowrk monitoring and security
**Bootable Drive Eraser**<br>[![__](https://i.ibb.co/P11d0YH/15.jpg)](https://amzn.to/2SsL67Y) | Easy-to-use bootable USB will completely erase your hard drive with military grade destruction, making it near-impossible for any files or personal data to be recovered. This should be done before you sell, or dispose of any hard drive. Of course there are various .ISOs you can download and flash to a USB yourself if you do not want to spend money, but this USB supports all devices and is quick and easy to use, with excellent results
**Mobile Privacy Screen**<br>[![__](https://i.ibb.co/Zg9QG1j/17.jpg)](https://amzn.to/2OZO3Lc) | Similar to the laptop/ monitor privacy filter, this screen protector will prevent anyone from seeing what is on your screen when reading from an angle
**Kensington Lock**<br>[![__](https://i.ibb.co/TKHV5d3/20.jpg)](https://amzn.to/38zu0e2) | Quite self-explanatory, this lock will make it harder for someone to steal your laptop, and get to your data. Of course it does require that your laptop has the [Kensington Security Slot](https://en.wikipedia.org/wiki/Kensington_Security_Slot), which many do
**Anti-Surveillance Clothing**<br>[![__](https://i.ibb.co/Gk8jBBm/21.jpg)](https://adversarialfashion.com) | Facial recognition is being rolled out in most countries now, the patterns on these clothes, will confuse facial, object and number plate recognition, injecting junk data in to the systems, hence making it harder for automated systems to monitor and track you
**Solo Key**<br>[![__](https://i.ibb.co/8PFQRDy/26.jpg)](https://amzn.to/37CsOpj) | Another FIDO2 physical security key for 2-facto authentication and storing encryption keys. SoloKeys have both open source hardware and software, they are easy to use out of the box, but can also be used for developers and makers, since there is a well documented CLI
**Nano Ledger**<br>[![__](https://i.ibb.co/HdVyPzb/22.jpg)](https://amzn.to/37q1cn6) | If you are in possession of Bitcoin or other crypto then one of the most secure ways to store, send and receive coins is with a hardware wallet. Ledger has a solid reputation when it comes to hardware encryption, and the main principle behind their wallets is to provide full isolation between the private keys and your easy-to-hack computer or smartphone
**Cold Storage**<br>[![__](https://i.ibb.co/nj6xyv1/23.jpg)](https://amzn.to/2HqVy9x) | If you are not planning on spending your crypto any time soon, and do not want to trust a tech-based solution, then consider this metal cold storage wallet. Unlike writing your private key down on paper, this will not fade, and cannot be destroyed by water, fire of other environmental circumstances. Of course you could just engrave your key on a small sheet of aluminium
**Anonabox**<br>[![__](https://i.ibb.co/L177XDJ/24.jpg)](https://amzn.to/2UWtP8E) | Plug-and-play Tor router, that can be used with public WiFi while travelling, or at home. Anonabox provides easy access to the deep web and lets you bypass censorship, protect your location, deter data collection and more. It can also be used with a VPN, or for online hosting. Of course you could build a similar product your self using a Raspberry Pi and a WiFi range extender
**Deauth Detector**<br>[![__](https://i.ibb.co/BqNGRCW/19.jpg)](https://amzn.to/2HtUy4B) | Most WiFi hacks begin by sending deauth packets, so that connected clients will briefly be disconnected to the network. This [ESP8266](https://en.wikipedia.org/wiki/ESP8266) comes pre-flashed with [@SpaceHuhn's](https://github.com/spacehuhn) deauth detector (which you can view [here, on GitHub](https://github.com/spacehuhn/DeauthDetector)). Once it detects [deauthentication or disassociation frames](https://mrncciew.com/2014/10/11/802-11-mgmt-deauth-disassociation-frames), it will activate a speaker to notify you
**WiPhone**<br>[![__](https://i.ibb.co/grnJjKt/wiphone.jpg)](https://www.wiphone.io/) | A fully open source, modular and easily customizable phone for VOIP and LoRa. Great for making free calls over WiFi, communicating locally over LoRa, or just tinkering thanks to its ESP32 pinouts
**Librem 5**<br>[![__](https://i.ibb.co/3TNh5Vt/l5-v1-front-100x100.png)](https://shop.puri.sm/shop/librem-5/) | Security and Privacy focused smart phone by Purism. With hardware kill switches and specially designed software, this device runs Linux, and does not track you. It Separates CPU from Cellular Baseband, uses IP-Native Communication First and Decentralized Communication by Default. The source code is user-controlled, and has layered security protection. Purism also have [other security-focused products](https://puri.sm/products)
**Slate Travel Router**<br>[![__](https://i.ibb.co/Nt7hmfW/ar750s-ext-1000x1000.jpg)](https://www.gl-inet.com/products/gl-ar750s/) | The GL-AR750S-Ext can serve as a Wi-Fi access point, a pfSense firewall or a portable router with always-on VPN connectivity. It's great for controlling your network (firewall, VPN, ad-block, web filtering, data limits and more) when traveling or away from home


## DIY Security Products

Don't want to spend money? Most of the products above, plus some that wearn't included can be built at home with some pretty simple hardware and open source software. The following list will point you in the right direction to start making!

See Also [DIY Networking Hardware](#diy-networking-hardware)

- **Network-wide add-block** - [Pi Hole](https://pi-hole.net) is a simple yet powerful app, that can be installed on a [Raspberry Pi](https://amzn.to/36GNpsm), and once you've updated your routers DNS servers to point to it, all resources on the blacklist will be blocked, at the point of origin. This makes it much more powerful than a browser add-on, and will also speed your internet up
- **USB Sanitiser** - [CIRCLean](https://www.circl.lu/projects/CIRCLean) is a hardware solution to clean documents from untrusted (obtained) USB drives. It automatically converts untrusted documents into a readable but disarmed format and stores these clean files on a trusted (user owned) USB key/stick.
- **Bootable Drive Eraser** - You can flash the [DBAN](https://dban.org) or [KillDisk](https://www.killdisk.com/bootablecd.htm) ISO file onto a USB, boot from it and securly, fully wipe your hard drives. This is useful to do before selling or disposing of a PC.
- **Deauth Detector** - Since most wireless attacked begin by sending out deauthentication packets, you can flash SpaceHuhns [DeauthDetector](https://github.com/spacehuhn/DeauthDetector), onto a standard [ESP8266 NodeMCU](https://amzn.to/2v5grV0), plug it in, and wait to be notified of wireless deauth attacks
- **AI Assistant Mod** - [Project Alias](https://github.com/bjoernkarmann/project_alias) runs on a Pi, and gives you more control and increased privacy for both Google Home and Alexa, through intercepting voice commands, emitting noise interference + lots more. If your interested in voice assistants, then also check out [Mycroft](https://mycroft.ai)- an open source, Pi-based alternative to Google Home/ Alexa
- **Tor WiFi Network** - Using [OnionPi](https://github.com/breadtk/onion_pi), you can create a second wireless network, that routed traffic through Tor. This is very light-weight so can be done with just a  [Pi Zero W](https://amzn.to/2Urc0hM). Here is a configuration [guide](https://www.sbprojects.net/projects/raspberrypi/tor.php)
- **Credential Recall Card** - A password card is a unique grid of random letters and digits, that lets you generate, store and recall unique and strong passwords for your accounts. Generate your own unique password card, and read more via: [PasswordCard.org](https://www.passwordcard.org/en)
- **Faraday Case** - If you want to block signals for devices such as car keys, smart phone, laptop or even just RFID-enabled cards and passports, you can line a box or pouch with [Faraday Fabric](https://amzn.to/2ORKtTr)
- **Hardware Wallet** - Using the Trezor Shield or [Trezor Core](https://github.com/trezor/trezor-firmware) and a Raspberry Pi, you can create your own hardware wallet for safley storing your crypto currency private keys offline. See [this guide](https://github.com/Multibit-Legacy/multibit-hardware/wiki/Trezor-on-Raspberry-Pi-from-scratch) for building. If you enjoyed that, you can also run your own Bitcoin and  Lightning Node [Raspiblitz](https://github.com/rootzoll/raspiblitz)
- **Encrypted USB** - You can use [VeraCrypt](https://www.veracrypt.fr/en/Home.html) to create an encrypted USB drive, using any off-the shelf [USB drive](https://amzn.to/2RykcLD)
- **Home VPN** - [Pi_VPN](https://www.pivpn.io) lets you use [OpenVPN](https://openvpn.net) to connect to your home network from anywhere, through your [Pi](https://amzn.to/2uniPqa). See [this guide](https://pimylifeup.com/raspberry-pi-vpn-server) for set-up instructions. This will work particularly well in combination with Pi Hole.
- **USB Password Manager** - Storing your passwords in the cloud may be convinient, but you cannot ever be certain they won't be breached. [KeePass](https://keepass.info/help/v2/setup.html) is an offline password manager, with a portable ddition that can run of a USB. There's also an [app](https://play.google.com/store/apps/details?id=com.korovan.kpass). See also [KeePassX](https://www.keepassx.org) and [KeePassXC](https://keepassxc.org) which are popular communnity forks with additional functionality
- **Secure Chat Platform** Tinfoil Chat (TFC) is an onion-routed, endpoint secure messaging system, that relies on high assurance hardware architecture to protect users from passive collection, MITM attacks and most importantly, remote key exfiltration. See [TFC](https://github.com/maqp/tfc)
- **Automated Backups** - [Syncthing](https://syncthing.net) is a privacy-focused continuous file synchronization program. You can use it to make on-site backups as well as encrypted and sync your data with your chosen cloud storage provider
- **GPS Spoofer** - If you don't want to be tracked with GPS, then using a SDR you can send out spoof GPS signals, making near-by GPS-enabled devices think that they are in a totally different location. (Wouldn't recommend using this while on an airplane though!). You can use [gps-sdr-sim](https://github.com/osqzss/gps-sdr-sim) by [@osqzss](https://github.com/osqzss), and run it on a [Hacker RF](https://greatscottgadgets.com/hackrf) or similar SDR. Here's a [guide](https://www.rtl-sdr.com/tag/gps-spoofing) outlineing how to get started, you'll also need a [NooElec HackRF One](https://amzn.to/2Ta1s5J) or similar [SDR](https://amzn.to/39cLiOx). Check your local laws first, you may need a radio license.
- **No-Mic Laptop** - You can go one step further than using a mic-blcoker, and physically remove the microphone from your laptop. (And then use a removable external mic when needed). See how, for [Apple MacBook and iPhone](https://www.wired.com/story/remove-the-mic-from-your-phone/) | [Video Guide](https://www.youtube.com/watch?v=Eo-IwQMeVLc). If that seems to extreme, there are [other options](https://security.stackexchange.com/a/130402)

If you are confident with electronics, then you could also make:
- **USB Data Blocker** - By simple removing the data wires from a USB adapter, you can create a protector to keep you safe while charing your device in public spaces. See [this guide](https://www.instructables.com/id/Making-a-USB-Condom) for more info (note: fast charge will not work)
- **Hardware Encrypted Password Manager** - Even better than a software-encrypted password manager, is the [hardpass0.2](https://bit.ly/3bg4Xi4) which is a very simple hardware-encrypted USB store, using [GnuPG Smart card](https://www.g10code.com/p-card.html), [GNU Password Standard](https://www.passwordstore.org/) and this [source code](https://github.com/girst/hardpass-passwordmanager) all running on a [Pi Zero](https://amzn.to/2Sz0vU4). See also the [Zamek Project](https://bit.ly/36ZJrec), using this [source code](https://github.com/jareklupinski/zamek) to achive a similar functioning hardware-password manager
- **U2F USB Token** - Similar to the FIDO2 2-factor authentication USB keys, [U2f-Zero](https://github.com/conorpp/u2f-zero) by Conor Patrick, lets you turn a Pi Zero into a second-factor auth method. Note: project no longer activley maintained, see [NitroKey](https://github.com/nitrokey) instead
- **True Random Number Generator - Standalone** - The [FST-01](https://www.gniibe.org/FST-01/fst-01.html) is an open source hardware RNG with good documentation, and see the [neug source code](https://salsa.debian.org/gnuk-team/gnuk/neug)
- **PC auto-lock Flash Drive** - Turn a flash drive into a lock/ unlock key for your PC, allowing you to quickly lock your device when needed [deprecated]
- **Headless Pi Zero SSH server** - Create an small test server, that you can SSH into for development, in order to not have to run risky or potentially dangerous code or software directly on your PC, see [this artticle](https://openpunk.com/post/5) for getting started


## Paranoid Security Gadgets

We can go even further, these products are far from essential and are maybe a little over-the-top. But fun to play around with, if you really want to avoid being tracked!

- **Self-Destroying PC** - The ORWL PC will wipe all data if it is compromised, and has many other safeguards to ensure no one other than you can access anything from your drive. Comes with QubeOS, Windows or Linux, and requires both a password and fob to log in. See more: [orwl.org](https://orwl.org)
- **Tor Travel-Router** - Plug-and-play travel router, providing WiFi with VPN or Tor for more private internet access, also has Wi-Fi uplink and range extender with a clear user interface. See more: [Anonabox.com](https://www.anonabox.com) | [Amazon](https://amzn.to/2HHV0fG) | [shop.itsfoss.com](https://shop.itsfoss.com/sales/anonabox-pro)
- **Hardware Data Encryption Token** - Savvi Solutions Purrtec Encryption Keys provide an extra layer of protection for ofline data encryption, requiring the USB to be inserted as well as the password, in order to encrypt or decrypt files and data. [Purrtec.com](http://www.purrtec.com/) | [shop.itsfoss.com](https://shop.itsfoss.com/sales/purrtec-encryption-keys-2-pack)
- **Active RFID Jamming** - Armour Card is a slim credit-card shaped device, which when in contact with any readers creates an electronic force field, strong enough to "jam" and readings from being taken by emmiting arbitrary data. Aimed at protecting cred cards, identity documents, key cards and cell phones. [US](https://amzn.to/38bJxB9) | [ArmourCard Website](https://armourcard.com)
- **Ultra-Sonic Microphone Jammer** - Blocks phones, dictaphones, voice assistants and other recording devices. Uses built-in transducers to generate ultrasonic signals that can not be heard by humans, but cause indistinct noise, on redording devices, making it impossible to distinguish any details of the conversations. See more [UK](https://amzn.to/2Hnk63s) | [US](https://amzn.to/2v2fwVG)
- **GPS Jammer** - In the DIY list, there was a link to how to build a GPS spoof device using an SDR. But you can also buy a GPS jammer, which may be useful if you fear that you are being tracked. They are aimed at preventing UAVs from operating in your area, but can also be used to confuse other tracking devices near by, there's a variety of models with varying power and range availible from $50 - $500. [AliExpress](https://www.aliexpress.com/item/4000214903055.html)
- **Audio Jammer/ White Noise Generator** - protects your private room conversations by generating a un-filterable masking sound which desensitizes any near-by microphones. Sounds like random static to your ears but it is a variable oscillating frequency that masks your in person conversations. via [SpyGadgets.com](https://www.spygadgets.com/rechargeable-audio-jammer-white-noise-generator-aj-40/)
- **LibremKey: USB Token** - A USB security token to make encryption, key management, and tamper detection convenient and secure. [Purism](https://puri.sm/products/librem-key/)
- **Secalot: All-in-one Security Key** - An open source, small USB, that functions as a hardware Hardware cryptocurrency wallet, OpenPGP smart card, U2F authenticator, and one-time password generator. via [Secalot](https://www.secalot.com/)
- **Slim Hardware OTP Generator** - A reprogrammable TOTP hardware token authenticator. Unlike USB security keys, this does not need to be connected, and instead is used like a mobile OTP generator, where you enter the 6-digit code. Useful as a backup, in case your phone is not accessible. Via [Protectimus](https://www.protectimus.com/protectimus-slim-mini/)
- **p@ss™ Bracelet** - Fun password generator wristband, allowing you to generate hard to guess, unique passwords for each of your online accounts, and not have to remember them. [Tindie](https://www.tindie.com/products/russtopia/psstm-bracelet/)
- **Credential Recall Cards** - An easy method for generating and recalling secure passwords. You could [make your own](https://www.passwordcard.org/en), or buy one such as the C@RD™ Mark II, available via: [Tindie](https://www.tindie.com/products/russtopia/crdtm-mark-ii-credential-ccess-recall-device/)
- **Card Skimmer Detector** - Ensure an ATM or card reader does not have an integrated skimming device. See more at [Lab401](https://lab401.com/products/hunter-cat-card-skimmer-detector)
- **Deauth Detector** - Most WiFi-based attacks involve sending deauth packets at some point, a deauth-detector will notify you whenever these packets are detected. This particular model uses SpaceHuhns code, running on an ESP8266. via: [Tindie](https://www.tindie.com/products/lspoplove/dstike-deauth-detector-pre-flashed-with-detector/) | [Amazon](https://www.amazon.com/MakerFocus-ESP8266-Detector-Pre-flashed-Deauther/dp/B07WKDPBRY)
- **Bug Detector** - Able to  detect radio waves, magnetic fields,  in order to find hidden wired or wireless recording or camera equipment and transmitting devices, Note: has limited accuracy. See more: [UK](https://amzn.to/2V8z8C1) | [US](https://amzn.to/2V9AnkI)
- **Advanced Multi-Frequency RF Detector** - Get instantly notified whenever a threat enters your environment. Detects the following frequencies: CDMA (824–849MHz), GSM(880-920MHz), GS-DCS(1710–1790MHz), WCDMA, 3G, GSM-PCS, DECT(1920–2480MHz), Bluetooth, WiFi(2400–2480MHz), Wi-Max(3000–7000MHz). via [spygadgets.com](https://www.spygadgets.com/1207i-multi-frequency-rf-bug-detector-cdma-gsm-bluetooth-wimax/)
- **Laser Surveillance Defeater** - Sophisticated spies could potentially use a laser microphone, which bounces an invisible infrared laser off of a window and back to a light sensor. By measuring any interference in that reflected light, the laser microphone can detect vibrations in the window pane and reconstruct sound on the other side of the glass. A laser surveillance defeater creates small in-audible vibrations, which can stop all vibration-based evesdropping. [shomer-tec](https://www.shomer-tec.com/laser-surveillance-defeater.html) | [Amazon](https://www.amazon.com/Surveillance-Defeater-Countermeasure-Protection-Device/dp/B00383Z5L0)
- **Voice Changer** - Useful to disguise voice, while chatting online. See more: [UK](https://amzn.to/3bXqpsn) | [US](https://amzn.to/2PqUEyz)
- **Anti-Facial Recognition Clothing** - Carefully printed patterns that confuse common facial recognition algorithms. See more: [Amazon UK](https://amzn.to/32dnYgO) | [Redbubble](https://www.redbubble.com/people/naamiko/works/24714049-anti-surveillance-clothing?p=mens-graphic-t-shirt) | [Monoza](https://www.monoza.mobi/hyperface-anti-surveillance-shirt/?sku=1045-19321-423696-174028)
- **Reflective Glasses** - Blocks faces from most CCTV and camera footage, and stops facial recognition from being able to map your face. See more: [Reflectacles](https://www.reflectacles.com)
- **Hardware Password Manager** - MooltiPass is an offline, hardware encrypted USB password manager, with desktop and mobile browser integrations. You can export your KeePass database onto it, for secure authentication on the road, and the hardware is open source. See More: [TheMooltiPass.com](https://www.themooltipass.com) | [Hackaday](https://hackaday.com/tag/mooltipass/)
- **QUANTUM** - Multifunctional crypto device, is an open source secure, reliable and simple cross-platform cryptocurrency wallet and password manager. See more: [crypto-arts.com](https://security-arts.com/) | [Tindie](https://www.tindie.com/products/security-arts/quantum-multifunctional-crypto-device/)
- **Faraday Cases** - A Faraday cage or Faraday shield is an enclosure used to block electromagnetic fields. Useful for electronics, since many devices are constantly transmitting and receiving, which is the worst when you are trying to avoid being tracked. Their have been numerous reportings that governments can apparently track phones, even when they are [powered off](https://slate.com/technology/2013/07/nsa-can-reportedly-track-cellphones-even-when-they-re-turned-off.html), and since smart phones often do not have removable batteries, the only option is often to shield them from any em waves. See [SilentPocket.com](https://silent-pocket.com/collections/all-products) | [Faraday Box](https://amzn.to/3cj9z7r) | [Faraday Phone Pouch](https://amzn.to/38faum5)
- **DNA Invisble** - An open source recipe that erases and deletes 99.5% of DNA left behind, and obfuscates the remaining 0.5%. You leave your DNA behind all the time, once analysed this is able to say a lot about your genetic makeup, and who you are. Learn more about this threat in [this video](https://youtu.be/MoX_BDWZUG0), See [DNA Invisible](http://biogenfutur.es)
- **Roller Stamp** - Data eraser for paper. [Amazon](https://www.amazon.co.uk/Vantamo-Identity-Protection-Including-Refills/dp/B074MGBXLS/)
- **Forensic bridge kit** - Allows for write blocking to prevent unauthorized writing to a device, and for crating images with out modifying data. See more: [Amazon](https://www.amazon.com/dp/B00Q76XG5W)
- **Firewalla** - Tiny open source smart firewall. Has many useful features: VPN Server, Ad-blocker, powerful monitoring, security analysis and family controls. [Firewalla.com](https://firewalla.com) | [Tindie](https://www.tindie.com/products/firewallallc/firewalla-smart-internet-security-for-your-home/)
- **IoTMATE v2b-CL** - Plug-and-play open source home automation module, does not require internet access and has some good privacy controls, making it a more secure alternative to big-name IoT hubs (Note: requires technical and electrical knowledge to install and configure). [Tindie](https://www.tindie.com/products/iotmate/iotmate-v2b-cl-home-automation-with-alexa-support/)
- **Stand-alone Drive Eraser** - Allows you to erase drives, without connecting them to your PC. Availible in different modesls for different needs. See More: [Amazon](https://www.amazon.com/StarTech-com-Hard-Drive-Eraser-Standalone/dp/B073X3YZNL)
- **Shredder** - It is important to safely dispose of any documents that contain personal information. This is a very affordable shredder - it cuts pieces into security level P-4 sizes (5/32" by 15/32"). It also shreds credit cards into the same size. [Amazon](https://www.amazon.com/AmazonBasics-6-Sheet-High-Security-Micro-Cut-Shredder/dp/B00Q3KFX8U)
- **Device Timer** - This non-smart device can be used to turn various devices (such as lights or radio) on or off at certain times. It's useful to deter people when you are away. [Amazon](https://www.amazon.com/Century-Digital-Programmable-Packaging-Security/dp/B00MVF16JG)
- **SurfEasy Key** - A portable web browser you can carry in your pocket for private and secure browsing on the go. Provides encrypted storage and anonymous browsing features. Again, you can make your own version with an encrypted USB, and a portable executable. [fightforthefuture.org](https://shop.fightforthefuture.org/products/surfeasy-key)
- **Private Texting LoRa Transceivers** | A pack of 2 private texting unit, which are small companion radios for a smartphone, allowing you to communicate independently from celluar networks, great for privacy, security and when you have no service. [Tindie](https://www.tindie.com/products/DLSpectrum/two-private-texting-lora-transceivers/) 
- **TrueRNG** - Generates a stream of True Random Numbers for use in Simulations, Security, and Gaming. [Tindie](https://www.tindie.com/products/ubldit/truerng-v3/)
- **Wire Tap Detector** - Easily check both single and multi-line phone systems for series and parallel taps. Via [BrickHouseSecurity](https://www.brickhousesecurity.com/counter-surveillance/wiretap/)
- **True Random Number Generator** - FST-01SZ is a tiny stand alone USB 32-bit computer based on a free hardware design. (NeuG is an implementation of a TRNG for GD32F103 MCU). See More: [Free Software Foundation: Shop](https://shop.fsf.org/storage-devices/neug-usb-true-random-number-generator)


## Network Security

Gadgets that help protect and anonamise your internet, detect & prevent intrusions and provide additional network controlls, both at home and while traveling. There are many products like this availible, some of them are over-priced for what they are, others provide some really essential network security features. It is possible to re-create some of these solutions yourself, to save money [above](#diy-security-products).

- **Anonabox** - Plug-and-play Tor router. Wi-Fi uplink and range extender with user interface, also has VPN options and USB ports for local file sharing.  [Amazon](https://amzn.to/38bwZIA) | [Anonabox.com](anonabox.com) | [shop.itsfoss.com](https://shop.itsfoss.com/sales/anonabox-pro)
- **Turris Omnia Router** - Open source wireless router, running OpenWrt. Above average specs, and useful features including automatic updates, distributed adaptive firewall and virtual server. Via [turris.com](https://www.turris.com/en/omnia/overview/) | [Amazon](https://www.amazon.com/Turris-hi-Performance-printserver-Virtual-Dual-core/dp/B07XCKK146)
- **FingBox** - Network monitoring and security, for what it offers Fing is very affordable, and there is a free [app](https://www.fing.com/products/fing-app) that you can use before purchasing the hardware to get started. [Fing.com](https://www.fing.com/products/fingbox) | [US](https://amzn.to/2wlXfCT) | [UK](https://amzn.to/2I63hKP)
- **BitdefenderBox** - Cybersecurity home firewall hub, for protecting IoT and other devices. Has other features such as parental controlls and is easy to set up. [US](https://amzn.to/2vrurZJ) | [UK](https://amzn.to/34Ul54w)
- **Flashed-Routers** - Pre-configured branded routers, flashed with custom open source firmware, for better security, privacy and performance. [flashrouters.com](https://www.flashrouters.com/routers)
- **Firewalla** - Tiny open source smart firewall. Has many useful features: VPN Server, Ad-blocker, powerful monitoring, security analysis and family controls. [Firewalla.com](https://firewalla.com) | [Tindie](https://www.tindie.com/products/firewallallc/firewalla-smart-internet-security-for-your-home/)
- **Trend Micro Box** - Protect home networks from external and internal cyber attacks. Detects intrusions, vulnrabbilities, remote access, web threats and provides other security features. [US](https://amzn.to/2wk3Y0s) | [US](https://amzn.to/2uqX4Wv)
- **AlwaysHome Duo** - USB VPN with accelerated virtual networking to your home or office network, crossing geo-blocking and firewall mechanisms. [US](https://amzn.to/2Ts6oSn) | [UK](https://amzn.to/3bi4cF0)
- **Firewalla Red** - An intrusion detection and intrusion prevention system, with a web and mobile interface. Also has Ad-block, VPN, internet controll features and insights. [US](https://amzn.to/388BlAw) | [Firewalla.com](https://firewalla.com)
- **LibertyShield** - Pre-configured, plug-and-play multi-country VPN router, note that after 1 year there is a monthly subscription. [US](https://amzn.to/2T89vzU) | [UK](https://amzn.to/2twJlwM)
- **Gigabit Travel AC VPN Router** - A fully-featured dual-band travel router with VPN capabilities. [US](https://amzn.to/32HD1zU) | [UK](https://amzn.to/2SkUxFg)
- **Helios 64** - ARM-powered fully open source NAS. Using a local backup solution mitigates a lot of the privacy concerns of popular cloud storage providers, and Kobol's Helios 64 is a great option in terms of cost, reliability, functionality and security. High capacity (up to 80TB across 5-bays), with good network throughput (2.5GB multi-Gigabit Ethernet and dual LAN), adequate computing power and memory, great reliability, (with a built-in UPS, dual DC input). [Kobol.io](https://kobol.io/)
- **InvizBox** - Tor router, that provides speed, privacy and security for all devices connected to it. [Invizbox.com](https://www.invizbox.com) | [Amazon](https://amzn.to/2w4v7V3) 
- **InviziBox Go** - Portable VPN: https://amzn.to/386ikPT
- **WatchGuard Firebox** - Business-grade network firewall. [US](https://amzn.to/2VF0MqR) | [UK](https://amzn.to/2VF12WR)

#### DIY Networking Hardware
- **[Pi-Hole](https://pi-hole.net)** - Network-level advertisement and Internet tracker blocking application which acts as a DNS sinkhole. Pi-Hole can significantly speed up your internet, remove ads and block malware. It comes with a nice web interface and a mobile app with monitoring features, it's open source, easy to install and very widley used
- **[IPFire](https://www.ipfire.org)** - A hardened, versatile, state-of-the-art open source firewall based on Linux. Its ease of use, high performance and extensibility make it usable for everyone
- **[PiVPN](https://pivpn.io)** - A simple way to set up a home VPN on a any Debian server. Supports OpenVPN and WireGuard with elliptic curve encryption keys up to 512 bit. Supports multiple DNS providers and custom DNS provividers - works nicley along-side PiHole
- **[E2guardian](http://e2guardian.org)** - Powerful open source web content filter
- **[OpenWRT](https://openwrt.org)** Powerful custom router firmware, with great security, performance and customization features. See more [custom router firmware](https://github.com/Lissy93/awesome-privacy#router-firmware)
- **[SquidGuard](http://www.squidguard.org)** - A URL redirector software, which can be used for content control of websites users can access. It is written as a plug-in for Squid and uses blacklists to define sites for which access is redirected
- **[PF Sense](https://www.pfsense.org)** - Widley used, open source firewall/router
- **[Zeek](https://www.zeek.org)** -  Detect if you have a malware-infected computer on your network, and powerful network analysis framework and monitor

[See more](https://geekflare.com/best-open-source-firewall) open source firewall apps

For most projects, a Raspberry Pi 3 or 4 is more than enough. You could also build your own hardware, see [this guide](https://www.instructables.com/id/Build-your-own-gateway-firewall) on constructing a gateware firewall yourself.


## Secure Computing Devices

- **ORWL PC** - A self-destroying PC, that will wipe all data if it is compromised, and has many other safeguards to ensure no one other than you can access anything from your drive. Comes with QubeOS, Windows or Linux, and requires both a password and fob to log in. See more: [orwl.org](https://orwl.org)
- **Librem 5** - An open source security and privacy-focused phone, running PureOS, built by Prism. See More: [puri.sm/products/librem-5](https://puri.sm/products/librem-5)
- **Armadillo Phones** - Encrypted phones, SIMs and Networks, provide zero-trust  communications and pro-active defences. Their keychain software is open source, and they also provide encrypted SIMs, and servers.
See More: [ArmadilloPhone.com](https://www.armadillophone.com/store#diamond)
- **KryptAll** - Provides secure mobile networking, for encrypted celluar calling. However without being open source, these devices are harder to verify. See More: [KryptAll.com](https://www.kryptall.com)
- **WiPhone** - A fully open source, modular and easily customizable phone for VOIP and LoRa. Great for making free calls over WiFi, communicating locally over LoRa, or just tinkering thanks to its ESP32 pinouts. See more: [WiPhone.io](https://www.wiphone.io/)
- **Ano-Phone** - Android devices loaded with additional security defences. Not open source. 
See More: [ano-phone.com](https://ano-phone.com)
- **Secure Group** - Hardware-encrypted smart phones, for privacy and security. See more: [SecureGroup.com](https://securegroup.com/hardware)
- **Librem Laptop** - The Librem 13, Librem 15 and Librem  Mini are well-speced, open source hardware-encrypted computing devices by Purism. They have several hardware features, like physical connectivity switches, and tamper-proof hardware. See More [puri.sm](https://puri.sm/products)



## Hardware Encrypted Storage

Hardware-based encryption uses a device’s on-board security to perform encryption and decryption. It is self-contained and does not require the help of any additional software. Therefore, it is essentially free from the possibility of contamination, malicious code infection, or vulnerability, and able to be used on any platform.

If the device itself becomes compromised, your data will remain safe. Really useful backing up, transporting and sharing personal data safely. For maximum security, you can combine hardware encryption with software encryption.

Reliable options include:

- AES Hardware encrypted USB 3.0 external hard drive enclosure for HDD or SSD: [US]() | [UK](https://amzn.to/2GM3GkB)
- Integral 256-bit AES USB 3.0 (Software required), 16GB, 32GB, 64GB. [US]() | [UK](https://amzn.to/37vpyNb)
- iStorage 256-bit AES USB 3.0 Pro (Hardware Encrypted), with keypad, 8GB, 16GB, 32GB, 64GB. [US](https://amzn.to/2T9wTgo) | [UK](https://amzn.to/2O1OPXu)
- IornKey Rugged Enterprise-grade encrypted USB Pen, 4GB, 8GB, 16GB, 32GB, 64GB, 128GB. [US](https://amzn.to/2wYWQH2) | [UK](https://amzn.to/3cjsnUi)
- iStorage 256-bit AES USB 3.0 Personal (Hardware Encrypted), with keypad, 8GB, 16GB, 32GB, 64GB. [US](https://amzn.to/2I99c1G) | [UK](https://amzn.to/38GzHqo)
- Lexar JumpDrive Fingerprint USB 3.0 (Software required), 32GB, 64GB, 128GB, 256GB. [US](https://amzn.to/38b0eeP) | [UK](https://amzn.to/2GtipRC)
- iStorage 256-bit Hardware Encrypted external USB 3.1 SSD Drive. 128GB, 256GB, 512GB, 1TB. [UK](https://amzn.to/37wkhVA)
- iStorage 256-bit Hardware Encrypted external USB 3.1 HDD Drive. 1TB, 2TB, 3TB, 4TB. [US](https://amzn.to/32DI4RA) | [UK](https://amzn.to/37vpFYN)
- iodd Mini USB 3.0 256-bit Secure encrypted SSD Drive. 256GB, 512GB, 1TB. [UK](https://www.amazon.co.uk/dp/B07Y4FR9H7)   

*Alternatively, a cheaper option would be a software-encrypted USB. [VeraCrypt](https://www.veracrypt.fr/en/Home.html) is cross-platform open source encryption application. It's surprisingly simple (see [this how-to guide](https://www.howtogeek.com/108501/the-how-to-geek-guide-to-getting-started-with-truecrypt)), and very secure. Combine this with an ordinary USB drive, this [high-speed (300mb/s) 256GB flash drive](https://amzn.to/2RykcLD) is a great option*

*For encryption your boot drive, you can use [BitLocker](https://docs.microsoft.com/en-us/windows/security/information-protection/bitlocker/bitlocker-overview) (Windows), [FileVault](https://support.apple.com/en-us/HT204837) (OSX), or any of these [options](https://www.tecmint.com/file-and-disk-encryption-tools-for-linux)  for Linux.*



## USB Data Blockers

Small, low-cost but essential devise. It attaches inbetween your USB cable and the charging socket, and will physically block data transfer and syncing while charging. Totally mitigates the risk of being hacked via a USB exploit, and stops anything being uploaded to your device.

- PortaPow 3rd Gen, USB A, 2-Pack. [Red](https://amzn.to/39aStqE) | [White](https://amzn.to/2TqXl4i) | [Black](https://amzn.to/38imYd2)
- PortaPow Dual USB Power Monitor with Data Blocker, usful for monitoring power consumption and managing which devices are allowed data connections. [US](https://amzn.to/2I7HT7J) | [UK](https://amzn.to/3chnWcJ) 
- Privise USB A Data Blocker. [US](https://amzn.to/3cig0rr) | [UK](https://amzn.to/2VAbX3K)
- Data-only Micro-USB cable. Be sure that it is actually data-only, you can count the pins at each end. Again PortaPow make a legitimate safe-charge cable. [US](https://amzn.to/2Tq09ys) | [UK](https://amzn.to/38chHDF)
- USB-C ondom. An open source power-with-no-data USB-C data blocker. [Tindie](https://www.tindie.com/products/CrowbarTech/usb-c-ondom/)

PortaPow (3rd gen) is one of the best options, since it has a SmartCharge chip (which isn't usually possible without the data wire).

You can also build your own very easily, [here is a schematic](https://www.electroschematics.com/diy-usb-condom-circuit).

Word of Warning: Sometimes the cable itself can be dangerous. See [O.M.G Cable](https://shop.hak5.org/products/o-mg-cable), it looks like a totally authentic phone cable, but is actually able to deploy advanced exploits often without you being able to identify. It is always best label your cables, to ensure you are using your own, safe wire.


## FIDO U2F Keys

Physical 2-factor authentication keys are a secure and convinient method of authentication. See [twofactorauth.org](https://twofactorauth.org) for a list of websites that provide 2FA.
- **[Solo Key](https://solokeys.com)** - An open source U2F and FIDO2 key, with NFC. via [SoloKeys.com](https://solokeys.com)
- **[LibremKey](https://puri.sm/products/librem-key/)** - A USB security token to make encryption, key management, and tamper detection convenient and secure. via [Puri.sm](https://puri.sm/products/librem-key/)
- **[OnlyKey](onlykey.io/alicia)** - A pin-protected open source hardware password manager with FIDO2/ U2F. It's very affordable, considering the broad feature set, but initial setup is a little complex. Via [OnlyKey.com](onlykey.io/alicia)
- **[NitroKey](https://www.nitrokey.com/)** - An open source secure USB, providing authentication (OTP, U2F and static passwords), email encryption (GnuPG, OpenGPG, S/MIME etc), file encryption (with VeraCrypt, GnuPG and more), key and certificate management and SSH keys for server administration. via [NitroKey.com](https://www.nitrokey.com/)
- **[Secalot](https://www.secalot.com/)** - A small open source USB, that functions as a hardware Hardware crypto wallet, OpenPGP smart card, U2F authenticator, and one-time password generator. via [Secalot.com](https://www.secalot.com/)
- **[Protectimus](https://www.protectimus.com/protectimus-slim-mini/)** - A credit-card sized, slim TOTP hardware token. Allows you to generate 6-digit OTP codes, without the need for a mobile device. Useful as a backup, in case your phone is not accessible. Via [Protectimus.com](https://www.protectimus.com/protectimus-slim-mini/)
- **[Yubikey](https://www.yubico.com/products/)** - Extremely popular, easy-to-use and reliable authentication keys, availible in a variety of form factors - from Micro keys, USB-C, Slim USB-A, and dual lightning + USB. Note, that neither the hardware, nor software is open source. Via [yubico.com](https://www.yubico.com/products/)
- **[Thetis](https://thetis.io)** - Extremely durable, mobile-friendly USB-A FIDO U2F Key. via [Thetis.io](https://thetis.io)
- **[U2F Zero](https://u2fzero.com/)** - Simple, open source U2F token, with write-only keys, tamper-resistance and hardware true random number generator to ensure high entropy.

You can also build your own key, see [U2f-Zero](https://github.com/conorpp/u2f-zero) by Conor Patrick, lets you turn a Pi Zero into a second-factor auth method. Or check out [NitroKey](https://github.com/nitrokey), for a guide on building U2F with an ESP-8266, see [this Hackaday article](https://hackaday.com/2018/01/04/two-factor-authentication-with-the-esp8266/) 



## Crypto Wallets

The most secure medium to store your currency is cold (offline) wallets, since they cannot be hacked. Of course it is vital that you keep your private keys somewhere that they cannot be stolen, and cannot be lost or destroyed. Electronic devices can make it easy to securely store and spend crypto currency. Choose a wallet that is open source, and with a good reputation. Ensure you backup your seed, and keep it somewhere safe.

- Trezor is fully open source and implements a firmware-based security on top of known hardware. [Trezor.com](https://trezor.io)
- Prokey Optimum is a secure, easy-to-use offline wallet, that works directly through the browser (on Windows, Mac, Linux and Android), without the need for installing any apps. Both the firmware and browser app is [open source](https://github.com/prokey-io), and it natively supports [over 1000 coins and tokens](https://prokey.io/all-coins). It's affordably priced at £42/ $59, with free world-wide shipping and customer support. [Prokey.io](https://prokey.io/?reflink=67e4a39bc5cd4c04bd7f38b50b041c1f)
- Ledger is a popular option, as both their hardware and software are good quality, easy to use, and feature rich, however it is not open source. [Ledger.com](https://shop.ledger.com/pages/hardware-wallets-comparison)
- Indestructible Steel Wallet, for private key. [US](https://amzn.to/2Px0EFV) | [UK](https://amzn.to/2VLeVmr)
- QUANTUM is a Multifunctional crypto device, that is an open source secure, reliable and simple cross-platform cryptocurrency wallet and password manager. [crypto-arts.com](https://security-arts.com/) | [Tindie](https://www.tindie.com/products/security-arts/quantum-multifunctional-crypto-device/)

Always ensure the packaging has not been tampered with, buy direct from the manufacturer when possible.

---

## See Also

- [Awesome Privacy-Respecting Software](https://github.com/Lissy93/awesome-privacy)
- [Ultimate Personal Security Checklist](/README.md)
- [Why Privacy and Security Matters](/0_Why_It_Matters.md)
- [Further Links + More Awesome Stuff](/4_Privacy_And_Security_Links.md)


Contributions welcome and appreciated - to propose an edit [raise an issue](https://github.com/Lissy93/personal-security-checklist/issues/new/choose) or [open a PR](https://github.com/Lissy93/personal-security-checklist/pull/new/master). See: [`CONTRIBUTING.md`](/.github/CONTRIBUTING.md)

*Licensed under [Creative Commons, CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), © [Alicia Sykes](https://aliciasykes.com) 2020*

[![Attribution 4.0 International](https://licensebuttons.net/l/by/3.0/88x31.png)](https://github.com/Lissy93/personal-security-checklist/blob/master/LICENSE.md)

---

Found this helpful? Consider sharing it with others, to help them also improve their digital security 😇

[![Share on Twitter](https://img.shields.io/badge/Share-Twitter-17a2f3?style=for-the-badge&logo=Twitter)](http://twitter.com/share?text=Check%20out%20the%20Personal%20Cyber%20Security%20Checklist-%20an%20ultimate%20list%20of%20tips%20for%20protecting%20your%20digital%20security%20and%20privacy%20in%202020%2C%20with%20%40Lissy_Sykes%20%F0%9F%94%90%20%20%F0%9F%9A%80&url=https://github.com/Lissy93/personal-security-checklist)
[![Share on LinkedIn](https://img.shields.io/badge/Share-LinkedIn-0077b5?style=for-the-badge&logo=LinkedIn)](
http://www.linkedin.com/shareArticle?mini=true&url=https://github.com/Lissy93/personal-security-checklist&title=The%20Ultimate%20Personal%20Cyber%20Security%20Checklist&summary=%F0%9F%94%92%20A%20curated%20list%20of%20100%2B%20tips%20for%20protecting%20digital%20security%20and%20privacy%20in%202020&source=https://github.com/Lissy93)
[![Share on Facebook](https://img.shields.io/badge/Share-Facebook-4267b2?style=for-the-badge&logo=Facebook)](https://www.linkedin.com/shareArticle?mini=true&url=https%3A//github.com/Lissy93/personal-security-checklist&title=The%20Ultimate%20Personal%20Cyber%20Security%20Checklist&summary=%F0%9F%94%92%20A%20curated%20list%20of%20100%2B%20tips%20for%20protecting%20digital%20security%20and%20privacy%20in%202020&source=)
[![Share on Mastodon](https://img.shields.io/badge/Share-Mastodon-56a7e1?style=for-the-badge&logo=Mastodon)](https://mastodon.social/web/statuses/new?text=Check%20out%20the%20Ultimate%20Personal%20Cyber%20Security%20Checklist%20by%20%40Lissy93%20on%20%23GitHub%20%20%F0%9F%94%90%20%E2%9C%A8)
