# Awesome Privacy & Security Links

[![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com) [![License](https://img.shields.io/badge/LICENSE-CC_BY_4.0-00a2ff?&style=flat-square)](https://creativecommons.org/licenses/by/4.0/) [![Contributors](https://img.shields.io/github/contributors/lissy93/personal-security-checklist?color=%23ffa900&style=flat-square)](https://github.com/Lissy93/personal-security-checklist/graphs/contributors)

*A curated list of notable guides, articles, tools and media - relating to digital security, internet freedom and online privacy*

**See also**: [Personal Security Checklist](https://github.com/Lissy93/personal-security-checklist/blob/master/README.md) | [Privacy-Respecting Software](https://github.com/Lissy93/personal-security-checklist/blob/master/5_Privacy_Respecting_Software.md) | [Security Gadgets](/6_Privacy_and-Security_Gadgets.md) | [Why Privacy Matters](/0_Why_It_Matters.md) | [TLDR](/2_TLDR_Short_List.md)🔐

## Contents

- **Information and Guides**
  - [How-To Guides](#how-to-guides)
  - [Articles](#articles)
  - [Blogs](#blogs)
- **Media**
  - [Books](#books)
  - [Podcasts](#podcasts)
  - [Videos](#videos)
- **Security Tools & Services**
  - [Online Tools](#online-tools)
  - Privacy-Respecting Software, moved to [here](https://github.com/Lissy93/awesome-privacy)
  - Security Hardware, moved to [here](/6_Privacy_and-Security_Gadgets.md)
- **Research**
  - [Data and API's](#data-apis-and-visualisations)
  - [Academic](#academic)
- **Organisations**
  - [Foundations](#foundations)
  - [Government and Independant Organisations](#governance)
- **More Lists**
  - [Mega Guides](#mega-guides)
  - [Other GitHub Security Lists](#more-awesome-github-lists)


## How-To Guides

- **Threat Protection**
  - Protect against SIM-swap scam: via [wired](https://www.wired.com/story/sim-swap-attack-defend-phone)
  - How to spot a phishing attack: via [EFF](https://ssd.eff.org/en/module/how-avoid-phishing-attacks)
  - Protection from Identity Theft: via [Restore Privacy](https://restoreprivacy.com/identity-theft-fraud)
  - Protecting from key-stroke-logging, with KeyScrambler: via [TechRepublic](https://www.techrepublic.com/blog/it-security/keyscrambler-how-keystroke-encryption-works-to-thwart-keylogging-threats)
  - Guide to Hash Checks, to ensure a program has not been tampered with: via [ProPrivacy](https://proprivacy.com/guides/how-why-and-when-you-should-hash-check)
  - Permanently and Securely Delete ‘Files and Directories’ in Linux: via [TechMint](https://www.tecmint.com/permanently-and-securely-delete-files-directories-linux/)
- **Networking**
  - How to enable DNS over HTTPS: via [geekwire](https://geekwire.co.uk/privacy-and-security-focused-dns-resolver)
  - How to resolve DNS leak issue: via [DNSLeakTest](https://www.dnsleaktest.com/how-to-fix-a-dns-leak.html) 
  - Protect against WebRTC Leaks: via [Restore Privacy](https://restoreprivacy.com/webrtc-leaks)
  - ISP and DNS privacy tips: via [bluz71](https://bluz71.github.io/2018/06/20/digital-privacy-tips.html)
  - Beginners guide on getting started with Tor: via [ProPrivacy](https://proprivacy.com/privacy-service/guides/ultimate-tor-browser-guide)
  - Beginners guide to I2P: via [The Tin Hat](https://thetinhat.com/tutorials/darknets/i2p.html)
  - About Using VPN and Tor together: via [ProPrivacy](https://proprivacy.com/vpn/guides/using-vpn-tor-together)
  - How to use `__nomap`, to reduce public exposure of SSID: via [ghacks](https://www.ghacks.net/2014/10/29/add-_nomap-to-your-routers-ssid-to-have-it-ignored-by-google-and-mozilla/)
  - Up-to-date router configurations for advanced security: via [RouterSecurity.org](https://routersecurity.org/)
- **Communication**
  - Email Self-Defense, Configure your mail client securly, from scratch - via [FSF.org](https://emailselfdefense.fsf.org)
  - How to avoid Phishing Attacks: via [EFF](https://ssd.eff.org/en/module/how-avoid-phishing-attacks)
  - How to use PGP: Via EFF - [Windows](https://ssd.eff.org/en/module/how-use-pgp-windows), [MacOS](https://ssd.eff.org/en/module/how-use-pgp-mac-os-x) and [Linux](https://ssd.eff.org/en/module/how-use-pgp-linux)
  - A Step-by-Step Guide to Generating More Secure GPG Keys: via [spin.atomicobject.com](https://spin.atomicobject.com/2013/11/24/secure-gpg-keys-guide/)
  - How to Maintain Anonyimity in Bitcoin Transactions: [coinsutra.com](https://coinsutra.com/anonymous-bitcoin-transactions/)
  - Beginners Guide to Signal (secure messaging app): via [Freedom of the Press Foundation](https://freedom.press/news/signal-beginners/)
  - How to use OTR messaging with Adium (MacOS): via [CalyxiIstitute.org](https://calyxinstitute.org/docs/howto-encrypted-instant-messaging-with-osx-adium-and-otr)
  - Full guide to using plaintext emails: via [useplaintext.email](https://useplaintext.email/)
- **Devices**
  - How to Enable Encryption on your Devices: via [SpreadPrivacy.com](https://spreadprivacy.com/how-to-encrypt-devices/)
  - How to Delete your Data Securely: Via EFF - [Windows](https://ssd.eff.org/en/module/how-delete-your-data-securely-windows), [MacOS](https://ssd.eff.org/en/module/how-delete-your-data-securely-macos) and [Linux](https://ssd.eff.org/en/module/how-delete-your-data-securely-linux) 
  - Layers of Personal Tech Security: via [The Wire Cutter](https://thewirecutter.com/blog/internet-security-layers)
  - Device-Specific Privacy Guides: via [SpreadPrivacy](https://spreadprivacy.com/tag/device-privacy-tips/)
    - For: [Windows 10](https://spreadprivacy.com/windows-10-privacy-tips/), [MacOS](https://spreadprivacy.com/mac-privacy-tips/), [Linux](https://spreadprivacy.com/linux-privacy-tips/), [Android](https://spreadprivacy.com/android-privacy-tips/) and [iOS](https://spreadprivacy.com/iphone-privacy-tips/)
  - Guide to scrubbing Windows OSs from forensic investigation: by u/moschles, via [Reddit](https://www.reddit.com/r/security/comments/32fb1l/open_guide_to_scrubbing_windows_oss_from_forensic)
  - A curated list of Windows Domain Hardening techniques: by @PaulSec, via: [GitHub](https://github.com/PaulSec/awesome-windows-domain-hardening)
  - Configuring Gboard for better Privacy: via [Ghacks](https://www.ghacks.net/2016/12/21/configure-gboard-privacy-google-keyboard/)
  - Settings to update on iPhone, for better privacy: via [lifehacker](https://lifehacker.com/the-privacy-enthusiasts-guide-to-using-an-iphone-1792386831)
  - How to check App Permissions (Android, iOS, Mac & Windows): via [Wired](https://www.wired.com/story/how-to-check-app-permissions-ios-android-macos-windows/)
  - How to manage Self-Encrypting Drives: via [TechSpot](https://www.techspot.com/guides/869-self-encrypting-drives/)
  - Harden your MacOS Security: via [@drduh on GitHub](https://github.com/drduh/macOS-Security-and-Privacy-Guide)
- **Software**
  - Complete guide to configuring Firefox for Privacy + Speed: via [12bytes](https://12bytes.org/articles/tech/firefox/firefoxgecko-configuration-guide-for-privacy-and-performance-buffs/)
  - Firefox Configuration Guide for Beginners: via [12bytes](https://12bytes.org/articles/tech/firefox/the-firefox-privacy-guide-for-dummies/)
  - How to use Vera Crypt: via [howtogeek](https://www.howtogeek.com/108501/the-how-to-geek-guide-to-getting-started-with-truecrypt)
  - How to use KeePassXC: via [EFF](https://ssd.eff.org/en/module/how-use-keepassxc)
  - How to use uMatrix browser addon to block trackers: via [ProPrivacy](https://proprivacy.com/privacy-service/guides/lifehacks-setup-umatrix-beginners) 
  - How to set up 2-Factor Auth on common websites: via [The Verge](https://www.theverge.com/2017/6/17/15772142/how-to-set-up-two-factor-authentication)
  - How to use DuckDuckGo advanced search features: via [Ghacks](https://www.ghacks.net/2013/03/24/duckduckgo-another-bag-of-tricks-to-get-the-most-out-of-it/)
  - How to use Cryptomator (encrypt files on cloud storage): via [It's Foss](https://itsfoss.com/cryptomator/)
- **Physical Security**
  - Guide to Living Anonymously, Personal Data Removal and Credit Freeze: via [IntelTechniques.com](https://inteltechniques.com/data/workbook.pdf)
  - Hiding from Physical Surveillance: via [Snallabolaget](http://snallabolaget.com/hiding-from-surveillance-how-and-why)
  - Guide to opting-out of public data listings and marketing lists: via [World Privacy Forum](https://www.worldprivacyforum.org/2015/08/consumer-tips-top-ten-opt-outs)
  -
- **Enterprise**
  - A basic checklist to harden GDPR compliancy: via [GDPR Checklist](https://gdprchecklist.io)
- **Reference Info**
  - A direcory of websites, apps and services supporting 2FA: via [TwoFactorAuth.org](https://twofactorauth.org)
  - A directory of direct links to delete your account from web services: via [JustDeleteMe.xyz](https://justdeleteme.xyz)
  - Impartial VPN Comparison Data: via [ThatOnePrivacySite](https://thatoneprivacysite.net/#detailed-vpn-comparison)
  - Terms of Service; Didn't Read - Vital resource that summarizes and extracts the key details from Privacy Policies/ Terms of Services, aiming to fix the issues caused by blindly agreeing to these Terms: via [tosdr.org](https://tosdr.org/)
  - Free, open-source and privacy-respecting alternatives to popular software: via [Switching.Software](https://switching.software/)
  - Product reviews from a privacy perspective, by Mozilla: via [Privacy Not Included](https://foundation.mozilla.org/en/privacynotincluded)
  - Surveillance Catalogue - Database of secret government surveillance equipment, Snowden: via [The Intercept](https://theintercept.com/surveillance-catalogue)
    - See also: The source code, on WikiLeaks [Vault7](https://wikileaks.org/vault7) and [Vault8](https://wikileaks.org/vault8), and the accompanying [press release](https://wikileaks.org/ciav7p1)
  - Who Has Your Back? - Which companies hand over your comply with Government Data Requests 2019: via [EFF](https://www.eff.org/wp/who-has-your-back-2019)
  - Check who your local and government representatives in your local area are [WhoAreMyRepresentatives.org](https://whoaremyrepresentatives.org)
  - Open project to rate, annotate, and archive privacy policies: via [PrivacySpy.org](https://privacyspy.org)
  - Hosts to block: via [someonewhocares/ hosts](https://someonewhocares.org/hosts) / [StevenBlack/ hosts](https://github.com/StevenBlack/hosts)
  - Magic Numbers - Up-to-date file signature table, to identify / verify files have not been tampered with: via [GaryKessler](https://www.garykessler.net/library/file_sigs.html)
  - List of IP ranges per country: via [Nirsoft](https://www.nirsoft.net/countryip)
  - Database of default passwords for various devices by manufacturer and model: via [Default-Password.info](https://default-password.info)
- **All-in-one digital and physical security**
  - Umbrella: an open source iOS/Android/Web app for learning about and managing digital, operational and physical security (from safe communication to dealing with a kidnap) via [Security First](https://www.secfirst.org)



## Articles
- **General**
  - 8-point manifesto, of why Privacy Matters: via [whyprivacymatters.org](https://whyprivacymatters.org)
  - Rethinking Digital Ads: via [TheInternetHealthReport](https://internethealthreport.org/2019/rethinking-digital-ads)
- **Encryption**
  - Overview of projects working on next-generation secure email: via [OpenTechFund](https://github.com/OpenTechFund/secure-email)
  - Anatomy of a GPG Key: via [@DaveSteele](https://davesteele.github.io/gpg/2014/09/20/anatomy-of-a-gpg-key/)
- **Surveillance**
  - Twelve Million Phones, One Dataset, Zero Privacy: via [NY Times](https://www.nytimes.com/interactive/2019/12/19/opinion/location-tracking-cell-phone.html)
  - Windows data sending: via [The Hacker News](https://thehackernews.com/2016/02/microsoft-windows10-privacy.html)
  - Is your Anti-Virus spying on you: via [Restore Privacy](https://restoreprivacy.com/antivirus-privacy)
  - What does your car know about you?: via [Washington Post](https://www.washingtonpost.com/technology/2019/12/17/what-does-your-car-know-about-you-we-hacked-chevy-find-out)
  - Turns Out Police Stingray Spy Tools Can Indeed Record Calls: via [Wired](https://www.wired.com/2015/10/stingray-government-spy-tools-can-record-calls-new-documents-confirm)
  - UK Police Accessing Private Phone Data Without Warrant: via [Restore Privacy](https://restoreprivacy.com/uk-police-accessing-phone-data)
  - Rage Against Data Dominance: via [Privacy International](https://privacyinternational.org/long-read/3734/rage-against-data-dominance-new-hope)
  - NSA Files Decoded, What the revelations mean for you: via [The Guardian](https://www.theguardian.com/world/interactive/2013/nov/01/snowden-nsa-files-surveillance-revelations-decoded)
  - How to Track a Cellphone Without GPS—or Consent: via [Gizmodo](https://gizmodo.com/how-to-track-a-cellphone-without-gps-or-consent-1821125371)
  - Apps able to track device location, through power manager: via [Wired](https://www.wired.com/2015/02/powerspy-phone-tracking/)
  - Hackers and governments can see you through your phone’s camera: via [Business Insider](https://www.businessinsider.com/hackers-governments-smartphone-iphone-camera-wikileaks-cybersecurity-hack-privacy-webcam-2017-6)
  - Law Enforcement Geo-Fence Data Requests - How an Innocent cyclist became a suspect when cops accessed his Google location data: via [Daily Mail](https://www.dailymail.co.uk/news/article-8086095/Police-issue-warrant-innocent-mans-Google-information.html)
  - IBM Used NYPD Surveillance Footage to Develop Technology That Lets Police Search by Skin Color: via [TheIntercept](https://theintercept.com/2018/09/06/nypd-surveillance-camera-skin-tone-search/)
- **Threats**
  - 23 reasons not to reveal your DNA: via [Internet Health Report](https://internethealthreport.org/2019/23-reasons-not-to-reveal-your-dna)
  - Security of Third-Party Keyboard Apps on Mobile Devices: via [Lenny Zelster](https://zeltser.com/third-party-keyboards-security)
  - Mobile Websites Can Tap Into Your Phone's Sensors Without Asking: via [Wired](https://www.wired.com/story/mobile-websites-can-tap-into-your-phones-sensors-without-asking)
  - Non-admin accounts mitigate 94% of critical Windows vulnerabilities: via [ghacks](https://www.ghacks.net/2017/02/23/non-admin-accounts-mitigate-94-of-critical-windows-vulnerabilities/)
  - Android Apps are able to monitor screen state, data usage, installed app details and more without any permissions: by @databurn-in, via [GitHub](https://github.com/databurn-in/Android-Privacy-Issues)
    - See also, [PrivacyBreacher](https://github.com/databurn-in/PrivacyBreacher) - an app developed by @databurn-in, which demonstrates these issues
  - How URL Previews in Apps can Leak Personal Info: via [hunch.ly](https://hunch.ly/osint-articles/osint-article-how-to-blow-your-online-cover)
  - Big data privacy risks: via [CSO Online](https://www.csoonline.com/article/2855641/the-5-worst-big-data-privacy-risks-and-how-to-guard-against-them.html)
  - Anti-Doxing Guide (For Activists Facing Attacks): via [Equality Labs](https://medium.com/@EqualityLabs/anti-doxing-guide-for-activists-facing-attacks-from-the-alt-right-ec6c290f543c)
- **Breaches**
  - Wired guide to data breaches - past, present and future: via [Wired](https://www.wired.com/story/wired-guide-to-data-breaches/)
  - Grindr and OkCupid Spread Personal Details Study Says: via [NY Times](https://www.nytimes.com/2020/01/13/technology/grindr-apps-dating-data-tracking.html)
  - The Asia-Pacific Cyber Espionage Campaign that Went Undetected for 5 Years: via [TheHackerNews](https://thehackernews.com/2020/05/asia-pacific-cyber-espionage.html)
  - ClearView AI Data Breach - 3 Billion Faces: via [Forbes](https://www.forbes.com/sites/kateoflahertyuk/2020/02/26/clearview-ai-the-company-whose-database-has-amassed-3-billion-photos-hacked/)
  - The MongoDB hack and the importance of secure defaults: via [Synk](https://snyk.io/blog/mongodb-hack-and-secure-defaults/)
  - Truecaller Data Breach – 47.5 Million Indian Truecaller Records On Sale: via [GBHackers](https://gbhackers.com/truecaller-data-breach/)
  - Hundreds of millions of Facebook user records were exposed on Amazon cloud server: via [CBS News](https://www.cbsnews.com/news/millions-facebook-user-records-exposed-amazon-cloud-server/)
  - Microsoft data breach exposes 250 million customer support records: via [Graham Cluley](https://www.grahamcluley.com/microsoft-data-breach/)  
- **Data Collection**
  - Ring Doorbell App Packed with Third-Party Trackers: via [EFF](https://www.eff.org/deeplinks/2020/01/ring-doorbell-app-packed-third-party-trackers)
  - How a highly targeted ad can track your precise movements: via [Wired](https://www.wired.com/story/track-location-with-mobile-ads-1000-dollars-study/)
    - Based on the paper, Using Ad Targeting for Surveillance on a Budget: via [Washington.edu](https://adint.cs.washington.edu/ADINT.pdf)
  - How websites can see your full personal details, from your phone contract info: via [Medium/@philipn](https://medium.com/@philipn/want-to-see-something-crazy-open-this-link-on-your-phone-with-wifi-turned-off-9e0adb00d024)
  - Facebook and America’s largest companies give worker data to Equifax: via [FastCompany](https://www.fastcompany.com/40485634/equifax-salary-data-and-the-work-number-database)
  - Exfiltration of personal data by session-replay scripts: via [Freedom-to-Tinker](https://freedom-to-tinker.com/2017/11/15/no-boundaries-exfiltration-of-personal-data-by-session-replay-scripts/)
  - Apple's iTerm2 Leaks Everything You Hover in Your Terminal via DNS Requests: via [BleepingComputer](https://www.bleepingcomputer.com/news/security/iterm2-leaks-everything-you-hover-in-your-terminal-via-dns-requests/)
  - Google Has Quietly Dropped Ban on Personally Identifiable Web Tracking: via [propublica.org](https://www.propublica.org/article/google-has-quietly-dropped-ban-on-personally-identifiable-web-tracking)


## Blogs
- **Security Reserachers**
  - [Krebs on Security](https://krebsonsecurity.com/) - Lots of up-to-date, in-depth interesting cyber security news and investigations, by a true legend in the field and NY Times Bestseller, Brian Krebs. [RSS](https://krebsonsecurity.com/feed/)
  - [Schneier on Security](https://www.schneier.com/) - Commentary, news, essays and more all about cryptography, cyber security and privacy. New posts are written almost daily, and this is also home to the famous [Crypto Gram](https://www.schneier.com/crypto-gram/) weekly newsletter, that's been popular since 1994. By the world-renowned security professional, and serial bestselling author, Bruce Schneier. [RSS](https://www.schneier.com/blog/atom.xml)
  - [Troy Hunt](https://www.troyhunt.com/) - Security researcher and data breach collector. [RSS](https://feeds.feedburner.com/TroyHunt) 
  - [Graham Cluley](https://www.grahamcluley.com/) - Security news, advise and opinion. From Graham Cluley, co-host of Smashing Security.
  - [The Last Watch Dog](https://www.lastwatchdog.com/) - Privacy and Security articles, opinion and media by Byron Acohido
  - [Daniel Miessler](https://danielmiessler.com/) - Summaries recent news and events, and focuses on security, technology and people. [RSS](https://danielmiessler.com/feed/)
  - [Errata Security](https://blog.erratasec.com/) - Covers latest interesting news, and explains concepts clearly. By Robert Graham and David Maynor. [RSS](https://blog.erratasec.com/feeds/posts/default?alt=rss)
  - [Underground Tradecraft](https://gru.gq/blog-feed/) - Counterintelligence, OPSEC and Tradecraft for everyone
- **Cyber Security News**
  - [Dark Reading](https://www.darkreading.com/) - Well-known cyber security news site, with articles on a range of topics, ranging from data breaches, IoT, cloud security and threat intelligence. [RSS](https://www.darkreading.com/rss_simple.asp)
  - [Threat Post](https://threatpost.com/) - News and Articles Cloud Security, Malware, Vulnerabilities, Waterfall Security and Podcasts. [RSS](https://threatpost.com/feed/)
  - [We Live Security](https://www.welivesecurity.com/) - Security news, views, and insight, by ESET + Community. [RSS](https://www.welivesecurity.com/rss-configurator/)
  - [The Hacker News](https://thehackernews.com/)  - News and info covering Data Breaches, Cyber Attacks, Vulnerabilities, Malware. [RSS](https://feeds.feedburner.com/TheHackersNews)
  - [Sophos: Naked Security](https://nakedsecurity.sophos.com/) - Security news and updates, presented in an easy-to-digest format. [RSS](https://nakedsecurity.sophos.com/feed/)
  - [IT Security Guru](https://www.itsecurityguru.org/) - Combines top cyber security news from multiple sites, easier to stay up-to-date
  - [FOSS Bytes - Cyber Security](https://fossbytes.com/category/security) - News about the latest exploits and hacks
- **Cyber Security Infomation**
  - [Heimdal](https://heimdalsecurity.com/blog) - Personal Cyber Security Tutorials and Articles
  - [Tech Crunch](https://techcrunch.com/tag/cybersecurity-101) - Cyber Security 101
  - [Email Self-Defense](https://emailselfdefense.fsf.org) - Complete guide to secure email
  - [Security Planner](https://securityplanner.org) - Great advise for beginners
  - [My Shaddow](https://myshadow.org) - Resources and guides, to help you take controll of your data
- **Privacy Guides**
  - [EFF SSD](https://ssd.eff.org) - Tips for safer online communications
  - [Restore Privacy](https://restoreprivacy.com) - Tools and guides about privacy and security
  - [That One Privacy Site](https://thatoneprivacysite.net) - impartial comparisons and discussions
  - [The Hated One](https://www.youtube.com/channel/UCjr2bPAyPV7t35MvcgT3W8Q) - Privacy and security videos
  - [12Bytes](https://12bytes.org/articles/tech) - Tech, Privacy and more (Note, sometimes covers controversial topics)
  - [Pixel Privacy](https://pixelprivacy.com/resources) - Online privacy guides
  - [The Tin Hat](https://thetinhat.com) - Tutorials and Articles for Online Privacy
  - [PrivacyTools.io]( https://www.privacytools.io) - Tools to protect against mass surveillance
  - [PrismBreak](https://prism-break.org/en/all) - Secure app alternatives
  - [The VERGE guide to privacy](https://bit.ly/2ptl4Wm) - Guides for securing mobile, web and home tech
- **Privacy News**
  - [Spread Privacy](https://spreadprivacy.com) - Raising the standard of trust online, by DuckDuckGo
  - [BringBackPrivacy](https://bringingprivacyback.com) - Easy-reading, sharable privacy articles
  - [The Privacy Project](https://www.nytimes.com/interactive/2019/opinion/internet-privacy-project.html) - Articles and reporting on Privacy, by the NYT
- **Internet Freedom**
  - [OONI](https://ooni.org/post), Internet freedom and analysis on blocked sites
  - [Internet Health Report](https://foundation.mozilla.org/en/internet-health-report) - Mozilla is documenting and explaining what’s happening to openness and freedom on the Internet
  - [Worth Hiding](https://worthhiding.com) - Posts about privacy, politics and the law

## Books
- [Permanent Record](https://www.amazon.co.uk/Permanent-Record-Edward-Snowden/dp/1529035651) by Edward Snowden
- [Sandworm](https://www.amazon.co.uk/Sandworm-Cyberwar-Kremlins-Dangerous-Hackers/dp/0385544405) by Andy Greenberg: A New Era of Cyberwar and the Hunt for the Kremlin's Most Dangerous Hackers
- [Extreme Privacy](https://www.amazon.co.uk/Extreme-Privacy-Takes-Disappear-America/dp/1093757620) by Michael Bazzell: Thoroughly detailed guide for protecting your privacy both electronically and physically
- [Ghost in the Wires](https://www.amazon.co.uk/gp/product/B00FOQS8D6) by Kevin Mitnick: Kevin tells his story of being the world's most wanted hacker
- [The Art of Invisibility](https://www.amazon.com/Art-Invisibility-Worlds-Teaches-Brother/dp/0316380504), by Kevin Mitnick: You How to Be Safe in the Age of Big Brother
- [Eyes in the Sky](https://www.goodreads.com/book/show/40796190-eyes-in-the-sky): The Secret Rise of Gorgon Stare and How It Will Watch Us All, by Arthur Holla Michel: Outlines the capabilities of the digital imaging in continuous aerial and satellite surveillance, and discusses both the current systems that are deployed, and the technical feasibility of future plans

## Podcasts
- [Darknet Diaries] by Jack Rhysider: Stories from the dark sides of the internet.<br>
[![Stitcher](https://img.shields.io/badge/Listen-Stitcher-E88923?logo=stitcher&style=flat-square)][da-stitch]
[![iTunes](https://img.shields.io/badge/Listen-iTunes-FB5BC5?logo=itunes&style=flat-square)][da-itunes]
[![Spotify](https://img.shields.io/badge/Listen-Spotify-1ED760?logo=spotify&style=flat-square)][da-spotify]
[![Google Podcasts](https://img.shields.io/badge/Listen-Google%20Podcasts-4285F4?logo=Google%20Podcasts&style=flat-square)][da-google]
[![PocketCasts](https://img.shields.io/badge/Listen-PocketCasts-F43E37?logo=Pocket%20Casts&style=flat-square)][cy-pocketcasts]
- [CYBER] by Motherboard: News and analysis about the latest cyber threats<br>
[![Stitcher](https://img.shields.io/badge/Listen-Stitcher-E88923?logo=stitcher&style=flat-square)][cy-stitch]
[![iTunes](https://img.shields.io/badge/Listen-iTunes-FB5BC5?logo=itunes&style=flat-square)][cy-itunes]
[![Spotify](https://img.shields.io/badge/Listen-Spotify-1ED760?logo=spotify&style=flat-square)][cy-spotify]
[![SoundCloud](https://img.shields.io/badge/Listen-SoundCloud-FF6600?logo=soundcloud&style=flat-square)][cy-soundcloud]
[![PocketCasts](https://img.shields.io/badge/Listen-PocketCasts-F43E37?logo=Pocket%20Casts&style=flat-square)][cy-pocketcasts]
- [The Privacy, Security, & OSINT Show] by Michael Bazzell: Comprehensive guides on Privacy and OSINT<br>
[![Stitcher](https://img.shields.io/badge/Listen-Stitcher-E88923?logo=stitcher&style=flat-square)][tp-stitch]
[![iTunes](https://img.shields.io/badge/Listen-iTunes-FB5BC5?logo=itunes&style=flat-square)][tp-itunes]
[![Spotify](https://img.shields.io/badge/Listen-Spotify-1ED760?logo=spotify&style=flat-square)][tp-spotify]
[![SoundCloud](https://img.shields.io/badge/Listen-SoundCloud-FF6600?logo=soundcloud&style=flat-square)][tp-soundcloud]
[![PocketCasts](https://img.shields.io/badge/Listen-PocketCasts-F43E37?logo=Pocket%20Casts&style=flat-square)][tp-pocketcasts]
- [Smashing Security] by Graham Cluley and Carole Theriault: Casual, opinionated and humerous chat about current cybersecurity news<br>
[![Stitcher](https://img.shields.io/badge/Listen-Stitcher-E88923?logo=stitcher&style=flat-square)][sm-stitch]
[![iTunes](https://img.shields.io/badge/Listen-iTunes-FB5BC5?logo=itunes&style=flat-square)][sm-itunes]
[![Spotify](https://img.shields.io/badge/Listen-Spotify-1ED760?logo=spotify&style=flat-square)][sm-spotify]
[![Google Podcasts](https://img.shields.io/badge/Listen-Google%20Podcasts-4285F4?logo=Google%20Podcasts&style=flat-square)][sm-google]
[![PocketCasts](https://img.shields.io/badge/Listen-PocketCasts-F43E37?logo=Pocket%20Casts&style=flat-square)][sm-pocketcasts]
- [IRL Podcast] by Mozilla: Online Life is Real Life, Stories about the future of the Web<br>
[![Stitcher](https://img.shields.io/badge/Listen-Stitcher-E88923?logo=stitcher&style=flat-square)][irl-stitch]
[![iTunes](https://img.shields.io/badge/Listen-iTunes-FB5BC5?logo=itunes&style=flat-square)][irl-itunes]
[![Spotify](https://img.shields.io/badge/Listen-Spotify-1ED760?logo=spotify&style=flat-square)][irl-spotify]
[![Google Podcasts](https://img.shields.io/badge/Listen-Google%20Podcasts-4285F4?logo=Google%20Podcasts&style=flat-square)][irl-google]
[![PocketCasts](https://img.shields.io/badge/Listen-PocketCasts-F43E37?logo=Pocket%20Casts&style=flat-square)][irl-pocketcasts]
- [Random but Memorable] by 1Password - A Security advice podcast<br>
[![Stitcher](https://img.shields.io/badge/Listen-Stitcher-E88923?logo=stitcher&style=flat-square)][rbm-stitch]
[![iTunes](https://img.shields.io/badge/Listen-iTunes-FB5BC5?logo=itunes&style=flat-square)][rbm-itunes]
[![Spotify](https://img.shields.io/badge/Listen-Spotify-1ED760?logo=spotify&style=flat-square)][rbm-spotify]
[![Google Podcasts](https://img.shields.io/badge/Listen-Google%20Podcasts-4285F4?logo=Google%20Podcasts&style=flat-square)][rbm-google]
[![PocketCasts](https://img.shields.io/badge/Listen-PocketCasts-F43E37?logo=Pocket%20Casts&style=flat-square)][rbm-pocketcasts]


 
More Security Podcasts on [player.fm](https://player.fm/featured/security)

 More Podcasts (Verification Required): [Naked Security](https://nakedsecurity.sophos.com) | [Open Source Security Podcast](opensourcesecuritypodcast.com) | [Defensive Security Podcast](https://defensivesecurity.org) | [Malicious Life](https://malicious.life) | [Down the Security Rabbit Hole](http://podcast.wh1t3rabbit.net) | [Cyber Wire](https://thecyberwire.com/podcasts/daily-podcast) | [Hacking Humans](https://thecyberwire.com/podcasts/hacking-humans) | [Security Now](https://twit.tv/shows/security-now) | [Cyber Security Interviews](https://cybersecurityinterviews.com) | [Security Weekly](https://securityweekly.com) | [The Shared Security Podcast](https://sharedsecurity.net) | [Risky Business](https://risky.biz/netcasts/risky-business) | [Crypto-Gram Security Podcast](https://crypto-gram.libsyn.com) | [Off the Hook](https://player.fm/series/off-the-hook-84511) | [Opt Out Podcast](https://optoutpod.com/)
 

[Darknet Diaries]: https://darknetdiaries.com
[da-stitch]: https://www.stitcher.com/podcast/darknet-diaries
[da-itunes]: https://podcasts.apple.com/us/podcast/darknet-diaries/id1296350485
[da-spotify]: https://open.spotify.com/show/4XPl3uEEL9hvqMkoZrzbx5
[da-pocketcasts]: https://pca.st/darknetdiaries
[da-google]: https://podcasts.google.com/?feed=aHR0cHM6Ly9mZWVkcy5tZWdhcGhvbmUuZm0vZGFya25ldGRpYXJpZXM%3D

[CYBER]: https://www.vice.com/en_us/article/59vpnx/introducing-cyber-a-hacking-podcast-by-motherboard
[cy-stitch]: https://www.stitcher.com/podcast/vice-2/cyber
[cy-soundcloud]: https://soundcloud.com/motherboard
[cy-itunes]: https://podcasts.apple.com/us/podcast/cyber/id1441708044
[cy-spotify]: https://open.spotify.com/show/3smcGJaAF6F7sioqFDQjzn
[cy-pocketcasts]: https://pca.st/z7m3

[The Privacy, Security, & OSINT Show]: https://inteltechniques.com/podcast.html
[tp-stitch]: https://www.stitcher.com/podcast/michael-bazzell/the-complete-privacy-security-podcast
[tp-soundcloud]: https://soundcloud.com/user-98066669
[tp-itunes]: https://podcasts.apple.com/us/podcast/complete-privacy-security/id1165843330
[tp-spotify]: https://open.spotify.com/show/6QPWpZJ6bRTdbkI7GgLHBM
[tp-pocketcasts]: https://pca.st/zdIq

[Smashing Security]: https://www.smashingsecurity.com
[sm-stitch]: https://www.stitcher.com/podcast/smashing-security
[sm-itunes]: https://podcasts.apple.com/gb/podcast/smashing-security/id1195001633
[sm-spotify]: https://open.spotify.com/show/3J7pBxEu43nCnRTSXaan8S
[sm-pocketcasts]: https://pca.st/47UH
[sm-google]: https://podcasts.google.com/?feed=aHR0cHM6Ly93d3cuc21hc2hpbmdzZWN1cml0eS5jb20vcnNz

[IRL Podcast]: https://irlpodcast.org
[irl-stitch]: https://www.stitcher.com/podcast/smashing-security
[irl-itunes]: https://geo.itunes.apple.com/podcast/us/id1247652431?mt=2&at=1010lbVy
[irl-spotify]: https://open.spotify.com/show/0vT7LJMeVDxyQ2ZamHKu08
[irl-pocketcasts]: https://pca.st/irl
[irl-google]: https://www.google.com/podcasts?feed=aHR0cHM6Ly9mZWVkcy5tb3ppbGxhLXBvZGNhc3RzLm9yZy9pcmw

[Random but Memorable]: https://blog.1password.com/random-but-memorable-the-security-advice-podcast-from-1password
[rbm-stitch]: https://www.stitcher.com/podcast/1password/random-but-memorable
[rbm-itunes]: https://podcasts.apple.com/us/podcast/random-but-memorable/id1435486599
[rbm-pocketcasts]: https://pca.st/43AW
[rbm-spotify]: https://open.spotify.com/show/5Sa3dy0xDvMT0h3O5MGMOr
[rbm-google]: https://podcasts.google.com/?feed=aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS9lRVpIazJhTA


## Videos
- **General**
  - [You are being watched](https://youtu.be/c8jDsg-M6qM) by The New York Times
  - [The Power of Privacy](https://youtu.be/KGX-c5BJNFk) by The Guardian
  - [Why Privacy matters, even if you have nothing to hide](https://youtu.be/Hjspu7QV7O0) by The Hated One
  - [The Unhackable Email Service](https://youtu.be/NM8fAnEqs1Q) by Freethink
  - [NSA Whistleblower: Government Collecting Everything You Do](https://youtu.be/SjHs-E2e2V4) by Empire Files
- **Cryptography**
  - [Advanced Into to GnuPGP](https://begriffs.com/posts/2016-11-05-advanced-intro-gnupg.html) by  Neal Walfield ([walfield.org](http://walfield.org/))
- **TED Talks**
  - [How Online Trackers Track You, and What To Do About It](https://youtu.be/jVeqAemtC6w) by Luke Crouch
  - [Why you should switch off your home WiFi](https://youtu.be/2GpNhYy2l08) by Bram Bonné
  - [Why Privacy Matters](https://www.ted.com/talks/glenn_greenwald_why_privacy_matters), by Glenn Greenwald
  - [Fighting viruses, defending the net](https://www.ted.com/talks/mikko_hypponen_fighting_viruses_defending_the_net), by Mikko Hypponen
  - [The 1s and 0s behind cyber warfare](https://www.ted.com/talks/chris_domas_the_1s_and_0s_behind_cyber_warfare), by Chris Domas
  - [State Sanctioned Hacking - The Elephant in the Room](https://youtu.be/z-A2MxHmnU4) - Historic, economic and demographic overview of the growing threat to the U.S. from Chinese cyber invasions, by Frank Heidt
  - [How the IoT is Making Cybercrime Investigation Easier](https://youtu.be/9CemONO6vrY) - How our data is changing the nature of "evidence" in digital forensics, by Jonathan Rajewski
  - [Online Privacy Doesn't Exist](https://youtu.be/LgWrD3EJ1Do) - The unexpected dangers our digital breadcrumbs can lead to, by Denelle Dixon
  - [Data is the new gold, who are the new thieves?](https://youtu.be/XNF-rGiGb50) - Introduction and demonstration of the power of data, by Tijmen Schep
- **Conferences**
  - [DEF CON 27](https://www.youtube.com/playlist?list=PL9fPq3eQfaaA4qJEQQyXDYtTIfxCNA0wB) - Collection of talks from DEF CON 2019, Vegas
  - [RSA Conference](https://www.youtube.com/user/RSAConference) - Collection of security talks from the RSA conferences
  - [Administraitor.video](https://administraitor.video) - A regularly updated collection of new and interesting security confrence talks
- **Misc**
  - [Through a PRISM, Darkly](https://youtu.be/e4woRYs0mM4) - Everything we know about NSA spying, by Kurt Opsahl
  - [What it REALLY takes to have True Privacy in the 21st Cen](https://youtu.be/bxQSu06yuZc) by @MalcomVetter

See also: [awesome-sec-talks](https://github.com/PaulSec/awesome-sec-talks) by @PaulSec


## Online Tools

- **Check and Test**
  - [εxodus](https://reports.exodus-privacy.eu.org) - Check which trackers any app on the Play Store has
  - [Have I been Pwned](https://haveibeenpwned.com) and [Dehashed](https://www.dehashed.com) - Check if your details have been compromised
  - [Redirect Detective](https://redirectdetective.com) - Check where a suspicious URL redirects to
  - [Botometer](https://botometer.iuni.iu.edu/) - An AI script to check if a certain username is a bot
  - [Who Tracks Me](https://whotracks.me/trackers.html) - Breakdown of common tracking scripts, and which sites use them
- **Utilities**
  - [Privacy.sexy](https://privacy.sexy/) - A collection of commands you can run to impplement best prctices on Windows or MacOS
  - [ExifRemove](https://www.exifremove.com) - Remove Meta/ EXIF data online
  - [Secure Password Check](https://password.kaspersky.com) - Fun little tool, to demonstrate how long it could take to crack a password
  - [33Mail](http://33mail.com/Dg0gkEA) or [Anonaddy](https://anonaddy.com) or [SimpleLogin](https://simplelogin.io?slref=bridsqrgvrnavso) Protect your email address, by auto-generating unique permeant aliases for each account, so all emails land in your primary inbox
  - [Deseat Me](https://www.deseat.me) - Clean up your online presence
- **Anti-Tracking Analysis**
  - [Panopticlick](https://panopticlick.eff.org) - Check if, and how your browser is tracking  you
  - [Browser Leaks](https://browserleaks.com) - Check which information is being leaked by your browser
  - [DNSLeakTest](https://www.dnsleaktest.com) - Check for and fix a DNS leak
  - [IP Leak](https://ipleak.net) - IP Leak test
  - [Am I Unique?](http://amiunique.org) - If your fingerprint is unique, then websites can track you
  - [Qualys SSL Client Test](https://clienttest.ssllabs.com:8443/ssltest/viewMyClient.html) - Check the SSL/TLS capabilities of your browser
- **Phishing, Hacking and Abuse**
  - [VirusTotal](https://www.virustotal.com) - Analyse a suspicious web resource for malware
  - [ScamAdviser](https://www.scamadviser.com) - Check if a website is a scam, before buying from it
  - [Abuse IP DB](https://www.abuseipdb.com) - Report an IP address for abuse, spam or attacks, and check the status of any IP
  - [Phish Tank](https://www.phishtank.com) - Check if a link is a known phishing URL, Submit a phishing URL, browse recent phishing URLs
  - [Is It Hacked?](http://www.isithacked.com) - Check if a website or page appears to be hacked, hijacked or generally suspicious 
- **IP Tools**
  - [I Know What You Download](https://iknowwhatyoudownload.com) - Shows torrents that have been downloaded or distributed from your IP address
  - [Hetrix Tools - Blacklist Check](https://hetrixtools.com/blacklist-check/) - Check if your Domain or IP appears on any common blacklists
  - [Check: The Tor Project](https://check.torproject.org/) - Check if your connected via Tor, and diagnose issues
- **Public Domain and Website Scanning Tools**
  - [URL Scan](https://urlscan.io) - Scan and analyse websites, shows IP, DNS, domain and host data, as well as info about resources and requests
  - [Security Trails](https://securitytrails.com/#search) - Shows all DNS records, historical DNS data and sub domains
  - [crt.sh](https://crt.sh) - Shows current and previous SSL/ TLS certificates for a given domain, has advanced search option
  - [Virus Total](https://www.virustotal.com) - Scans any URL, web asset or file for malware
  - [DomainTools WhoIs](https://whois.domaintools.com) - Who Is Lookup. Check who registered a domain name, and find contact details
  - [Pentest Tools Vulnerability Scanner](https://pentest-tools.com/website-vulnerability-scanning/website-scanner) - Light scan searches for client and server-side vulnerabilities and missing HTTP security headers
  - [Qualys SSL Server Test](https://www.ssllabs.com/ssltest) - Perform a deep analysis of the configuration of any SSL web server on the public Internet
  - [Abuse IP DB](https://www.abuseipdb.com) - Check if an IP or domain has been reported for abuse, or file a report
  - [RIPEstat](https://stat.ripe.net) - Detailed analysis of IP Addresses (Routing, DNS, Abuse History, Activity etc)
  - [Multirbl](http://multirbl.valli.org) - Complete IP check for sending Mailservers
  - [IPVoid](https://www.ipvoid.com) - Full suit of Domain, IP, and DNS tools for Tracing, Lookup, Checking and Pinging
- **Net Neutrality**
  - [Blocked by ORG](https://www.blocked.org.uk) - Check if your website is blocked by certain ISPs
  - [Data Rights Finder](https://www.datarightsfinder.org) - Find, understand and use information from privacy policies
  - [Down For Everyone Or Just Me](https://downforeveryoneorjustme.com) - Quickly determine if a website is down, or just unavailable for you
- **Anonymous Services** - The following sites host a veriety of anonymous online services
  - [NixNet](https://nixnet.services)
  - [Snopyta](https://snopyta.org)
  - [Disroot](https://disroot.org)
- **Archives**
  - [The Way Back Machine](https://archive.org/web/web.php) - See previous versions of any website. An archive of 431 billion snapshots over 20 years
  - [PolitiTweet](https://polititweet.org) -  Archives Tweets from powerful public figures, and records silent retractions and deleted tweets
  - [Internet Archive Software Collection](https://archive.org/details/software) - The largest vintage and historical software library
  - [OpenLibrary](https://openlibrary.org) - A free, digital library of over 2 million eBooks, and information on over 20 million books
  - [Archive-It](https://archive-it.org) - Collecting and accessing cultural heritage on the web


## Privacy-Respecting Software

This section has moved to [here](https://github.com/Lissy93/awesome-privacy). Complete list of privacy-respecting software and services

## Security Hardware

This section has moved to [here](/6_Privacy_and-Security_Gadgets.md). Products, gadgets and DIY projects to help improve security

## Data, API's and Visualisations

- **Research Results**
  - [Internet Census Data](https://ant.isi.edu/datasets) - Includes data on address space allocation, traffic, DNS, service enumeration, internet outages and other internet topology data
  - [Web Tracking Data](https://webtransparency.cs.princeton.edu/webcensus/#data) by Princeton University - This is the largest and most detailed analysis of online tracking to date, and measures both stateful (cookie-based) and stateless (fingerprinting-based) tracking. The crawls were made with [OpenWPM](https://github.com/mozilla/OpenWPM)
  - [Who has your Back?](https://www.eff.org/files/2019/06/11/whyb_2019_report.pdf) by EFF - Anual report assessing how companies handle personal data
    - Historic Reports: [2012](https://www.eff.org/files/who-has-your-back-2012_0.pdf) | [2013](https://www.eff.org/sites/default/files/who-has-your-back-2013-report-20130513.pdf) | [2014](https://www.eff.org/files/2014/05/15/who-has-your-back-2014-govt-data-requests.pdf) | [2015](https://www.eff.org/files/2015/06/18/who_has_your_back_2015_protecting_your_data_from_government_requests_20150618.pdf) | [2016](https://www.eff.org/files/2016/05/04/who-has-your-back-2016.pdf) | [2017](https://www.eff.org/files/2017/07/08/whohasyourback_2017.pdf) | [2018](https://www.eff.org/files/2018/05/31/whyb_2018_report.pdf) | [2019](https://www.eff.org/files/2019/06/11/whyb_2019_report.pdf)
  - [Lists of Websites Abusing Session Replay](https://webtransparency.cs.princeton.edu/no_boundaries/session_replay_sites.html) - Third-party sesssion replay scripts, record all your acions and allow them to be watched by a human. This list of websites include this
    - See also, the accompaniing [blog post](https://freedom-to-tinker.com/2017/11/15/no-boundaries-exfiltration-of-personal-data-by-session-replay-scripts/) and the [WebTAP](https://webtap.princeton.edu/) project
  - [Sensor Access Data](https://databank.illinois.edu/datasets/IDB-9213932) - A Crawl of the Mobile Web Measuring Sensor Accesses, Illinois
  - [Canalys Newsroom](https://www.canalys.com/newsroom) - Research Studies on Security, Privacy, Technology and Finance
  - [Data Never Sleeps](https://web-assets.domo.com/blog/wp-content/uploads/2019/07/data-never-sleeps-7-896kb.jpg) - An infographic visualizing how much data is generated every minute (2019)
  - [What they Know about You](https://external-preview.redd.it/KU3pS4LIhLWqeYSluiYyJMhLQW1fEjTdh8lEKL2jafc.png?auto=webp&s=fe015c1e32731bc61cd0d57313f5a261173846ca) - An Infographic showing what information are Giant Tech Companies collecting from you (2020)
- **Databases**
  - [Exodus](https://reports.exodus-privacy.eu.org/en/trackers/stats) - Trackers in Android Apps
  - [Exploit Database](https://www.exploit-db.com) - A database or Current software vulnerabilities
  - [URLScan](https://urlscan.io) - Service scanning for malicious domains, with historical results
  - [Dehashed](https://www.dehashed.com/breach) - Data Breaches and Credentials
  - [VirusTotal](https://developers.virustotal.com/v3.0/reference) - Detailed virus scans of software
  - [Abuse IP DB](https://www.abuseipdb.com) - Database of IPs reported for abuse
  - [SnusBase](https://snusbase.com) - Long standing database hosting breached data
  - [OpenPhish](https://openphish.com) - A feed of current phishing endpoints
  - [HashToolkit](http://hashtoolkit.com) - Database of 'cracked' hashes
  - [SecLists](https://github.com/danielmiessler/SecLists) - Starter list of leaked databases, passwords, usernames etc (Great for programming)
  - [Qualys SSL Pulse](https://www.ssllabs.com/ssl-pulse) - A continuous and global dashboard for monitoring the quality of SSL / TLS support over time across 150,000 SSL - and TLS-enabled websites, based on Alexa’s list of the most popular sites in the world
  - [Tor Bulk Exit List](https://check.torproject.org/torbulkexitlist) - List of all exit nodes (IP) in use on the Tor network
- **Fun with Live Data** 🌠
  - **Internet**
    - [Tor Flow](https://torflow.uncharted.software) - Real-time data flow between Tor nodes
    - [Internet Census](http://census2012.sourceforge.net/images/geovideo.gif) - 24-hour world map of average utilization of IPv4 addresses
    -  ICMP ping requests were sent out via the Carna botnet. Read how this was done on the [Official Site](http://census2012.sourceforge.net) or download similar [datasets](https://ant.isi.edu/datasets/all.html)
    - [Map of Mobile Internet](https://labs.mapbox.com/labs/twitter-gnip/brands/) - Shows world data coverage, according to Twitter data
    - [IKnow](https://iknowwhatyoudownload.com/en/stat/GB/daily) - Live data showing what content is being downloaded + distributed via torrents
    - [Semantic Internet Map](http://internet-map.net) - Shows how different websites link together
    - [Wiggle](https://wigle.net) - Worlds largest WiFi Map showing personal hotspot statistics geographically
    - [BGP Stream](https://bgpstream.com) - Shows all current outages
    - [Freedom House - Censorship Map](https://freedomhouse.org/explore-the-map) - Global internet freedom and democracy status per country, over time
    - [DomainTools Statistics](https://research.domaintools.com/statistics) - Domain registration Numbers and Charts
    - [Insecam](http://www.insecam.org) - A directory and feed of insecure or public live webcams
  - **Cyber**
    - [Checkpoint](https://threatmap.checkpoint.com) - Geographical plotting of Malware, Phishing and Exploits
    - [Comparitech Ransomware Attack Map](https://www.comparitech.com/ransomware-attack-map/) - Geographically plotted ransomware attacks and stats
    - [FortiGuard](https://threatmap.fortiguard.com) - Incoming & Outgoing Attacks per Country
    - [Kaspersky Stats](https://cybermap.kaspersky.com/stats) - Shows detailed threats per second from a variety of categories
    - [Kaspersky LogBook](https://apt.securelist.com) - Historic Threat Time Line
    - See also
      - Every AV-provider and wannabe security company has a matrix-style cyber map nowadays, here are some less-spectacular ones, which didn't make it onto the list: [Fire Eye](https://www.fireeye.com/cyber-map/threat-map.html), [BitDefender](https://threatmap.bitdefender.com), [ESET](https://www.virusradar.com), [Looking Glass Cyber Map](https://map.lookingglasscyber.com), [Digital Attack Map](https://www.digitalattackmap.com)
      - [pewpew](https://github.com/hrbrmstr/pewpew) is a sweet web component, that you can use to build your own threat map (with sound effects!)
  - **Unrelated, but Awesome Data**
    - [Submarine Cable Map](https://www.submarinecablemap.com) - An up-to-date map of major global internet cables (see also [he.net](https://he.net/3d-map) and [this](https://submarine-cable-map-2016.telegeography.com))
    - [FlightRadar24](https://www.flightradar24.com) - World-wide map of live aircraft positions
    - [Marine Traffic](https://www.marinetraffic.com/) - World-wide map of live ships, tankers, cargo & passenger vessels and more
    - [Stuff in Space](http://stuffin.space) - Shows objects orbiting Earth
    - [Asterank](http://www.asterank.com/) - A scientific and economic database of over 600,000 asteroids
    - [Flight Misery Map](https://uk.flightaware.com/miserymap/) - Real-time US geographical flight delay & cancellation trends
    - [Meteor Showers](https://www.meteorshowers.org/) - Shows commit locations, simulating meteor showers with time
    - [Airport WiFi Map](https://www.google.com/maps/d/u/0/viewer?mid=1Z1dI8hoBZSJNWFx2xr_MMxSxSxY) - Shows WiFi networks and their passwords for airports around the world
    - [One in a Million](https://onemilliontweetmap.com/) - A real-time Twitter map
    - [ListenToWikipedia](http://listen.hatnote.com/) - Wikipedia edits, represented by a tone, depending on size, built by Hatnote
    - [BitListen](https://www.bitlisten.com/) - Real-time BTC transactions, represented by bubbles and tones
    - [FiatLeak](https://fiatleak.com/) - Real-time crypto stats
    - [Google Search Terms](https://trends.google.com/trends/hottrends/visualize?pn=p9&nrow=4&ncol=4) - Hourly Google Search Trends, in your location
    - [Sentiment Sweep](https://sentiment-sweep.com/now) - Geographic sentiment analysis on real-time Twitter data (- I made this one)
    - [Three Thousand Years](http://histography.io/) - Shows major events throughout history, using Wikipedia data
    - [Wiki-Atlas](https://wiki-atlas.org/) - Wikipedia articles, categorized and plotted on a map
    - [ncov2019/live](https://ncov2019.live/) - Real-time Covid-19 data, map and dashboard (by Avi Schiffmann)
    - [National Grid: Live Status](http://grid.iamkate.com/) - Real-time UK energy stats (by Kate Morley) (similar to [Grid Watch](https://www.gridwatch.templar.co.uk/))
    - [Globe of Economic Complexity](http://globe.cid.harvard.edu/) - Visualize's 15 Trillion dollars of world trade, where each dot is $100,000,000 of export
 
 Interested in discovering more awesome real-time data visualizations? Check out [this post, here](https://listed.to/@lissy93/18611/fun-with-real-time-data) 🌠
 
## Academic

- **Journals**
  - Rethinking information privacy‐security: Does it really matter? By Waseem Afzal: via [Wiley](https://asistdl.onlinelibrary.wiley.com/doi/10.1002/meet.14505001095)
  - Crypto Paper: Privacy, Security, and Anonymity For Every Internet User, by Crypto Seb: via [GitHub](https://github.com/cryptoseb/cryptopaper)
  - Challenges in assessing privacy impact, Tales from the Front Line: via [Wiley](https://onlinelibrary.wiley.com/doi/10.1002/spy2.101)
  - A privacy‐preserving multifactor authentication system: via [Wiley](https://onlinelibrary.wiley.com/doi/10.1002/spy2.88)
  - Web Browser Privacy: What Do Browsers Say When They Phone Home?: via [scss.tcd.ie](https://www.scss.tcd.ie/Doug.Leith/pubs/browser_privacy.pdf)
  - Online Tracking, A 1-million-site Measurement and Analysis: via [Princeton University](https://www.cs.princeton.edu/~arvindn/publications/OpenWPM_1_million_site_tracking_measurement.pdf)
  - Detecting and Defending Against Third-Party Tracking on the Web: via [Franziska Roesner](http://www.franziroesner.com/pdf/webtracking-NSDI2012.pdf)
  - Is Google degrading search? Consumer Harm from Universal Search: via [law.berkeley.edu](https://www.law.berkeley.edu/wp-content/uploads/2015/04/Luca-Wu-Yelp-Is-Google-Degrading-Search-2015.pdf)
  - A Comprehensive Evaluation of Third-Party Cookie Policies: via [WhoLeftOpenTheCookieJar.com](https://wholeftopenthecookiejar.com/static/tpc-paper.pdf)
  - The Dangers of Surveillance: via [Harvard Law Review](https://harvardlawreview.org/wp-content/uploads/pdfs/vol126_richards.pdf)
  - Recognizing Speech From Gyroscope Signals: via [Stanford](https://crypto.stanford.edu/gyrophone/)
  - A Study of Scripts Accessing Smartphone Sensors: via [sensor-js.xyz](https://sensor-js.xyz/webs-sixth-sense-ccs18.pdf)
  - Pixel Perfect, Fingerprinting Canvas in HTML5: [hovav.net](https://hovav.net/ucsd/dist/canvas.pdf)
  - Shining the Floodlights on Mobile Web Tracking — A Privacy Survey: via [semanticscholar.org](https://pdfs.semanticscholar.org/80bb/5c9119ff4fc2374103b4f3d6a8f614b3c2ed.pdf)
  - Characterizing the Use of Browser-Based Blocking Extensions To Prevent Online Tracking: via [aruneshmathur.co.in](http://aruneshmathur.co.in/files/publications/SOUPS18_Tracking.pdf)
  - Privacy implications of email tracking: via [senglehardt.com](https://senglehardt.com/papers/pets18_email_tracking.pdf)
  - Battery Status Not Included, Assessing Privacy in Web Standards: via [princeton.edu](https://www.cs.princeton.edu/~arvindn/publications/battery-status-case-study.pdf)
  - Achieving Anonymity Against Major Face Recognition Algorithms: via [ruhr-uni-bochum.de](https://www.mobsec.ruhr-uni-bochum.de/media/ei/veroeffentlichungen/2016/01/15/2013-cms-face-recognition.pdf)
  - De-anonymizing Web Browsing Data with Social Networks: via [princeton.edu](https://www.cs.princeton.edu/~arvindn/publications/browsing-history-deanonymization.pdf)
  - The Surveillance Implications of Web Tracking: via [senglehardt.com](https://senglehardt.com/papers/www15_cookie_surveil.pdf)
  - Understanding Facebook Connect login permissions: via [jbonneau.com](http://jbonneau.com/doc/RB14-fb_permissions.pdf)
  - Corporate Surveillance in Everyday Life, How Companies Collect, Combine, Analyze, Trade, and Use Personal Data on Billions: By Wolfie Christl, via [crackedlabs.org](https://crackedlabs.org/dl/CrackedLabs_Christl_CorporateSurveillance.pdf)
  - Using Ad Targeting for Surveillance on a Budget: via [washington.edu](https://adint.cs.washington.edu/ADINT.pdf)
  - Cross-Site WebSocket Hijacking: via [christian-schneider.net](http://www.christian-schneider.net/CrossSiteWebSocketHijacking.html)
  - Location Tracking using Mobile Device Power Analysis: [scribd.com](https://www.scribd.com/doc/256304846/PowerSpy-Location-Tracking-using-Mobile-Device-Power-Analysis)
  - HORNET, High-speed Onion Routing at the Network Layer: via [arxiv.org](https://arxiv.org/pdf/1507.05724v1.pdf)
  - Decoy Routing: Toward Unblockable Internet Communication: via [usenix.org](https://www.usenix.org/legacy/events/foci11/tech/final_files/Karlin.pdf)
  - Trackers Vs Firefox, Comparing different blocking utilities: via [GitHub - @jawz101](https://github.com/jawz101/TrackersVsFirefox)
  - 'I've Got Nothing to Hide' and Other Misunderstandings of Privacy: via [ssrn.com](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=998565&)
- **Write-Ups**
  - Privacy - An Encyclopedic Definition and Background [stanford.edu](https://plato.stanford.edu/entries/privacy/)


- **Implementations and Standards**
  - [The GNU Privacy Guard](https://www.gnupg.org)
  - [OpenPGP JavaScript Implementation](https://openpgpjs.org)
  - [WireGuard](https://www.wireguard.com/papers/wireguard.pdf)
  - [Nym](https://as93.link/nym-blog-post) - Next Generation of Privacy infrastructure
  - [REC-X.509](https://www.itu.int/rec/T-REC-X.509) - The standard defining the format of public key certificates, used across most internet protocols and applications
  - [obfs4-spec](https://gitweb.torproject.org/pluggable-transports/obfs4.git/tree/doc/obfs4-spec.txt) & [obfs3-protocol-spec](https://gitweb.torproject.org/pluggable-transports/obfsproxy.git/tree/doc/obfs3/obfs3-protocol-spec.txt) - The Tor obfourscator and Pluggable transport for obfuscated traffic
  




## Foundations

- [Contract for the Web](https://contractfortheweb.org)
- [Electronic Frountier Foundation](https://www.eff.org) - Defending digital privacy + more
- [OWASP Foundation](https://www.owasp.org)
- [Freedom House](https://freedomhouse.org) - Fighting for freedom on the net
- [Privacy International](https://privacyinternational.org)
- [Open Tech Fund](https://www.opentech.fund)
- [Freedom of the Press Foundation](https://freedom.press)
- [Open Rights Group](https://www.openrightsgroup.org)
- [LEAP Encryption Access Project](https://leap.se)
- [The Guardian Project](https://guardianproject.info)
- [Foundation for Applied Privacy](https://applied-privacy.net)
- [Safe + Secure](https://safeandsecure.film) - advise for journalists and film makers
- [Citizen Lab](https://citizenlab.ca)
- [Electronic Privacy Information Center](https://epic.org)
- [American Civil Liberties Union](https://www.aclu.org/issues/privacy-technology)
- [Free Software Foundation](https://www.fsf.org)
- [Calyx Institute](https://calyxinstitute.org/) - Brooklyn-based organisation, aiming to educate the public about privacy in digital communications
- [Courage Foundation](https://www.couragefound.org) - Supports those who risk life / liberty to make significant contributions to the historical record
- [Fight for the Future](https://www.fightforthefuture.org) - Fighting for a future where technology liberates
- [Public Citizen](https://www.citizen.org) - Standing up to corporate power and hold the government accountable
- [The DNS Privacy Project](https://dnsprivacy.org/wiki/display/DP) - Collaborative open project to promote, implement and deploy DNS Privacy
- [Epic](https://www.epic.org/) - Washington DC-based organisation raising attention to emerging privacy and civil liberties issues


## Governance

- **Citizen/ Small business Advice and Infrormation**
  - [UK National Cyber Security Center](https://www.ncsc.gov.uk)
  - [US Cybersecurity - NIST](https://www.nist.gov/topics/cybersecurity)
  - [Stay Safe Online](https://staysafeonline.org) - US government-backed project, aimed to inform and educate individuals and small businesses about basic digital security
  - [Annual Credit Report](https://www.annualcreditreport.com) - US Free Credit Reports
- **Cybercrime**
    - [Consumer Fraud Reporting](http://consumerfraudreporting.org) - US's Catalogue of online scams currently circulating, and a means to report cases
    - [Action Fraud](https://www.actionfraud.police.uk) - UK’s national reporting centre for fraud and cyber crime
    - [Crime Stoppers](https://crimestoppers-uk.org/) - UK Independent Charity, for reporting crimes anonymously 
- **Fact Checkling**
  - [Full Fact](https://fullfact.org) - UK independent fact checking charity, campaigning to expose bad information, and the harm it does
  - [Snopes](https://www.snopes.com/) - Transparent fact checking service, with documented sources. Their investigative reporting uses evidence-based and contextualized analysis
  - [FactCheck.org](https://www.factcheck.org/fake-news/) - US Site debunking misinformation shared on social media
  - [Media Bias Fact Check](https://mediabiasfactcheck.com/) - Focusing on media bias, and comparing different view points on each story from over 3000 sources
  - [AP Fact Check](https://apnews.com/APFactCheck) - Fact checking service provided by AP News
- **CERT** - Your local jurisdiction will likely have a Computer emergency response team (historically known as [CERT](https://online.norwich.edu/academic-programs/resources/how-computer-emergency-response-teams-and-computer-security-incident-response-teams-combat-cyber-threats)). Who is in charge of handline handles domestic and international computer security incidents.
  - **A-C** - Australia: [auscert.org.au](https://www.auscert.org.au) | Austria: [cert.at](https://www.cert.at) | Bangladesh: [cirt.gov.bd](https://www.cirt.gov.bd) |  Bolivia: [cgii.gob.bo](https://cgii.gob.bo) | Brazil: [cert.br](https://www.cert.br) | Canada: [cyber.gc.ca](https://cyber.gc.ca/en/about-cyber-centre) | China: [cert.org.cn](https://www.cert.org.cn) | Columbia: [colcert.gov.co](http://www.colcert.gov.co) | Croatia: [carnet.hr](https://www.carnet.hr) |  Czech Republic: [csirt.cz](https://csirt.cz) 
  - **D-G** - Denmark: [cert.dk](https://www.cert.dk) | Ecuador: [ecucert.gob.ec](https://www.ecucert.gob.ec) | Egypt: [egcert.eg](https://www.egcert.eg) | Estonia: [ria.ee / CERT-EE](https://ria.ee/en/cyber-security/cert-ee.html) | Finland: [kyberturvallisuuskeskus.fi](https://www.kyberturvallisuuskeskus.fi/en/homepage) | France: [cert.ssi.gouv.fr](https://www.cert.ssi.gouv.fr) | Germany: [cert-bund.de](https://www.cert-bund.de) | Ghana: [nca-cert.org.gh](https://nca-cert.org.gh) 
  - **H-M** - Hong Kong: [hkcert.org](https://www.hkcert.org) | Iceland: [cert.is](https://www.cert.is) | India: [CERT-IN](https://www.cert-in.org.in) | Indonesia: [idsirtii.or.id](https://idsirtii.or.id) | Iran: [cert.ir](https://cert.ir) | Italy: [cert-pa.it](https://www.cert-pa.it) | Japan: [JPCERT](https://www.jpcert.or.jp) | Kyrgyzstan: [cert.gov.kg](http://cert.gov.kg) | Luxembourg: [circl.lu](https://circl.lu) | Macau: [mocert.org](www.mocert.org) | Malaysia: [mycert.org.my](http://www.mycert.org.my) | Morocco: [educert.ma](http://www.educert.ma) 
  - **N-P** - Netherlands: [ncsc.nl](https://www.ncsc.nl) |  New Zealand: [cert.govt.nz](https://www.cert.govt.nz) | Nigeria: [cert.gov.ng](https://cert.gov.ng) | Norway: [norcert](https://www.nsm.stat.no/norcert) | Pakistan: [pakcert.org](http://www.pakcert.org) | Papua New Guinea: [pngcert.org.pg](https://www.pngcert.org.pg) | Philippines: [cspcert.ph](https://cspcert.ph) | Poland: [cert.pl](https://www.cert.pl) | Portugal: [cncs.gov.pt/certpt](https://www.cncs.gov.pt/certpt)
  - **Q-S** - Qatar: [qcert.org](https://qcert.org) | Rep of Ireland: [ncsc.gov.ie](https://www.ncsc.gov.ie) | Romania: [cert.ro](https://www.cert.ro) | Russia: [gov-cert.ru](http://www.gov-cert.ru) / [cert.ru](https://www.cert.ru) | Singapore: [csa.gov.sg/singcert](https://www.csa.gov.sg/singcert) | Slovenia: [sk-cert.sk](https://www.sk-cert.sk) | South Korea: [krcert.or.kr](https://www.krcert.or.kr) | Spain: [incibe.es](https://www.incibe.es) | Sri Lanka - [cert.gov.lk](https://www.cert.gov.lk) | Sweden: [cert.se](https://www.cert.se) | Switzerland: [govcert.ch]
  - **T-Z** - Taiwan: [twcert.org.tw](https://www.twcert.org.tw) | Thailand: [thaicert.or.th](https://www.thaicert.or.th) | Tonga:  [cert.to](https://www.cert.to) | Ukraine:[cert.gov.ua](https://cert.gov.ua) | UAE: [tra.gov.ae/aecert](https://www.tra.gov.ae/aecert) | United Kingdom: [ncsc.gov.uk](https://www.ncsc.gov.uk) | United States: [us-cert.gov](https://www.us-cert.gov)
  - **Global**: [first.org](https://www.first.org) - The global Forum of Incident Response and Security Teams

## Mega Guides
- Very thorough list of things to be aware of and defensive steps, by Michael Horowitz: [defensivecomputingchecklist.com](https://defensivecomputingchecklist.com/)
- Software reccomendations and advice for privacy: [privacytools.io](https://www.privacytools.io/) 
- Tips and tricks, for internet freedom, data health and privacy: [datadetoxkit.org](https://datadetoxkit.org/)
- Digital security tools and tactics: [securityinabox.org](https://securityinabox.org/)
- Online privacy guide, and software reccomendations: via [Fried](https://fried.com/privacy)
- Guide to security through encryption: via [ProPrivacy](https://proprivacy.com/guides/the-ultimate-privacy-guide)
- Large collection of beginner security guides: [Heimdal Security](https://heimdalsecurity.com/blog/cyber-security-mega-guide)
- The Motherboard guide to not getting hacked: via [Vice](https://www.vice.com/en_us/article/d3devm/motherboard-guide-to-not-getting-hacked-online-safety-guide)
- Online anonimity, and Tor + VPN tutorials: via [ivpn](https://www.ivpn.net/privacy-guides)


## More Awesome GitHub Lists

- **Awesome Open Source Apps**
  - [awesome-windows-apps](https://github.com/Awesome-Windows/Awesome) by 'many'
  - [awesome-macOS-apps](https://github.com/iCHAIT/awesome-macOS) by @iCHAIT
  - [awesome-linux-software](https://github.com/luong-komorebi/Awesome-Linux-Software) by @luong-komorebi
  - [open-source-ios-apps](https://github.com/dkhamsing/open-source-ios-apps) by @dkhamsing
  - [open-source-android-apps](https://github.com/pcqpcq/open-source-android-apps) by @pcqpcq
  - [awesome-selfhosted](https://github.com/awesome-selfhosted/awesome-selfhosted) by 'many'
  - [privacy-respecting](https://github.com/nikitavoloboev/privacy-respecting) by @nikitavoloboev
  - [awesome-privacy](https://github.com/KevinColemanInc/awesome-privacy) by @KevinColemanInc
  - [privacy-respecting-software](https://github.com/Lissy93/personal-security-checklist/blob/master/5_Privacy_Respecting_Software.md) by @lissy93
- **Guides**
  - [MacOS-Security-and-Privacy-Guide](https://github.com/drduh/macOS-Security-and-Privacy-Guide) by @drduh
  - [YubiKey-Guide](https://github.com/drduh/YubiKey-Guide) by @drduh
  - [Debian-Privacy-Server-Guide](https://github.com/drduh/Debian-Privacy-Server-Guide) by @drduh
  - [personal-security-checklist](https://github.com/Lissy93/personal-security-checklist) by @lissy93
- **Security Links (Hacking / Pen Testing / Threat Inteligence / CFTs)**
  - [Security_list](https://github.com/zbetcheckin/Security_list) by @zbetcheckin
  - [awesome-security](https://github.com/sbilly/awesome-security) by @sbilly
  - [awesome-sec-talks](https://github.com/PaulSec/awesome-sec-talks) by @PaulSec
  - [awesome-threat-intelligence](https://github.com/hslatman/awesome-threat-intelligence) by @hslatman
  - [awesome-incident-response](https://github.com/meirwah/awesome-incident-response) by @meirwah
  - [awesome-anti-forensic](https://github.com/remiflavien1/awesome-anti-forensic) by @remiflavien1
  - [awesome-malware-analysis](https://github.com/rshipp/awesome-malware-analysis) by @rshipp
  - [awesome-lockpicking](https://github.com/fabacab/awesome-lockpicking) by @fabacab
  - [awesome-hacking](https://github.com/carpedm20/awesome-hacking) by @carpedm20
  - [awesome-honeypots](https://github.com/paralax/awesome-honeypots) by @paralax
  - [awesome-forensics](https://github.com/Cugu/awesome-forensics) by @cugu
  - [awesome-pentest](https://github.com/enaqx/awesome-pentest) by @enaqx
  - [awesome-ctf](https://github.com/apsdehal/awesome-ctf) by @apsdehal
  - [awesome-osint](https://github.com/jivoi/awesome-osint) by @jivoi
  - [SecLists](https://github.com/danielmiessler/SecLists) by @danielmiessler
  - [Infosec_Reference](https://github.com/rmusser01/Infosec_Reference) by @rmusser01
- **Misc**
  - [awesome-crypto-papers](https://github.com/pFarb/awesome-crypto-papers) by @pFarb
- **Awesome Lists of Awesome Lists**
  - [awesome]( https://github.com/sindresorhus/awesome) by @sindresorhus
  - [lists](https://github.com/jnv/lists) by @jnv
- **More In This Repo**
  - [Personal Security Checklist](/README.md) by @lissy93
  - [Privacy-Respecting Software](https://github.com/Lissy93/awesome-privacy)
  - [Importance of Privacy & Security](/0_Why_It_Matters.md)
  - [Digital Security Gadgets / DIY hardware](/6_Privacy_and-Security_Gadgets.md)
  - [TLDR - Condensed Summary of this Repo](/2_TLDR_Short_List.md)
  
---

*Thanks for visiting, hope you found something useful here :) Contributions are welcome, and much appreciated - to propose an edit [raise an issue](https://github.com/Lissy93/personal-security-checklist/issues/new/choose), or [open a PR](https://github.com/Lissy93/personal-security-checklist/pull/new/master). See: [`CONTRIBUTING.md`](/.github/CONTRIBUTING.md).*

*Licensed under [Creative Commons, CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), © [Alicia Sykes](https://aliciasykes.com) 2020*

[![Attribution 4.0 International](https://licensebuttons.net/l/by/3.0/88x31.png)](https://github.com/Lissy93/personal-security-checklist/blob/master/LICENSE.md)


----

Found this helpful? Consider sharing it with others, to help them also improve their digital security 😇

[![Share on Twitter](https://img.shields.io/badge/Share-Twitter-17a2f3?style=for-the-badge&logo=Twitter)](http://twitter.com/share?text=Check%20out%20the%20Personal%20Cyber%20Security%20Checklist-%20an%20ultimate%20list%20of%20tips%20for%20protecting%20your%20digital%20security%20and%20privacy%20in%202020%2C%20with%20%40Lissy_Sykes%20%F0%9F%94%90%20%20%F0%9F%9A%80&url=https://github.com/Lissy93/personal-security-checklist)
[![Share on LinkedIn](https://img.shields.io/badge/Share-LinkedIn-0077b5?style=for-the-badge&logo=LinkedIn)](
http://www.linkedin.com/shareArticle?mini=true&url=https://github.com/Lissy93/personal-security-checklist&title=The%20Ultimate%20Personal%20Cyber%20Security%20Checklist&summary=%F0%9F%94%92%20A%20curated%20list%20of%20100%2B%20tips%20for%20protecting%20digital%20security%20and%20privacy%20in%202020&source=https://github.com/Lissy93)
[![Share on Facebook](https://img.shields.io/badge/Share-Facebook-4267b2?style=for-the-badge&logo=Facebook)](https://www.linkedin.com/shareArticle?mini=true&url=https%3A//github.com/Lissy93/personal-security-checklist&title=The%20Ultimate%20Personal%20Cyber%20Security%20Checklist&summary=%F0%9F%94%92%20A%20curated%20list%20of%20100%2B%20tips%20for%20protecting%20digital%20security%20and%20privacy%20in%202020&source=)
[![Share on Mastodon](https://img.shields.io/badge/Share-Mastodon-56a7e1?style=for-the-badge&logo=Mastodon)](https://mastodon.social/web/statuses/new?text=Check%20out%20the%20Ultimate%20Personal%20Cyber%20Security%20Checklist%20by%20%40Lissy93%20on%20%23GitHub%20%20%F0%9F%94%90%20%E2%9C%A8)

