# Digital Privacy and Security - Why is Matters


**TLDR;** Privacy is a fundamental right, and essential to democracy, liberty, and freedom of speech. Our privacy is being abused by governments (with mass-surveillance), corporations (profiting from selling personal data), and cyber criminals (stealing our poorly-secured personal data and using it against us). Security is needed in order to keep your private data private, and good digital security is critical to stay protected from the growing risks associated with the war on data.

----

## What is Personal Data?
Personal data is any information that relates to an identified or identifiable living individual. Even data that has been de-identified or anonymized can often still be used to re-identify a person, especially when combined with a secondary data set.

This could be sensitive documents (such as medical records, bank statements, card numbers, etc), or user-generated content (messages, emails, photos, search history, home CCTV, etc) or apparently trivial metadata (such as mouse clicks, typing patterns, time spent on each web page, etc)

## How is Data Collected?
One of the most common data collection methods is web tracking. This is when websites use cookies, device fingerprints, and other methods to identify you, and follow you around the web. It is often done for advertising, analytics, and personalization. When aggregated together, this data can paint a very detailed picture of who you are.

## How is Data Stored?
Data that has been collected is typically stored in databases on a server. These servers are rarely owned by the companies managing them, [56% of servers](https://www.canalys.com/newsroom/global-cloud-market-Q3-2019) are owned by Amazon AWS, Google Cloud, and Microsoft Azure. If stored correctly the data will be encrypted, and authentication required to gain access. However that usually isn't the case, and large data leaks [occur almost daily](https://selfkey.org/data-breaches-in-2019/). As well as that data breaches occur, when an adversary compromises a database storing personal data. In fact, you've probably already been caught up in a data breach (check your email, at [have i been pwned](https://haveibeenpwned.com))

## What is Personal Data Used For?

Data is collected, stored and used by governments, law enforcement, corporations and sometimes criminals:

### Government Mass Surveillance
Intelligence and law enforcement agencies need surveillance powers to tackle serious crime and terrorism. However, since the Snowden revelations, we now know that this surveillance is not targeted at those suspected of wrongdoing - but instead the entire population. All our digital interactions are being logged and tracked by our very own governments.

Mass surveillance is a means of control and suppression, it takes away our inerrant freedoms and breeds conformity. When we know we are being watched, we subconsciously change our behavior. A society of surveillance is just one step away from a society of submission.

### Corporations
On the internet the value of data is high. Companies all want to know exactly who you are and what you are doing. They collect data, store it, use it and sometimes sell it onwards.

Everything that each of us does online leaves a trail of data. These traces make up a goldmine of information full of insights into people on a personal level as well as a valuable read on larger cultural, economic and political trends. Tech giants (such as Google, Facebook, Apple, Amazon, and Microsoft) are leveraging this, building billion-dollar businesses out of the data that our interactions with digital devices create. We, as users have no guarantees that what is being collected is being stored securely, we often have no way to know for sure that it is deleted when we request so, and we don't have access to what their AI systems have infered from our data.

Our computers, phones, wearables, digital assistants and IoT have been turned into tracking bugs that are plugged into a vast corporate-owned surveillance network. Where we go, what we do, what we talk about, who we talk to, and who we see – everything is recorded and, at some point, leveraged for value. They know us intimately, even the things that we hide from those closest to us. In our modern internet ecosystem, this kind of private surveillance is the norm.

### Cybercriminals
Hackers and cybercriminals pose an ongoing and constantly evolving threat. With the ever-increasing amount of our personal data being collected and logged - we are more vulnerable to data breaches and identity fraud than ever before.

In the same way, criminals will go to great lengths to use your data against you: either through holding it ransom, impersonating you, stealing money or just building up a profile on you and selling it on, to another criminal entity.

---

## Why Data Privacy Matters

#### Data Privacy and Freedom of Speech
Privacy is a fundamental right, and you shouldn't need to prove the necessity of fundamental right to anyone. As Edward Snowden said, "Arguing that you don't care about the right to privacy because you have nothing to hide is no different than saying you don't care about free speech because you have nothing to say". There are many scenarios in which privacy is crucial and desirable like intimate conversations, medical procedures, and voting. When we know we are being watched, our behavior changes, which in turn suppresses things like free speech.

#### Data Can Have Control Over You
Knowledge is power; Knowledge about you is power over you. Your information will be used to anticipate your actions and manipulate the way you shop, vote, and think. When you know you are being watched, you subconsciously change your behavior. Mass surveillance is an effective means of fostering compliance with social norms or with social orthodoxy. Without privacy, you might be afraid of being judged by others, even if you're not doing anything wrong. It can be a heavy burden constantly having to wonder how everything we do will be perceived by others.

#### Data Can Be Used Against You
Your personal information and private communications can be "cherry-picked" to paint a certain one-sided picture. It can make you look like a bad person, or criminal, even if you are not. Data often results in people not being judged fairly - standards differ between cultures, organisations, and generations. Since data records are permanent, behavior that is deemed acceptable today, may be held against you tomorrow. Further to this, even things we don't think are worth hiding today, may later be used against us in unexpected ways.

#### Data Collection Has No Respect For Boundaries
Data collection has no respect for social boundaries, you may wish to prevent some people (such as employers, family or former partners) from knowing certain things about you. Once you share personal data, even with a party you trust, it is then out of your control forever, and at risk of being hacked, leaked or sold. An attack on our privacy, also hurts the privacy of those we communicate with.

#### Data Discriminates
When different pieces of your data is aggregated together, it can create a very complete picture of who you are. This data profile, is being used to influence decisions made about you: from insurance premiums, job prospects, bank loan eligibility and license decisions. It can determine whether we are investigated by the government, searched at the airport, or blocked from certain services. Even what content you see on the internet is affected by our personal data. This typically has a bigger impact on minority groups, who are unfairly judged the most. Without having the ability to know or control what, how, why and when our data is being used, we lose a level of control. One of the hallmarks of freedom is having autonomy and control over our lives, and we can’t have that if so many important decisions about us are being made in the dark, without our awareness or participation.

#### The "I Have Nothing to Hide" Argument
Privacy isn’t about hiding information; privacy is about protecting information, and everyone has information that they’d like to protect. Even with nothing to hide, you still put blinds on your window, locks on your door, and passwords on your email account.- Nobody would want their search history, bank statements, photos, notes or messages to be publicly available to the world.

#### Data Privacy needs to be for Everyone
For online privacy to be effective, it needs to be adopted my the masses, and not just the few. By exercising your right to privacy, you make it easier for others, such as activists and journalists, to do so without sticking out.

----

## So What Should we Do?

- Educate yourself about what's going on and why it matters
- Be aware of changes to policies, revelations, recent data breaches and related news
- Take steps to secure your online accounts and protect your devices
- Understand how to communicate privately, and how use the internet anonymously
- Use software and services that respect your privacy, and keep your data safe
- Support organisations that fight for your privacy and internet freedom
- Find a way to make your voice heard, and stand up for what you believe in

----

## Further Links
- [Ultimate Personal Security Checklist](/README.md)
- [Privacy-Respecting Software](https://github.com/Lissy93/awesome-privacy)
- [Privacy & Security Gadgets](/6_Privacy_and-Security_Gadgets.md)
- [Further Links + More Awesome Stuff](/4_Privacy_And_Security_Links.md)

----

#### Notes

*Thanks for visiting, hope you found something useful here :) Contributions are welcome, and much appreciated - to propose an edit [raise an issue](https://github.com/Lissy93/personal-security-checklist/issues/new/choose), or [open a PR](https://github.com/Lissy93/personal-security-checklist/pull/new/master). See: [`CONTRIBUTING.md`](/.github/CONTRIBUTING.md).*

*I owe a lot of thanks others who've conducted research, written papers, developed software all in the interest of privacy and security. Full attributions and references found in [`ATTRIBUTIONS.md`](/ATTRIBUTIONS.md).*


*Licensed under [Creative Commons, CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), © [Alicia Sykes](https://aliciasykes.com) 2020*

[![Attribution 4.0 International](https://licensebuttons.net/l/by/3.0/88x31.png)](https://github.com/Lissy93/personal-security-checklist/blob/master/LICENSE.md)

----

Found this helpful? Consider sharing it with others, to help them also improve their digital security 😇

[![Share on Twitter](https://img.shields.io/badge/Share-Twitter-17a2f3?style=for-the-badge&logo=Twitter)](http://twitter.com/share?text=Check%20out%20the%20Personal%20Cyber%20Security%20Checklist-%20an%20ultimate%20list%20of%20tips%20for%20protecting%20your%20digital%20security%20and%20privacy%20in%202020%2C%20with%20%40Lissy_Sykes%20%F0%9F%94%90%20%20%F0%9F%9A%80&url=https://github.com/Lissy93/personal-security-checklist)
[![Share on LinkedIn](https://img.shields.io/badge/Share-LinkedIn-0077b5?style=for-the-badge&logo=LinkedIn)](
http://www.linkedin.com/shareArticle?mini=true&url=https://github.com/Lissy93/personal-security-checklist&title=The%20Ultimate%20Personal%20Cyber%20Security%20Checklist&summary=%F0%9F%94%92%20A%20curated%20list%20of%20100%2B%20tips%20for%20protecting%20digital%20security%20and%20privacy%20in%202020&source=https://github.com/Lissy93)
[![Share on Facebook](https://img.shields.io/badge/Share-Facebook-4267b2?style=for-the-badge&logo=Facebook)](https://www.linkedin.com/shareArticle?mini=true&url=https%3A//github.com/Lissy93/personal-security-checklist&title=The%20Ultimate%20Personal%20Cyber%20Security%20Checklist&summary=%F0%9F%94%92%20A%20curated%20list%20of%20100%2B%20tips%20for%20protecting%20digital%20security%20and%20privacy%20in%202020&source=)
[![Share on Mastodon](https://img.shields.io/badge/Share-Mastodon-56a7e1?style=for-the-badge&logo=Mastodon)](https://mastodon.social/web/statuses/new?text=Check%20out%20the%20Ultimate%20Personal%20Cyber%20Security%20Checklist%20by%20%40Lissy93%20on%20%23GitHub%20%20%F0%9F%94%90%20%E2%9C%A8)
