# 什么是OJ

以下摘自我的毕业论文

## 背景及研究意义
随着信息技术的发展，人们越来越注重基础的算法知识教学。现代企业中，人工智能无处不在，而人工智能又离不开算法，对于未来人才的培养，基础算法显得尤为重要。因此各大高校也越来越重视算法人才的培养。现在许多高校都有一套成熟的培养系统，比如杭州电子科技大学，北京大学，清华大学都有自己的判题系统。所谓判题系统，就是一个能对学生提交的程序进行自动判断的系统，这样不仅能省下老师许多时间，学生还能够自行的进行更多的训练，并从中学到更多的算法。一个好的判题系统不仅能进行判题，还能让学生随时随地的学习，即让判题程序以网页的形式呈现，只需要一个浏览器即可访问。同时还配套有一系列功能，如学生能迅速定位到自己的错误，并且能动态的看到自己的学习与锻炼情况等等。

上述判题系统我们称之为OJ，即Online Judge，中文名叫在线评测系统，目前在国内比较出名的在线评测系统有学校运营着的杭州电子科技大学的HDOJ，有北大的POJ，有浙江大学的ZOJ等等，同时也有企业运营着的PTA系统，计蒜客的判题系统，和企业面试常用的牛客网。这些均是国内出名的判题系统。在国外也有在全球出名的LeetCode网站，许多程序员在面试前都会上这个网站进行学习，同时还有由俄罗斯高校运营着的一个算法竞赛的做题网站Codeforces，还有日本的AtCoder等等。


虽然市面上有许许多多的OJ，但是OJ之间的题目数据并不共享，这就使得这些学习资源被垄断，因此一个属于学校本身的OJ就显得尤为重要。虽然在Github上有许多开源的OJ，最出名的如华中科技大学主持开源的HustOJ，有青岛大学主持的QDUOJ，但是要理解且修改当中的源码或者定制自己的功能显得尤为困难。所以学校要有自己的一个判题系统去培养算法人才。

## 算法竞赛介绍与OJ介绍
现代科技企业为了招到算法人才，会举办各种各样的算法竞赛去吸引人才。如百度每年都会举办百度之星，美团也会举办算法竞赛，同时在国际上，有由美国计算机协会（现在由JetBrain公司）支持举办的国际大学生程序设计竞赛，每年都会举办各国区域赛选拔顶尖算法人才去参加全球总决赛。在国内，也有中国大学生程序设计赛，也有各省的省赛。这些竞赛的目的都是为了培养各种各样的算法人才。


算法竞赛的形式非常简单，通常是在比赛的时候，每人或每只队伍使用一台电脑，然后需要在有限的5个小时内使用自己熟悉的编程语言写程序解决七个以上的问题。程序提交之后会给裁判或者在线的测评系统进行编译，然后运行，运行的结果会判定为正确或错误两种并及时通知各个参赛队。比赛形式非常的简单，但是却很非常紧张且具有挑战性。这些题目涵盖的领域非常广，包括数据结构，动态规划，图论，数论，运筹学，博弈论，概率论等等，而且通常需要学生编写非常严谨的程序，不容得一丝错误。

在实际工作当中，一个小小的漏洞都会给企业带来非常大的损失，所以一个长期参加算法竞赛的学生在工作中会展现出自身的优势，因此各大高校和企业也都非常重视算法竞赛的发展。但是要判断学生写的程序是否正确就需要一个能自动对学生程序进行判题的系统。这个系统会在数据库中存放各种题目数据，然后通过前端展示给学生，通常题目由：题目描述、输入描述、输出描述组成。学生需要编写一个程序去接收系统提供的输入数据，然后按照题目要求，对数据进行处理后，输出一个正确的答案。系统会将这个答案与后台的答案进行比较，如果相同，则代表学生的程序是正确的，错误则代表学生的程序有漏洞。通常系统会限制学生的程序要在一定时间内运行完毕，即程序的时间复杂度要在合理的范围内，同时空间复杂度也要在限定的范围内。因为在实际工作中效率非常重要。

同时程序在运行过程中不容得出现致命的系统错误，比如数组越界，除零等等。还有在比赛过程当中，由于集中提交，会有高并发的业务，因此一个系统要对上述所有情况作出判断且稳定的运行是非常困难的，这也是一个要攻克的难点。在本文后面会有提到如何解决。
