<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Home Page
    |--------------------------------------------------------------------------
    |
    | resources/views/home.blade.php
    |
    */

    'Log in' => 'Log in',
    'Register' => 'Register',

    'Dashboard' => 'Dashboard',
    'Copyright' => 'Copyright',
    'Made with' => 'Made with',
    'by' => 'by',

    'HOME.MESSAGE' => '
    <p>Take control of your online presence with&nbsp;<a href="https://linkstack.org/"><strong>LinkStack</strong></a>
     the privacy-focused, open-source <strong>link management platform</strong>. Create a customizable profile page to manage <strong>
     all your important links in one convenient location</strong> and give your audience a seamless browsing experience.</p>
     ',


    /*
    |--------------------------------------------------------------------------
    | Demo Page/Home Page Example Page
    |--------------------------------------------------------------------------
    |
    | resources/views/demo.blade.php
    |
    */
    
    'Example page' => 'Example page',


    /*
    |--------------------------------------------------------------------------
    | Authentication Pages
    |--------------------------------------------------------------------------
    |
    | Login, Register, Forgot Password, Reset Password etc.
    | This includes authentication emails like password reset and email verification.
    | resources/views/auth
    |
    */

    # Login Page
    'Sign In' => 'Sign In',
    'Login to stay connected' => 'Login to stay connected',
    'Email' => 'Email',
    'Password' => 'Password',
    'Remember Me' => 'Remember Me',
    'Forgot Password?' => 'Forgot Password?',
    'or sign in with other accounts?' => 'or sign in with other accounts?',
    'Don’t have an account?' => 'Don’t have an account?',
    'Click here to sign up' => 'Click here to sign up',


    # Reset password
    'Forgot your password?' => 'Forgot your password?',
    'No problem' => 'No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.',
    'Email Password Reset Link' => 'Email Password Reset Link',


    # Register Page
    'Sign Up' => 'Sign Up',
    'Register to stay connected' => 'Register to stay connected',
    'Display Name' => 'Display Name',
    'Confirm Password' => 'Confirm Password',
    'Already have an account?' => 'Already have an account?',
    'Click here to sign in' => 'Click here to sign in',


    # Pending verification by admin
    'Verification Status' => 'Verification Status',
    'auth_pending' => 'Your account is still pending verification',
    'auth_unverified' => 'Your account is currently unverified and requires manual verification by an administrator.',
    'Log out' => 'Log out',


    # Password confirmation
    'auth_password' => 'This is a secure area of the application. Please confirm your password before continuing.',
    'Confirm' => 'Confirm',


    # Password Reset
    'Reset Password' => 'Reset Password',
    'Enter a new password' => 'Enter a new password',


    # Test email
    'Test E-Mail' => 'Test E-Mail',


    # Signup notification email
    'A new user has registered on' => 'A new user has registered on',
    'and is awaiting verification' => 'and is awaiting verification',
    'The user' => 'The user',
    'with the email' => 'with the email',
    'has registered a new account on' => 'has registered a new account on',
    'and is awaiting confirmation by an admin' => 'and is awaiting confirmation by an admin.',
    'Click' => 'Click',
    'here' => 'here',
    'to verify the user' => 'to verify the user.',
    'Manage Users' => 'Manage Users',


    # Email verification email
    'auth_thanks' => 'Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another. If you do not see the email in a few minutes, check your junk mail or spam folder.',
    'auth_verification' => 'A new verification link has been sent to the email address you provided during registration.',
    'Resend Verification Email' => 'Resend Verification Email',


    /*
    |--------------------------------------------------------------------------
    | Styling Slide In
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */

    'Settings' => 'Settings',
    'Scheme' => 'Scheme',
    'Auto' => 'Auto',
    'Dark' => 'Dark',
    'Light' => 'Light',
    'Color Customizer' => 'Color Customizer',
    'Sidebar Color' => 'Sidebar Color',
    'Default' => 'Default',
    'Color' => 'Color',
    'Transparent' => 'Transparent',
    'Sidebar Types' => 'Sidebar Types',
    'Mini' => 'Mini',
    'Hover' => 'Hover',
    'Boxed' => 'Boxed',
    'Sidebar Active Style' => 'Sidebar Active Style',
    'Rounded One Side' => 'Rounded One Side',
    'Rounded All' => 'Rounded All',
    'Pill One Side' => 'Pill One Side',
    'Pill All' => 'Pill All',


    /*
    |--------------------------------------------------------------------------
    | Site customization
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/site.blade.php
    |
    */

    'Home' => 'Home',
    'Add Link' => 'Add Link',
    'Administration' => 'Administration',
    'Admin' => 'Admin',
    'Config' => 'Config',
    'Footer Pages' => 'Footer Pages',
    'Site Customization' => 'Site Customization',
    'Site Logo' => 'Site logo',
    'Personalization' => 'Personalization',
    'Links' => 'Links',
    'Appearance' => 'Appearance',
    'Themes' => 'Themes',
    'Site logo' => 'Site logo',
    'Favicon' => 'Favicon',
    'Home message' => 'Home message',


    /*
    |--------------------------------------------------------------------------
    | Navbar
    |--------------------------------------------------------------------------
    |
    | resources/views/layouts/sidebar.blade.php
    |
    */
    
    'View Page' => 'View Page',
    'Share your profile' => 'Share your profile',
    'Share your profile:' => 'Share your profile:',
    'Error sharing:' => 'Error sharing:',
    'Text copied to clipboard!' => 'Text copied to clipboard!',
    'Error copying text:' => 'Error copying text:',
    'QR Code' => 'QR Code',
    'Scan QR Code' => 'Scan QR Code',
    'QR code could not be generated' => 'QR code could not be generated',
    'Reason:' => 'Reason:',

    # QR Code dropdown
    'Close' => 'Close',
    'Dismiss' => 'Dismiss',
    
    # Notification dropdown
    'All Notifications' => 'All Notifications',

    # Updater dropdown
    'Updater' => 'Updater',
    'Beta Mode' => 'Beta Mode',
    'Local version' => 'Local version',
    'Latest beta' => 'Latest beta',
    'Run updater' => 'Run updater',
    'Update available' => 'Update available',
    'Up to date' => 'Up to date',
    'Check again' => 'Check again',

    # User section in navbar
    'Administrator' => 'Administrator',
    'Verified user' => 'Verified user',
    'User' => 'User',
    'Profile' => 'Profile',
    'Styling' => 'Styling',
    'Logout' => 'Logout',


    /*
    |--------------------------------------------------------------------------
    | Dashboard Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/index.blade.php
    |
    */

    # Header with image
    'Hi' => 'Hi',
    'stranger' => 'stranger',
    'welcome' => 'Welcome to :appName!',
    'Set a handle' => 'Set a handle',

    # Dashboard Page
    'Total Links:' => 'Total Links:',
    'Link Clicks:' => 'Link Clicks:',
    'View/Edit Links' => 'View/Edit Links',
    'Top Links:' => 'Top Links:',
    'You haven’t added any links yet' => 'You haven’t added any links yet.',
    'clicks' => 'clicks',
    'Clicks' => 'Clicks',
    'Site statistics:' => 'Site statistics:',
    'Total links' => 'Total links',
    'Total clicks' => 'Total clicks',
    'Total users' => 'Total users',
    'Registrations:' => 'Registrations:',
    'Last 30 days' => 'Last 30 days',
    'Last 7 days' => 'Last 7 days',
    'Last 24 hours' => 'Last 24 hours',
    'Active users:' => 'Active users:',
    
    

    /*
    |--------------------------------------------------------------------------
    | Button Editor
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/button-editor.blade.php
    |
    */

    'Button Editor' => 'Button Editor',
    'Back' => 'Back',
    'Custom Button' => 'Custom Button',
    'CSS' => 'CSS',
    'background' => 'background',
    'gradient' => 'gradient',
    'Show CSS' => 'Show CSS',
    'Custom CSS' => 'Custom CSS',
    'Save' => 'Save',
    'Reset to default' => 'Reset to default',
    'Result' => 'Result:',
    'Custom Icon' => 'Custom Icon',
    'Custom Alert' => 'Your custom icon’s short code does not contain the string "fa-" always use icons in the format: fa-ghost, for example.',
    'cb.description.1-4' => 'Custom icons can be added to buttons via Font Awesome. You can use any icon from the list below, you can access this list by clicking the "See all icons" button. Each icon on that list has a short code, which you can copy and enter in the custom icon field.',
    'cb.description.2-4' => 'Every icon short code consists of a prefix and main part. If the short code is not a brand icon, you can simply enter the code in the format: fa-icon-name. The "fa-..." formatting is important here. For example "fa-code".',
    'cb.description.3-4' => 'If the short code is a brand icon, it is important to include a "fab" before the short code part. Again, The "fa-..." formatting still applies here. For example, "fab fa-github"',
    'cb.description.4-4' => 'To apply color to your icons, you can simply write out the color name or just write the HEX value before the icon, followed by a ";". Here it is important to put the color before the icon short code and the color code must be ended with a semicolon.<br>You can find a list of available colors <a href="https://www.w3schools.com/cssref/css_colors.asp" target="_blank">here</a>.',
    'Style' => 'Style',
    'Prefix' => 'Prefix',
    'Icon' => 'Icon',
    'Short Code' => 'Short Code',
    'Regular' => 'Regular',
    'Brands' => 'Brands',
    'Color name' => 'color_name',
    'Color HEX' => 'Color HEX',
    'Color HEX1' => 'Color HEX',
    'Update icon' => 'Update icon',
    'See all icons' => 'See all icons',


    /*
    |--------------------------------------------------------------------------
    | Edit Link Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/edit-link.blade.php
    |
    */

    'Edit' => 'Edit',
    'Add' => 'Add',
    'Block' => 'Block',
    'Blocks' => 'Blocks: ',
    'Select Block' => 'Select Block ',
    'Toggle Dropdown' => 'Toggle Dropdown',
    'Cancel' => 'Cancel',
    'Save and Add More' => 'Save and Add More',
    'Click to change link blocks' => 'Click to change link blocks',
    'Click for a list of available link blocks' => 'Click for a list of available link blocks',


    /*
    |--------------------------------------------------------------------------
    | Links Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/links.blade.php
    |
    */

    'My Links' => 'My Links',
    'Add new Link' => 'Add new Link',
    'No Link Added' => 'You haven’t added any links yet.',
    'Download' => 'Download',
    'Preview' => ' Preview:',
    'No compatible browser' => 'Your browser isn’t compatible',
    'Page Icons' => 'Page Icons',
    'Save links' => 'Save links',

    # Tooltips
    'Customize' => 'Customize',
    'Delete' => 'Delete',
    'Clear icon cache' => 'Clear icon cache',
    
    'confirm_delete' => 'Are you sure you want to delete :title?',


    /*
    |--------------------------------------------------------------------------
    | "My Profile"/Appearance Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/page.blade.php
    |
    */

    'My Profile'=> 'My Profile',
    'Profile Picture' => 'Profile Picture',
    'Page URL' => 'Page URL',
    'Display name' => 'Display name',
    'Name:' => 'Name:',
    'Page Description' => 'Page Description',
    'Show checkmark' => 'Show checkmark',
    'disableverified' => 'You are a verified user. This setting allows you to hide your checkmark on your page.',
    'Show share button' => 'Show share button',
    'disablesharebutton' => 'This setting allows you to hide the share button on your page.',
    'Open links in new tab' => 'Open links in new tab',
    'openlinksnewtab' => 'This setting determines if your links on your links page get opened in the same or a new tab.',


    /*
    |--------------------------------------------------------------------------
    | Personal Settings Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/profile.blade.php
    |
    */

    'Account Settings' => 'Account Settings',
    'Change email' => 'Change email',
    'Change password' => 'Change password',
    'Export user data' => 'Export user data',
    'Export your user data' => 'Export your user data to transfer to a different instance.',
    'Export all data' => 'Export all data',
    'Export links only' => 'Export links only',
    'Import user data' => 'Import user data',
    'import.user.alert' => 'Are you sure you want to import this file? This action will replace all your current data, including links!',
    'Import your user data from another instance' => 'Import your user data from another instance.',
    'Import' => 'Import',
    'Delete your account' => 'Delete your account',
    'You are about to delete' => 'You are about to delete your account!',
    'You are about to delete This action cannot be undone' => 'You are about to delete your account! This action cannot be undone.',
    'Delete account' => 'Delete account',

    # Alerts
    'Profile updated successfully!' => 'Profile updated successfully!',
    'An error occurred while updating your profile.' => 'An error occurred while updating your profile.',

    'That handle has already been taken' => 'That handle has already been taken.',
    'The selected file must be an image' => 'The selected file must be an image.',
    'The image must be' => 'The image must be:',
    'The image size should not exceed 2MB' => 'The image size should not exceed 2MB.',
    'Please select an image' => 'Please select an image.',
    

    /*
    |--------------------------------------------------------------------------
    | Themes Page
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme.blade.php
    |
    */

    'Select a theme' => 'Select a theme',
    'Select theme' => 'Select theme',
    'Custom background' => 'Custom background',
    'No image selected' => 'No image selected',
    'Remove background' => 'Remove background',
    'Manage themes' => 'Manage themes',
    'Loading...' => 'Loading...',
    'Upload themes' => 'Upload themes',
    'Delete themes' => 'Delete themes',
    'Download themes' => 'Download themes',
    'Delete a theme' => 'Delete a theme',


    /*
    |--------------------------------------------------------------------------
    | Theme Updater
    |--------------------------------------------------------------------------
    |
    | resources/views/studio/theme-updater.blade.php
    |
    */

    'Theme Updater' => 'Theme Updater',
    'Theme name' => 'Theme name:',
    'Update status' => 'Update status:',
    'Version' => 'Version:',
    'Error!' => 'Error!',
    'Update manually' => 'Update manually',
    'Update all themes' => 'Update all themes',


    /*
    |--------------------------------------------------------------------------
    | Edit User Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/edit-user.blade.php
    |
    */
    
    'Edit User' => 'Edit User',
    'Logo' => 'Logo',
    'Page description' => 'Page description',
    'Role' => 'Role',


    /*
    |--------------------------------------------------------------------------
    | Links Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Title' => 'Title',


    /*
    |--------------------------------------------------------------------------
    | Links Page (Admin)
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/links.blade.php
    |
    */

    'Link' => 'Link',


    /*
    |--------------------------------------------------------------------------
    | PHP info Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/phpinfo.blade.php
    |
    */

    'Information about PHP’s configuration' => 'Information about PHP’s configuration',
    'Outputs information about the current state of PHP' => 'Outputs information about the current state of PHP',


    /*
    |--------------------------------------------------------------------------
    | Delete themes page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/theme.blade.php
    |
    */

    'Delete theme' => 'Delete theme',


    /*
    |--------------------------------------------------------------------------
    | Manage Users Page
    |--------------------------------------------------------------------------
    |
    | resources/views/panel/users.blade.php
    |
    */

    'Users:' => 'Users:',
    'Search user' => 'Search user',
    'ID' => 'ID',
    'Name' => 'Name',
    'E-Mail' => 'E-Mail',
    'Page' => 'Page',
    'Created at' => 'Created at',
    'Last seen' => 'Last seen',
    'Status' => 'Status',
    'Action' => 'Action',
    'N/A' => 'N/A',
    'Pending' => 'Pending',
    'Verified' => 'Verified',
    'Approved' => 'Approved',
    'Add new user' => 'Add new user',

    # Tooltips
    'tt.Delete' => 'Delete',
    'tt.Impersonate' => 'Impersonate',
    'tt.Edit' => 'Edit',
    'tt.All links' => 'All links',

    'confirm.delete.user' => 'Are you sure you want to delete this user? \nThis action cannot be undone!',

    # Date Format
    'date.format' => 'd/m/Y',

    'days ago' => 'days ago',
    '1 day ago' => '1 day ago',
    'Today' => 'Today',
    '1 year ago' => '1 year ago',
    'years ago' => 'years ago',


    /*
    |--------------------------------------------------------------------------
    | Config Page
    |--------------------------------------------------------------------------
    |
    | resources/views/components/config/
    | resources/views/panel/config-editor.blade.php
    |
    */

    'Advanced Config' => 'Advanced Config',
    'Take Backup' => 'Take Backup',
    'All Backups' => 'All Backups',
    'Diagnosis' => 'Diagnosis',

    'Alternative Config Editor' => 'Alternative Config Editor',
    'Use the Alternative Config Editor to edit the config directly' => 'Use the Alternative Config Editor to edit the config directly',

    'PHP info' => 'PHP info',
    'Display debugging information about your PHP setup' => 'Display debugging information about your PHP setup',

    'Jump directly to:' => 'Jump directly to:',

    'Application' => 'Application',
    'Panel settings' => 'Panel settings',
    'Security' => 'Security',
    'Advanced' => 'Advanced',
    'SMTP' => 'SMTP',
    'Footer links' => 'Footer links',
    'Debug' => 'Debug',
    'Language' => 'Language',

    'default' => 'default',
    'Apply' => 'Apply',

    'AC.description' => 'Allows editing the frontend of your site. Amongst other things, this file allows customization of: Home Page, links, titles, Google Analytics and meta tags.',
    'Advanced Configuration file.' => 'Advanced Configuration file.',
    'Restore defaults' => 'Restore defaults',

    'Backup' => 'Backup',
    'You can back up your entire instance:' => 'You can back up your entire instance:',
    'The backup system won’t save more than two backups at a time' => 'The backup system won’t save more than two backups at a time.',
    'Backup Instance' => 'Backup Instance',

    'wtrue' => 'Everything is working as expected!',
    'wfalse' => 'This file cannot be written to. This may impede proper operation.',
    'utrue' => 'Your security is at risk. This file can be accessed by everyone. Immediate action is required!',
    'ufalse' => 'Everything is working as expected!',
    'unull' => 'Something went wrong. This might be normal if you’re running behind a proxy or docker container.',
    'Debugging information' => 'Debugging information',
    'security.risk' => 'Your security is at risk. Some files can be accessed by everyone. Immediate action is required! Click this message to learn more.',
    'security.risk.1-3' => 'Here, you can easily verify if critical system files can be accessed externally. It is important that these files cannot be accessed, otherwise user data like passwords could get leaked. Entries marked with a',
    'security.risk.2-3' => 'cannot be accessed externally, entries marked with a',
    'security.risk.3-3' => 'can be accessed by anyone and require immediate action to protect your data.',
    'Hover for more' => 'Hover for more',
    'Write access' => 'Write access',
    'Write access.description.1-3' => 'Here, you can easily verify if important system files can be written to. This is important for every function to work properly. Entries marked with a',
    'Write access.description.2-3' => 'work as expected, entries marked with a',
    'Write access.description.3-3' => 'do not.',
    'File' => 'File',
    'Dependencies' => '',
    'Required PHP modules' => 'Required PHP modules.',
    'PHP Extension' => 'PHP Extension',
    'No backups found' => 'No backups found',
    'Backup your instance' => 'Backup your instance',

    'Go back' => 'Go back',

    'Strings with a # in front of them are comments and wont affect anything' => 'Strings with a # in front of them are comments and wont affect anything.',

    'Download your updater backups:' => 'Download your updater backups:',
    'The server will never store more that two backups at a time' => 'The server will never store more that two backups at a time.',

    'SMTP.title' => 'Use built in SMTP server',
    'SMTP.description' => 'Uses SMTP server provided by LinkStack. Might not be 100% reliable. Has to be disabled in order to user a custom SMTP server.',
    'SMTP.description.alt' => '(Save changes with "Apply changes" below)',
    'Enable' => 'Enable',
    'Custom SMTP server:' => 'Custom SMTP server:',
    'Host' => 'Host',
    'Port' => 'Port',
    'Username' => 'Username',
    'Encryption type' => 'Encryption type',
    'From address' => 'From address',
    'Apply changes' => 'Apply changes',
    'Test E-Mail setup:' => 'Test E-Mail setup:',
    'Send Test E-Mail' => 'Send Test E-Mail',

    'Debug.title' => 'Debug mode',
    'Debug.description' => 'Should be disabled in a production environment. Useful for debugging during setup.',

    'DISPLAY_FOOTER_HOME.title' => 'Home footer link',
    'DISPLAY_FOOTER_HOME.description' => 'Enable Home footer link.',
    'REGISTER_AUTH.title' => 'Enable email verification',
    'REGISTER_AUTH.description' => 'Determines if users have to verify their email when they register.',
    'ALLOW_REGISTRATION.title' => 'Enable registration',
    'ALLOW_REGISTRATION.description' => 'Determines whether users can register for your application.',
    'NOTIFY_EVENTS.title' => 'Notify on events',
    'NOTIFY_EVENTS.description' => 'Displays a notification if an event is in progress.',
    'NOTIFY_UPDATES.title' => 'Notify on updates',
    'NOTIFY_UPDATES.description' => 'Displays a notification if a new update is available.',
    'DISPLAY_FOOTER.title' => 'Show footer',
    'DISPLAY_FOOTER.description' => 'Determines whether the footer links should be displayed.',
    'DISPLAY_CREDIT.title' => 'Display credit on user pages',
    'DISPLAY_CREDIT.description' => 'Determines whether the credit notice should be displayed on users pages.',
    'DISPLAY_CREDIT_FOOTER.title' => 'Display credit in footer',
    'DISPLAY_CREDIT_FOOTER.description' => 'Determines whether the credit notice should be displayed in the footer.',
    'HOME_URL.title' => 'Set user page as Home Page',
    'HOME_URL.description' => 'Set a user page as the home page. This will move the previous home page to example.com/home.',
    'ALLOW_USER_HTML.title' => 'Allow extended syntax in user\'s descriptions',
    'ALLOW_USER_HTML.description' => 'This enables users to use special formatting like headings and links in their page description.<br>This is generally considered safe.',
    'APP_NAME.title' => 'Application title',
    'APP_NAME.description' => 'Sets the title of your app. A change will logout every active user.',
    'APP_KEY.title' => 'APP_KEY',
    'APP_KEY.description' => 'APP_KEY',
    'APP_URL.title' => 'APP_URL',
    'APP_URL.description' => 'APP_URL',
    'ENABLE_BUTTON_EDITOR.title' => 'Enable Button Editor',
    'ENABLE_BUTTON_EDITOR.description' => 'Determines whether users are allowed to customize their own buttons using CSS.',
    'APP_DEBUG.title' => 'APP_DEBUG',
    'APP_DEBUG.description' => 'APP_DEBUG',
    'APP_ENV.title' => 'APP_ENV',
    'APP_ENV.description' => 'APP_ENV',
    'LOG_CHANNEL.title' => 'LOG_CHANNEL',
    'LOG_CHANNEL.description' => 'LOG_CHANNEL',
    'LOG_LEVEL.title' => 'LOG_LEVEL',
    'LOG_LEVEL.description' => 'LOG_LEVEL',
    'MAINTENANCE_MODE.title' => 'Enable Maintenance Mode',
    'MAINTENANCE_MODE.description' => 'Displays a maintenance message on all public pages. This will disable the login pages.',
    'MAIL_MAILER.title' => 'MAIL_MAILER',
    'MAIL_MAILER.description' => 'MAIL_MAILER',
    'MAIL_HOST.title' => 'MAIL_HOST',
    'MAIL_HOST.description' => 'MAIL_HOST',
    'MAIL_PORT.title' => 'MAIL_PORT',
    'MAIL_PORT.description' => 'MAIL_PORT',
    'MAIL_USERNAME.title' => 'MAIL_USERNAME',
    'MAIL_USERNAME.description' => 'MAIL_USERNAME',
    'MAIL_PASSWORD.title' => 'MAIL_PASSWORD',
    'MAIL_PASSWORD.description' => 'MAIL_PASSWORD',
    'MAIL_ENCRYPTION.title' => 'MAIL_ENCRYPTION',
    'MAIL_ENCRYPTION.description' => 'MAIL_ENCRYPTION',
    'MAIL_FROM_ADDRESS.title' => 'MAIL_FROM_ADDRESS',
    'MAIL_FROM_ADDRESS.description' => 'MAIL_FROM_ADDRESS',
    'JOIN_BETA.title' => 'Join the Beta Program',
    'JOIN_BETA.description' => 'Enables the use of beta versions when updating. Read more about this <a target=\'_blank\' href=\'https://linkstack.org/b\'>here</a>.',
    'SKIP_UPDATE_BACKUP.title' => 'Skip update backups',
    'SKIP_UPDATE_BACKUP.description' => 'Skips backups when updating. This option is recommended to be disabled at all times, <br>but it may cause errors in some configurations.',
    'CUSTOM_META_TAGS.title' => 'Enable custom meta tags',
    'CUSTOM_META_TAGS.description' => 'Enables use of custom meta tags in the head of all pages. Defined in Advanced Config.',
    'FORCE_HTTPS.title' => 'Force links HTTPS',
    'FORCE_HTTPS.description' => 'Makes all links utilize HTTPS by default. It is advised to enable this option if you are using a reverse proxy.',
    'ALLOW_CUSTOM_CODE_IN_THEMES.title' => 'Allow custom code in themes',
    'ALLOW_CUSTOM_CODE_IN_THEMES.description' => 'Allows use of custom code in themes. If you use themes from unknown sources, <br>this may pose a security risk.',
    'ENABLE_ADMIN_BAR_USERS.title' => 'Enable Admin Bar for all users',
    'ENABLE_ADMIN_BAR_USERS.description' => 'If enabled users, all authenticated users will have an Admin Bar displayed on their links pages.',
    'ENABLE_THEME_UPDATER.title' => 'Enable Theme Updater',
    'ENABLE_THEME_UPDATER.description' => 'Determines if the theme updater should be active.',
    'ENABLE_SOCIAL_LOGIN.title' => 'Enable social login',
    'ENABLE_SOCIAL_LOGIN.description' => 'Enables social login. This option requires further setup. Read more about this <a target=\'_blank\' href=\'https://linkstack.org/social-login\'>here</a>.',
    'USE_THEME_PREVIEW_IFRAME.title' => 'Use iframe as theme preview',
    'USE_THEME_PREVIEW_IFRAME.description' => 'Determines if an internal iframe should be used as the preview for them theme page.',
    'FORCE_ROUTE_HTTPS.title' => 'Redirect all pages to HTTPS',
    'FORCE_ROUTE_HTTPS.description' => 'This option will break your setup when using a reverse proxy.',
    'DISPLAY_FOOTER_TERMS.title' => 'Terms footer link',
    'DISPLAY_FOOTER_TERMS.description' => 'Enable Terms footer link.',
    'DISPLAY_FOOTER_PRIVACY.title' => 'Privacy footer link',
    'DISPLAY_FOOTER_PRIVACY.description' => 'Enable Privacy link.',
    'DISPLAY_FOOTER_CONTACT.title' => 'Contact footer link',
    'DISPLAY_FOOTER_CONTACT.description' => 'Enable Contact link.',
    'TITLE_FOOTER_HOME.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_HOME.description' => 'Title of home footer link.',
    'TITLE_FOOTER_TERMS.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_TERMS.description' => 'Title of terms footer link.',
    'TITLE_FOOTER_PRIVACY.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_PRIVACY.description' => 'Title of privacy link.',
    'TITLE_FOOTER_CONTACT.title' => '<div style="margin-top:-40px"></div>',
    'TITLE_FOOTER_CONTACT.description' => 'Title of contact link.',
    'HOME_FOOTER_LINK.title' => '<div style="margin-top:-40px">Home footer link URL</div>',
    'HOME_FOOTER_LINK.description' => 'Enter any URL to redirect your home link URL.<br>Leave empty to use the default link.',
    'ALLOW_CUSTOM_BACKGROUNDS.title' => 'Allow custom backgrounds',
    'ALLOW_CUSTOM_BACKGROUNDS.description' => 'Allow users to upload custom background images for their pages.',
    'ALLOW_USER_IMPORT.title' => 'Allow users to import profiles from other instances',
    'ALLOW_USER_IMPORT.description' => 'Allows users to import their profile and links from an external file.',
    'ALLOW_USER_EXPORT.title' => 'Allow users to export their profile',
    'ALLOW_USER_EXPORT.description' => 'Allows users to export their own links and profile.',
    'MANUAL_USER_VERIFICATION.title' => 'Verify users manually',
    'MANUAL_USER_VERIFICATION.description' => 'Determines if admins have to manually verify newly registered users.',
    'ADMIN_EMAIL.title' => 'Admin email',
    'ADMIN_EMAIL.description' => 'Used to send notification emails.',
    'HIDE_VERIFICATION_CHECKMARK.title' => 'Hide verification checkmark',
    'HIDE_VERIFICATION_CHECKMARK.description' => 'Hides verification badge displayed on admin and VIP pages.',
    'ENABLE_REPORT_ICON.title' => 'Enable report icon',
    'ENABLE_REPORT_ICON.description' => 'Displays an icon on user pages that allows users to report pages.',
    'LOCALE.title' => 'App locale',
    'LOCALE.description' => 'Change the language of your application',


    /*
    |--------------------------------------------------------------------------
    | Installer
    |--------------------------------------------------------------------------
    |
    | resources/views/installer/installer.blade.php
    |
    */

    # Title Tag
    'LinkStack setup' => 'LinkStack setup',

    'Setup LinkStack' => 'Setup LinkStack',
    'Welcome to the setup for LinkStack!' => 'Welcome to the setup for LinkStack!',
    'This setup will:' => 'This setup will:',
    'Check the server dependencies' => '1. Check the server dependencies',
    'Setup the database' => '2. Setup the database',
    'Create the admin user' => '3. Create the admin user',
    'Configure the app' => '4. Configure the app',
    'Choose a language' => 'Choose a language',
    'setup.disclaimer' => 'By continuing, you agree to abide by our',
    'Terms and Conditions' => 'Terms and Conditions',

    'Next' => 'Next',
    'Yes' => 'Yes',
    'No' => 'No',
    'Finish setup' => 'Finish setup',

    'Setup failed' => 'Setup failed',
    'An error has occured. Please try again' => 'An error has occured. Please try again.',
    'Depending on your database type:' => 'Depending on your database type:',
    'Try again' => 'Try again',

    'Dependency check' => 'Dependency check',
    'Required PHP modules:' => 'Required PHP modules:',

    'Select a database type' => 'Select a database type',
    'Under most circumstances, we recommend using SQLite' => 'Under most circumstances, we recommend using SQLite.',
    'MySQL requires a separate, empty MySQL database' => 'MySQL requires a separate, empty MySQL database.',

    'Database type:' => 'Database type:',
    'Database host:' => 'Database host:',
    'Database port:' => 'Database port:',
    'Database name:' => 'Database name:',
    'Database username:' => 'Database username:',
    'Database password:' => 'Database password:',

    'Create an admin account' => 'Create an admin account.',
    'Admin email:' => 'Admin email:',
    'Admin password:' => 'Admin password:',
    'Handle:' => 'Handle:',
    'Name:' => 'Name:',

    'Configure your page' => 'Configure your page',
    'Enable registration:' => 'Enable registration:',
    'Enable email verification:' => 'Enable email verification:',
    'Set your page as Home Page' => 'Set your page as Home Page',
    'This will move the Home Page to /home' => 'This will move the Home Page to /home',
    'App Name:' => 'App Name:',


    /*
    |--------------------------------------------------------------------------
    | Updater/Update-Backup
    |--------------------------------------------------------------------------
    |
    | resources/views/update.blade.php
    |
    */

    # Title Tag
    'Update LinkStack' => 'Update LinkStack',

    'Latest beta version' => 'Latest beta version',
    'Installed beta version' => 'Installed beta version',
    'none' => 'none',
    'You need to update to the latest mainline release' => 'You need to update to the latest mainline release',
    'You’re running the latest mainline release' => 'You’re running the latest mainline release',

    'update.manually' => 'You can update your installation automatically or download the update and install it manually:',
    'update.windows' => 'Windows users can use the alternative updater. This updater won’t create a backup. Use at your own discretion.',
    'Update automatically' => 'Update automatically',

    'Updating' => 'Updating',
    'Creating backup' => 'Creating backup',
    'Preparing update' => 'Preparing update',
    'No new version' => 'No new version',
    'There is no new version available' => 'There is no new version available',
    'Admin Panel' => 'Admin Panel',
    'Finishing up' => 'Finishing up',
    'Success!' => 'Success!',
    'The update was successful' => 'The update was successful, you can now return to the Admin Panel.',
    'View the release notes' => 'View the release notes',
    'Run again' => 'Run again',
    'Error' => 'Error',
    'Something went wrong with the update' => 'Something went wrong with the update',

    
    /*
    |--------------------------------------------------------------------------
    | Backup
    |--------------------------------------------------------------------------
    |
    | resources/views/backup.blade.php
    |
    */

    # Title Tag
    'Backup.title' => 'Backup',

    'The backup was successful' => 'The backup was successful, you can now return to the Admin Panel or see all your backups.',


    /*
    |--------------------------------------------------------------------------
    | Page Blocks
    |--------------------------------------------------------------------------
    |
    | Parts are stored in the database.
    | resources/views/studio/edit-link.blade.php
    |
    */

    # predefined
    'block.title.predefined' => 'Predefined Site',
    'block.description.predefined' => 'Select from a list of predefined websites and have your link automatically styled using that sites brand colors and icon.',

    # link
    'block.title.link' => 'Custom Link',
    'block.description.link' => 'Create a Custom Link that goes to any website. Customize the button styling and icon, or use the favicon from the website as the button icon.',

    # vcard
    'block.title.vcard' => 'Vcard',
    'block.description.vcard' => 'Create or upload an electronic business card.',

    # email
    'block.title.email' => 'E-Mail address',
    'block.description.email' => 'Add an email that opens a system dialog to compose a new email.',

    # telephone
    'block.title.telephone' => 'Telephone number',
    'block.description.telephone' => 'Add a telephone number that opens a system dialog to initiate a phone call.',

    # heading
    'block.title.heading' => 'Heading',
    'block.description.heading' => 'Use headings to organize your links and separate them into groups.',

    # spacer
    'block.title.spacer' => 'Spacer',
    'block.description.spacer' => 'Add blank space to your list of links. You can choose how tall.',

    # text
    'block.title.text' => 'Text',
    'block.description.text' => 'Add static text to your page that is not clickable.',


    /*
    |--------------------------------------------------------------------------
    | Page Items
    |--------------------------------------------------------------------------
    |
    | resources/views/components/pageitems/
    |
    */

    'Default Email' => 'Default Email',
    'Custom Title' => 'Custom Title',
    'Leave blank for default title' => 'Leave blank for default title',
    'E-Mail address' => 'E-Mail address',
    'Enter your E-Mail' => 'Enter your E-Mail',

    'Heading Text:' => 'Heading Text:',

    'URL' => 'URL',
    'Show website icon on button' => 'Show website icon on button',

    'Select a predefined site' => 'Select a predefined site',
    'Enter the link URL' => 'Enter the link URL',

    'Spacing height' => 'Spacing height',

    'Phone' => 'Phone',
    'Telephone number' => 'Telephone number',
    'Enter your telephone number' => 'Enter your telephone number',

    'Text to display' => 'Text to display',

    'Vcard' => 'Vcard',
    'First Name' => 'First Name',
    'Middle Name' => 'Middle Name',
    'Last Name' => 'Last Name',
    'Suffix' => 'Suffix',
    'Work' => 'Work',
    'Organization' => 'Organization',
    'Work URL' => 'Work URL',
    'Emails' => 'Emails',
    'Enter your personal email' => 'Enter your personal email',
    'Work Email' => 'Work Email',
    'Enter your work email' => 'Enter your work email',
    'Phones' => 'Phones',
    'Home Phone' => 'Home Phone',
    'Work Phone' => 'Work Phone',
    'Cell Phone' => 'Cell Phone',
    'Home Address' => 'Home Address',
    'Label' => 'Label',
    'Street' => 'Street',
    'City' => 'City',
    'State/Province' => 'State/Province',
    'Zip/Postal Code' => 'Zip/Postal Code',
    'Country' => 'Country',
    'Work Address' => 'Work Address',

    'URL to the video' => 'URL to the video',


    /*
    |--------------------------------------------------------------------------
    | Maintenance Page
    |--------------------------------------------------------------------------
    |
    | resources/views/mainenance.blade.php
    |
    */

    'Maintenance Mode' => 'Maintenance Mode',
    'We are performing scheduled site maintenance at this time' => 'We are performing scheduled site maintenance at this time.',
    'Please check back with us later' => 'Please check back with us later.',
    'Admin options:' => 'Admin options:',
    'Turn off' => 'Turn off',
    'Warn.Disable.Maintenance' => 'You are about to disable Maintenance Mode. Are you sure?',


    /*
    |--------------------------------------------------------------------------
    | LinkStack (Links) Page
    |--------------------------------------------------------------------------
    |
    | resources/views/linkstack/linkstack.blade.php
    |
    */

    'Share this page' => 'Share this page',
    'Share' => 'Share',
    'Copy URL to clipboard' => 'Copy URL to clipboard',
    'URL has been copied to your clipboard!' => 'URL has been copied to your clipboard!',

    'Delete User' => 'Delete User',
    'Block User' => 'Block User',
    'Users Theme' => 'Theme',
    'Search User' => 'Search for User',
    
    'Edit my profile' => 'Edit my profile',


    /*
    |--------------------------------------------------------------------------
    | Footer
    |--------------------------------------------------------------------------
    |
    | Added to the bottom of certain pages.
    | resources/views/layouts/footer.blade.php
    |
    */

    'Learn more about LinkStack' => 'Learn more about LinkStack',
    'Learn more' => 'Learn more',

    /*
    |--------------------------------------------------------------------------
    | Notification messages
    |--------------------------------------------------------------------------
    |
    | All internal notifications.
    | resources/views/layouts/notifications.blade.php
    |
    */

    'No notifications' => 'No notifications',

    # Security Risk Notification
    'Your security is at risk!' => 'Your security is at risk!',
    'Immediate action is required!' => 'Immediate action is required!',
    'security.msg1' => 'Your security is at risk.',
    'security.msg2' => 'Some files can be accessed by everyone. Immediate action is required!',
    'security.msg3' => 'Some important files, are publicly accessible, putting your security at risk. Please take immediate action to revoke public access to these files to prevent unauthorized access to your sensitive information.',
    'security.msg4' => 'Learn more',

    # Help Us Out Notification
    'Hide this notification' => 'Hide this notification',
    'Help Us Out' => 'Help Us Out',
    'Enjoying Linkstack?' => 'Enjoying Linkstack?',
    'Support Linkstack' => 'Support Linkstack',
    'support.msg1' => 'If you\'re enjoying using Linkstack, we would greatly appreciate it if you could take a moment to',
    'support.msg2' => 'give our project a star on GitHub',
    'support.msg3' => 'Your support will help us reach a wider audience and improve the quality of our project.',
    'support.msg4' => 'If you\'re able to',
    'support.msg5' => 'make a financial contribution</a>, even a small amount would help us cover the costs of maintaining and improving Linkstack.',
    'support.msg6' => 'Thank you for your support and for being a part of the LinkStack community!',


    /*
    |--------------------------------------------------------------------------
    | Footer Links
    |--------------------------------------------------------------------------
    |
    */

    'footer.Home' => 'Home',
    'footer.Terms' => 'Terms',
    'footer.Privacy' => 'Privacy',
    'footer.Contact' => 'Contact',


    /*
    |--------------------------------------------------------------------------
    | Report Page
    |--------------------------------------------------------------------------
    |
    */

    'report_violation' => 'Report a Violation',
    'url_label' => 'URL of the site you are reporting',
    'report_type_label' => 'Type of report',
    'hate_speech' => 'Hate Speech or Harassment',
    'violence_threats' => 'Violence or Threats',
    'illegal_activities' => 'Illegal Activities',
    'copyright_infringement' => 'Copyright Infringement',
    'misinformation_fake_news' => 'Misinformation or Fake News',
    'identity_theft' => 'Identity Theft',
    'drug_related_content' => 'Drug-related Content',
    'weapons_harmful_objects' => 'Weapons or Harmful Objects',
    'child_exploitation' => 'Child Exploitation',
    'fraud_scams' => 'Fraud or Scams',
    'privacy_violation' => 'Privacy Violation',
    'impersonation' => 'Impersonation',
    'other_specify' => 'Other (Specify)',
    'additional_comments_label' => 'Additional comments',
    'submit_button' => 'Submit',
    

    'report_mail_admin_subject' => 'Profile Report',
    'report_mail_admin_report' => 'A Profile has been reported',

    'report_mail_reported_profile' => 'Reported Profile',
    'report_mail_reported_url' => 'Reported URL',
    'report_mail_type' => 'Type',
    'report_mail_message' => 'Message',

    'report_mail_report_submitted_by' => 'Report submitted by',
    'report_mail_reported_by' => 'Reported by',
    'report_mail_profile' => 'Profile',

    'report_mail_button_profile' => 'View on Users Page',
    'report_mail_button_delete' => 'Delete Reported User',


    'report_error' => 'Profile could not be reported',
    'report_success' => 'Profile has been reported successfully',

    
    #=============================================================================#
    # Laravel internal translations                                               #
    #=============================================================================#


    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    'failed' => 'These credentials do not match our records.',
    'password' => 'The provided password is incorrect.',
    'throttle' => 'Too many login attempts. Please try again in :seconds seconds.',


    /*
    |--------------------------------------------------------------------------
    | Pagination Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the paginator library to build
    | the simple pagination links. You are free to change them to anything
    | you want to customize your views to better match your application.
    |
    */

    'previous' => '&laquo; Previous',
    'next' => 'Next &raquo;',


];