<p align="center">
  <img width="200px" src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/logo/svg/logo_animated.svg"><br>
  <br>
  <picture>
    <source media="(prefers-color-scheme: dark)" width="400px" srcset="https://raw.githubusercontent.com/LinkStackOrg/branding/main/logo/png/wordmark_light.png">
    <img width="400px" src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/logo/png/wordmark_dark.png">
  </picture>
</p>

<h3 align="center"><b>Open-Source Linktree Alternative</b></h3>

<h3 align="center">LinkStack is a highly customizable link sharing platform<br>with an intuitive, easy to use user interface.</h3>

<br>

<p align="center">
  <a href="#Function">Function</a> •
  <a href="#About">About</a> •
  <a href="#Instances">Instances</a> •
  <a href="#Themes">Themes</a> •
  <a href="#Installation">Installation</a> •
  <a href="#Docker">Docker Version</a> •
  <a href="#Updating">Updating</a> •
  <a href="#Discord">Discord</a> •
  <a href="#Fork-Structure">Fork structure</a> •
  <a href="#License">License</a> •
  <a href="#Supporters">Supporters</a> •
  <a href="#Special-thanks">Special thanks</a> •
  <a href="#Additional-credit">Additional credit</a>
</p>

<p align="center">
<a href="https://github.com/linkstackorg/linkstack/stargazers"><img alt="GitHub Repo stars" src="https://img.lss.ovh/github/stars/julianprieber/littlelink-custom?label=Star%20the%20project&logo=GitHub"></a>
<a href="https://mstdn.social/@linkstack"><img alt="Mastodon Follow" src="https://img.lss.ovh/mastodon/follow/110147874401985724?domain=http%3A%2F%2Fmstdn.social&style=social"></a>
<a href="https://discord.linkstack.org"><img alt="Discord online user count" src="https://img.lss.ovh/discord/955765706111193118?color=4A55CC&label=Discord&logo=Discord&style=flat"></a>
</p>
<p align="center">
<a href="https://github.com/sponsors/julianprieber"><img alt="GitHub spomsors" src="https://img.lss.ovh/github/sponsors/JulianPrieber?color=BF4B8A&logo=githubsponsors&style=flat&label=Sponsor%20us%20on%20Github"></a>
<a href="https://patreon.com/julianprieber"><img alt="Patreon" src="https://img.lss.ovh/endpoint.svg?url=https%3A%2F%2Fshieldsio-patreon.vercel.app%2Fapi%3Fusername%3Djulianprieber%26type%3Dpatrons&style=flat&logo=patreon"></a>
<a href="https://liberapay.com/LittleLink-Custom"><img src="https://img.lss.ovh/liberapay/patrons/LittleLink-Custom?logo=liberapay&label=LiberaPay patrons"></a>
</p>

---

<p align="center">
  <a href="https://github.com/linkstackorg/linkstack/releases/latest/download/linkstack.zip"><img src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/badges/png/download_latest.png" alt="Download latest" width="380" ></a>
    <br>
	<a href="https://github.com/linkstackorg/linkstack/releases"><img alt="GitHub release (latest by date)" src="https://img.lss.ovh/github/v/release/JulianPrieber/LittleLink-Custom?label=Latest%20release"></a>
</p>

---

<a name="Function"></a>
## Function

LinkStack: The Ultimate Link Management Solution

LinkStack is a unique platform that provides an efficient solution for managing and sharing links online. Our platform offers a website similar to Linktree, which allows users to overcome the limitation of only being able to add one link on social media platforms.

With LinkStack, users can easily link to their own custom page and provide their followers with access to all the links they need in one convenient location. What sets LinkStack apart from other link management platforms is its flexibility, which allows users to host their links on their own web server or web hosting provider. This provides users with complete control over their online presence and ensures that their links are easily accessible.

Additionally, LinkStack allows other users to register and create their own links, making it an ideal solution for businesses and organizations looking to manage multiple links. With our user-friendly Admin Panel, managing and accessing other users' links is easy.

<br>
	    
<a name="About"></a>
## About

With LinkStack, our mission is to provide users with a free and privacy-focused solution for managing and sharing links online. We believe that everyone should have access to a customizable link-sharing platform without sacrificing their privacy and control over their data.

To achieve this mission, we offer a self-hosted option for users who want complete control over their data without having it sold to third-party companies. Our platform can be easily implemented through a simple **drag and drop** process, eliminating the need for complex terminal commands or source code manipulation.

For those who may not have the technical expertise to self-host, we also offer free instances of our platform while still prioritizing their privacy. Our platform offers many of the same features and options as commercial link-sharing platforms while maintaining the values of privacy and autonomy.

Our goal is to provide a free version of a link-sharing service, similar to Linktree, while empowering users to take ownership of their data. We will never sell user data and believe in providing a trustworthy and transparent solution for managing and sharing links online.
	    
<br>
	    
<a name="Instances"></a>
## Instances

<h3 align="center">Find the right instance for you</h3>

<br>
<p align="center">Our community instance program provides users with the opportunity to register on hosted instances and use Linkstack for free. Members of our community have generously provided their resources to host instances, allowing us to expand the reach of Linkstack and give back to the community</h3>

<br>

<p align="center">
  <a href="https://linkstack.org/instances"><img src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/badges/png/create_account.png" alt="Community instances" width="350" ></a>
</p>
	    
<a name="Themes"></a>
## Themes

<h3 align="center">Custom Themes</h3>

<br>
<p align="center">
Customize the look of your LinkStack instance with themes. Themes allow you to change the look and feel of your site with a few clicks. Users can submit themes they created for everyone to download and use.
</p>
    
<p align="center">
Contribute by designing your own themes. You can read more about contributing below.
</p>
    
<br>

|![preview1](https://raw.githubusercontent.com/LinkStackOrg/stargazer/main/preview.png) |![preview2](https://raw.githubusercontent.com/LinkStackOrg/Magic-Kingdom/main/preview.png)|
| ------------- |-------------|
|![preview3](https://raw.githubusercontent.com/LinkStackOrg/polygon/main/preview.png)|![preview4](https://raw.githubusercontent.com/LinkStackOrg/PolySleek/main/preview.png)|  

<br>

You can find all available Themes on here:
[linkstack.org/themes](https://linkstack.org/themes)


<br>

### How to add themes
#### How to add themes to your LinkStack instance
You can add your downloaded themes to your LinkStack instance on the Admin Panel. Navigate to the 'Themes' tab and scroll to the bottom of the page.

Now click on Choose file and select your downloaded theme zip file. Now click on 'Upload theme' and you should be able to select your uploaded theme now.

<br><br>

### **Themes are envisioned to be made by users for users.**

If you know a bit about CSS, consider making your own theme and adding it to the public directory.
Everything is documented in the dedicated GitHub repository.

[github.com/LinkStackOrg/linkstack-themes/tree/main/contributing](https://github.com/LinkStackOrg/linkstack-themes/tree/main/contributing)

<a name="Installation"></a>
## Installation

### Downloading and installing steps:
* **[Download](https://github.com/linkstackorg/linkstack/releases)** the latest release of LinkStack and simply place the folder 'linkstack' or the contents of this folder in the root directory of your website.

### That's it! No coding no command line setup just plug and play.

<br>	

#### Go through the first setup page:

When accessing your instance for the first time, you will be greeted by the first setup page.

<p align="center">
<img width="650" src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/marketing/setup_wizard.png">
</p>

<br>

<a name="Docker"></a>
## Docker

<p align="center">
<a href="https://github.com/linkstackorg/linkstack-docker">
<picture>
  <source media="(prefers-color-scheme: dark)" width="600px" srcset="https://raw.githubusercontent.com/LinkStackOrg/branding/main/marketing/docker_edition_dark.png">
  <img width="600px" src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/marketing/docker_edition_light.png">
</picture>
</a>
</p>

The official docker version of [LinkStack](https://github.com/linkstackorg/linkstack). This docker image is a simple to set up solution, containing everything you need to run LinkStack.

The docker version of LinkStack retains all the features and customization options of the [original version](https://github.com/linkstackorg/linkstack).

This docker is based on [Alpine Linux](https://www.alpinelinux.org), a Linux distribution designed to be small, simple and secure. The web server is running [Apache2](https://www.apache.org), a free and open-source cross-platform web server software. The docker comes with [PHP 8.0](https://www.php.net/releases/8.0/en.php) for high compatibility and performance.

#### Using the docker is as simple as pulling and deploying.

#### Pull

`docker pull linkstackorg/linkstack`

#### [Learn more about the Docker version](https://github.com/LinkStackOrg/linkstack-docker)

<br>

<a name="Updating"></a>
## Updating

When a **new version** is released, you will get an update notification on your Admin Panel.

### Automatic one click Updater
This updater allows you to update your installation with just one click.

<br>	

**How to use the Automatic Updater:**

- To update your instance, click on the update notification on your Admin Panel.

- Click on “Update automatically” and the updater will take care of the rest.

You can still download updates manually. New versions will are still uploaded to the GitHub repository as usual.

<br>	

Before updating, the updater will create a backup. Your instance won’t save more than two backups at a time. You can download these updates from the created folder: `backups\updater-backups`.

If you switched your database to MySQL, your database will not be included in the backup.

The updater may fail without throwing an error and just remain on the current version if there are unmet dependencies. This could include not having the correct version of the dependencies (eg. having php-sqlite3 pointing to php8.3-sqlite3, while LinkStack uses PHP 8.2 and needs php8.2-sqlite3). To troubleshoot, update manually and check the errors thown by the instance when accessing the website, as well as the PHP version reported.

<a name="Discord"></a>
## Discord

<br>

<p align="center">
  <a href="https://discord.linkstack.org"><img src="https://raw.githubusercontent.com/LinkStackOrg/branding/main/marketing/discord.png" alt="Join the Discord" width="600" ></a>
</p>

<br>

<a name="License"></a>
## License

[![License: AGPL v3](https://img.lss.ovh/badge/License-AGPL%20v3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)

As of version 4.0.0, the license for this project has been updated to the GNU Affero General Public License v3.0, which explicitly requires that any modifications made to the project must be made public. This license also requires that a copyright notice and license notice be included in any copies or derivative works of the project.

Additionally, any changes made to the project must be clearly stated, and the source code for the modified version must be made available to anyone who receives the modified version. Network use of the project is also considered distribution, and as such, any network use of the project must comply with the terms of the license.

Finally, any derivative works of the project must be licensed under the same license terms as the original project.

[Read more here](https://www.gnu.org/licenses/agpl-3.0)

<br>

<a name="Supporters"></a>
## Supporters
You can support LinkStack [here](https://linkstack.org/sponsor).


**💖 Thank you:**

- Stephen Marshall
- [Jascha Urbach](https://github.com/jaschaurbach)
- [LeoColman](https://github.com/LeoColman)
- [Eric Chung](https://github.com/erickchung)
- [Daltz](https://github.com/Daltz)
- [Jan Klomp](https://github.com/escuco)
- [AnhDOS](https://github.com/AnhDOS)
- [MrSpuddy](https://github.com/MrSpuddy)
- [Chih Wang](https://github.com/dozod-c)
- [kigordid](https://github.com/kigordid)
- [Ariq Naufal](https://github.com/naufdotal)
- [Molleman-De-Coster-BV](https://github.com/Molleman-De-Coster-BV)
- [RogueThorn](https://github.com/DunklerPhoenix)
- [sachacalibre](https://github.com/sachacalibre)
- [John Francis Sukamto](https://github.com/bigbadmonster17)

- [Add Your Name](https://linkstack.org/sponsor)

<br>

### Contributors

Thank you for improving LinkStack!

<p>
  <a href="https://github.com/linkstackorg/linkstack/graphs/contributors"><img src="https://components.linkstack.org/contributors" alt="Contributors" width="600" ></a>
</p>

<br>

### Beta Testers

Thank you for all your efforts!

<p>
  <a href="https://linkstack.org/beta-tester"><img src="https://components.linkstack.org/beta-testers" alt="Contributors" width="600" ></a>
</p>

[Become a beta tester](https://linkstack.org/beta-tester)

<br>

### Stargazers

<a href="https://star-history.com/#LinkStackOrg/LinkStack&LinkStackOrg/linkstack-docker&LinkStackOrg/linkstack-themes&Date">
    <img alt="Star History Chart" width="700px" src="https://api.star-history.com/svg?repos=LinkStackOrg/LinkStack,LinkStackOrg/linkstack-docker,LinkStackOrg/linkstack-themes&type=Date">
</a>

<br>

<a name="Additional-credit"></a>
## Additional-credit

- [laravel](https://github.com/laravel/laravel)
- [forked from](https://github.com/khzg/littlelink-admin)
- [default theme](https://github.com/sethcottle/littlelink)
- [dashboard template](https://github.com/iqonicdesignofficial/hope-ui-laravel-dashboard)
- [general animations](https://github.com/animate-css/animate.css)
- [config editor](https://github.com/GeoSot/Laravel-EnvEditor)
- [text editor (admin)](https://github.com/ckeditor/ckeditor4)
- [text editor (user)](https://github.com/ckeditor/ckeditor5)
- [backup backend](https://github.com/spatie/laravel-backup)
- [Vcard backend](https://github.com/jeroendesloovere/vcard)
- [QR code backend](https://github.com/Bacon/BaconQrCode)
