/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.io.file.DirectoryStreamFilter;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectoryStreamFilterTest {
    private static final String PATH_FIXTURE = "NOTICE.txt";

    @Test
    public void testFilterByName() throws Exception {
        NameFileFilter pathFilter = new NameFileFilter(PATH_FIXTURE);
        DirectoryStreamFilter streamFilter = new DirectoryStreamFilter((PathFilter)pathFilter);
        Assertions.assertEquals((Object)pathFilter, (Object)streamFilter.getPathFilter());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(PathUtils.current(), (DirectoryStream.Filter<? super Path>)streamFilter);){
            Iterator<Path> iterator = stream.iterator();
            Path path = iterator.next();
            Assertions.assertEquals((Object)PATH_FIXTURE, (Object)path.getFileName().toString());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testFilterByNameNot() throws Exception {
        IOFileFilter pathFilter = new NameFileFilter(PATH_FIXTURE).negate();
        DirectoryStreamFilter streamFilter = new DirectoryStreamFilter((PathFilter)pathFilter);
        Assertions.assertEquals((Object)pathFilter, (Object)streamFilter.getPathFilter());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(PathUtils.current(), (DirectoryStream.Filter<? super Path>)streamFilter);){
            for (Path path : stream) {
                Assertions.assertNotEquals((Object)PATH_FIXTURE, (Object)path.getFileName().toString());
            }
        }
    }
}

