/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsCleanSymlinksTestCase {
    @TempDir
    public File top;

    @Test
    public void testCleanDirWithSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realOuter = new File(this.top, "realouter");
        Assertions.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        File realFile = new File(realInner, "file1");
        FileUtils.touch((File)realFile);
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(realInner, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomFile, symlinkFile));
        Assertions.assertEquals((int)2, (int)realInner.list().length);
        FileUtils.cleanDirectory((File)realOuter);
        Assertions.assertEquals((int)0, (int)realOuter.list().length);
        Assertions.assertTrue((boolean)randomFile.exists());
        Assertions.assertFalse((boolean)symlinkFile.exists());
    }

    @Test
    public void testCleanDirWithASymlinkDir() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realOuter = new File(this.top, "realouter");
        Assertions.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realOuter, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomDirectory, symlinkDirectory));
        Assertions.assertEquals((int)1, (int)symlinkDirectory.list().length);
        FileUtils.cleanDirectory((File)realOuter);
        Assertions.assertEquals((int)0, (int)realOuter.list().length);
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length, (String)"Contents of sym link should not have been removed");
    }

    @Test
    public void testCleanDirWithParentSymlinks() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realParent = new File(this.top, "realparent");
        Assertions.assertTrue((boolean)realParent.mkdirs());
        File realInner = new File(realParent, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realParent, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomDirectory, symlinkDirectory));
        Assertions.assertEquals((int)1, (int)symlinkDirectory.list().length);
        File symlinkParentDirectory = new File(this.top, "fakeouter");
        Assertions.assertTrue((boolean)this.setupSymlink(realParent, symlinkParentDirectory));
        FileUtils.cleanDirectory((File)symlinkParentDirectory);
        Assertions.assertEquals((int)0, (int)symlinkParentDirectory.list().length);
        Assertions.assertEquals((int)0, (int)realParent.list().length);
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length, (String)"Contents of sym link should not have been removed");
    }

    @Test
    public void testStillClearsIfGivenDirectoryIsASymlink() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(this.top, "fakeDir");
        Assertions.assertTrue((boolean)this.setupSymlink(randomDirectory, symlinkDirectory));
        FileUtils.cleanDirectory((File)symlinkDirectory);
        Assertions.assertEquals((int)0, (int)symlinkDirectory.list().length);
        Assertions.assertEquals((int)0, (int)randomDirectory.list().length);
    }

    @Test
    public void testIdentifiesSymlinkDir() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        File symlinkDirectory = new File(this.top, "fakeDir");
        Assertions.assertTrue((boolean)this.setupSymlink(randomDirectory, symlinkDirectory));
        Assertions.assertTrue((boolean)FileUtils.isSymlink((File)symlinkDirectory));
        Assertions.assertFalse((boolean)FileUtils.isSymlink((File)randomDirectory));
    }

    @Test
    public void testIdentifiesSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(this.top, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomFile, symlinkFile));
        Assertions.assertTrue((boolean)FileUtils.isSymlink((File)symlinkFile));
        Assertions.assertFalse((boolean)FileUtils.isSymlink((File)randomFile));
    }

    @Test
    public void testIdentifiesBrokenSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File noexistFile = new File(this.top, "noexist");
        File symlinkFile = new File(this.top, "fakeinner");
        File badSymlinkInPathFile = new File(symlinkFile, "fakeinner");
        File noexistParentFile = new File("noexist", "file");
        Assertions.assertTrue((boolean)this.setupSymlink(noexistFile, symlinkFile));
        Assertions.assertTrue((boolean)FileUtils.isSymlink((File)symlinkFile));
        Assertions.assertFalse((boolean)FileUtils.isSymlink((File)noexistFile));
        Assertions.assertFalse((boolean)FileUtils.isSymlink((File)noexistParentFile));
        Assertions.assertFalse((boolean)FileUtils.isSymlink((File)badSymlinkInPathFile));
    }

    @Test
    public void testCorrectlyIdentifySymlinkWithParentSymLink() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realParent = new File(this.top, "realparent");
        Assertions.assertTrue((boolean)realParent.mkdirs());
        File symlinkParentDirectory = new File(this.top, "fakeparent");
        Assertions.assertTrue((boolean)this.setupSymlink(realParent, symlinkParentDirectory));
        File realChild = new File(symlinkParentDirectory, "realChild");
        Assertions.assertTrue((boolean)realChild.mkdirs());
        File symlinkChild = new File(symlinkParentDirectory, "fakeChild");
        Assertions.assertTrue((boolean)this.setupSymlink(realChild, symlinkChild));
        Assertions.assertTrue((boolean)FileUtils.isSymlink((File)symlinkChild));
        Assertions.assertFalse((boolean)FileUtils.isSymlink((File)realChild));
    }

    private boolean setupSymlink(File res, File link) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        args.add("-s");
        args.add(res.getAbsolutePath());
        args.add(link.getAbsolutePath());
        Process proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        return proc.waitFor() == 0;
    }
}

