---
authors:
  - jenniferplusplus
title: Starting the Letterbook Project
image:
  href: /img/startingLetterbook.jpg
  alt: "An expensive looking gold-tipped fountain pen on textured black paper"
  attribution: https://www.pexels.com/photo/classic-close-up-draw-expensive-372748/
canonical: https://jenniferplusplus.com/letterbook/
---

Like a lot of other people, I joined the fediverse at the end of 2022. I had primarily used Twitter until that point. There were always a lot of tradeoffs involved in the choice to use Twitter, but thanks to Musk they ceased to be worthwhile. There are likewise tradeoffs in making my home on the fediverse. It's far from perfect. But of all the options, I believe the fediverse has the most upside, and by far the most future potential. That potential exists mainly in the more democratized nature of the network. Anyone can, in theory, run their own server and set their own terms for engaging with the rest of the fediverse. Letterbook is one such server. I started it recently as an attempt to bring that theory closer to practice.

I hate the term microblogging, but I love the dynamic of it. Or at least the dynamic it can facilitate. I prefer to call it open correspondence. The rapid but not-quite-real-time nature of interactions enables dialog, but leaves time for considered responses. The mostly public nature of it enables serendipitous meetings and conversations. I think the short format is something of an enabling constraint. Combining some thoughtful discovery mechanisms with all that, I think, is a recipe for real connection. One of the tradeoffs of Twitter was that the discovery mechanisms were not thoughtful; they were manipulative. One of the tradeoffs with Mastodon is that there are almost no discovery mechanisms.

In fact, that open correspondence is the origin of the name. In the times when written letters were the standard technology for communicating across distances, a letter book was an actual book used to store and file those letters. Letterbook is where you keep your correspondence.

## Why Not Mastodon

I have concerns about the sustainability of the fediverse as it stands now, and I'm hardly the only one. Topics like cost, admin burnout, and haphazard moderation come up frequently. The model we have is that, with a few exceptions, servers are run by unpaid volunteers and funded by donations. That is, if they're not funded entirely by the admin. Mastodon is a complex distributed system, with poor observability, minimal documentation, and difficult scaling. The services it depends on can be quite expensive. I do not envy anyone who's trying to run it on their own, or unpaid. Overwhelmingly the same people running it as a service are also working as moderators for the communities that inhabit them. Community moderation, like system operations, is already a hard and thankless job. And like on the operations side, Mastodon's tools for handling it are crude.

The moderation tools that do exist are very coarse. They sever connections, and disrupt communication, and there's no middle ground between applying these effects on a single account or across the entire instance. You can silence a person, or a server, but nothing in between. And possibly worse is that almost any action taken by moderators is completely invisible to the members of an instance. People can be cut off from entire other communities, and they wouldn't know unless they happened to go looking for it. I feel like this actually betrays the promise of the fediverse. It should be empowering. People should be able to control their own experience, or at least select their own curator. But they don't have the information to make that choice, and the curators don't have the tools to do curation. So instead everyone is left to navigate even more uncertainty than before.

There are numerous mastodon instances that exist primarily to foster hate. They are widely blocked, but not universally. Abuse that originates from these hate farms can land on poorly moderated general purpose instances. And it will be completely invisible to people on proactively moderated instances. When two admins don't get along, they can cut their entire communities off from each other with no recourse, and third parties won't even know it happened. If an instance admin can't or won't run their server anymore, it can just disappear with no warning. The end result of all of this is that people have wildly differing and unpredicatable experiences on mastodon depending on what instance they happened to join based on nothing more than vibes. And on what race they present as.

[Mastodon is a very white space](https://techpolicy.press/the-whiteness-of-mastodon/. This is not a coincidence, and it's not a good thing. Whenever anyone criticizes any aspect of the mastodon-flavored fediverse, they can expect a flood of pushback, and much of it will consist of being dismissed with the refrain that you should "just move" to another instance. Or even to "just run your own" instance. Neither of these is a reasonable response to fair criticism. And they never will be. While the stakes are much lower, it's not really different than telling someone to just move to another country if they don't like the one they live in. It's not that simple, and they shouldn't have to, anyway. There are a lot of missing voices, and we're all worse off for it.

## The Point

If this all sounds very critical, well, it is. I'm critical of the things I care about. I really do think there's enormous potential in the fediverse. I've been able to stay in touch with a lot of people I like and respect, and I've met quite a few more besides. I have a lot of respect and appreciation for the admin and moderators of the instance I joined based on vibes, and none of this is a criticism of them. In fact, I say these things in sympathy for them. They're doing a hard job that's made harder by the tools they have to use. And I can do something about that. I build tools. I can build better tools. Better tools don't solve these problems on their own, but they will help. They can make intractable problems tractable. They can create options where they didn't exist before.

Tools are also reciprocal with culture. We build tools, but we are also shaped by the affordances of those tools. There's no magic to this, either, and nothing changes overnight. But when you change what's possible, what's easy, what's visible, you can change behavior. Changing behavior changes culture. And everything is downstream from culture.

I'm building Letterbook. I think it can be a very good thing. I would like it if you join me.
