﻿# Purpose

This document exists primarily as a statement of values, and our intent to uphold them. Rules and procedure are good; necessary even. But how we approach those rules and procedures is and always will be a product of our values. The rules are the means to doing that, not the end.

## Our Values

### Self Determination

Individuals and communities should be able to make their own choices and have enough information to fully understand those choices. A decision is not a choice if it is coerced or unfair, and there is no decision at all if only one real choice is offered. Freedom and openness are necessary components of this, but people must be empowered to realize the potential that freedom creates. We must provide all information necessary to make an informed decision, and we must provide fair choices with real alternatives.

### Human Communication

As contributors to the project, we're colleagues, and we have a responsibility to each other. Human communication means that we're honest, respectful, and considerate with each other. We should welcome each other's input, teach and learn from each other, and address conflict early and directly. We similarly have a responsibility to the admins, moderators, and members of Letterbook instances. This is a communication tool, and its users will conduct significant portions of their lives and affairs with it. We need to empower them to do so safely, securely, and privately.

### Safety and Inclusion

We recognize that many people cannot assume that any given space is safe for them, because the world is not safe. We should protect the people with the least power. We should invite the people with the least representation. We should support the people with the least opportunity. We want to enable anyone and everyone to participate, but wherever that isn't possible we should favor people's needs and safety over ease and comfort.

## Scope

Participants in the project do not have to all deeply hold these same values, but they do have to generally uphold them. This code of conduct applies in all interactions related to the project, between project members, and in public situations related to the project. It may also be relevant in unrelated public situations, in the event someone is acting severely or repeatedly in ways that contradict these values.

## Standards

It's impossible to define a comprehensive set of rules that can apply in all situations. Instead, examples of welcome behavior may serve better.

* Expressing gratitude
* Inviting input
* Accepting feedback
* Providing respectful and constructive guidance or feedback
* Accepting responsibility and apologizing
* Providing time and space for others to contribute

And by contrast, some examples of unacceptable behavior.

* Advocating for white supremacy or fascism
* Using sexualized imagery or language, or making sexual advances
* Using racial stereotypes or slurs
* Trolling, sealioning, whataboutism, "just asking questions", or any kind of harassment
* Undermining fellow contributors

## Enforcement

It is the responsibility of all the project members to uphold the values and standards of the project. In general, people should try to resolve conflicts directly with each other. The project's leaders and maintainers should step in whenever that isn't enough, and they should take whatever action they deem necessary to uphold the code of conduct. In all cases, the project leaders must respect the privacy and safety of anyone who reports an incident to them.

### Reporting
To report an incident, email Jennifer Moore (contact@jenniferplusplus.com) or any other member of the [Maintainers](https://github.com/orgs/Letterbook/teams/maintainers) team.

### Corrective Action

Project leaders may take any of these actions as needed, and may take action beyond this list if necessary.

**Public or private correction.** Often the best thing is simply to step in and ask for some behavior to stop. We may also ask for an apology for any inappropriate behavior.

**Formal warning.** More substantially inappropriate behavior may warrant setting some explicit boundaries, informing other maintainers, and making a record of the event.

**Temporary ban.** A serious violation of the project's standards may require that someone be prohibited from participating for a period of time.

**Permanent ban.** If someone repeatedly or egregiously violates the project's standards, they should be removed from the project. This is a serious action, but the project and community are much better off not tolerating this kind of behavior.

## Attribution

Portions of this Code of Conduct are adapted from the Contributor Covenant, version 2.1, available at https://www.contributor-covenant.org/version/2/1/code_of_conduct.html.

The Corrective Actions are inspired by Mozilla’s code of conduct enforcement ladder.
