# AspNet.WebApi.Exceptions.Mapper

[![NuGet Version](https://img.shields.io/nuget/v/AspNet.WebApi.Exceptions.Mapper.svg?style=flat)](https://www.nuget.org/packages?q=AspNet.WebApi.Exceptions.Mapper)
[![Build Status](https://img.shields.io/appveyor/tests/LeonidEfremov/aspnet-webapi-exceptions-mapper.svg?style=flat)](https://ci.appveyor.com/project/LeonidEfremov/aspnet-webapi-exceptions-mapper/)
[![SonarQube Coverage](https://img.shields.io/sonar/http/sonarcloud.io/AspNet.WebApi.Exceptions.Mapper/coverage.svg?style=flat)](https://sonarcloud.io/dashboard?id=AspNet.WebApi.Exceptions.Mapper)
[![Libraries.io dependency status](https://img.shields.io/librariesio/github/LeonidEfremov/aspnet.webapi.exceptions.mapper.svg)](https://libraries.io/github/LeonidEfremov/aspnet.webapi.exceptions.mapper)
[![License](https://img.shields.io/github/license/LeonidEfremov/AspNet.WebApi.Exceptions.Mapper.svg?style=flat)](https://github.com/LeonidEfremov/aspnet.webapi.exceptions/blob/master/license.md)

## About

Exception Mapper allow to map some Exception to ApiException and treat them in a certain way.

## Usage

``` csharp
public void ConfigureServices(IServiceCollection services)
{
    services.AddExceptionMapper(options =>
    {
        options.Map<System.ArgumentException, BadRequestException>();
        options.Map<System.NullReferenceException, ApiException>();
    });
}
```

## Requirements

Only [.NET Core SDK](http://dot.net/) (2.2.0 and above) required.