[![AWESOME CHEATSHEETS LOGO](_design/cover_github@2x.png)](https://lecoupa.github.io/awesome-cheatsheets/)

[![Awesome](https://awesome.re/badge.svg)](https://awesome.re) [![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/LeCoupa/awesome-cheatsheets/blob/master/LICENSE)

**WEBSITE DIRECTORY**: [Available here](https://lecoupa.github.io/awesome-cheatsheets/).

> 📚 Awesome cheatsheets for popular programming languages, frameworks and development tools. They include everything you should know in one single file.

## 🤔 Why Awesome-Cheatsheets?

I usually make a cheat sheet when I want to improve my skills in a programming language, a framework or a development tool. [I started doing these kinds of things a long time ago on Gist](https://gist.github.com/LeCoupa). To better keep track of the history and to let people contribute, I re-organized all of them into this single repository. Most of the content is coming from official documentation and some books I have read.

Feel free to take a look. You might learn new things. They have been designed to provide a quick way to assess your knowledge and to save you time.

## 📚 Table of Contents

### 📃 Languages

<details>
<summary>View cheatsheets</summary>

#### Command line interface

- [Bash](languages/bash.sh)

#### Imperative

- [C](languages/C.txt)
- [C#](languages/C%23.txt)
- [Go](languages/golang.md)
- [Java](languages/java.md)
- [PHP](languages/php.php)
- [Python](languages/python.md)

#### Functional

- [JavaScript](languages/javascript.js)

</details>

### 📦 Backend

<details>
<summary>View cheatsheets</summary>

#### PHP

- [Laravel](backend/laravel.php)

#### Python

- [Django](backend/django.py)

#### Javascript

- [Adonis.js](backend/adonis.js)
- [Express.js](backend/express.js)
- [Feathers.js](backend/feathers.js)
- [Moleculer](backend/moleculer.js)
- [Node.js](backend/node.js)
- [Sails.js](backend/sails.js)
  </details>

### 🌐 Frontend

<details>
<summary>View cheatsheets</summary>

#### Basics

- [HTML5](frontend/html5.html)
- [CSS3](frontend/css3.css)

#### Frameworks

- [React.js](frontend/react.js)
- [Vue.js](frontend/vue.js)
- [Tailwind.css](frontend/tailwind.css)
- [Ember.js](frontend/ember.js)
- [Angular (2+)](frontend/angular.js)
- [AngularJS](frontend/angularjs.js)
  </details>

### 🗃️ Databases

<details>
<summary>View cheatsheets</summary>

#### SQL

- [MySQL](databases/mysql.sh)

#### NoSQL

- [Redis](databases/redis.sh)
  </details>

### 🔧 Tools

<details>
<summary>View cheatsheets</summary>

#### Development

- [cURL](tools/curl.sh)
- [Drush](tools/drush.sh)
- [Elasticsearch](tools/elasticsearch.js)
- [Emmet](tools/emmet.md)
- [Git](tools/git.sh)
- [Puppeteer](tools/puppeteer.js)
- [Sublime Text](tools/sublime_text.md)
- [VIM](tools/vim.txt)
- [Visual Studio Code](tools/vscode.md)
- [Xcode](tools/xcode.txt)

#### Infrastructure

- [AWS CLI](tools/aws.sh)
- [Docker](tools/docker.sh)
- [Heroku CLI](tools/heroku.sh)
- [Kubernetes](tools/kubernetes.md)
- [Nanobox Boxfile](tools/nanobox_boxfile.yml)
- [Nanobox CLI](tools/nanobox_cli.sh)
- [Nginx](tools/nginx.sh)
- [PM2](tools/pm2.sh)
- [Ubuntu](tools/ubuntu.sh)
- [Firebase CLI](tools/firebase_cli.md)
  </details>

## 🙌🏼 How to Contribute?

You are more than welcome to contribute and build your own cheat sheet for your favorite programming language, framework or development tool. Just submit changes via pull request and I will review them before merging.

## 👩‍💻👨‍💻 Our valuable Contributors

<p align="center"><a href="https://github.com/LeCoupa/awesome-cheatsheets/graphs/contributors">
  <img src="https://contributors-img.web.app/image?repo=LeCoupa/awesome-cheatsheets" />
</a></p>
