---
icon: 📕 
title: Buong Wika
---

<pixra url="/assets/pixra/ralju/cll2.webp" caption="Ang Buong Wika ng Lojban, ang 2016 na inilimbag na edisyon"></pixra>

**CLL hindi opisyal** (sa pang-araw-araw, *UnCLL*, *InCLL*) ay isang proyektong itinatag ni Gleki ng mga regular na eksperimental na hindi opisyal (hindi kinakailangang aprobado ng Logical Language Group) na mga build ng aklat ng Buong Wika ng Lojban.

*   Ipadala ang iyong feedback (mga napansin na bugs, mga mungkahi, mga suhestiyon) sa isa sa mga sumusunod na lugar:
    *   [Lojban Reddit group](https://www.reddit.com/r/lojban/)
    *   [Lojban Facebook group](https://www.facebook.com/groups/lojban)
    *   Live chat: [Telegram chat](https://t.me/lojban) o [Discord chat](https://discord.gg/BVm4EYR)
    *   sa <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), ang tagapangalaga ng UnCLL.


## Mga Pinalabas

### geklojban-1.2.15 Oktubre 2022

#### Kompiladong Bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at paglalathala. Pansinin na ang pahina ng pamagat ay may eksplisitong marka bilang "geklojban-1.2.15" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [Format ng PDF](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [Format ng HTML, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [Format ng HTML - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference_prefixed.pdf) na nagko-compare ng geklojban-1.2.15 sa UnCLL, bersyon 1.2.14 (inilathala noong Hulyo 2021). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefixes ay idinagdag upang mabilis na mahanap ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento upang hanapin ang mga pagkakaiba).
*   o basahin ang dokumento ng pagkakaiba sa format ng HTML sa halip:
    *   [may prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.14 Hulyo 2021'

* inayos ang mga maling pagsusulat at mga problema sa istilo sa chrestomathy (salamat kay koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** binago sa **nunkilca'a** (salamat kay up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) pina-improve ang tosmabru test algorithm (salamat kay vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) ang "matrix transpose" cmavo ngayon ay gumagamit ng superscript T para sa transposition operator
* Ang mga pahiwatig ng Helvetica font ay pinalitan ng mga pahiwatig ng Comic font ("Comic" ay pangalan ng kahit isang open-source font)
* inayos ang iba pang mga maliit na pagkakamali sa pagsusulat (salamat kay Matt Nazarian, mattfbacon, la-kanba)
* Mga pagbabago sa CSS upang gumana nang mas maayos ang mga bersyon ng html sa mga aparato sa dark mode (salamat kay NathanHawks)
* Ang UnCLL ngayon ay may mga visual na mga file ng pagkakaiba mula sa nakaraang release at hiwalay para sa opisyal na release.

[git source ng UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Ihambing sa bersyon 'geklojban-1.2.12 Nobyembre 2020': git pagkakaiba](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Paghahambing sa opisyal na edisyon ng CLL v.1.1 (2016) at ang UnCLL Nobyembre 2020 edisyon': git pagkakaiba](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* ang ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf) na nagkokumpara ng geklojban-1.2.15 sa opisyal na CLL v.1.1 edisyon (2016). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang mabilis mong mahanap ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento upang hanapin ang mga pagkakaiba).

### geklojban-1.2.14 Hulyo 2021

#### Kumpiladong Bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may tatak na "geklojban-1.2.14" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [HTML format, isang seksyon ng aklat bawat pahina](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [HTML format - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference_prefixed.pdf) na nagtutulad ng geklojban-1.2.14 sa UnCLL, bersyon 1.2.12 (inilathala noong Nobyembre 2020). Ang dokumento ay may mga inilalagay na may berdeng marka at "ins\`" prefix at mga tinatanggal na may pula at "del\`" prefix. Ang mga prefix ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento upang hanapin ang mga pagkakaiba).
*   o basahin ang dokumento ng pagkakaiba sa HTML format sa halip:
    *   [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.11.1 Oktubre 2020'

* ito ay isa sa mga pangunahing pagpapabuti. [Lojban Words Glossary](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) ay may mga bagong halimbawa ng mga pangungusap sa Lojban kasama ang kanilang pagsasalin sa Ingles. Dahil ang bilang ng mga pangunahing salita sa Lojban ay mga 2000, nangangahulugan ito ng ~10% ng gawain na ito ay tapos na
* inayos ang mga pagkakamali sa **bo**, **ke'e** sa Kabanata 5. 'Scalar negation of selbri'
* inayos ang maling pangalan ng isang audio file
* mas maraming pagpapabuti sa indeks: idinagdag ang ZEhA at higit pang BAI
* mas mahusay na ipinaliwanag ang cmevla ayon sa dotside
* idinagdag ang mga nawawalang dots sa cmavo kung kinakailangan
* inayos ang bantas sa pagsasalin ng tula na 'Kubla Khan'

[git source ng UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Kumpara sa bersyon 'geklojban-1.2.12 Nobyembre 2020': pagkakaiba sa git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Paghahambing sa opisyal na edisyon ng CLL v.1.1 (2016) at ang UnCLL Nobyembre 2020 edisyon: pagkakaiba sa git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.13 Mayo 2021

#### Kompiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may marka na "geklojban-1.2.13" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [Format ng PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [Format ng HTML, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [Format ng HTML - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf) na nagko-compare ng geklojban-1.2.13 sa UnCLL, bersyon 1.2.12 (inilathala noong Nobyembre 2020). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento para hanapin ang mga pagkakaiba).
*   o basahin ang dokumentong pagkakaiba sa format ng HTML sa halip:
    *   [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.11.1 Oktubre 2020'

* idagdag ang mga bagong magagandang larawan ng kabanata ni [la-ninpre](https://github.com/la-ninpre)
* idagdag ang isang pagsasalin ng tula na 'In Xanadu' sa chrestomathy
* ayusin ang kakaibang petsa ng pagsusuri sa teorya ng set ni [simpson](https://github.com/MostAwesomeDude)
* ayusin ang kahulugan ng **toldi** (_paru-paro_)
* ayusin ang maling pahayag na nagpapahiwatig na ang fuhivla ay walang rafsi
* gawing hindi nakakalito ang paliwanag ng **le vi tavla ba klama** (ayusin na isinagawa ni [mezohe](https://github.com/mezohe))
* Ang mga Matrices na higit sa dalawang dimensyon ay maaaring itayo gamit ang **pi'a** o **sa'i** na may angkop na subscript na naglalarawan ng dimensyon... Ang mga label ay maaaring anumang suportado ng **xi**, halimbawa **pa** o **mlatu bu**.
* Kabanata 5: ibalik ang pagsasabi tungkol sa **bo** grouping sa seksyon tungkol sa NAhE, at idagdag ang **bo** sa isang halimbawa (ayusin na isinagawa ni [mezohe](https://github.com/mezohe))
* Kabanata 7: ayusin ang pahayag tungkol sa **ra'o** sa halimbawa 7.39 (ayusin na isinagawa ni [mezohe](https://github.com/mezohe))
* Kabanata 2: ayusin ang diagrama (predicate -> predication) (ayusin na isinagawa ni [mezohe](https://github.com/mezohe))
* idagdag ang nawawalang mga tuldok sa cmavo
* inayos ang iba pang mga maliit na pagkakamali, elemento ng mga indeks, mga script ng kompilasyon, atbp.

[git source ng UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Kumpara sa bersyon 'geklojban-1.2.12 Nobyembre 2020': git pagkakaiba](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Paghahambing sa pagitan ng opisyal na edisyon ng CLL v.1.1 (2016) at ang UnCLL Nobyembre 2020 edisyon': git pagkakaiba](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.12 Nobyembre 2020

#### Kumpiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may marka na "geklojban-1.2.12" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [Format ng PDF](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [Format ng HTML, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [Format ng HTML - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference_prefixed.pdf) na nagkokumpara ng geklojban-1.2.12 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may marka ng berde at "ins\`" prefix at mga deletions na may marka ng pula at "del\`" prefix. Ang mga prefix ay idinagdag upang mabilis mong mahanap ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong i-scroll ang dokumento para hanapin ang mga pagkakaiba).
*   o basahin ang dokumento ng pagkakaiba sa HTML format sa halip:
    *   [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.11.1 Oktubre 2020'

* Idinagdag ang pamantayang pagbigkas ng {u} sa kabanata ng IPA (ni [Vexatos](https://github.com/Vexatos))
* Ang mga subscript na simbolo sa mga glosses ay naaayos nang naaayon (bug napansin ni [gr-g](https://github.com/gr-g))
* Naayos ang isang grammatical error sa Halimbawa 17.36 (bug napansin ni [kotwys](https://github.com/kotwys))
* Ang particle **ri'u** ay nawawala sa Seksyon 10.28 (na napansin ni [gr-g](https://github.com/gr-g)). Idinagdag
* Sa Halimbawa 7.12 ang unang lugar ng **lafti** ay inilalapat sa isang tao. Binago ang predicate sa **lafmuvgau** (na nasa mga notes ng kahulugan ng **lafti**)
* Sa English text baguhin ang .) sa ). kung kinakailangan
* Ipakita ang square root, infinity at golden ration phi gamit ang mga aktwal na simbolo
* Naayos ang maling pagsasalin ng **levi rozgu cu sofi'upanova'e xunre**
* iba pang mga minor fixes

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.12)

#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.11.1 Oktubre 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Kumpara sa bersyon 'geklojban-1.2.3 Enero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Kumpara sa opisyal na edisyon ng CLL v.1.1 (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)


### geklojban-1.2.11.1 Oktubre 2020

#### Kumpiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may marka na "geklojban-1.2.11" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [HTML format, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [HTML format - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference_prefixed.pdf) na nagko-compare ng geklojban-1.2.11 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefixes ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng difference na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong i-scroll ang dokumento para hanapin ang mga pagkakaiba).
*   o basahin ang dokumentong pagkakaiba sa HTML format sa halip:
    *   [may prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.10 Agosto 2020'

* Ang mga audio link (audio ni la tcakoi, la .lindar., la .aionys.) ay idinagdag sa "splits by sections" at "split by chapters" HTML versions ng aklat
* Inayos ang ilang mga maling tipo
* Idinagdag ang mga hanzi characters sa isang halimbawa ng Chinese
* 1.2.11.1 hotfix release: ginawa ang mga audio buttons sa mga HTML pages na talagang gumagana

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.11)

#### Paghahambing ng source code sa mga naunang bersyon
* [Ihambing sa bersyon 'geklojban-1.2.10 Agosto 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Ihambing sa bersyon 'geklojban-1.2.3 Enero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Ihambing sa opisyal na CLL v.1.1 edisyon (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)

### geklojban-1.2.10 Agosto 2020

#### Kumpiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang title page ay eksplisitong may marka bilang "geklojban-1.2.10" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang LLG publication:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [HTML format, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [HTML format - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference_prefixed.pdf) na nagkokumpara sa geklojban-1.2.10 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng difference na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento para hanapin ang mga pagkakaiba).
*   o basahin ang dokumento ng pagkakaiba sa HTML format sa halip:
    *   [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.9 Hulyo 2020'

* Ang volume ng Chrestomathy (piniling mga teksto) ay idinagdag pagkatapos ng huling kabanata
* Ang mga tuldok ay hindi kailanman ini-imis sa mga salita, kahit sa Lojban Words Index

#### [source ng git](https://github.com/lojban/cll/compare/geklojban-1.2.10)

#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.9 Hulyo 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Kumpara sa bersyon 'geklojban-1.2.3 Enero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Kumpara sa opisyal na edisyon ng CLL v.1.1 (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)


### geklojban-1.2.9 Hulyo 2020

#### Kompiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may tatak na "geklojban-1.2.9" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [Formatong PDF](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [Formatong EPUB](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [Formatong HTML, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [Formatong HTML - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference_prefixed.pdf) na nagko-compare ng geklojban-1.2.9 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may tatak na berde at "ins\`" prefix at mga deletions na may tatak na pula at "del\`" prefix. Ang mga prefix ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng difference na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong i-scroll ang dokumento para hanapin ang mga pagkakaiba).
*   o basahin ang dokumentong pagkakaiba sa formatong HTML sa halip:
    *   [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.8.1 Hunyo 2020'

* Ang bersyong HTML ngayon ay may mga talahanayan at mga halimbawa na maaaring i-scroll ng pahalang sa makitid (halimbawa, mga mobile device') na mga screen. Ito ay gumagawa ng bersyong HTML na mas kaibigan sa mobile
* Ang EPUB ay muli nang nilikha (wala sa bersyon 1.2.8.1)
* Ang mga simbolo sa Korean at Chinese ay ipinapakita ngayon gamit ang Noto CJK font
* Ang mga lugar tulad ng "$x_1$" ay ipinapakita ngayon na may mga numero sa subscript
* Ang isang halimbawa sa Seksyon 16.9 {naku zo'u la djan. klama} ay hindi tugma sa iba pang mga halimbawa sa paligid kaya ito ay pinalitan ng {naku zo'u mi klama le zarci} (isang bug na napansin ni [Corbin Simpson](https://github.com/MostAwesomeDude))
* isang kahulugan ng salitang {bu'u} ay idinagdag sa listahan ng iba pang mga bahagi ng gramatika ng klase FAhA

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.9)

#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.8.1 Hunyo 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Kumpara sa bersyon 'geklojban-1.2.3 Enero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Kumpara sa opisyal na edisyon ng CLL v.1.1 (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)

### geklojban-1.2.8.1 Hunyo 2020

#### Kompiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay may eksplisitong tatak na "geklojban-1.2.8.1" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [Formato ng PDF](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [Formato ng HTML, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [Formato ng HTML - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference_prefixed.pdf) na nagkokumpara ng geklojban-1.2.8.1 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may tatak na berde at "ins\`" prefix at mga deletions na may tatak na pula at "del\`" prefix. Ang mga prefix ay idinagdag upang mabilis mong mahanap ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong i-scroll ang dokumento upang hanapin ang mga pagkakaiba).
*   o basahin ang dokumento ng pagkakaiba sa HTML format sa halip:
    *   [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.7 May 2020'

* Isang bagong ortograpiyang "diacritic" na tinatawag na "zbalermorna" ang idinagdag. Malinaw na binanggit na hindi opisyal ito. Ang mga simbolo ("mga titik") nito ay ipinapakita gamit ang angkop na font. Saludo kay [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) at sa kanilang koponan (la saski'o, la xaspeljba at iba pa) para sa font at sa pagsusuri ng ortograpiya.
* Na-rebisa ang mga indeks (halos lahat ng 4000 na entry). Maraming entry ang binago para sa kaginhawahan sa paggamit o inilipat mula sa Lojban Words Index patungo sa General Index o kabaligtaran nito.
* ang patakaran para sa paggamit ng koma ay [ibalik](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) pabalik sa bersyon mula sa CLL 1.1
* isang mas mahusay na algoritmo ng pagkakaiba para sa pagtingin ng mga pagkakaiba sa pagitan ng mga bersyon (walang karagdagang kalat)
* bersyon 1.2.8.1 hotfix release: inayos ang mga problema sa pagpapakita ng mga simbolo ng zbalermorna sa PDF document

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.7 May 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Kumpara sa bersyon 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Kumpara sa opisyal na edisyon ng CLL v.1.1 (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)

### geklojban-1.2.7 May 2020

#### Kompiladong bersyon
* basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang title page ay eksplisitong may marka na "geklojban-1.2.7" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    * [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    * [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    * [HTML format, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    * [HTML format - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf) na nagko-compare ng geklojban-1.2.7 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang mabilis mong mahanap ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong i-scroll ang dokumento para hanapin ang mga pagkakaiba).
* o basahin ang dokumento ng pagkakaiba sa HTML format sa halip:
    * [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.6 Abril 2020'

* "Ang cmavo na tu'a ay ginagamit sa pagbuo ng mga abstraksyon, at ipinaliwanag nang mas detalyado sa Seksyon 11.11." ngunit hindi ito binanggit sa anumang paraan sa seksyong iyon. Binago ang sanggunian patungo sa Seksyon 11.10. Napansin ang pagkakamali ni [Robert Baruch](https://github.com/RobertBaruch).
* lahat ng sanggunian sa selma'o ay inilipat mula sa indeks ng mga salita sa lojban patungo sa pangkalahatang indeks sa appendix.
* Seksyon 10.18. Ang pariralang "Hindi katulad ng -nai na kontradiktoryang negasyon, ang scalar negation ng mga panahon ay hindi limitado sa PU at FAhA:" ay nagtutol sa sumusunod na teksto ng seksyon. Pinapalitan ng "Isang halimbawa ng scalar negation ng FAhA:"

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.7)
#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.6 Abril 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Kumpara sa bersyon 'geklojban-1.2.3 Enero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Kumpara sa opisyal na edisyon ng CLL v.1.1 (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)

### geklojban-1.2.6 Abril 2020

#### Kompiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may tatak na "geklojban-1.2.6" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [HTML format, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [HTML format - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference_prefixed.pdf) na nagkokumpara ng geklojban-1.2.6 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng difference na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento upang hanapin ang mga pagkakaiba).
*   o basahin ang dokumentong pagkakaiba sa HTML format sa halip:
    *   [may prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa naunang bersyon 'geklojban-1.2.5 Marso 2020'

* mga bagong magandang larawan sa mataas na resolusyon para sa ilang kabanata na ginawa ni [la ninpre](https://github.com/la-ninpre) (posibleng paglabag sa karapatan sa pag-aari na tinanggihan)
* ang patakaran na 'ang mga koma ay hindi kailanman kinakailangan' ay pansamantalang limitado ngayon sa mga koma na mga tagapaghiwalay ng pantig
* idinagdag ang higit pang mga link sa iba't ibang selma'o sa lojban-word index

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.6)
#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.5 Marso 2020': git pagkakaiba](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Kumpara sa bersyon 'geklojban-1.2.3 Enero 2020': git pagkakaiba](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)

### geklojban-1.2.5 Marso 2020

#### Kumpiladong bersyon
* basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay may eksplisitong tatak na "geklojban-1.2.5" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    * [Formatong PDF](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    * [Formatong EPUB](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    * [Formatong HTML, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    * [Formatong HTML - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference_prefixed.pdf) na nagkokumpara sa geklojban-1.2.5 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang madaling hanapin ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento upang hanapin ang mga pagkakaiba).
* o basahin ang dokumentong pagkakaiba sa formatong HTML sa halip:
    * [may mga prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Maikling listahan ng mga pagbabago kumpara sa bersyon 'geklojban-1.2.3 Enero 2020'
* pansamantalang tinanggal ang kontrobersyal na paggamit ng ni+ce'u
* gumamit ng mas magandang halimbawa para sa NU JA NU, tanggalin ang pagpapalawak ng NU JA NU (na maaaring hindi malinaw kung maraming NU JA NU sa isang bridi)
* idagdag ang hanzi at mas magandang pinyin sa mga halimbawa sa Tsino
* Dotside: Pagdagdag ng isang simulaing glottal stop sa IPA transcription sa isang halimbawa
* idagdag ang "FA selma'o" sa lojban-word index
* ang patakaran na 'ang mga koma ay hindi kailanman kinakailangan' ay pansamantalang limitado lamang sa cmevla
* inayos ang ilang mga maling pagsusulat
* idinagdag ang mga simbolo ng UTF nang tulad ng kanilang mga paglalarawan
*   Dotside naipatupad
*   ang mga konsepto ng "cmene" at "cmevla" ay ngayon hiwalay na
*   **sumti tcita** ay binago ang pangalan sa **sumtcita**
*   **mi kucli le jei broda** ay ngayon **mi kucli tu'a le jei broda**
*   Ang diksiyonaryo na may mga halimbawa ay ngayon teknikal na posible: ang glossary ay maaaring magkaroon ng mga halimbawa sa ilalim ng mga kahulugan ng mga salita (at ginagawa ito para sa salitang **coi** bilang isang halimbawa)
*   ang rafsi para sa **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** ay binago ayon sa cmavo.txt mula sa taong 2002.
*   napakaraming mga maling pagsusulat at mga maliit na pagkakamali ang naayos

#### [git source](https://github.com/lojban/cll/compare/geklojban-1.2.5)
#### Pagkumpara ng source code sa mga naunang bersyon
* [Kumpara sa bersyon 'geklojban-1.2.4 Pebrero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Kumpara sa bersyon 'geklojban-1.2.3 Enero 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)


### geklojban-1.2.4 Pebrero 2020

#### Kumpiladong bersyon
*   basahin ang huling dokumento na gagamitin para sa pag-iimprenta at pampublikasyon. Pansinin na ang pahina ng pamagat ay eksplisitong may tatak na "geklojban-1.2.4" at may pangalan ng organisasyon na naglathala nito na iba sa LLG; ginagawa ito upang bigyang-diin na hindi ito isang publikasyon ng LLG:
    *   [PDF format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [EPUB format](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [HTML format, isang pahina ay isang seksyon ng aklat](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [HTML format - ang buong aklat sa isang napakahabang pahina](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* o basahin ang tinatawag na ["difference" PDF document](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference_prefixed.pdf) na nagkokumpara ng geklojban-1.2.4 sa CLL na inilathala noong 2016 (2016-08-27 release). Ang dokumento ay may mga insertions na may markang berde at "ins\`" prefix at mga deletions na may markang pula at "del\`" prefix. Ang mga prefix ay idinagdag upang mabilis na mahanap ang mga pagkakaiba sa PDF document gamit ang Cmd+F o Ctrl+F. Mayroong [alternatibong bersyon ng pagkakaiba na walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (ngunit kailangan mong manu-manong mag-scroll sa dokumento upang hanapin ang mga pagkakaiba).
*   o basahin ang dokumento ng pagkakaiba sa HTML format sa halip:
    *   [may prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [walang prefixes](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

### Maikling listahan ng mga pagbabago kumpara sa bersyon 'geklojban-1.2.3 Enero 2020'
* naayos ang ilang mga maling pagsusulat
* idinagdag ang mga simbolo ng UTF nang tulad ng kanilang anyo (sa halip ng kanilang mga paglalarawan)

#### [pinagmulan ng git](https://github.com/lojban/cll/compare/geklojban-1.2.4)

#### Paghahambing ng source code sa mga naunang bersyon
* [Ihambing sa bersyon 'geklojban-1.2.3 Enero 2020': pagkakaiba sa git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Ihambing sa opisyal na edisyon ng CLL v.1.1 (2016)': pagkakaiba sa git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)

### geklojban-1.2.3 Enero 2020

#### Maikling listahan ng mga pagbabago

*   Ipinalabas ang Dotside
*   Ang mga konsepto ng "cmene" at "cmevla" ay ngayon hiwalay
*   **sumti tcita** ay binago ang pangalan sa **sumtcita**
*   Ang Dictionary na may mga halimbawa ay ngayon teknikal na posible: ang glossary ay maaari nang magkaroon ng mga halimbawa sa ilalim ng mga kahulugan ng mga salita (at ginagawa ito para sa salitang **coi** bilang isang halimbawa)
*   ang rafsi para sa **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** ay binago ayon sa cmavo.txt mula sa taong 2002.
*   napakaraming mga maling pagsusulat at mga maliit na pagkakamali ang naayos

#### [pinagmulan ng git](https://github.com/lojban/cll/compare/geklojban-1.2.3)
