## Урок 9. Логические союзы

Логические союзы в ложбане основаны на 4 примитивных союзах: **.a**, **.e**, **.o**, **.u**. В этом уроке мы рассмотрим их подробно.

### Логические союзы для аргументов

Вот союзы, объединяющие два слова: _это_ и _то_.

- **ti .a ta** = _это и/или то_

 > **mi ba vitke le mamta .a le tamne**
 >_Я навещу маму или двоюродного брата._

 Обратите внимание, что **.a** также может быть переведено как _хотя бы одно из двух значений_, и таким образом оставляет открытой возможность, что я в конечном итоге навещу обоих.

- **ti .e ta** = _это и то_

 > **mi ralte le pa gerku .e le re mlatu**
 >_У меня есть собака и две кошки._
 >`У меня есть одна собака и две кошки.`

- **ti .o ta** = _либо это и то, либо ничего_

 > **mi ba vitke le mamta .o le tamne**
 >_Я навещу либо и маму, и двоюродного брата, либо никого из них._

- **ti .u ta** = _это, и возможно, то_, _это независимо от того, будет ли то_

 > **mi ba vitke le mamta .u le tamne**
 >_Я навещу маму, независимо от того, навещу ли я двоюродного брата._

 **.u** просто подчеркивает, что второе значение не влияет на истинность предложения.

Постановка **nai** после союза отрицает то, что находится справа от него. Постановка **na** перед союзом отрицает то, что находится слева от него:

- **ti .e nai ta** = _это и не то_

 > **mi nelci la .bob. e nai la .alis.**
 >_Мне нравится Боб, но не Алиса._
 >`Мне нравится Боб, и не Алиса`

 Мы также можем сказать **ti .e nai ku'i ta** (_это, но не то_) добавляя оттенок контраста для второго аргумента.

- **ti na .e ta** = _не это, а то_

 > **mi nelci la .alis. na .e la .bob.**
 >_Мне не нравится Алиса, но мне нравится Боб._
 >`Мне нравится Алиса не, а Боб`

 Это может звучать немного странно для носителей русского языка (`Мне нравится Алиса не …`), поэтому вы можете предпочесть поменять аргументы и использовать **.e nai** вместо этого: **mi nelci la .bob. e nai la .alis.** или даже **mi nelci la .bob. i mi na ku nelci la .alis.** будет означать то же самое.

- **ti na .e nai ta** = _ни это, ни то (ничего)_

 > **mi nelci la .alis. na .e nai la .bob.**
 >_Мне не нравится ни Алиса, ни Боб._

Отрицание с помощью других примитивных союзов может показаться неинтуитивно используемым, но вы можете просто изучить их на примерах:
- **ti .a nai ta** = _это если то_, _для этого единственное условие, чтобы это произошло, это_

 > **mi ba vitke le mamta .a nai le tamne**
 > _Я навещу маму, но для этого мне нужно навестить кузена._

 Таким образом, **ti .a nai ta** означает, что **ta** необходимо (но может быть не единственным условием) для применения **ti**.

- **ti .o nai ta** = _либо это, либо то_

 > **mi ba vitke le mamta .o nai le tamne**
 > _Я навещу либо маму, либо кузена._

 Если я хочу сказать, что я навещу либо маму, либо кузена, но не обоих, мне нужно использовать **.o nai** (_либо/или_). Это отличается от **.a** (_или/и_) где я могу навестить обоих.

- **ti na .u ta** = не влияет _(не это, но возможно то)_
- **ti na .u nai ta** = не влияет _(не это, но возможно то)_

- **ti se .u ta** = _возможно это, и то_
- **ti se .u nai ta** = _возможно это, но не то_

<!-- **se** используется только для **.u**, потому что в других случаях это не влияет на значение. -->

Они используются для соединения аргументов. Для соединения частей составных отношений мы используем аналогичные союзы: **ja**, **je**, **jo**, **ju**. Так что вместо точки (паузы) здесь мы используем **j**.

<!-- Обычно **ja**, **je**, **jo**, **ju** также используются для соединения аргументов. -->

### Логические союзы для предложений

Это более краткий способ сказать:

> **mi ralte le pa gerku .i je mi ralte le re mlatu**
> _У меня есть собака, и у меня есть две кошки._

**.i je** объединяет два предложения с логическим _и_, показывая, что оба предложения являются частью одной мысли и являются истинными.

Вот примеры других союзов для предложений:

> **la .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os.**
> _Ромео любит Джульетту, <u>и</u> Джульетта любит Ромео._

Это означает, что оба утверждения истинны, то есть Ромео и Джульетта любят друг друга.

То же самое относится и к другим союзам:

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Ромео любит Джульетту, и/или Джульетта любит Ромео._

Это означает, что один из них любит другого, а возможно, что оба они любят друг друга.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Или Ромео любит Джульетту, или Джульетта любит Ромео._

Здесь, или Ромео любит Джульетту (но она его не любит), или Джульетта любит Ромео (но он ее не любит).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _Для того, чтобы Ромео любил Джульетту, необходимо, чтобы Джульетта любила Ромео._

Это означает, что если Джульетта любит Ромео, он определенно любит ее, но он может любить ее в любом случае (единственный невозможный исход - это когда Джульетта любит Ромео, но он ее не любит).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Или Ромео любит Джульетту, и Джульетта любит Ромео, или ни одно из этих событий не происходит._

Это означает, что если Джульетта любит Ромео, он любит ее, и если она его не любит, он ее не любит.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Ромео любит Джульетту, независимо от того, любит ли Джульетта Ромео._

Обратите внимание, как мы преобразовали имя "Ромео" в Ложбане: сочетание "eo" невозможно в Ложбане, поэтому мы использовали "e'o" и добавили согласный в конце его имени.

Обратите внимание, что **da** относится к одной и той же сущности, когда несколько предложений связаны.

### Логические союзы в составных отношениях

> **le melbi xunre fonxa**
> _красивые красные телефоны_

<!-- -->

> **le melbi je xunre fonxa**
> _красивые и красные телефоны_

Другие союзы также имеют смысл:

> **mi nelci ro tu voi xajmi ja melbi prenu**
> _Мне нравятся все люди, которые смешные или красивые (или и то, и другое)._

<!-- -->

> **mi nelci ro tu voi xajmi jo nai melbi prenu**
> _Мне нравятся все люди, которые либо смешные, либо красивые._

Это может быть объяснено, если, например, я считаю, что качества юмора и хорошей внешности несовместимы, то есть смесь двух качеств будет слишком много.

> **mi nelci ro tu voi xajmi ju melbi nanmu**
> _Мне нравятся все люди, которые смешные (независимо от того, красивые они или нет)._

И снова, не забываем о разнице между соединением аргументов и соединением частей составных отношений.

> **mi klama le zarci gi'o klama le panka**
> _Do I go to the store or go to the park?_

Here, **gi'o** is used to indicate a choice between going to the store and going to the park.

### Summary

- Use **gi'e** to join several relations with a common head.
- Use **gi'a** for _and/or_, **gi'o nai** for _either … or_, **gi'u** for _whether or not_, etc.
- Tenses as terms and tenses attached to the main relation of the relation make a difference in sentences with several attached relations.
- Use **gi'o** to indicate a choice in questions.

> **— xu do pinxe le tcati .o nai le ckafi?**
> **— pinxe**
> _— Ты будешь пить чай или кофе?_
> _— Да._

Это странный, но вполне разумный ответ: _Да, я буду пить чай или кофе._

Это происходит потому, что в русском языке у слова "или" есть несколько значений:

1. _A or B_ может означать _либо A, либо B, но не оба_. Здесь мы используем **.o nai**.
2. _A or B_ может означать _A или B или оба_. Здесь мы используем **.a**.
3. _A or B?_ может быть вопросом, означающим _выбери из A и B, что ты выбираешь?_ Здесь мы используем **ji**.

Таким образом, в последнем случае мы используем отдельное вопросительное соединение **ji**:

> **— do pinxe le tcati ji le ckafi?**
> _— Ты будешь пить чай или кофе?_

Возможные ответы:

> **le tcati .e le ckafi**
> _Чай и кофе._

<!-- -->

> **le tcati**
> _Чай._

<!-- -->

> **le ckafi**
> _Кофе._

Также можно использовать союзы при ответе:

> **.e** — <span>_Оба_ (выбраны и первый, и второй пункт)</span>

<!-- -->

> **.e nai** — <span>_Первый (чай)_ (выбран только первый пункт)</span>

<!-- -->

> **na .e** — <span>_Второй (кофе)_ (выбран только второй пункт)</span>

<!-- -->

> **na .e nai** — <span>_Ни один_ (ни первый, ни второй пункт не выбран)</span>

Вы можете задавать вопросы таким же образом о других типах союзов, о которых мы говорили. Вопросительное соединение для отношений — **gi'i**, для составных отношений — **je'i**, для предложений — **.i je'i**.

Косвенные вопросы достигаются с помощью **ji kau**:

Представьте себе, что официант спрашивает посетителя:

> **- le'e dembi ji le'e rismi**
> _- Бобы или рис?_

Когда посетитель отвечает, официант знает, хочет ли посетитель есть баранину или говядину:

> **ba le nu le vitke cu spusku kei le bevri cu djuno le du'u le vitke cu djica le nu ri citka le'e dembi ji kau le'e rismi**
> _После ответа посетителя официант знает, хочет ли посетитель есть бобы или рис._

### Предварительные союзы

> **ge do gi mi**
> _И ты, и я_

<!-- -->

> **ge nai do gi mi**
> _Не ты, а я_

<!-- -->

> **ge do gi nai mi**
> _Ты, но не я_

<!-- -->

> **go nai do gi mi**
> _Либо ты, либо я_

Союз **ge** вводит союзную конструкцию _и_, но он ставится перед первым аргументом, с разделителем **gi** между двумя аргументами. Эта серия параллельна другим союзам: **ga**, **ge**, **go**, **gu**, а также **ga nai**, **ge nai**, **go nai** и т.д. Разделитель **gi** одинаков для всех этих союзов.

Использование этих союзов - это вопрос удобства:

> **mi citka ge nai le badna gi le plise**
> _Я ем не банан, а яблоко._

Здесь, как и в русском, _не_ указывается перед первым аргументом.

**ge** и слова из этой серии также могут использоваться для связывания отношений:

> **ge mi dansu gi mi zgipli le pipno**
> _Я и танцую, и играю на пианино._

zgipli
: $x_1$ играет на музыкальном инструменте $x_2$

le pipno
: пианино

> **.i ga nai pu zi carvi gi ca cilmo**
> _Если недавно шел дождь, сейчас мокро._
