## Урок 7. Буквы, относящиеся к отношениям, датам

### Названия букв на ложбане

Каждая буква имеет свое название на ложбане.

Следующая таблица представляет основной алфавит ложбана и произношение букв (под каждой буквой):

<table>
<tbody><tr>
<td>'
</td>
<td><b><font  class="guibutton" color="#FF1493">a</font></b>
</td>
<td>b
</td>
<td>c
</td>
<td>d
</td>
<td><b><font  class="guibutton" color="#FF1493">e</font></b>
</td></tr>
<tr>
<td><b>.y'y.</b>
</td>
<td><b>.a bu</b>
</td>
<td><b>by.</b>
</td>
<td><b>cy.</b>
</td>
<td><b>dy.</b>
</td>
<td><b>.ebu</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>f
</td>
<td>g
</td>
<td><b><font  class="guibutton" color="#FF1493">i</font></b>
</td>
<td>j
</td>
<td>k
</td>
<td>l
</td></tr>
<tr>
<td><b>fy.</b>
</td>
<td><b>gy.</b>
</td>
<td><b>.i bu</b>
</td>
<td><b>jy.</b>
</td>
<td><b>ky.</b>
</td>
<td><b>ly.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>m
</td>
<td>n
</td>
<td><b><font class="guibutton" color="#FF1493">o</font></b>
</td>
<td>p
</td>
<td>r
</td>
<td>s
</td></tr>
<tr>
<td><b>my.</b>
</td>
<td><b>ny.</b>
</td>
<td><b>.o bu</b>
</td>
<td><b>py.</b>
</td>
<td><b>ry.</b>
</td>
<td><b>sy.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>t
</td>
<td><b><font  class="guibutton" color="#FF1493">u</font></b>
</td>
<td>v
</td>
<td>x
</td>
<td><b><font  class="guibutton" color="#FF1493">y</font></b>
</td>
<td>z
</td></tr>
<tr>
<td><b>ty.</b>
</td>
<td><b>.u bu</b>
</td>
<td><b>vy.</b>
</td>
<td><b>xy.</b>
</td>
<td><b>.y bu</b>
</td>
<td><b>zy.</b>
</td></tr></tbody></table>

Как вы можете видеть:

- чтобы получить название гласной, мы добавляем слово **bu**.
- чтобы получить название согласной, мы добавляем **y.** к согласной.
- слово для **'** (апострофа) - **.y'y**.

Мы можем произносить слова, используя эти названия. Например, CNN будет **cy. ny. ny.**

<!-- Заглавная буква сама по себе имеет особое значение. Она обозначает название этой буквы:

**A** означает то же самое, что и **.abu**, **B** означает то же самое, что и **by.** и так далее. Они означают то же самое и даже произносятся так же, как обычные **.abu**, **by.** и т. д. Так что _CNN_ также можно написать как **CNN** на ложбане, и это все равно будет произноситься и означать то же самое, что и **cy. ny. ny.** -->

### Буквы вместо «он» и «она»

Строка из одного или нескольких названий букв может служить местоимением, предоставляя альтернативный способ обращения к ранее упомянутым аргументам в речи.

> **la .alis. pu klama le nurma .i le nurma cu melbi la .alis.**
> **la .alis. pu klama le nurma .i ri melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi .a bu**
> _Алиса отправилась в сельскую местность. Сельская местность красива для Алисы._
> _Алиса отправилась в сельскую местность. Она красива для неё._

Все ложбанские варианты выше имеют одно и то же значение.

Поскольку первая буква в **.alis.** - **a** (игнорируя точку), а первая буква в **nurma** - **n**, мы можем использовать слова-буквы для соответствующего обозначения этих аргументов:

- **.a bu** относится к **la .alis.**
- **ny.** относится к **le nurma**

Этот метод может быть более удобным, чем русские _он_ или _она_, или даже ложбанские **ri** или **ra**. Он позволяет сделать речь более краткой, но точной, не повторяя потенциально длинные имена или другие термы аргументов.

Однако важно отметить, что могут возникнуть ситуации, когда мы хотим сослаться, например, на **le nurma**, но в это время появляется другой аргумент, начинающийся на **n**, что делает **ny.** неспособным ссылаться на сельскую местность. В таких случаях самым быстрым решением будет повторить весь аргумент, то есть сказать **le nurma**:

> **bu'u le nurma la .alis. pu penmi la .nik. i ri se zdani bu'u le nurma**
> _В стране Алиса встретила Ника. Он имеет свой дом в стране._

zdani
: … является домом для …

se zdani
: … имеет дом …, … живет в …

Если имя состоит из нескольких cmevla, вы можете использовать первые буквы для обращения к этому имени. То же самое относится к составным отношениям:

> **la .djan.smit. cu citka le glare stasu .i dy.sy. nelci fy.sy.**
> _Джон Смит ест горячий суп. Ему нравится это._

glare
: … горячий

**dy.sy.** - это одно местоимение. То же самое относится к **fy.sy.**.

Если вам нужно поставить несколько местоимений одно за другим, разделите их словом **boi**:

> **mi klama la .paris. la .moskov.**
> _Я еду в Париж из Москвы._

<!-- -->

> **mi klama py. boi my.**
> _Я еду в П из М._

Предложение **mi klama py. my.** означало бы _Я еду в ПМ_, что означало бы нечто другое.

> **la .tom.silver. pu zvati .i je'u ty. sy. boi .ui pu sidju mi**
> _Том Сильвер был присутствующим. И на самом деле, ТС (ура!) помог мне._

Если вы ставите междометие после таких букв, разделите их **boi**. Без **boi**, междометия будут относиться к последней букве.

### Разные способы сказать «мы» в ложбане

В ложбане есть несколько местоимений, близких по значению к «мы»:

mi'o
: ты и я

mi'a
: мы без тебя

ma'a
: ты, я и другие

Так что, говоря, вам нужно быть внимательным к тому, какое значение «мы» вам нужно.

И наконец:

mi
: я или говорящие

**mi** также может означать _мы_! Lojban по умолчанию не делает различия между единственным и множественным числом. Так что, если несколько человек говорят вместе, **mi** (которое относится к одному или нескольким говорящим) вполне правильно для _мы_. На практике вы обычно найдете **mi** использованным таким образом, когда один человек предполагает говорить (или чаще писать) от имени других.

Некоторые примеры:

> **mi prami do**
> _Я люблю тебя._

<!-- -->

> **mi'a ba penmi do**
> _Мы встретим тебя._

<!-- -->

> **ma'a remna**
> _Мы все люди._

<!-- -->

> **mi djica le nu do cliva**
> _Мы хотим, чтобы ты ушел._

cliva
: $x_1$ уходит

### «**ri**» вместо ‘_he_’ и ‘_she_’

Ранее мы узнали о местоимении **ri**:

ri
: местоимение: относится к предыдущему аргументу, который только что завершился (пропускает стабильные местоимения, такие как **mi**, **do**, слова для _мы_)

> **mi catlu le nanmu .i ri melbi**
> _Я смотрю на мужчину. Он красивый._

melbi
: $x_1$ красивый / симпатичный / привлекательный для кого-то $x_2$

**ri** относится к предыдущему завершенному аргументу, использованному в тексте или речи:

> **la .alis. cu sipna bu'u le sledi'u pe la .alis.**
> _Алиса спит в своей комнате._
> `Алиса спит-в в комнате-Алисы.`

> **la .alis. cu sipna bu'u le sledi'u pe ri**
> _Алиса спит в своей комнате._
> `Алиса спит в комнате [предыдущего аргумента].`

sledi'u
: $x_1$ - комната для цели $x_2$ (предложение)

**ri** эквивалентно повторению последнего аргумента, который здесь является **la .alis.**.

Одним из аспектов, на который следует обратить внимание, является то, что **ri** не повторяет **le sledi'u pe ri** (который также является аргументом), потому что **ri** является частью этого аргумента и, следовательно, этот аргумент не является "предыдущим", не завершенным, когда появляется **ri**. Это предотвращает рекурсивное ссылание **ri** на самого себя.

Еще один пример:

> **le du'u le prenu cu melbi cu se djuno ri**
> _Что человек красивый, известно ей самой._

**ri** относится к **le prenu** (а не к **le du'u le prenu cu melbi**, хотя оба аргумента завершены: **le prenu** начинается последним, после начала **le du'u le prenu cu melbi**).

Отношение внутри форм **sei** образует параллельный текст. **ri** пропускает аргументы внутри отношений **sei**:

> **mi viska la .lukas. sei la .doris. pu cusku .i ri jibni la .micel.**
> _Я вижу Лукаса, — сказала Дорис. Он рядом с Мишель._

В этом примере **ri** не может относиться к **la .doris.** Мы просто пропускаем всю связь **sei la .doris. pu cusku**, когда решаем, к чему должно относиться **ri**.

Местоимения, которые остаются неизменными на протяжении диалога или истории, игнорируются **ri**. Мы просто повторяем их напрямую:

> **mi lumci mi**
> _Я моюсь._
> `Я мою себя`

lumci
: $x_1$ моет $x_2$

> **mi prami mi**
> _Я люблю себя._
> `Я люблю себя.`

Однако:

- местоимения **ti**, **ta**, **tu** заменяются на **ri**, потому что вы можете изменить то, на что указываете, поэтому повторение **tu** может быть неэффективным.
- аналогично, **ri** само по себе (или, скорее, его антецедент) может быть повторено позже **ri**. Фактически, последовательность слов **ri** без других промежуточных аргументов всегда будет повторять один и тот же аргумент:

 > **la .alis. cu catlu le nanmu .i ri melbi .i ri co'a zgana .a bu**
 > _Алиса замечает мужчину. Он красивый. Он замечает Алису._

zgana
: наблюдать

co'a zgana
: начать наблюдать, заметить

В этом примере второе **ri** имеет первое **ri** в качестве антецедента, которое, в свою очередь, имеет **le nanmu** в качестве антецедента. Все три относятся к одному и тому же: к мужчине.

В конечном итоге, вы решаете, что, где и когда использовать в речи: метод с **le** + отношение, метод с именами букв или с **ri**.

<!-- ### "_Myself, themselves_"

В славянских языках люди говорят буквально _I wash self_. Чтобы быть ближе к славянскому стилю, мы можем использовать **lo nei**.

>**mi nelci mi**
>_Мне нравлюсь я._

>`Мне нравлюсь я.`

Это то же самое по смыслу, что и:

>**mi nelci lo nei**
>_Мне нравлюсь я._

>**mi lumci mi**
>**mi lumci lo nei**
>_Я моюсь._

>**la ian ca lumci lo nei**
>**la ian ca lumci ri**
>_Ян моет себя._

**lo nei** ссылается на первое существительное текущего отношения.

Помните, что **ri** не может ссылаться на местоимения, такие как **mi**, поэтому в последнем примере может быть предпочтительно использовать **lo nei**. При изменении первого существительного **lo nei** не меняется, что довольно удобно:

>**mi lumci lo nei i do lumci lo nei i la ian cu lumci lo nei**
>_Я моюсь. Ты моешься. Ян моет себя._

>**la .doris. cu pensi lo nei**
>_Дорис думает о себе._

>**pa gerku cu batci lo nei**
>_Собака кусает себя._

---

**nei** хорошо работает, когда в предложении содержится только одно отношение. Но когда в нем есть несколько вложенных отношений, нам может понадобиться что-то другое. В

>**la .doris. cu djuno lo du'u la .alis. cu prami lo nei**
>_Дорис знает, что Алиса любит себя._

**lo nei** относится к **la .alis.**

Что если мы хотим ссылаться на Дорис? Вот решение:

>**la .doris. cu djuno lo du'u la .alis. cu prami vo'a**
>_Дорис знает, что Алиса любит ее._

Таким образом, в то время как **lo nei** относится к первому существительному текущего отношения, **vo'a** относится к первому существительному текущего предложения.

Когда нет вложенных отношений, эти два слова означают то же самое:

>**la .alis. cu prami vo'a** то же самое, что и **la .alis. cu prami lo nei**
>_Алиса любит себя._

- **vo'a** относится к первому существительному текущего предложения.
- **vo'e** относится ко второму существительному текущего предложения.
- **vo'i** относится к третьему существительному текущего предложения.
- **vo'o** относится к четвертому существительному текущего предложения.
- **vo'u** относится к пятому существительному текущего предложения.

---

**lo nei** может давать забавные результаты, когда применяется к взаимным действиям:

>**la .alis. e la .kevin. cu cinba lo nei**
>_Алиса целует себя, а Кевин целует себя._

Вот решение:

>**la .alis. jo'u la .kevin. cu cinba zu'ai**
>_Алиса и Кевин целуют друг друга._

Это означает то же самое, что и:

>**la alis cu cinba la kevin i je la kevin cu cinba la alis**
>_Алиса целует Кевина, а Кевин целует Алису._

**zu'ai** помещается на второе место глагола. Он показывает взаимное действие между первым местом и вторым местом. Участники этого взаимного действия помещаются на первое место и соединяются союзом **jo'u**. -->

### «**go'i**» для предыдущего отношения

> **la .alis. cu klama le barja .i la .alis. cu viska le nanmu**
> **la .alis. cu klama le barja .i le go'i cu viska le nanmu**
> _Алиса идет в бар. Она видит мужчину._

- **le go'i** относится к первому месту предыдущего отношения.
  - **go'i** представляет еще один способ ссылки на аргумент, который нам нужен.
- **le se go'i** относится ко второму месту предыдущего отношения.
- **le te go'i** относится к третьему месту и так далее.

Примеры:

> **.i la .alis. cu zgana le nanmu .i ri melbi**
> **.i la .alis. cu zgana le nanmu .i le se go'i cu melbi**
> _Алиса наблюдает за мужчиной. Он красивый._

Здесь **le se go'i** относится ко второму месту ($x_2$) предыдущего отношения, которым является **le nanmu**.

Ещё один пример:

> _Билл увидел Ника. Он ударил его._

В русском языке здесь нет точности — _он_ просто означает _какое-то мужское лицо, упомянутое где-то рядом в тексте или выведенное из контекста_. Мы не знаем, ударил ли Билл Боба или Боб ударил Билла. В ложбане мы можем сказать:

> **la .bil. pu viska la .nik. .i le se go'i cu darxi le go'i**
> _Билл увидел Ника. Ник ударил Билла._

Однако в большинстве случаев можно использовать **ri** или буквенные слова:

> **la .bil. cu viska la .nik. i ri darxi la .bil.**
> **la .bil. cu viska la .nik. i ny. darxi by.**
> _Билл увидел Ника. Ник ударил Билла._

**go'i** сам по себе является словом отношения и, следовательно, имеет структуру мест:

> **mi tatpi .i do ji'a go'i**
> _Я устал. И ты тоже._

Когда мы говорим **do go'i**, мы повторяем предыдущее отношение, но заменяем его первое место на **do**. Другими словами, **do ji'a go'i** здесь то же самое, что и сказать **do ji'a tatpi**.

<!-- ### Что копирует **go'i**?

Междометия, такие как **pei** (когда используется отдельно), **xu**, **.ui**, **.u'i**, **je'u** и те, которые образованы с помощью **sei**, а также вопросительное междометие, не являются частями отношений. Поэтому они не копируются с помощью **go'i**.

Термы, такие как **na ku**, **pu**, отрицатели слева, такие как **na'e**, **no'e**, **to'e**, являются частями отношений.

Таким образом, **go'i** копирует предыдущее отношение с этими частицами:

>— **la .bob. na ku prami la .alis.**
>— _**go'i**_

>— _It is not true that Bob loves Alice._

>— _ He doesn't (love)._

> **— la .bob. na'e prami la .alis.**
> _— Bob doesn't love Alice._

> **— go'i**
> _— He doesn't (love)._

Чтобы сказать "Нет, он действительно любит её", мы используем нужный глагол напрямую:

> **— la .bob. na ku prami la .alis.**
> _Bob doesn't love Alice._

> **— ja'a ku go'i**
> _Bob does love Alice._

Здесь **ja'a ku** заменяет **na ku** в исходном отношении. -->

### Время суток

> **— ma tcika ti**
> _Который час?_

<!-- -->

> **— li cacra bu pa pa**
> _Одиннадцать часов_

tcika
: $x_1$ (часы, минуты, секунды) — время события $x_2$

В ложбане время всегда является временем чего-то. Поэтому мы спрашиваем, какое время события **ti**, что означает _это событие/вещь_, или, другими словами, _сейчас_.

**li**, префикс для чисел, также используется для временных меток.

- **cacra bu** - префикс, указывающий на количество часов. В языке ложбан почти всегда используется 24-часовой формат времени.
- **mentu bu** - префикс, указывающий на количество минут.
- **snidu bu** - префикс, указывающий на количество секунд.

> **li cacra bu pa pa mentu bu pa no**
> _11:10 (Десять минут после одиннадцати)_

<!-- -->

> **li cacra bu pa pa mentu bu pa no snidu bu pa ci**
> _11 часов, 10 минут и 13 секунд._

<!-- -->

> **li cacra bu pa no mentu bu mu no**
> _10:50, десять минут до одиннадцати_

Если мы хотим указать время события, а не только сообщить время, заполняется второе место:

> **li cacra bu pa no tcika le nu mi klama**
> _Десять часов - это время, когда я прихожу._

Используя терм **de'i**, мы можем получить более естественное предложение:

> **mi klama de'i li cacra bu pa no**
> _Я прихожу в 10 часов._

de'i
: в … (время), в … (дата)

И один полезный пример:

> **ca tcika le nu .ei sipna**
> _Пора спать._

### Даты

> **— ma detri ti**
> _Какое сегодня число?_

> **— li mastu bu ze djedi bu pa**
> _1 июля._

detri
: $x_1$ (год, месяц, день) - дата/время события $x_2$

Другой вариант:

> **— ma ca detri**
> _— Какая сейчас дата?_

- **nanca bu** - префикс, указывающий на год.
- **masti bu** - префикс, указывающий на месяц.
- **jefydei bu** - префикс, указывающий на день недели.
- **djedi bu** - префикс, указывающий на день.

Префиксы с числами после них могут использоваться в любом порядке (давайте использовать цифры для обозначения чисел):

> **li djedi bu 2 ca detri**
> _Сегодня второе число месяца._

<!-- -->

> **li masti bu 4 djedi bu 1 ca detri**
> _Сейчас апрель, первое число._

<!-- -->

> **li djedi bu 5 masti bu 7 nanca bu 2005 detri le nu mi jbena**
> _Пятого июля (седьмой месяц), 2005 год - это когда я родился._

jbena
: $x_1$ рождается

Мы также можем использовать **de'i**:

> **mi ba klama de'i li masti bu pano**
> _Я приду в октябре._

В ложбане частицы могут быть написаны без пробелов между ними, как в этом **pano**, что эквивалентно **pa no**.

Для дней недели обычно понедельник является первым днем:

> **mi gunka de'i li jefydei bu pa**
> _Я работаю в понедельник._

<!-- -->

> **mi gunka ca ro se detri be li jefydei bu re**
> _Я работаю каждый вторник._

<!-- -->

> **xu do pu zvati la .paris. de'i li jefydei bu ci**
> _Ты был в Париже в среду?_

### Указание временных интервалов

> **mi nanca li re re**
> _Мне 22 года._

nanca
: $x_1$ длится $x_2$ (число) лет

**nanca** указывает продолжительность, и чтобы сказать _двухлетний_, заполни второе место числом, предваренным **li**.

> **le verba cu masti li re**
> _Ребенку два месяца._

masti
: $x_1$ длится $x_2$ месяцев

> **le nu carvi cu djedi li ci**
> _Идет дождь три дня._

djedi
: $x_1$ (событие) длится $x_2$ (число) полных дней

### Новые глаголы из одной шкалы: «_кроме_» — «**na'e**», «_анти-_» — «**to'e**»

> **mi na'e nelci do**
> _Я не люблю тебя._

"Левые скалярные" частицы (к которым относится **na'e**) располагаются слева от конструкций, которые они затрагивают, образуя шкалу:

Сама шкала может быть указана с помощью модального тега **ci'u**.

- **je'a** = _действительно (утвердительная позиция на шкале)_. Слово **je'a** подтверждает значение части предложения. Обычно оно просто опускается.

 > **mi je'a nelci do**
 > _Я действительно люблю тебя._

- **na'e** = _не (кроме утвердительной позиции на шкале)_

 > **mi na'e nelci do**
 > _Я не люблю тебя._

 > **le stizu cu na'e xunre be ci'u le ka skari**
 > _Стул имеет не-красный цвет._
 > `Стул отличается от красного на шкале наличия цвета`

- **no'e** = _не совсем (середина шкалы)_. Слово **no'e** придает части предложения среднее значение.

 > **mi no'e nelci do**
 > _Что касается того, люблю ли я или ненавижу тебя, я к тебе безразличен. Я ни люблю, ни ненавижу тебя._

- **to'e** = _анти-, дез-, неправильно и т. д. (противоположная позиция на шкале)_. Слово **to'e** придает части предложения противоположное значение. Оно похоже на русский префикс _анти-_.

 > **mi to'e nelci do**
 > _Я ненавижу тебя._
 > `Я анти-люблю тебя`

**na'e** более неопределенное, чем **no'e** и **to'e**; оно может означать любое из них, когда вам не важен точный смысл.

### Сложные модальные термы: «_потому что_» — «**ki'u**», «_несмотря на_» — «**to'e ki'u nai**»

Модальные термы могут быть отрицательными двумя способами, чтобы получить связанные значения.

ki'u
: модальный терм: потому что, из-за объяснения …, что можно объяснить фактом, что …

> **ki'u ma do cusku zo co'o**
> _Почему ты говоришь прощай?_

Добавление суффикса **nai** меняет значение:

ki'u nai
: модальный терм: не потому что, что нельзя объяснить фактом, что …

> **mi se nabmi ki'u nai le nu mi laldo ce'e ki'u le nu mi na certu**
> _У меня проблемы не потому что я старый, а потому что я не эксперт._

nabmi
: $x_1$ - проблема для $x_2$

se nabmi
: $x_1$ имеет проблему $x_2$

laldo
: $x_1$ - старый …

certu
: $x_1$ - эксперт, профессионал в свойстве $x_2$

Добавление **to'e** устанавливает отрицание значения:

to'e ki'u
: потому что не, что можно объяснить фактом, что это не происходит …

> **mi jinga to'e ki'u le nu mi pu surla**
> _Я выиграл, потому что я не отдыхал._

Комбинируя **to'e** и **nai**, мы получаем:

to'e ki'u nai
: несмотря на причину …, не потому что не, что нельзя объяснить фактом, что это не происходит …

> **.i to'e ki'u nai le nu le mamta cu sanga su'o melbi kei le verba na snada lo ka sipna**
> _Несмотря на то, что мама поет красиво, ребенок не может заснуть._

Использование **se** меняет порядок аргументов. В остальном значение сохраняется.

se ki'u
: следовательно, что объясняет факт, что …

> **ra bilma se ki'u le nu ra na pu cusku zo coi do**
> _Он болен, что объясняет, почему он не поздоровался с тобой._

se ki'u nai
: но это не означает, что …, что не объясняет факт, что …

> **ra bilma se ki'u nai le nu ra klama le drata tcadu**
> _Он болен, что не объясняет, почему он едет в другой город._

se to'e ki'u
: …, отсутствие которого объясняет факт, что …

> **ra bilma se to'e ki'u le nu ra klama le drata tcadu**
> _Он не болен, и это объясняет, почему он едет в другой город._

se to'e ki'u nai
: …, отсутствие которого не объясняет тот факт, что …

> **ra bilma se to'e ki'u nai le nu ra penmi le mikce**
> _Он не болен, и это не объясняет, почему он встречается с врачом._

mikce
: $x_1$ - врач