## Урок 5. Модальные термы, «**да**», их относительное положение

### Как модальные термы относятся к связи?

Некоторые модальные термы, такие как те, которые описывают время (временную форму), связывают текущую связь с той, которая следует после них в аргументе:

> **mi cadzu ca le nu le cipni cu vofli**
> _Я иду, когда птицы летят._

cadzu
: … идет

le cipni
: птица/птицы

vofli
: … летит к …

> **mi pu cadzu fa'a le rirxe**
> _Я шел к реке._

<!-- -->

> **mi pu cadzu se ka'a le rirxe**
> _Я шел к реке._

se ka'a
: приближаясь к …

fa'a
: прямо к …

Модальные термы не удаляют упорядоченные места (**fa**, **fe**, **fi**, **fo**, **fu**) из связи:

> **mi klama se ka'a le rirxe le dinju**
> **mi klama fe le rirxe .e le dinju**
> _Я иду к реке, к дому._

В первом примере **se ka'a** связывает **le rirxe**, а затем следует второе место **klama**, заполняемое **le dinju**. Это то же самое, что просто заполнить второе место **klama** дважды, связывая их с помощью **.e** — _и_.

Однако **se ka'a** полезен, когда применяется к другим связям, например, к **cadzu** в предыдущем примере.

> **le prenu pu cadzu tai le nu ri bevri su'o da poi tilju**
> _Человек шел, будто нес что-то тяжелое._

bevri
: $x_1$ несет $x_2$

tai
: модальный терм: как …, похожий на …

<!--
- Некоторые термины описывают отношения первого места связи с существительным после термина:

>**mi jinga se rai le ka clani**
>_Я побеждаю, будучи самым высоким._

se rai
: термин от **se traji**: быть наиболее …

Здесь $x_1$ связи соответствует наиболее высокому в сравнении, указанному после **se rai**.

- Наконец, некоторые термины описывают отношения первого места связи и самой связи с существительным после термина:

>**le fragari cu se nelci mi te rai le'i jbari**
>_Из ягод мне больше всего нравятся клубника._

te rai
: термин от **te traji**: предпочитая из …

lo fragari
: клубника

lo jbari
: ягоды

$x_1$ связи описывает наиболее предпочтительное в этом сравнении, сама связь описывает сравнение.

Словарь объясняет такие хитрые случаи, когда отношение, определенное термином, может вызывать затруднения. На практике, отношение часто ясно из приведенных примеров. -->

### Использование «**ne**» + терм. «**se mau**» — ‘_больше, чем …_’

**mi ne se mau do cu melbi**
_Я красивее тебя._

se mau
: частица от **se zmadu**: больше, чем; само отношение описывает сравнение

Этот пример похож на

> **mi zmadu do le ka melbi**
> _Я превосхожу тебя в красоте._

Другими словами, основное отношение **melbi** похоже на третье место **zmadu**, которое указывает критерии сравнения. Еще два примера:

> **mi prami do ne se mau la .doris.**
> _Я люблю тебя больше, чем Дорис._

<!-- -->

> **mi ne se mau la .doris. cu prami do**
> _Я люблю тебя больше, чем Дорис._
> _Я люблю тебя больше, чем Дорис любит тебя._
> `Я (больше, чем Дорис) люблю тебя.`

Дополнительные примеры:

> **mi nelci le'e pesxu ne se mau le'e jisra**
> _Мне нравится варенье больше, чем сок._

песху
: … это варенье

> **le'e pesxu cu zmadu le'e jisra le ka mi nelci**
> _Мне нравится варенье больше, чем сок._
> `Варенье превосходит сок в том, насколько я его люблю.`

И теперь интересное предложение:

> _Боб любит Бетти больше, чем Мэри._

В русском языке это может иметь два разных значения!

1. Боб любит Бетти, а Мэри он любит меньше.
2. Боб любит Бетти, но Мэри тоже любит Бетти, хотя не так сильно, как Боб!

Мы сравниваем Бетти с Мэри в том, как Боб их любит?

Или, на самом деле, мы сравниваем Боба с Мэри в том, как они любят Бетти?

Русский язык в этом отношении неоднозначен.

В ложбане мы можем различить два значения, добавив **се мау** к соответствующим аргументам:

> **la .bob. ne se mau la .maris. cu nelci la .betis.**
> _Боб (по сравнению с Мэри) любит Бетти больше. Мэри любит Бетти меньше._
> _Боб любит Бетти больше, чем Мэри._

<!-- -->

> **la .bob. cu nelci la .betis. ne se mau la .maris.**
> _Боб любит Бетти, и он любит Мэри меньше._
> _Боб любит Бетти больше, чем Мэри._

### Сравнения: ‘_равный_’, ‘_такой же_’

> **mi dunli le mensi be mi le ka mitre .i ku'i mi na ku du le mensi**
> *Я такой же большой, как моя сестра, но я не она.*
> _Я равен моей сестре в метрах, но я не идентичен ей._

dunli
: $x_1$ (любой тип) равен $x_2$ (любой тип) в свойстве $x_3$ (свойство $x_1$ и $x_2$ с **kau**)

mitre
: $x_1$ имеет длину $x_2$ метров

du
: $x_1$ (любой тип) идентичен $x_2$ (любой тип)

**dunli** сравнивает два места по одному свойству, в то время как **du** сравнивает по идентичности. Моя сестра и я одинаковой высоты, но мы не один и тот же человек. Кларк Кент и Супермен имеют разных поклонников, но они один и тот же человек.

То же самое относится к этим двум глаголам:

> **Мы отличаемся друг от друга в том, что нам нравится.**
> _Я отличаюсь от тебя в том, что мне нравится._

<!-- -->

> **le drata be mi cu kakne le ka sidju**
> *Кто-то, кто не я, может помочь.*

frica
: $x_1$ (любой тип) отличается от $x_2$ (любой тип) в свойстве $x_3$ (свойство $x_1$ и $x_2$ с **kau**)

drata
: $x_1$ (любой тип) не является тем же самым, что и $x_2$ (любой тип)

### Понятие «только»

> **mi .e no le pendo be mi cu nelci le'e badna**
> _Я и ни один из моих друзей не любим бананы._
> _Среди моих друзей только я люблю бананы._

Понятие «не только» выражается аналогично:

> **mi .e le su'o pendo be mi cu nelci le'e badna**
> _Среди моих друзей не только я люблю бананы._
> _Я и некоторые из моих друзей любим бананы._

<!-- Более точное выражение:

> **mi se steci le ka nelci le'e badna kei le'i pendo be mi**
> _Среди моих друзей только я люблю бананы._ (кстати, предполагается, что вы являетесь другом для себя)

se steci
: $x_1$ является единственным в $x_2$ (свойство $x_1$) среди $x_3$ (множество) -->

<!-- Обратите внимание, что это пример предполагает, что вы являетесь другом для себя :) В противном случае, пожалуйста, используйте еще более точное утверждение:

> **mi se steci le ka nelci le'e badna kei le'i me mi .e le pendo be mi**
> _Среди множества меня и моих друзей только я люблю бананы._ -->

<!-- Отрицая это, мы получаем:

> **na ku mi se steci le ka nelci le'e badna**
> _Не верно, что только я люблю бананы._

— возможно, никому не нравятся бананы, возможно, мне + другим нравятся. -->

<!-- Еще один интересный пример:

> **le'e troci cu se steci le ka snada**
> _Только тот, кто пытается, достигает успеха._
> `Тот, кто пытается, является единственным, кто достигает успеха.`

> **le'e po'o zukte be le ka troci cu fliba**
> _Тот, кто только пытается, терпит неудачу._
> `Тот, кто делает попытки и ничего, кроме этого, терпит неудачу.`

troci
: $x_1$ пытается сделать $x_2$ (свойство $x_1$)

snada
: $x_1$ успешно делает $x_2$ (свойство $x_1$)

fliba
: $x_1$ неудачно делает $x_2$ (свойство $x_1$)

И еще одно решение:

> **ro snada pu troci**
> _Каждый, кто успешен, пытался._

ro
: число: каждый, каждая

Как видите, в Ложбане есть разные способы выражения одного и того же, некоторые из которых могут значительно отличаться от английских форм. -->

### «_Большинство_», «_много_» и «_слишком много_»

Слова, такие как _most_ и _many_, также являются числами в Ложбане:

<table>
<tbody><tr>
<td><b>ro</b>
</td>
<td><i>каждый</i>
</td></tr>
<tr>
<td><b>so'a</b>
</td>
<td><i>почти все</i>
</td></tr>
<tr>
<td><b>so'e</b>
</td>
<td><i>большинство</i>
</td></tr>
<tr>
<td><b>so'i</b>
</td>
<td><i>много</i>, <i>множество</i>
</td></tr>
<tr>
<td><b>so'o</b>
</td>
<td><i>несколько</i>
</td></tr>
<tr>
<td><b>so'u</b>
</td>
<td><i>немного</i>
</td></tr>
<tr>
<td><b>no</b>
</td>
<td><i>ноль</i>, <i>ничего</i>
</td></tr>
<tr>
<td><b>su'e</b>
</td>
<td><i>максимум</i>
</td></tr>
<tr>
<td><b>su'o</b>
</td>
<td><i>минимум</i>
</td></tr>
<tr>
<td><b>za'u</b>
</td>
<td><i>больше, чем …</i>
</td></tr>
<tr>
<td><b>du'e</b>
</td>
<td><i>слишком много</i>
</td></tr></tbody></table>

Некоторые примеры:

> **su'e re no le prenu ba klama**
> _Не более 20 человек придут._

<!-- -->

> **su'o pa le prenu cu prami do**
> _По крайней мере один человек любит тебя._

### «_никогда_» — «**no roi**», «_всегда_» — «**ro roi**»

Термины, указывающие количество раз:

- **no roi** = _никогда_
- **pa roi** = _один раз_
- **re roi** = _два раза_
- **ci roi** = _три раза_

…

- **so'i roi** = _много раз_
- **so'u roi** = _несколько раз_
- **du'e roi** = _слишком много раз_
- **ro roi** = _всегда_

> **mi du'e roi klama le zarci**
> _Я слишком часто хожу на рынок._

zarci
: $x_1$ является рынком

> **mi pu re roi klama le zarci**
> _Я ходил на рынок дважды._

Без **pu**, конструкция **re roi** может означать, что я ходил на рынок один раз, но второй раз это произойдет только в будущем. Эти временные частицы могут использоваться с аргументом после них.

> **mi klama ti pa roi le jeftu**
> _Я прихожу сюда раз в неделю._

### «**pa re'u**» — «_в первый раз_», «**ro re'u**» — «_в последний раз_»

- **pa re'u** = _в первый раз_
- **re re'u** = _во второй раз_

…

- **za'u re'u** = _снова_
- **ro re'u** = _в последний раз_

Частица, связанная со временем, **re'u** работает как **roi**, но указывает на количество повторений, с которыми происходит событие.

Сравните:

> **mi pa roi klama le muzga**
> _Я посетил музей один раз._

<!-- -->

> **mi pa re'u klama le muzga**
> _Я посетил музей в первый раз._

<!-- -->

> **mi za'u roi klama le muzga**
> _Я посетил музей несколько раз._

<!-- -->

> **mi za'u re'u klama le muzga**
> _Я снова посетил музей._

<!-- -->

> **mi za'u pa roi klama le muzga**
> _Я посетил музей более одного раза._

<!-- -->

> **mi za'u pa re'u klama le muzga**
> _Я посетил музей не в первый раз (может быть, во второй/третий и т. д.)._

vitke
: посещать (кого-то или что-то)

Обратите внимание на разницу между:

za'u re'u
: снова, не в первый раз

re re'u
: во второй раз (здесь также не требуется контекст, и даже указывается точное количество раз)

### Модальные частицы: их расположение внутри отношения

> **le nu tcidu kei ca cu nandu**
> _Чтение сейчас трудно._

<!-- -->

> **ca ku le nu tcidu cu nandu**
> _Сейчас чтение трудно._

Голые термы без аргументов после них могут перемещаться по предложению, добавив после них **ku**.

**ku** предотвращает присоединение следующих аргументов к таким терминам. Сравните:

> **ca le nu tcidu cu nandu**
> _Когда читаешь, это трудно._

Вот несколько мест, где могут находиться модальные частицы.

- Модальный терм модифицирует отношение справа от него:

 >**ca ku mi citka**
 >_Сейчас я ем._

  — здесь терм помечен словом **ku** как завершенный.

 >**ca le cabdei mi citka**
 >_Сегодня я ем._

  — здесь после термина следует аргумент.

 >**mi ca citka**
 >_Я сейчас ем._

  — здесь модальная частица является частью основной конструкции отношения и не имеет аргумента.

- Модальный терм применяется к целому отношению:

 >**mi citka ca**
 >_Я ем сейчас._

  — здесь модальный терм в конце отношения.

### Объединение утверждений с модальными термами

> **mi pinxe le jisra ca le nu do co'i klama le zdani**
> _Я пью сок, когда ты приходишь домой._

<!-- -->

> **mi pinxe le jisra .i ca bo do co'i klama le zdani**
> _Я пью сок, и в то же время ты приходишь домой._

Оба примера передают одно и то же значение. Второй вариант чаще используется, когда любое из исходных отношений звучит громоздко.

Еще одно использование — перемещение модальных термов за пределы других модальных термов:

> **mi na ku te vecnu ki'u le nu kargu**
> _Не правда, что я покупаю, потому что это дорого._

В этом примере можно предположить, что я покупаю только то, что дорого. Однако это не так.

Здесь **na ku** отрицает, что _я покупаю вещи, потому что они дорогие_. **na ku** применяется ко всему отношению, поэтому оно "покрывает" **ki'u**.

> **mi na ku te vecnu .i ki'u bo kargu**
> _Я не покупаю. Это потому что дорого._

В этом случае я не покупаю вещи. Почему? Потому что они дорогие. Может быть, я предпочитаю только дешевые вещи.

Здесь **ki'u** находится в другом предложении. Таким образом, **na ku** не распространяется на него.

Оба примера можно перевести как _Я не покупаю, потому что это дорого._ Однако они имеют разное значение.

Существует особое правило для использования **.i ba bo** и **.i pu bo**. Сравните:

> **mi cadzu pu le nu mi citka**
> _Я иду перед тем, как есть._

<!-- -->

> **mi cadzu .i ba bo mi citka**
> _Я иду, а затем ем._

**.i ba bo** означает _после этого, затем_. Предложение после **.i ba bo** относится к чему-то, что произошло позже, чем то, что произошло в отношении до этого.

**pu** заменяется на **ba**, и наоборот. Это особое правило для ложбана было создано по аналогии с естественными языками. Так что вам просто нужно запомнить это особое поведение этих двух слов.

### Существующие вещи, «_есть ..._»

На самом деле есть три слова в серии **da**: **da**, **de** и **di**. Мы используем их, когда обращаемся к разным объектам в одном дискурсе:

> **ci le mlatu cu citka re le finpe**
> _Есть три кошки, для каждой кошки есть две рыбы, и каждая кошка съедает две рыбы._

Если вам нужно больше таких слов в одном тексте, добавьте суффикс **xi** к ним, а затем любое число (которое мы можем назвать индексом). Таким образом,

- **da xi pa** то же самое, что и просто **da**,
- **da xi re** то же самое, что и **de**,
- **da xi ci** то же самое, что и **di**
- **da xi vo** - четвертый "что-то" и так далее...

### Тема и комментарий. «**zo'u**»

Иногда полезно показать тему отношения, а затем сказать комментарий о ней:

> **le'e finpe zo'u mi nelci le'e salmone**
> _Что касается рыбы, мне нравится лосось._

salmone
: ...это лосось

zo'u
: завершает тему и начинает комментарий отношения

**zo'u** более полезно, когда местоимение, такое как **da**, определено в теме, а затем используется в комментарии:

> **su'o da zo'u mi viska da**
> _Существует такая вещь, что я вижу ее._

<!-- -->

> **ro da poi gerku zo'u mi nelci da**
> _Для каждой вещи, которая является собакой: я ее люблю._
> _Мне нравятся все собаки._

<!-- -->

> **da de zo'u da viska de**
> _Существуют **da** и **de**, такие что **da** видит **de**._

Два местоимения **da** и **de** указывают на то, что есть две вещи, которые находятся в отношении, что одна видит другую. Может быть так, что предполагаемые две вещи на самом деле являются одной и той же вещью, которая любит сама себя: ничто в предложении не исключает такую интерпретацию, поэтому разговорный перевод не говорит _Кто-то видит кого-то другого._ Вещи, на которые указывают разные местоимения из серии **da**, могут быть разными или одними и теми же.

Совершенно нормально, если эти местоимения появляются более одного раза в одном предложении:

> **da zo'u da prami da**
> _Существует **da**, такой что **da** любит **da**. Есть кто-то, кто любит себя._

Не обязательно, чтобы местоимение было прямым аргументом отношения:

> **da zo'u le gerku pe da cu viska mi**
> _Существует **da**, такой что собака из них видит меня. Собака кого-то видит меня._

### «_любой_» и «_некоторый_» в примерах

Слова _любой_ и _некоторый_, а также их производные, имеют много значений в русском языке. Мы должны быть внимательны при переводе предполагаемого значения:

Перевод на русский язык:

- _кто-то/что-то_: что-то неопределенное:

 >**da pu klama .i je ko smadi le du'u da me ma kau**
 >_Кто-то пришел. Угадай, кто это был._

  <!-- -->

 >**mi pu tirna da .i je mi fliba le ka jimpe le du'u da mo kau**
 >_Я что-то слышал, но не понимаю, что это было._

- _кто-то/что-то_ в вопросах:

 >**xu su'o da pu klama**
 >_Кто-то пришел?_

- _кто-нибудь/что-нибудь_ используется в командах, просьбах или предложениях:

 >**.e'u mi'o pilno su'o da poi drata**
 >_Давайте попробуем что-нибудь другое. Давайте попробуем другие вещи._

  <!-- -->

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Давайте попробуем где-нибудь еще._

- _кто-либо/что-либо_ и подобные слова могут использоваться во внутренних отношениях:

 >**mi rivbi le ka jdice da**
 >_Я избегал принятия какого-либо решения._

 Как в отношениях внутри модальных термов:

 >**ba le nu do zgana da kei ko klama**
 >_После того, как ты заметишь что-нибудь, приходи!_

- Область видимости: _никто/ничто_ используется в русском языке при отрицании, в то время как в ложбане используется **na ku**, но всё равно с ним **da**:

 >**mi na ku viska su'o da poi prenu**
 >_Я никого не вижу._

- _никто/ничто_ и подобные слова используются, когда нет различий среди обсуждаемых членов:

 >**.au nai mi tavla su'o da poi na ku slabu mi**
 >_Я не хочу разговаривать ни с кем._

- Область видимости: отрицание следует использовать в соответствующем отношении, как показано ниже:

 >**mi jinvi le du'u na ku da jimpe**
 >_Я думаю, что нет никого, кто понимает._

 Это можно перефразировать следующим образом:

 >**mi jinvi le du'u no da jimpe**
 >_Я думаю, что никто не понимает._

- В сравнениях _каждый_ переводится как **ro da**:

 >**do zmadu ro da le ka se canlu**
 >_Ты выше всех._
 >`Ты превосходишь каждого по размеру.`

- При предоставлении выбора используется **ro da**:

 >**ro da poi do nelci zo'u .e'a do citka da**
 >_Ты можешь есть всё, что тебе нравится._
 >`Для всего, что тебе нравится, я разрешаю тебе это есть.`

- Для термов, таких как _кто-нибудь/где-нибудь/что-нибудь:

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Давайте попробуем где-нибудь еще._

Здесь, **su'o da poi drata** означает _любая другая вещь или место_. Количество таких мест не указано, хотя любое из них может подойти.

Чтобы сказать _любое место, но только одно место_, используйте:

> **.e'u mi'o troci bu'u pa da poi drata**
> _Давай попробуем в другом месте._

- Переводим _любой_ как **le'e** в общих высказываниях:

> **le'e gerku cu se tuple le vo da**
> _У любой собаки четыре ноги. От собак ожидаются четыре ноги._

- Используем **le** при описании конкретных объектов, мест или событий:

> **le drata zo'u .e'u mi'o pilno ri**
> _Другая вещь, давай использовать её._

> **le drata stuzi zo'u .e'u mi'o troci bu'u ri**
> _Другое место, давай попробуем там._

### Резюме: на какие конструкции влияет область видимости?

Область видимости создается только:

- границами отношений,
- модальными термами и модальными частицами основной конструкции отношения,
- аргументами, начинающимися с чисел (например, **pa le prenu** — _один из людей_).
<!-- - дискурсивными междометиями **po'o**, **ji'a**. -->

**da**, **de**, **di**, если используются без префикса и без явного числа впереди, предполагаются как **su'o da**, **su'o de**, **su'o di** и также создают область видимости.

Таким образом, относительный порядок таких конструкций меняет значение:

> **pa le prenu ca ku zvati**
> _Есть один человек, который сейчас присутствует._

> **ca ku pa le prenu ca zvati**
> _Сейчас есть один человек._

Область видимости не имеет значения для конструкций отношений и для аргументов, начинающихся с **le** (например, **le prenu** или **le re prenu**). Оба эти предложения имеют одно и то же значение:

> **le prenu ca ku zvati le zdani**
> **ca ku le prenu cu zvati le zdani**
> **ca ku fe le zdani fa le prenu cu zvati**
> _Люди сейчас присутствуют._

Область видимости модального терма распространяется от его использования до правой границы отношения и всех его внутренних отношений (если они есть).

Здесь, **ki'u le nu kargu** находится под областью видимости **na ku**:

> **na ku mi te vecnu ki'u le nu kargu**
> _Не правда, что: Я покупаю, потому что это дорого._

Но здесь **ki'u le ne kargu** не находится под областью видимости **na ku**. **ki'u** применяется ко всему предыдущему предложению, включая **na ku**:

> **mi na ku te vecnu .i ki'u bo kargu**
> _Я не покупаю. Это потому что это дорого._
