## Урок 4. Практика

Теперь мы знаем самые важные части грамматики и можем начать накапливать новые слова через ситуации.

### Разговорные выражения

Вот некоторые общие структуры, используемые свободно говорящими на ложбане, вместе с примерами, иллюстрирующими их использование.

Они могут помочь вам быстрее привыкнуть к разговорному ложбану.

- <dl><dt>.i ku'i</dt><dd>Но…</dd></dl>
 > **mi djuno .i ku'i mi na ku djica**
 > _Я знаю. Но я не хочу._
- <dl><dt>mi djica le nu</dt><dd>Я хочу, чтобы …</dd></dl>

 > **mi djica le nu mi sipna**
 > _Я хочу спать._
 > `Я хочу, чтобы я спал.`
- <dl><dt>mi djuno le du'u ma kau</dt><dd>Я знаю, что/кто …</dd></dl>

 > **mi djuno le du'u ma kau smuni zo coi**
 > _Я знаю, что означает **coi**._

 <!-- -->

 > **mi na ku djuno**
 > _Я не знаю._
- <dl><dt>jinvi le du'u</dt><dd>… имеет мнение, что …</dd></dl>

 > **mi jinvi le du'u la .lojban. cu zabna**
 > _Я думаю, что ложбан крутой._

 <!-- -->

 > **coi ro do**
 > _Привет всем!_

 <!-- -->

 > **co'o ro do**
 > _Пока всем!_
- <dl><dt>jinvi le du'u</dt><dd>… имеет мнение, что …</dd></dl>

 > **ai mi cliva .i co'o**
 > _Я собираюсь уйти. Пока!_
- <dl><dt>.ei mi</dt><dd>Я должен …</dd></dl>

 > **.ei mi citka .i co'o**
 > _Я должен поесть. Пока!_
- <dl><dt>ca le nu</dt><dd>когда …</dd></dl>

 > **mi pu bebna ca le nu mi citno**
 > _Я был глупым, когда был молодым._
- <dl><dt>va'o le nu</dt><dd>при условии, что …</dd></dl>

 > **va'o le nu do djica kei mi ka'e ciksi**
 > _Если хочешь, я могу объяснить._
- <dl><dt>simlu le ka</dt><dd>… кажется быть …</dd></dl>

 > **simlu le ka zabna**
 > _Кажется, что это круто._
- <dl><dt>ca le cabdei</dt><dd>сегодня</dd></dl>

 > **pu ce'e ca le cabdei mi surla**
 > _Сегодня я отдыхал._
- <dl><dt>mi nelci</dt><dd>Мне нравится</dd></dl>

 > **mi nelci le mlatu**
 > _Мне нравится кошка._
- <dl><dt>le nu pilno</dt><dd>используя …</dd></dl>

 > **na ku le nu pilno le vlaste cu nandu**
 > _Использование словарей не сложно._
- <dl><dt>kakne le ka</dt><dd>способен на …</dd></dl>

> **xu do kakne le ka sutra tavla**
> _Ты можешь говорить быстро?_
>
- <dl><dt>tavla fi</dt><dd>говорить о ...</dd></dl>

> **.e'ei tavla fi le skami**
> _Давай поговорим о компьютерах!_
>
- <dl><dt>mutce le ka</dt><dd>очень ...</dd></dl>

> **mi mutce le ka se cinri**
> _Мне очень интересно._
>
- <dl><dt>troci le ka</dt><dd>... пытается ...</dd></dl>

> **mi troci le ka tavla fo la .lojban.**
> _Я пытаюсь говорить на ложбане._
>
- <dl><dt>rinka le nu</dt><dd>(событие) приводит к ...</dd></dl>

> **le nu mi tadni la .lojban. cu rinka le nu mi jimpe fi do**
> _То, что я изучаю ложбан, позволяет мне понимать тебя._
>
- <dl><dt>gasnu le nu</dt><dd>(агент) вызывает ...</dd></dl>

> **mi pu gasnu le nu le skami pe mi co'a spofu**
> _Я сделал так, чтобы мой компьютер сломался._
>
- <dl><dt>xusra le du'u</dt><dd>утверждать, что ...</dd></dl>

> **xu do xusra le du'u mi na ku drani**
> _Ты утверждаешь, что я не прав?_
>
- <dl><dt>kanpe le du'u</dt><dd>ожидать (в смысле оценки, предсказания), что ...</dd></dl>

<!-- -->

> **mi na ku kanpe le du'u mi jinga**
> _Я не ожидаю, что победю._

### Простой диалог

> **coi la .alis.**
> _Привет, Алиса!_
<!-- -->
> **coi la .doris.**
> _Привет, Дорис!_
<!-- -->
> **do mo**
> _Как дела?_
<!-- -->
> **mi kanro .i mi ca tadni la .lojban. .i mi troci le ka tavla do**
> _У меня все хорошо. Я сейчас изучаю ложбан. Я пытаюсь с тобой поговорить._

kanro
: быть здоровым

tadni
: изучать ... (что-то)

troci
: пытаться ... (сделать что-то)

tavla
: говорить [с кем-то]

> **zabna .i ma tcima ca le bavlamdei**
> _Хорошо. Какая будет погода завтра?_

zabna
: ... хорошо, приятно

tcima
: ... погода

ca
: в (какое-то время)

le bavlamdei
: завтра (день как событие)

> **mi na ku djuno .i le solri sei mi pacna**
> _Я не знаю. Будет солнечно, надеюсь._

djuno
: знать (факт)

le solri
: солнце

Обратите внимание, что **le solri cu tcima** (буквально _солнце - это погода_) - это способ использования **tcima** на Ложбане.

sei
: начало комментария

pacna
: надеяться (на какое-то событие)

> **mi jimpe**
> _Я понимаю._

> **co'o**
> _До свидания._

### Человеческие ощущения

> **ju'i la .alis.**
> _Привет, Алиса!_

ju'i
: обращение, привлекающее внимание: _Эй! Пс-с-с! Ага! Внимание!_

> **re'i**
> _Слушаю._

re'i
: обращение: _Я готов получить информацию._

> **xu do viska ta**
> _Ты видишь то, что рядом с тобой?_

----

Отношения, описывающие восприятие, будут объяснены после диалога.

> **viska .i plise**
> **.i le plise cu xunre .i skari le ka xunre**
> _Да. Это яблоко._
> _Яблоко красное. Оно окрашено в красный цвет._

> **xu do viska le tarmi be le plise**
> _Ты видишь форму яблока?_

<!-- -->

> **viska .i le plise cu barda**
> _Да. Яблоко большое._

<!-- -->

> **xu do jinvi le du'u le plise ca makcu**
> _Ты думаешь, что яблоко спелое?_

makcu
: ...спелое

> **.au mi zgana le sefta be le plise**
> _Я бы хотел ощупать его._

> **.i ua xutla**
> _О, оно гладкое._

> **.i mi pacna le nu makcu ie**
> _Я надеюсь, что оно спелое, да._

<!-- -->

> **panci pei**
> _А как насчет запаха?_

> **.i .e'o do sumne le plise**
> _Пожалуйста, понюхай его._

<!-- -->

> **le xrula cu panci**
> _Он пахнет цветами._

> **.i .au mi zgana le vrusi be le plise**
> _Я бы хотел попробовать яблоко._

> **.i .oi nai le kukte cu vrusi**
> _Ммм, оно сладкое._

> **.i .oi**
> _Ой-ой._

le xrula
: цветок(и)

<pixra url="/assets/pixra/cilre/xrula.webp" caption="xrula" definition="цветок"></pixra>

> **ma pu fasnu**
> _Что случилось?_

<!-- -->

> **mi pu farlu**
> _Я упала._

farlu
: ... падает в ...

<!-- -->

> **xu do cortu**
> _У тебя что-нибудь болит?_

<!-- -->

> **cortu .i mi cortu le cidni**
> _Да, у меня болит колено._

> **.i na ku ckape**
> _Это не опасно._

> **.i ca ti mi ganse le nu da vi zvati**
> _И сейчас я чувствую присутствие кого-то здесь._

<!-- -->

> **doi la .alis. do cliva .e'o sai**
> _Алиса, пожалуйста, вернись немедленно!_

<!-- -->

> **ko denpa .i mi ca tirna le sance**
> _Подожди, я слышу какой-то звук._

<!-- -->

> **le sance be ma**
> _Звук чего?_

<!-- -->

> **mi pu tirna le nu le prenu cu tavla**
> _Я слышала, как человек говорит._

> **.i ca ti mi zgana le lenku**
> _Теперь мне холодно._

<!-- -->

> **ju'i la .alis.**
> _Эй, Алиса!.._

В этом диалоге были затронуты самые важные концепции для человеческих чувств. В следующих разделах мы объясним их структуры местоимений, а также дополнительные отношения и примеры.

#### Зрение

viska
: $x_1$ видит $x_2$ (объект, форма, цвет)

skari
: $x_1$ - объект с цветом $x_2$ (свойство)

tarmi
: $x_1$ - форма $x_2$

cukla
: $x_1$ - круглый (по форме)

<pixra url="/assets/pixra/cilre/coha_viska.webp" caption="le prenu co'a viska le cipni" definition="Человек замечает, начинает видеть птицу."></pixra>

> **mi viska le plise**
> _Я вижу яблоко._

> **mi viska le tarmi be le plise**
> _Я вижу форму яблока._

> **.i le plise cu se tarmi le cukla**
> _Яблоко круглое._

<!-- -->
<!-- > **ми виска ле се скари бе ле плисе**
> _Я вижу цвет яблока._ -->

> **.i le plise cu skari lo ka xunre**
> _Яблоко красного цвета._

Примечание: мы можем сказать и "видеть форму яблока", и "видеть яблоко".

#### Слух

turna
: $x_1$ слышит $x_2$ (объект или звук)

<pixra url="/assets/pixra/cilre/le_prenu_cu_tirna_lei_djacu.webp" caption="le prenu cu tirna lei djacu" definition="Человек слышит звуки воды."></pixra>

> **mi tirna le palta**
> _Я слышу тарелку._

<!-- -->

> **mi tirna le sance be le palta poi ca'o porpi**
> _Я слышу звук падающей тарелки._

> **.i le palta cu se sance le cladu**
> _Он звучит громко._

le palta
: тарелка

cladu
: $x_1$ громкий

olycladu
: $x_1$ довольно тихий

tonga
: $x_1$ - тональность $x_2$

Мы можем использовать **cladu** и подобные слова напрямую:

> **mi tirna le cladu**
> _Я слышу что-то громкое._

<!-- -->

> **mi tirna le tolycladu**
> _Я слышу что-то довольно тихое._

<!-- -->

> **mi tirna le tonga be le palta poi farlu**
> _Я слышу тон тарелки, падающей вниз._

Аналогично зрению, мы можем сказать "слышать звук" и "слышать что-то, издавая звук":

> **— ma sance gi'e se tirna do**
> _— Какой звук ты слышишь?_

> **— le zgike**
> _— Музыка._

<!-- -->

> **— do tirna le sance be ma**
> _— Ты слышишь звук чего?_

> **— le plise poi co'i farlu**
> _— Яблоко, которое упало._

#### Восприятие в общем

Мы также можем использовать общий глагол **ganse** — _ощущать стимул_.

ganse
: $x_1$ ощущает стимул $x_2$ (объект, событие) с помощью средства $x_3$

ganse la glare
: чувствовать жару

ganse le lenku
: чувствовать холод

> **mi ganse le plise**
> _Я ощущаю яблоко._

<!-- -->

Для наблюдения за нашими восприятиями мы можем использовать **zgana**:

<pixra url="/assets/pixra/cilre/zgana_le_sefta.webp" caption="le prenu cu zgana le sefta be le xrula" definition="Человек пальпирует поверхность цветка."></pixra>

> **mi zgana le tarmi be le plise**
> _Я наблюдаю форму яблока._

> **.i le plise cu se tarmi le'e cukla**
> _Яблоко круглое._

zgana
: $x_1$ замечает, наблюдает, смотрит на $x_2$. Не ограничивается только зрением

Некоторые аргументы могут использоваться с различными чувственными отношениями. Например, мы можем

viska le sefta
: видеть поверхность

zgana le sefta
: ощупывать поверхность

#### Обоняние

sumne
: $x_1$ чувствует запах $x_2$ (запах)

panci
: $x_1$ — запах $x_2$ (объект)

<pixra url="/assets/pixra/cilre/sumne.webp" caption="le mlatu cu sumne le xrula" definition="Кот чувствует запах цветка."></pixra>

> **mi sumne le xrula**
> _Я чувствую запах цветка._

<!-- -->

> **mi sumne le panci be le za'u xrula**
> _Я чувствую запах цветов._

<!-- -->

> **mi sumne le panci be le plise**
> _Я чувствую запах яблока._

> **.i le plise cu se panci le xrula**
> _Яблоко пахнет цветами._

Обратите внимание, что в русском языке может быть путаница в различении между "чувствовать запах" и "чувствовать объект, который источает запах". Мы говорим "почувствовать запах яблока", "яблоко пахнет цветами". Это различие важно, потому что яблоко выделяет ароматические частицы, которые отличаются от самого яблока. То же самое относится к падающей тарелке и ее звуку — мы не хотим их смешивать.

В ложбане мы легко можем разделить эти случаи, как показано в приведенных выше примерах.

#### Вкус

vrusi
: $x_1$ — вкус $x_2$

<pixra url="/assets/pixra/cilre/se_vrusi_lo_ka_kukte.webp" caption="le prenu cu zgana le vrusi be le grute" definition="Человек пробует, ощущает вкус фрукта."></pixra>

> **mi zgana le vrusi be le grute**
> _Я пробую яблоко._
> `Я ощущаю вкус фрукта`

le grute
: фрукт, фрукты
<!-- -->

> **.i le plise cu se vrusi le titla**
> _Яблоко сладкое._

titla
: ... сладкий, ... сладость

#### Ощущение прикосновения

sefta
: $x_1$ - поверхность $x_2$

> **mi zgana le sefta be le plise**
> _Я ощущаю поверхность яблока._

<!-- -->

> **.i le plise cu se sefta le xutla**
> _У яблока гладкая поверхность._

#### Боль

> **mi cortu le birka be mi**
> _Я чувствую боль в руке._
> _Моя рука болит._

<!-- -->

<pixra url="/assets/pixra/cilre/cortu.webp" caption="mi cortu le cidni" definition="Моё колено болит."></pixra>

> **mi cortu le cidni**
> _Я чувствую боль в колене, мое колено болит._

cortu
: $x_1$ чувствует боль в $x_2$ (орган, часть тела $x_1$)

cidni
: $x_1$ - колено $x_2$

#### Цвета

Разные языки используют разные наборы слов для обозначения цветов. Некоторые языки просто ссылаются на цвета, используя другие "прототипные" объекты с похожими цветами, оттенками или формами. В ложбане мы используем все варианты:

> **ti xunre**
> _Это красное._

xunre
: $x_1$ - красный

> **ti skari le ka xunre**
> _Это красное. Это имеет цвет красных вещей._

<!-- -->

> **ti skari le ka ciblu**
> _Это имеет цвет крови._

le ciblu
: кровь

Вот несколько примеров цветов, соответствующих русскому языку. Вы также можете использовать другие слова для цветов, отражая способ, которым носители разных языков обычно категоризируют вещи.

> **le tsani cu xunre ca le cerni**
> _Небо утром красное._

le tsani
: небо

> **.i le xolri cu simlu le ka narju**
> _Солнце кажется оранжевым._

le solri
: Солнце

<pixra url="/assets/pixra/cilre/tsani.webp" caption="tsani .i solri" definition="Небо. Солнце."></pixra>

simlu
: $x_1$ выглядит как $x_2$ (свойство $x_1$)

> **.i le pelxu xrula cu se farna le solri**
> _Желтые цветы обращены к Солнцу._

se farna
: $x_1$ обращен в сторону $x_2$

farna
: $x_1$ является направлением $x_2$

> **.i le pezli be le tricu cu crino**
> _Листья деревьев зеленые._

pezli
: $x_1$ является листом $x_2$

le tricu
: дерево

> **.i mi zvati le korbi be le blanu xamsi**
> _Я на границе синего моря._

zvati
: … присутствует в …

korbi
: $x_1$ является границей $x_2$

le xamsi
: море

> **.i mi catlu le prenu noi dasni le zirpu taxfu**
> _Я смотрю на человека, который носит фиолетовое платье._

dasni
: $x_1$ носит $x_2$ (что-то)

xunre
: $x_1$ красный

narju
: $x_1$ оранжевый

pelxu
: $x_1$ желтый

crino
: $x_1$ зеленый

blanu
: $x_1$ синий

zirpu
: $x_1$ фиолетовый

Другие полезные отношения:

> **le gusni be le manku pagbu pu na ku carmi**
> _Свет, освещающий темные области, был неярким._

<!-- -->

> **le gusni be fi le solri pu carmi**
> _Свет от Солнца был ярким._

gusni
: $x_1$ является светом, освещающим $x_2$ от источника света $x_3$

carmi
: $x_1$ интенсивный, яркий

manku
: $x_1$ темный

### «**sipna**» — ‘_спать_’, «**sanji**» — ‘_быть осознанным_’

Следующие примеры иллюстрируют некоторые основные аспекты сознания:

> **pu ku mi cikna gi'e ku'i na ganse le nu do klama**
> _Я был бодрствующим, но не почувствовал твоего прихода._

<!-- -->

> **pu ku ca le nu mi sipna kei mi ganse ku'i le nu do klama**
> _Пока я спал, я тем не менее почувствовал, что ты пришел._

<!-- -->

<pixra url="/assets/pixra/cilre/le_prenu_cu_senva_tuha_le_nei.webp" caption="mi ca'o sipna gi'e sanji le nu mi sipna" definition="Я сплю и осознаю, что я сплю."></pixra>

> **pu ku mi ca'o sipna gi'e sanji le nu mi sipna**
> _Я спал и осознавал, что я сплю._
> _У меня был осознанный сон._

<!-- -->

> **mi sanji le nu mi sanji**
> _Я осознаю, что я осознаю._
> _Я самосознателен._

sipna
: $x_1$ спит

cikna
: $x_1$ бодрствует

ganse
: наблюдатель $x_1$ ощущает, замечает некоторый стимул (событие) с помощью средства $x_3$

sanji
: $x_1$ осознает, осознает $x_2$ (событие)

**ganse** не подразумевает никакой умственной обработки; она просто описывает восприятие, распознавание, обнаружение какого-либо стимула через сенсорные каналы (указанные в $x_3$).

С другой стороны, **sanji** описывает пассивное восприятие, которое включает умственную обработку, но не обязательно через сенсорные входы вообще (некоторые умственные отношения не обнаруживаются органами чувств).

### Эмоции: «**cmila**» — ‘_смеяться_’, «**cisma**» — ‘_улыбаться_’

> **coi**
> **.i ma nuzba**
> **.i do simlu le ka badri**
> _Привет._
> _Какие новости?_
> _Ты кажешься грустным._

badri
: $x_1$ грустит из-за $x_2$

<pixra url="/assets/pixra/cilre/badri.webp" caption="Человек кажется грустным." definition="The person seems to be sad."></pixra>

> **mi стеба ле ну ле бруна бе ми цо'а спени ле нинму**
> _Меня раздражает, что мой брат женится на женщине._

steba
: $x_1$ чувствует раздражение из-за $x_2$

> **mi se cfipu**
> **.i xu do na ku gleki le nu le bruna co'a speni**
> _Я запутался._
> _Ты не радуешься, что брат женится?_

se cfipu
: $x_1$ запутан из-за $x_2$

gleki
: $x_1$ радуется $x_2$

> **ie**
> **.i le ninmu cu pindi**
> **.i le ninmu na ku ponse le jdini**
> **.i mi na ku kakne le ka ciksi**
> _Да._
> _Женщина бедна._
> _У нее нет денег._
> _Я не могу объяснить._

le jdini
: деньги

kakne
: $x_1$ способен на $x_2$ (свойство $x_1$)

> **ua**
> **.i la'a do kanpe le nu le ninmu na ku prami le bruna**
> _Ах!_
> _Вероятно, ты ожидаешь, что женщина не любит брата._

la'a
: междометие: вероятно, скорее всего

kanpe
: $x_1$ ожидает $x_2$ (какое-то событие)

> **mi terpa le nu le ninmu ba tarti lo xlali**
> **.i ku'i le bruna cu cisma ca ro nu ri tavla le ninmu**
> **.i ri ta'e cmila**
> _Я боюсь, что она будет плохо себя вести._
> _Но брат улыбается каждый раз, когда разговаривает с ней._
> _И она обычно смеется._

terpa
: $x_1$ боится $x_2$

cisma
: $x_1$ улыбается

cmila
: $x_1$ смеется

> **mi kucli le nu le ninmu cu prami le bruna**
> _Интересно, нравится ли девушке брат._

kucli
: $x_1$ интересуется $x_2$

> **mi na ku kanpe**
> _Я не ожидаю этого._

kanpe
: $x_1$ ожидает, что произойдет $x_2$ (событие)

> **ko surla**
> _Расслабься!_

surla
: $x_1$ расслабляется, делая $x_2$ (свойство $x_1$)

cinmo
: $x_1$ чувствует эмоцию $x_2$ (свойство $x_1$)

nelci
: $x_1$ нравится $x_2$

manci
: $x_1$ испытывает восхищение или удивление по поводу $x_2$

fengu
: $x_1$ злится на $x_2$

xajmi
: $x_1$ считает, что $x_2$ смешно

se zdile
: $x_1$ развлекается с $x_2$

zdile
: $x_1$ забавный

djica
: $x_1$ желает $x_2$

pacna
: $x_1$ надеется, что $x_2$ верно

### Здоровье

> **ca glare**
> _Сейчас жарко._

<!-- -->

> **.i ku'i mi ganse le lenku**
> _Но мне холодно._

ku'i
: междометие: но, однако

> **xu do bilma**
> _Ты болен?_

<!-- -->

> **bilma**
> _Да._

<!-- -->

> **xu do bilma fi le vidru**
> **.i .e'u do klama le mikce**
> _У тебя вирус? Я предлагаю тебе пойти к врачу._

le vidru
: вирус

le mikce
: врач

> **mi bilma le ka cortu le galxe**
> **.i mi sruma le du'u mi bilma fi la .zukam.**
> _У меня симптомы, что у меня болит горло._
> _Я предполагаю, что у меня простуда._

cortu
: $x_1$ испытывает боль в $x_2$ (орган, часть тела $x_1$)

la .zukam.
: простуда (болезнь)

> **ko kanro**
> _Выздоравливай!_

kanro
: $x_1$ здоров

> **ki'e**
> _Спасибо._

bilma
: $x_1$ болен или имеет симптомы $x_2$ от болезни $x_3$

Обратите внимание, что второе место **bilma** описывает симптомы, например, **le ka cortu le galxe** = _чувствовать боль в горле_. Третье место указывает на название болезни, вызывающей эти симптомы. Очевидно, вы можете пропустить заполнение этих мест **bilma**.

### Человеческое тело

> **le nanmu cu se xadni le clani**
> _У мужчины длинное тело. Мужчина высокий._

se xadni
: $x_1$ имеет тело $x_2$

xadni
: $x_1$ - тело $x_2$

> **mi pu darxi fi le stedu .e le zunle xance**
> **.i ca ti le degji be le xance cu cortu**
> **.i ku'i le pritu xance na ku cortu**
> _Я ударил что-то головой и левой рукой. Теперь палец на руке болит. Но правая рука не болит._

darxi
: $x_1$ бьет $x_2$ с помощью $x_3$

Большинство слов, обозначающих части тела, имеют такую же структуру, как и **xadni**:

stedu
: $x_1$ - голова $x_2$

Однако, некоторые описывают более мелкие части:

degji
: $x_1$ - палец/палец ноги на части $x_2$ (рука, нога)

> **le degji be le xance be le ninmu cu clani**
> _Пальцы женщины длинные._
> `Пальцы руки женщины длинные`

> **mi viska le jamfu .i ku'i mi na ku viska le degji be le jamfu**
> _Я вижу ноги. Но я не вижу их пальцы._

janco
: $x_1$ - сустав, соединяющий конечности $x_2$

ctebi
: $x_1$ - губа, край отверстия $x_2$

cidni
: $x_1$ - колено или локоть конечности $x_2$

![](/assets/pixra/cilre/xadni1.svg)

![](/assets/pixra/cilre/xadni2.svg)

### Родство

> **coi do mi se cmene zo .adam.**
> **.i ti du la .alis.**
> **.i ri speni mi**
> _Привет тебе. Меня зовут "Адам"._
> _Это Алиса._
> _Она моя жена._

<!-- -->

> **pluka fa le nu penmi do**
> **.i .e'o do klama le nenri be le dinju**
> _Приятно познакомиться._
> _Пожалуйста, входи в дом._

<!-- -->

> **ki'e**
> _Спасибо._

<!-- -->

> **.i .au gau mi do co'a slabu le lanzu be mi**
> **.i le re verba cu panzi mi**
> **.i le tixnu cu se cmene zo .flor.**
> **.i la .karl. cu du le bersa**
> _Я хотел бы, чтобы ты познакомился с моей семьей._
> _Эти двое детей - мои потомки._
> _Дочь зовут "Флор"._
> _Карл - сын._

<!-- -->

> **la .karl. cu mutce citno**
> _Карл очень молодой._

<!-- -->

> **ie**
> _Да._

<!-- -->

> **.i ji'a mi se tunba re da noi ca na ku zvati le dinju**
> **.i sa'e mi se tunba le pa bruna .e le pa mensi**
> _У меня также есть двое братьев и сестра, которые сейчас не в доме._
> _Чтобы быть точным, у меня есть брат и сестра._

<!-- -->

> **ue**
> **.i le lanzu be do cu barda**
> _Вау!_
> _У тебя большая семья._

<!-- -->

> **je'u pei**
> _Действительно?_

je'u
: междометие: действительно

Слова для обозначения имен членов семьи имеют похожую структуру:

speni
: $x_1$ - муж/жена $x_2$

**co'a speni** означает _выйти замуж/жениться_:

> **mi co'a speni la .suzan.**
> _Я женился на Сьюзан._

lanzu
: $x_1$ - семья, включающая $x_2$

panzi
: $x_1$ - ребенок $x_2$

tixnu
: $x_1$ - дочь $x_2$

bersa
: $x_1$ - сын $x_2$

tunba
: $x_1$ - брат/сестра $x_2$

bruna
: $x_1$ - брат $x_2$

mensi
: $x_1$ - сестра $x_2$

Обратите внимание, что **panzi** может относиться и к взрослым детям:

verba
: $x_1$ - ребенок, незрелый человек возраста $x_2$ (событие)

panzi
: $x_1$ - ребенок, потомок $x_2$

**verba** не обязательно описывает ребенка как члена семьи:

> **le bersa be le pendo be mi cu verba le nanca be li ci**
> _Сын моего друга - ребенок трех лет._

citno
: $x_1$ - молодой

laldo
: $x_1$ - старый, пожилой

Пары традиционных слов (только для людей):

le ninmu
: женщина / женщины

le nanmu
: мужчина / мужчины

le nixli
: девочки

le nanla
: мальчики

le remna
: люди

Обратите внимание, что **le prenu** означает _люди_ или _лица_. В сказках и фантастических историях, не только люди (**lo'e remna**), но и животные или инопланетные существа могут считаться лицами.

Эти слова могут использоваться для описания генетически обусловленного пола (как в животных, так и в людях), в отличие от гендера:

le fetsi
: женский

le nakni
: мужской

Эти слова описывают родительские (не обязательно генетические) отношения:

mamta
: $x_1$ - мать $x_2$, $x_1$ ведет себя матерински

patfu
: $x_1$ - отец $x_2$

rirni
: $x_1$ - родитель $x_2$, $x_1$ воспитывает $x_2$

### В магазине

> **ue**
> **do pu te vecnu le laldo karce**
> _Вау!_
> _Ты купил старую машину._

<!-- -->

> **ie**
> **.i ku'i mi na ku pu pleji le so'i jdini**
> _Да._
> _Но я не заплатил много денег._

<!-- -->

> **ma pu jdima le karce**
> _Какова была цена машины?_

<!-- -->

> **mi pu pleji le rupnusudu be li pa ki'o le kagni le karce**
> _Я заплатил тысячу долларов компании за машину._

<!-- -->

> **mi pu vecnu le laldo karce pe mi le pendo be mi**
> **.i le pendo pu pleji le rupne'uru be li re ki'o mi le karce**
> _Я продал свою старую машину другу._
> _Друг заплатил 2 000 евро за машину._

ki'o
: запятая между цифрами, так что **pa ki'o** - _1, 000_ (_одна тысяча_)

vecnu
: $x_1$ продает $x_2$ $x_3$

te vecnu
: $x_1$ покупает $x_2$ у $x_3$

pleji
: $x_1$ платит $x_2$ $x_3$ за $x_4$

jdima
: $x_1$ - цена $x_2$

jdini
: $x_1$ - деньги

rupnusudu
: $x_1$ стоит $x_2$ (число) долларов США

rupne'uru
: $x_1$ стоит $x_2$ (число) евро

### Магазин, здания

> **ma stuzi le zdani be do**
> _Где находится ваш дом?_

<!-- -->

> **le korbi be le cmana**
> **.i mi se zdani le nurma**
> **.i le zdani be mi cu barda dinju gi'e se sledi'u ci da .e le vimstu .e le lumstu**
> _На краю горы._
> _Я живу в деревне._
> _Мой дом - большой дом и имеет три комнаты, плюс туалет, плюс ванная._

<!-- -->

> **je'e**
> **.i ku'i mi pu jbena le tcadu .i je ca ti mi se zdani le jarbu be la .paris.**
> **.i mi xabju ne'a le zarci**
> _Понятно._
> _Но я родился в городе, и сейчас живу в пригороде Парижа._
> _Я живу рядом с магазином._

stuzi
: $x_1$ - место

dinju
: $x_1$ - здание, дом

sledi'u
: $x_1$ - комната, часть здания $x_2$

vimstu
: $x_1$ - туалет, место для выделения

lumstu
: $x_1$ - ванная, место для мытья чего-либо

zdani
: $x_1$ - дом для $x_2$

se zdani
: $x_1$ живет в $x_2$, $x_1$ обитает в $x_2$

tcadu
: $x_1$ - город или городок

jarbu
: $x_1$ - пригород города/городка $x_2$

nurma
: $x_1$ - сельская местность, $x_1$ находится в деревне

zarci
: $x_1$ - магазин
