## Урок 3. Цитирование. Вопросы. Междометия

### «**sei**»: комментарии к тексту

Частица **sei** позволяет вставить комментарий о нашем отношении к сказанному в отношении:

> **do jinga sei mi gleki**
> _Ты выиграл! (Я рад этому!)_

Однако:

> **do jinga sei la .ian. cu gleki**
> _Ты выиграл! (И Ян рад этому!)_

Как и с аргументами, образованными с помощью **le**, отношение, образованное с помощью **sei**, должно заканчиваться конструкцией отношения.

> **la .alis. cu prami sei la .bob. cu gleki la .kevin.**

Добавим скобки, чтобы сделать его более читаемым.

> **la .alis. cu prami (sei la .bob. cu gleki) la .kevin.**
> _Алиса любит (Боб счастлив) Кевина._
> _Алиса любит Кевина (Боб счастлив)._

Конечно, мы можем добавить больше аргументов к отношению с помощью **be** и **bei**, как мы делаем это внутри аргументных термов:

> **do jinga sei mi zausku be fo la fircku**
> _Ты выиграл! (Я напишу поздравления на Facebook)_

la fircku
: Facebook

zausku
: $x_1$ хвалит $x_2$ для аудитории $x_3$ с помощью средства $x_4$

### Кавычки

Для цитирования текста мы помещаем частицу цитирования **lu** перед цитатой и ставим **li'u** после нее. Результатом является аргумент, представляющий цитируемый текст:

> **mi cusku lu mi prami do li'u**
> _Я говорю "Я тебя люблю"._

cusku
: $x_1$ выражает/говорит $x_2$ (цитата) аудитории $x_3$

Хорошей особенностью ложбана является то, что маркеры **lu** - «начало цитаты» и **li'u** - «конец цитаты» произносимы. Это довольно удобно, поскольку в устном ложбане не нужно менять интонацию, чтобы показать, где начинается и заканчивается цитируемый текст.

Однако в письменном тексте, цитирующем разговор, автор часто обращает внимание читателя на содержание цитат. В таких случаях предпочтительно использовать **sei**.

Мы также можем вкладывать цитаты друг в друга, например:

> **la .ian. pu cusku lu la .djein. pu cusku lu coi li'u mi li'u**
> _Ян сказал: "Джейн сказала: 'Привет' мне"._

что похоже на

> **la .ian. pu cusku lu la .djein. pu rinsa mi li'u**
> _Ян сказал: "Джейн поприветствовала меня"._

rinsa
: $x_1$ приветствует кого-то $x_2$

<pixra url="/assets/pixra/cilre/rinsa2.webp" caption="le prenu cu rinsa mi" definition="Человек приветствует меня."></pixra>

Обратите внимание, что в ложбане мы различаем вещи и их имена:

> **lu le munje li'u cu cmalu**
> _"Вселенная" мала._

<!-- -->

> **le munje na ku cmalu**
> _Вселенная не мала._

le munje
: вселенная, мир

Здесь текст _"вселенная"_ маленький, в то время как сама вселенная не мала.

---

Междометия и обращения работают как конструкции с **sei**:

> **je'u mi jinga sei ra cusku**
> _Правда, "Я победил", - сказал он._

je'u
: междометие: правда

Как видите, **je'u** не является частью его слов. Оно представляет ваше отношение к отношению. Если вы хотите процитировать "**je'u mi jinga**", используйте кавычки, как в этом примере:

> **lu je'u mi jinga li'u se cusku ra**
> _"Правда, я победил", - сказал он._

Заметьте разницу между этими двумя примерами?

Вот несколько общих слов, связанных с разговорами:

> **ra pu retsku lu do klama ma li'u**
> _Она спросила: "Куда ты идешь?"_

<!-- -->

> **mi pu spusku lu mi klama le zdani li'u**
> _Я ответил: "Я иду домой"._

<!-- -->

> **mi pu spuda le se retsku be ra le ka spusku lu mi klama le zdani li'u**
> _Я ответил на ее вопрос, сказав: "Я иду домой"._

spuda
: $x_1$ отвечает $x_2$ путем совершения действия $x_3$ (свойство $x_1$)

У оставшихся трех слов отношения одинаковая структура мест:

cusku
: $x_1$ выражает/говорит $x_2$ (цитата) аудитории $x_3$

retsku
: $x_1$ задает вопрос $x_2$ (цитата) аудитории $x_3$

spusku
: $x_1$ отвечает/говорит ответ $x_2$ (цитата) аудитории $x_3$

### «**zo**» — цитирование одного слова

**zo** - это маркер цитаты, аналогичный **lu**. Однако **zo** цитирует только одно слово, непосредственно следующее за ним. Это означает, что он не требует слова для окончания цитаты, такого как **li'u**; мы уже знаем, где заканчивается цитата. Таким образом, мы экономим два слога и делаем нашу речь более лаконичной.

> **zo .robin. cmene mi**
> _"Робин" - мое имя._
> _Меня зовут Робин._

cmene
: $x_1$ (цитата) - это имя $x_2$ …

Чтобы представить себя на ложбане, используя свое ложбанизированное имя, следуйте приведенному выше примеру. Если ваше имя состоит из нескольких слов, используйте **lu … li'u**:

> **lu .robin.djonsyn. li'u cmene mi**
> _Меня зовут Робин Джонсон._

Другой подход - использовать **me**:

> **mi me la .robin.djonsyn.**
> _Я Робин Джонсон._

Обратите внимание на разницу: _"Робин"_ в кавычках - это цитируемое имя, тогда как Робин - это человек.

Чтобы продемонстрировать это лучше, вот глупая вариация:
> **zo .robin. cmene la .robin.**
> _"Робин" - это имя Робина._
> _"Робин" - это имя Робина._

Первое место в **cmene** - это цитата, текст. Поэтому мы используем **lu … li'u** или **zo**, чтобы создать цитату и заполнить первое место **cmene** им, вместо **la** (префикс для имен).

### Глаголы речи

Вот несколько отношений, описывающих речь:

> **mi pu skicu le purdi le pendo be mi lo ka bredi**
> _Я рассказал моему другу о том, что мой сад готов._

skicu
: $x_1$ рассказывает о $x_1$ (объект/событие/состояние) $x_3$ с описанием $x_4$ (свойство)

bredi
: … готов к …

> **mi pu cusku lu le purdi cu bredi li'u le pendo be mi lo ka cladu bacru**
> _Я сказал моему другу: "Сад готов", произнеся это громко._

cusku
: $x_1$ говорит $x_2$ (текст) для аудитории $x_3$ с помощью средства $x_4$

cladu
: … громкий

> **mi pu tavla le pendo be mi le nu le purdi cu bredi kei le lojbo**
> _Я разговаривал с моим другом на ложбане о том, что сад готов._

tavla
: $x_1$ разговаривает с $x_2$ о теме $x_3$ на языке $x_4$

Вкратце:

* **skicu** означает _рассказывать_, _описывать с помощью описания_,
* **cusku** означает _говорить какой-то текст_,
* **tavla** означает _разговаривать на языке_.

### Вопросы о содержании

В русском языке есть несколько вопросительных слов _кто?_, _что?_, _как?_, _почему?_ и т. д. В ложбане для всех из них используется одно слово: **ma**. Это слово является аргументом (как **mi**, **le prenu** и т. д.) и является призывом заполнить пропущенное место. Например:

> **— do klama ma**
> **— la .london.**
> _— Куда ты едешь?_
> _— В Лондон._

<!-- -->

> **— ma klama la .london.**
> **— la .kevin.**
> _— Кто едет в Лондон?_
> _— Кевин._

<!-- -->

> **— mi plicru do ma**
> **— le plise**
> <span>_— Что я тебе даю?_ (вероятно, имеется в виду _Что я должен тебе дать?_)</span>
> _— Яблоко._

Для перевода _какой/какая/какое_, мы также используем **ma**:

> **— ma gugde gi'e se xabju do**
> **— le gugde'usu**
> _— В какой стране ты живешь?_
> _— США_
> `— Что является страной и место обитания тебя?`
> `— США`

xabju
: … (кто-то) живет в … (каком-то месте)

se xabju
: … (какое-то место) населено … (кем-то)

**mo** похоже на **ma**, но это - слово-отношение.

**mo** предлагает заполнить отношение вместо аргумента. Это как вопрос _Что делает X?_ или _Что такое X?_ в русском (в ложбане вам не нужно различать между бытием и действием).

Мы можем рассматривать **mo** как призыв описать отношение между аргументами в вопросе.

> **— do mo**
> _— Как дела? Что нового?_
> `— Ты - кто? Ты что делаешь?`

Это наиболее распространенный способ спросить _Как дела?_ или _Привет?_ на ложбане. Некоторые возможные ответы:

> **— mi gleki**
> _— Я счастлив._

gleki
: $x_1$ счастлив

> **— mi kanro**
> _— Я здоров._

<!-- -->

> **mi tatpi**
> _Я устал._

<!-- -->

> **mi gunka**
> _Я работаю._

Другой способ спросить _Как дела?_:

> **— do cinmo le ka mo**
> _— Как ты себя чувствуешь (эмоционально)?_

cinmo
: $x_1$ чувствует $x_2$ (свойство $x_1$)

Другие примеры:

> **ti mo**
> _Что это?_

<!-- -->

> **la .meilis. cu mo**
> _Кто такая Мэй Ли? / Что такое Мэй Ли? / Что делает Мэй Ли?_

Возможные ответы в зависимости от контекста:

- **ninmu**: _Она женщина._
- **jungo**: _Она китаянка._
- **pulji**: _Она полицейский._
- **sanga**: _Она певица_ или _Она поет._

> **do mo la .kevin.**
> _Кто ты для Кевина?_
> `Ты что (ты что делаешь) для Кевина.`

Ответ зависит от контекста. Возможные ответы на этот вопрос:

- **nelci**: _Я его люблю._
- **pendo**: _Я его друг._
- **prami**: _Я обожаю его._
- **xebni**: _Я его ненавижу._
- **fengu**: _Я злюсь на него._
- **cinba**: _Я поцеловал его._

Обратите внимание, что время здесь не важно: так же, как **cinba** может означать _целовать_, _поцеловал_, _поцелует_ и так далее, **mo** не задает вопрос о каком-либо конкретном времени.

Если мы хотим различать _делать_ и _быть кем-то или чем-то_, мы используем дополнительные отношения:

> **la meilis cu zukte ma**
> *Чем занимается Меё Ли?*
> `Что делает Мэй Ли?`

> **le ka lumci**
> *Чисткой*

<!-- -->

> **la meilis cu zukte le ka lumci**
> _Мэй Ли занимается чисткой._

zukte
: $x_1$ делает $x_2$ (свойство $x_1$)

lumci
: ... чистит или моет... (что-то)

<pixra url="/assets/pixra/cilre/lumci.webp" caption="ra lumci le zdani" Definition="Она убирает дом."></pixra>

> **do du ma**
> `Кто ты?`

> **mi du le ctuca**
> _Я учитель._

Использование модальных термов с **ma** может дать нам другие полезные вопросы:

<table>
<tbody><tr>
<th>слово
</th>
<th>значение
</th>
<th><code>[буквально]</code>
</th></tr>
<tr>
<td><b>ca ma</b>
</td>
<td>Когда?
</td>
<td>во время чего?
</td></tr>
<tr>
<td><b>bu'u ma</b>
</td>
<td>Где?
</td>
<td>в чём, в каком месте?
</td></tr>
<tr>
<td><b>ma prenu gi'e …</b>
</td>
<td>Кто?
</td>
<td>кто является человеком и …?
</td></tr>
<tr>
<td><b>ma dacti gi'e</b>
</td>
<td>Что? (о неживых объектах)
</td>
<td>Что является объектом и …?
</td></tr>
<tr>
<td><b>ri'a ma</b>
</td>
<td>Почему?
</td>
<td>по причине чего
</td></tr>
<tr>
<td><b>pe ma</b>
</td>
<td>Чьё? Кого?
</td>
<td>относящийся к кому/чему?
</td></tr>
<tr>
<td><b>le mlatu poi mo</b>
</td>
<td>Какая кошка?
</td>
<td>
Кошка, которая что делает/кем является?
</td></tr></tbody></table>

**pe ma** присоединяется только к аргументам:

> **le penbi pe ma cu zvati le jubme**
> _Чья ручка находится на столе?_

### Вопросы о числе

> **le xo prenu cu klama ti**
> _Сколько людей приходит сюда?_

<!-- -->

> **mu**
> _Five._

Слово **xo** означает _Сколько?_ и поэтому спрашивает о числе. Полный ответ будет:

> **le mu prenu cu klama ti**
> _% человек приходят в это место._

Человеку, которому задается вопрос, предполагается вставить соответствующее значение вместо **xo**.

Вот еще несколько примеров:

> **le xo botpi cu kunti**
> _Сколько бутылок пусто?_

<!-- -->

> **do ralte le xo gerku**
> _Сколько собак ты держишь?_

### Глаголы фактов

Рассмотрим пример:

> **mi djuno le du'u do stati**
> _Я знаю, что ты умный._

djuno
: $x_1$ означает $x_2$ (предложение) о $x_3$

> **mi jimpe le du'u do pu citka**
> _Я понимаю, что ты что-то ел._

jimpe
: $x_1$ понимает $x_2$ (утверждение) о $x_3$

<pixra url="/assets/pixra/cilre/na_jimpe.webp" caption="mi na jimpe" definition="Я не понимаю."></pixra>

В местах, где описываются факты, используется частица **du'u** (вместо **nu**).

**djuno** (_знать_) и **jimpe** (_понимать_) описывают факты. Было бы нелогично сказать: "Я понимаю, что ты ел, но на самом деле ты не ел".

Обратите внимание, что утверждение, начинающееся с **du'u**, не обязательно должно быть истинным:

> **le du'u do mlatu cu jitfa**
> _То, что ты кот, неверно._

jitfa
: $x_1$ (утверждение) неверно

Когда следует использовать **du'u**, а когда следует использовать **nu**? Вы можете обратиться к словарю:

- Метка _(du'u)_ или _(утверждение)_ указывает на места, где рекомендуется использовать **du'u**.
- Метка _(nu)_ или _(событие)_ указывает на места, где рекомендуется использовать **nu**.

Если вы ошибочно используете **nu** вместо **du'u**, вас все равно поймут. Однако, свободно владеющие языком ложбан обычно различают эти частицы.

### Косвенные вопросы

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Я знаю, кто изучает ложбан._

Это называется косвенным вопросом. Слово _кто_ здесь не является просьбой о информации, и знака вопроса нет. Ответ предполагается, и на самом деле вы сами знаете ответ на вопрос "Кто изучает ложбан?"

**kau** - это междометие, которое мы ставим после вопросительного слова, чтобы указать, что это косвенный вопрос.

Если я задам вам вопрос **ma tadni la .lojban.**, вы знаете, какое значение заполнить в слоте **ma**: **la .kevin.** Так что вы можете просто сказать

> **ma tadni la .lojban.**
> _Кто изучает ложбан?_

<!-- -->

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Я знаю, кто изучает ложбан. Я знаю личность человека, который изучает ложбан._

<!-- -->

> **mi djica le nu ma tadni la .lojban.**
> _Кого я хочу, чтобы изучал ложбан?_
> `Я хочу, чтобы кто-то изучал ложбан?`

Это никогда не может быть косвенным вопросом: это вопрос, на который требуется ответ (даже если вы делаете это риторически).

Вы можете поставить его после других вопросительных слов:

> **mi djuno le du'u le xo kau prenu cu tadni la .lojban.**
> _Я знаю, сколько людей изучает ложбан._

### Косвенная речь: «_Я сказал, что приду._»

Отношение вроде _Алиса сказала: "Мишель сказала мне 'Привет'"_ также можно выразить более тонким способом:

> **la .alis. pu cusku zo'e pe le nu la .micel. pu rinsa la .alis.**
> _Алиса говорила что-то о том, что Мишель поприветствовала ее._
> `Алиса сказала что-то о том, что Мишель поприветствовала её.`

Или можно сделать это короче:

> **la .alis. pu cusku le se du'u la .micel. pu rinsa la .alis.**
> _Алиса сказала, что Мишель поприветствовала её._

Комбинация **se du'u** позволяет выражать косвенную речь.

Вот несколько примеров отношений, полезных для косвенной речи:

> **le ninmu pu retsku le se du'u mi klama ma kau**
> _Она спросила, куда я иду._

<!-- -->

> **mi pu spusku le se du'u mi klama le zdani**
> _Я ответил, что я иду домой._

<!-- -->

> **mi pu spuda le se retsku be le ninmu le ka spusku le se du'u mi klama le zdani**
> _Я ответил на ее вопрос, сказав в ответ, что иду домой._

Вопросы в косвенной речи:

> **mi pu cusku le se du'u ma tadni la .lojban.**
> _Я сказал, что кто изучает ложбан?_

В ложбане есть несколько слов для сложноподчинённых предложений, в зависимости от того, что именно имеется в виду.

- Если _что_ описывает то, что можно видеть, слышать или что происходит, используйте **nu**.
- Если _что_ описывает то, что вы думаете, какой-то факт или информацию, используйте **du'u**.
- Если _что_ описывает то, что вы говорите, используйте **se du'u**.
  - Но если вам нужна буквальная цитата, используйте **lu … li'u**.

### Эмоциональные междометия: «_Ура!_» = «**ui**», «_Да!_» = «**ie**», «_Уф!_» = «**.o'u**»

Мы знаем такие междометия, как **ui** (_Ура!_), **.a'o** (_Я надеюсь_).

> **do jinga ui**
> _Ты выиграл! (Я этому рад!)_

ui
: междометие: _Ура!_, междометие радости

<pixra url="/assets/pixra/cilre/ui_jinga.webp" caption="ui mi jinga" definition="Ура! Я выиграл!"></pixra>

Междометия работают как **sei** со своими отношениями. **ui** означает то же самое, что и **sei mi gleki**, поэтому мы могли бы также сказать **do jinga sei mi gleki**, что означает то же самое (хотя это немного длиннее).

Есть междометия, выражающие другие эмоциональные состояния. Они похожи на смайлики, такие как ;-), или :-(, но на ложбане мы можем быть более конкретными в выражении наших эмоций, оставаясь при этом краткими в речи.

> **ie tu mlatu**
> _Согласен, это кошка._

<!-- -->

> **ie nai .i tu na ku mlatu**
> _Нет, я не согласен. Это не кошка._

ie
: междометие: _Да! Ага!_ (согласие)

ie nai
: междометие: несогласие

> **.ai mi vitke do**
> _Я собираюсь навестить тебя._

.ai
: междометие: _Я собираюсь …_ (намерение)

> **.au do kanro**
> _Я желаю, чтобы ты был здоров._

.au
: междометие: желание

<pixra url="/assets/pixra/cilre/clira.webp" caption="mi clira klama" definition="Я пришел рано."></pixra>

> **.a'o do clira klama**
> _Я надеюсь, ты придешь рано._

.a'o
: междометие: надежда

clira
: $x_1$ происходит рано

<pixra url="/assets/pixra/cilre/ciska.webp" caption=".ei mi ciska le xatra ti voi pelji ku'o le penbi" definition="Мне следует написать письмо на этой бумаге, используя ручку."></pixra>

> **.ei mi ciska le xatra le pelji le penbi**
> _Мне следует написать письмо на бумаге, используя ручку._

.ei
: Мне следует … (обязанность)

ciska
: $x_1$ пишет $x_2$ на средстве $x_4$

> **.i'e do pu gunka le vajni**
> _Очень хорошо! Ты выполнил важную работу._

.i'e
: междометие: _Отлично!_ (одобрение)

> **.o'u tu mlatu**
> _Ой, это всего лишь кошка._

.o'u
: междометие: _Уф!_ (облегчение)

В этом случае, вы, вероятно, подумали, что это что-то опасное, но это всего лишь кошка, поэтому вы говорите **.o'u**.

> **.u'i ti zmitci**
> _Ха-ха, это робот._

.u'i
: междометие: _Ха-ха!_ (веселье)

zmitci
: … является автоматическим инструментом

Вы можете добавлять или удалять междометия в предложении без риска его нарушения.

Любое слово, начинающееся с чистого гласного (за исключением **u** и **i** перед гласными), в ложбане в письменной форме предваряется точкой, а в устной речи - паузой. Таким образом, правильное написание - **.a'o** и так далее. Обычно точки опускаются при письме. Однако, при разговоре вы всегда должны показывать эту точку, сделав короткую паузу перед произнесением такого слова, чтобы предотвратить слияние двух соседних слов в одно.

Как и с **xu** или **sei**-отношениями, мы можем добавлять междометия после любого аргумента или конструкции отношения, выражая таким образом наше отношение к этой части предложения.

### Побуждающие междометия

Особая группа "императивных/побуждающих" междометий используется для подстрекательств, команд и просьб. Мы уже сталкивались с **.e'o**:

> **.e'o mi ciksi da poi mi cusku djica**
> _Пожалуйста, позвольте мне объяснить, что я хочу сказать._

.e'o
: междометие: _Пожалуйста …_ (просьба)

> **— au mi klama le nenri**
> **— .e'a**
> _— Я хотел бы войти._
> _— Пожалуйста, пойдите._

.e'a
: междометие: _Я разрешаю, вы можете …_ (разрешение)

le nenri
: внутренность, то, что находится внутри

> **.e'ei do zukte**
> _Давай, сделай это!_

.e'ei
: междометие: _Давай!_ (поощрение, подстрекательство, провокация). Неофициальное слово

> **.e'i do zutse doi le verba**
> _Садись, ребенок!_

.e'i
: междометие: _Сделай это!_ (команда)

> **.e'u do pinxe le jisra**
> _Я предлагаю тебе выпить сок. Тебе лучше выпить сок._

.e'u
: междометие: _Давайте …_ (предложение)

### «**ko**» для более быстрых побуждений

> **do bajra**
> _Ты бежишь._

<!-- -->

> **bajra**
> _Кто-то бежит._

Местоимение **ko** используется вместо **do** для выражения просьб, предложений или команд:

> **ko bajra**
> _Беги! Сделай это, чтобы ты бежал!_

**ko** является более неопределенной альтернативой **do .e'o**, **do .e'u**, **do .e'i**.

Совершенно нормально сказать что-то более точное, например:

> **do .e'o bajra**
> _Ты, пожалуйста, беги!_

ставя акцент на нашу вежливость перед **do** (_ты_).

Перемещая **ko** в отношение, команда/просьба переносится на эту часть. Например:

> **nelci ko**
> _Сделай так, чтобы ты кому-то понравился!_

nelci
: … (кому-то) нравится … (что-то или кто-то)

Как видите, нам приходится перестраивать это отношение в русском языке, что все равно звучит странно. Однако вы можете использовать это в ложбане в смысле _Постарайся произвести хорошее впечатление_.

Обратите внимание, что **prami** соответствует русскому _любить_, а **nelci** соответствует русскому _нравиться_.

Мы даже можем иметь несколько **ko** в одном предложении:

> **ko kurji ko**
> _Позаботься о себе._

kurji
: … (кто-то) заботится о … (кому-то или чём-то)

### Разговорные междометия

> **au mi citka le salta .e ji'a le grute**
> _Я бы хотел съесть салат и также фрукты._

ji'a
: _дополнительно, также_, означает, что есть другие, кто также такой же (в данном случае _вы_) или делает то же самое

salta
: … это какой-то салат

grute
: … это фрукт

> **mi si'a nelci do**
> `Я тоже люблю тебя`

<!-- -->
> **— mi nelci le'e mlatu**
> **— mi si'a nelci le'e mlatu**
> _— Мне нравятся кошки._
> _— Мне тоже нравятся кошки (Я тоже)._

si'a
: _аналогично, тоже_, указывает на то, что что-то похоже, но отличается в других неупомянутых аспектах

### Структура междометий: «**nai**», «**sai**», «**pei**», «**dai**»

Междометия могут состоять из

1. корня, например, **ui** (_Ура!_)
2. после него могут следовать суффиксы, такие как **pei**, **dai**, **zo'o**:

    > **ui zo'o**
    > _Ура! (шучу, я на самом деле не рад)_

3. как корень, так и каждый из суффиксов могут быть изменены скалярными частицами, такими как **nai**:

    > **ui nai**
    > _Увы!_

    <!-- -->
    > **ui nai zo'o**
    > _Увы! (шучу, я не серьезно в этом чувстве)_

    <!-- -->
    > **ui nai zo'o nai**
    > _Увы, я не шучу, я чувствую себя несчастным_

Некоторые примеры того, как работают скалярные частицы.

- **ju'o** = _междометие: Я уверен (уверенность)_
- **ju'o cu'i** = _междометие: возможно, может быть (неопределенность)_
- **ju'o nai** = _междометие: У меня нет понятия!_

Общие примеры междометий:

- междометие, состоящее только из корня:

 > **ju'o le bruna co'i klama**
 > _Я уверен, брат пришел._

- скалярная частица **cu'i** превращает междометие с голым корнем в среднюю оценку:

 > **ju'o cu'i le bruna co'i klama**
 > _Возможно, брат пришел, я не уверен._

- скалярная частица **nai** превращает междометие в противоположную оценку:

 > **ju'o nai le bruna co'i klama**
 > _Возможно, брат пришел, а может и нет, я не знаю_

Точно так же, **ui** означает _Ура! Ура!_, а **ui nai** означает _Увы!_

Точные значения междометий, которые имеют смысл скалярных частиц **cu'i** и **nai**, приведены в словаре.

- скалярная частица **sai** обозначает сильную интенсивность междометия:

 > **.u'i sai**
 > _Ха-ха-ха!_

Междометия также могут модифицироваться скалярными частицами:

> **ki'e sai do**
> _Большое спасибо!_

Суффиксы добавляются после корня междометия (вместе с его скалярными частицами, если мы их использовали):

- суффикс междометия **pei** превращает междометие в вопрос.

 > **— .au pei do .e mi klama le zarci**
 > **— .au cu'i**
 > _— Хочешь, чтобы мы пошли в магазин?_
 > _— Не особо._

 <!-- -->

 > **— ie pei tu melbi**
 > **— ie**
 > _— Он красивый, не так ли?_
 > _— Да._

- суффикс междометия **dai** показывает чувства других, а не чувства говорящего:

 > **ui nai dai do na ku co'i jinga**
 > _Тебе, должно быть, грустно, ты не выиграл._

 <!-- -->

 > **.a'u**
 > _Это интересно!_

 <!-- -->

 > **.a'u dai**
 > _Тебе, должно быть, это было интересно!_

- Голые междометия выражают отношение говорящего. **ei do cliva** означает не _Тебе следует уйти_, а _Я чувствую обязанность тебе уйти_. **dai** показывает, что говорящий сопереживает чувствам других.

 > **.ei dai do cliva**
 > _Ты чувствуешь обязанность уйти._

Обратите внимание, что междометия не обязательно выражают отношение к самим говорящим. Вместо этого они выражают отношение говорящих к другим вещам.

- суффикс междометия **zo'o** указывает на то, что отношение выражено не серьезно:

 > **.e'u zo'o do pinxe ti**
 > _Я предлагаю тебе выпить это (шутя)._

- Суффиксы также могут модифицироваться скалярными частицами:

 > **ie zo'o nai**
 > _Я согласен (не шутя)._

- **zo'o nai** используется, чтобы показать, что информация не является шуткой:

 >**zo'o nai ra pu klama la .paris.**
 >_— Я серьезно, он поехал в Париж._

- Суффиксы могут использоваться самостоятельно:

  - **pei** при использовании в одиночку запрашивает любое междометие, которое слушатель почувствует подходящим:

> **— pei le lunra ku crino**
> **— .ie nai**
> _— Луна зеленая (каково твое чувство об этом?)_
> _— Я не согласен._

- Для других суффиксов означает, что корневое междометие **jua** (_я утверждаю_) было опущено:

 > **zo'o do kusru**
 > **ju'a zo'o do kusru**
 > _Ты жестокий (шучу)._

ju'a
: междометие: я утверждаю (не путать с **juo** (я уверен))

### Только для справки: междометия в таблицах

Вот более полное представление: эмоциональные, побуждающие и различные другие междометия по сериям.

<table>
<tbody><tr>
<td><b>.au</b><br/><i>Желание …</i>
</td>
<td><b>.ai</b><br/><i>Я собираюсь…</i>
</td>
<td><b>.ei</b><br/><i>Это должно быть…</i>
</td>
<td><b>.oi</b><br/><i>Ой!</i>
</td></tr>
<tr>
<td><b>.au cu'i</b><br/><i>мэх</i><br/>безразличие
</td>
<td><b>.ai cu'i</b><br/>нерешительность
</td>
<td><b>.ei cu'i</b>
</td>
<td><b>.oi cu'i</b>
</td></tr>
<tr>
<td><b>.au nai</b><br/><i>Нет-нет!</i><br/>нежелание, неохота
</td>
<td><b>.ai nai</b><br/>непреднамеренно, случайно
</td>
<td><b>.ei nai</b><br/>свобода, как вещи могут быть необязательными
</td>
<td><b>.oi nai</b><br/>удовольствие
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Эмоция</th></tr></thead>
<tbody>
<tr>
<td><b>ua</b><br/><small>"уа" как в "<u>уау</u>"</small><br/><i>Ага! Эврика!</i>
</td>
<td><b>ue</b><br/><i>Какой сюрприз!</i>
</td>
<td><b>ui</b><br/><i>ура!</i>
</td>
<td><b>uo</b><br/><i>вот!</i>
</td>
<td><b>uu</b><br/><i>бедняжка</i>
</td></tr>
<tr>
<td><b>ua cu'i</b><br/>&nbsp;
</td>
<td><b>ue cu'i</b><br/><i>Я не слишком удивлен</i>
</td>
<td><b>ui cu'i</b><br/>&nbsp;
</td>
<td><b>uo cu'i</b><br/>&nbsp;
</td>
<td><b>uu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ua nai</b><br/><i>Ага! Я не понимаю!</i><br/>путаница
</td>
<td><b>ue nai</b><br/>ожидание, отсутствие удивления
</td>
<td><b>ui nai</b><br/><i>Увы!</i><br/>чувство несчастья
</td>
<td><b>uo nai</b><br/>чувство неполноценности
</td>
<td><b>uu nai</b><br/><i>Муа-ха-ха!</i><br/>жестокость
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Эмоция</th></tr></thead>
<tbody>
<tr>
<td><b>ia</b><br/><small>"я" как в слове "ярко"</small><br/><i>Я верю</i>
</td>
<td><b>ie</b><br/><small>"йэ" как в слове "ел"</small><br/><i>согласен!</i>
</td>
<td><b>ii</b><br/><small>"йи"</small><br/><i>ой!</i>
</td>
<td><b>io</b><br/><small>"йо" как в слове "йогурт"</small><br/><i>уважение</i>
</td>
<td><b>iu</b><br/><small>"ю" как в словах "юг"</small><br/><i>Мне нравится</i>
</td></tr>
<tr>
<td><b>ia cu'i</b><br/>&nbsp;
</td>
<td><b>ie cu'i</b><br/>&nbsp;
</td>
<td><b>ii cu'i</b><br/>&nbsp;
</td>
<td><b>io cu'i</b><br/>&nbsp;
</td>
<td><b>iu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ia nai</b><br/><i>Фшш!</i><br/>недоверие
</td>
<td><b>ie nai</b><br/>несогласие
</td>
<td><b>ii nai</b><br/><i>Я чувствую себя в безопасности</i>
</td>
<td><b>io nai</b><br/>неуважение
</td>
<td><b>iu nai</b><br/>ненависть
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Эмоция</th></tr></thead>
<tbody>
<tr>
<td><b>.u'a</b><br/><small>"уhа"</small><br/><i>прирост</i>
</td>
<td><b>.u'e</b><br/><small>"уhэ"</small><br/><i>какое чудо!</i>
</td>
<td><b>.u'i</b><br/><small>"уи"</small><br/><i>ха-ха-ха!</i>
</td>
<td><b>.u'o</b><br/><small>"уhо"</small><br/><i>смелость</i>
</td>
<td><b>.u'u</b><br/><small>"уhу"</small><br/><i>извините!</i>
</td></tr>
<tr>
<td><b>.u'a cu'i</b><br/>&nbsp;
</td>
<td><b>.u'e cu'i</b><br/>&nbsp;
</td>
<td><b>.u'i cu'i</b><br/>&nbsp;
</td>
<td><b>.u'o cu'i</b><br/>застенчивость
</td>
<td><b>.u'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.u'a nai</b><br/>потеря
</td>
<td><b>.u'e nai</b><br/><i>Ффф!</i><br/>обыденность
</td>
<td><b>.u'i nai</b><br/><i>Бла</i><br/>усталость
</td>
<td><b>.u'o nai</b><br/>трусость
</td>
<td><b>.u'u nai</b><br/>&nbsp;
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Отношение</th></tr></thead>
<tbody>
<tr>
<td><b>.i'a</b><br/><small>"иhа"</small><br/><i>хорошо, я принимаю это</i>
</td>
<td><b>.i'e</b><br/><small>"иhэ"</small><br/><i>Я одобряю!</i>
</small></td>
<td><b>.i'i</b><br/><small>"иhи"</small><br/><i>Я с тобой в этом</i>
</td>
<td><b>.i'o</b><br/><small>"иhо"</small><br/><i>благодаря этому</i>
</td>
<td><b>.i'u</b><br/><small>"иhу"</small><br/><i>знакомство</i>
</td></tr>
<tr>
<td><b>.i'a cu'i</b><br/>&nbsp;
</td>
<td><b>.i'e cu'i</b><br/>несогласие
</td>
<td><b>.i'i cu'i</b><br/>&nbsp;
</td>
<td><b>.i'o cu'i</b><br/>&nbsp;
</td>
<td><b>.i'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.i'a nai</b><br/>сопротивление
</td>
<td><b>.i'e nai</b><br/><i>Бу!</i><br/>неодобрение
</td>
<td><b>.i'i nai</b><br/>чувство враждебности
</td>
<td><b>.i'o nai</b><br/>зависть
</td>
<td><b>.i'u nai</b><br/>незнакомство
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Прикрепление к ситуации</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.a'a</b><br/><small>"аhа"</small><br/><i>Я слушаю</i>
</td>
<td><b>.a'e</b><br/><small>"аhэ"</small><br/><i>бдительность</i>
</td>
<td><b>.a'i</b><br/><small>"аhи"</small><br/><i>уф!</i><br/>усилие
</td>
<td><b>.a'o</b><br/><small></small><br/><i>Я надеюсь</i>
</td>
<td><b>.a'u</b><br/><small></small><br/><i>хм, интересно…</i>
</td></tr>
<tr>
<td><b>.a'a cu'i</b><br/>невнимательно
</td>
<td><b>.a'e cu'i</b><br/>&nbsp;
</td>
<td><b>.a'i cu'i</b><br/>без особых усилий
</td>
<td><b>.a'o cu'i</b><br/>&nbsp;
</td>
<td><b>.a'u cu'i</b><br/><i>Хм-хм</i><br/>отсутствие интереса
</td></tr>
<tr>
<td><b>.a'a nai</b><br/>избегание
</td>
<td><b>.a'e nai</b><br/><i>Я устал</i>
</td>
<td><b>.a'i nai</b><br/>покой
</td>
<td><b>.a'o nai</b><br/><i>Фу!</i><br/>отчаяние
</td>
<td><b>.a'u nai</b><br/><i>Фу! Фу!</i><br/>отвращение
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Побуждение</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.e'a</b><br/><small>"эhа"</small><br/><i>ты можешь</i>
</td>
<td><b>.e'ei</b><br/><small>"эhэй"</small><br/><i>давай, делай!</i>
</td>
<td><b>.e'i</b><br/><small>"эhи"</small><br/><i>делай!</i>
</td>
<td><b>.e'o</b><br/><small>"эhо"</small><br/><i>пожалуйста, сделай это</i>
</td>
<td><b>.e'u</b><br/><small>"эhу"</small><br/><i>я предлагаю</i>
</td></tr>
<tr>
<td><b>.e'a cu'i</b><br/>&nbsp;
</td>
<td><b>.e'ei cu'i</b><br/>&nbsp;
</td>
<td><b>.e'i cu'i</b><br/>&nbsp;
</td>
<td><b>.e'o cu'i</b><br/>&nbsp;
</td>
<td><b>.e'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.e'a nai</b><br/>запрещение
</td>
<td><b>.e'ei nai</b><br/>выражение обескураженности, деморализации
</td>
<td><b>.e'i nai</b><br/>&nbsp;
</td>
<td><b>.e'o nai</b><br/>предложение, дарование
</td>
<td><b>.e'u nai</b><br/>предупреждение, отсоветование
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Эмоция</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.o'a</b><br/><small>"оhа"</small><br/><i>гордость</i>
</td>
<td><b>.o'e</b><br/><small>"оhэ"</small><br/><i>Я чувствую это под рукой</i>
</td>
<td><b>.o'i</b><br/><small>"оhи"</small><br/><i>опасность!</i>
</td>
<td><b>.o'o</b><br/><small>"оhо" как в "с<u>ахо</u>р"</small><br/><i>терпение</i>
</td>
<td><b>.o'u</b><br/><small>"оhу"</small><br/><i>расслабление</i>
</td></tr>
<tr>
<td><b>.o'a cu'i</b><br/>скромность, смирение
</td>
<td><b>.o'e cu'i</b><br/>&nbsp;
</td>
<td><b>.o'u cu'i</b><br/>&nbsp;
</td>
<td><b>.o'o cu'i</b><br/>просто терпимость
</td>
<td><b>.o'u cu'i</b><br/>спокойствие, равновесие
</td></tr>
<tr>
<td><b>.o'a nai</b><br/><i>Как неловко.<br/>Мне стыдно.</i>
</td>
<td><b>.o'e nai</b><br/>удаление
</td>
<td><b>.o'i nai</b><br/>безрассудство, безрассудность
</td>
<td><b>.o'o nai</b><br/>нетерпение, нетерпимость
</td>
<td><b>.o'u nai</b><br/>стресс, беспокойство
</td></tr></tbody></table>

Обратите внимание, как эмоция меняется на противоположную, когда используется **nai**, и на среднюю эмоцию, когда используется **cu'i**.

Почему некоторые ячейки с междометиями с **cu'i** и **nai** пусты? Потому что в русском языке нет кратких способов выражения таких эмоций.

Более того, многие из этих междометий редко используются.

### Комбинирование междометий

> **iu ui nai**
> _Несчастливо влюбленный._

<!-- -->

> **ue ui do jinga**
> _О, ты выиграл! Я так счастлив!_

jinga
: … побеждает

В этом случае победа была невероятной, поэтому я удивлен и счастлив одновременно.

Междометия (в отличие от скалярных частиц и суффиксов междометий) не изменяют друг друга:

> **ue ui do jinga**
> **ui ue do jinga**
> _О, ты выиграл! Я так счастлив!_

Здесь два междометия изменяют одну конструкцию (весь предложение), но они не изменяют друг друга, поэтому их порядок не имеет значения.

> **pei .u'i le gerku cu sutra plipe**
> _(Как ты себя чувствуешь?) Ха, собака быстро прыгает._

Здесь **pei** используется в одиночку и не изменяет **.u'i**, который стоит после него.

### Забыли добавить междометие в начало?

> **do pu sidju mi ui**
> _Ты помог мне (ура!)_

**ui** изменяет только местоимение **mi**, выражая отношение только к _мне_.

> **ui do pu sidju mi**
> _Ура, ты помог мне._

Что, если мы забыли добавить **ui** в начало этого предложения?

Мы можем явно указать отношение как завершенное с помощью **vau**, а затем добавить междометие:

> **do pu sidju mi vau ui**
> _Ты помог мне, ура!_