## Урок 11. Более сложные темы

### Знайте и свой родной язык

Важно не делать ложбан просто копией русского языка.

Рассмотрим фразу:

> _Тигр Терри посещает большой город._

Может возникнуть соблазн использовать отношение

Витке
: $x_1$ (гость) посещает $x_2$ (кого-то) в $x_3$

Однако фраза «посещает большой город» подразумевает посещение места, а не кого-то в этом месте, что подчеркивает тот факт, что русский глагол «посещать» может иметь несколько значений.

Действительно, например, если мы рассмотрим французский язык, мы увидим отдельные решения:

> Я хотел бы навестить своих друзей.<br/>
> J'aimerais rendre visite à mes amis.

<!-- -->

> Я бы хотел посетить этот город.<br/>
> J'aimerais visiter cette ville.

Во французском языке используется _rendre visite_, когда посещаешь кого-то, и _visiter_, когда посещаешь какое-либо место.

В ложбане мы переводим смысл, а не просто слова.

Понимание особенностей собственного языка также важно при попытке выразить что-то на ложбане.

Решениями приведенного выше примера могут быть:

> **la .teris. poi tirxu cu klama le barda tcadu**
> _Тигр Терри приходит в большой город._

tirxu
: $x_1$ — тигр

> **la .teris. poi tirxu cu pa roi klama le barda tcadu**
> _Тигр Терри однажды приходит в большой город._
<!-- -->

> **la .teris. poi tirxu cu pa re'u mo'u klama le barda tcadu**
> _Тигр Терри впервые приходит в большой город._
<!-- -->

> **la .teris. poi tirxu cu co'a klama le barda tcadu**
> _Тигр Терри отправляется в большой город._

### Четыре значения «_ты_» в русском языке

Мы уже видели два личных местоимения, **mi** (_я_ или _меня_) и **do** (_ты_). Однако, _ты_ и _вы_ в русском языке может иметь несколько значений, которые переводятся на ложбан специфическим образом:

- _ты_ как _тот человек, с которым я разговариваю_:

 >**le pa do**<br/>
 >_вы (один человек)_
 >_ты_

 Мы знаем, что **le re prenu** означает _двое людей_. Также можно ставить числа после **le** и перед местоимениями.

- _вы_ как _все люди, с которыми я разговариваю_:

 >**ro do**<br/>
 >_каждый из вас_, _все вы_

 Можно также использовать числа с **ko**:

 >**ro ko klama ti**<br/>
 >_Все вы, подойдите сюда._

- _вы_ как _определенное количество людей, с которыми я разговариваю_:

 >**le re do**<br/>
 >_вы двое_

 Например, можно начинать письма родителям с **coi le re do**.

 Обратите внимание, что **re do** означает _двое из вас_, а **re le ci do** означает _двое из вас троих_.

- _вы_ как _человек или люди, с которыми я разговариваю, плюс кто-то еще_:

 >**do'o**<br/>
 >_ты и кто-то еще_

- _ты_ как _любой_ (например, _Деньги не могут купить тебе любовь._):

 Обычно выражается следующим образом:

 >**ro da**<br/>
 >_все **da**_

 или

 >**ro lo prenu**<br/>
 >_все люди_

 Однако, вы часто можете опустить его полностью или поставить **zo'e** на это место.
<!-- Рекомендуемый метод - сначала превратить местоимения в глаголы:

>**lo re me do ko klama ti**
>_Вы двое, идите сюда._

В этой позиции можно опустить **me** и сказать **lo re do ko klama ti**, но это может вызвать путаницу у начинающих. -->

### Больше о коротких придаточных предложениях

Короткие придаточные предложения с притяжательным местоимением могут быть помещены непосредственно после **le**:

> **le gerku pe mi**
> _Моя собака_

В таких случаях **pe** даже может быть опущено:

> **le gerku pe mi**
> **le mi gerku**
> _Моя собака_

**le mi gerku** означает то же самое, что и **le gerku pe mi**.

Таким образом, "**le** + аргумент + конструкция отношения" эквивалентно "**le** + конструкция отношения + **pe** + аргумент".

Несколько правил:

- если вы хотите использовать аргумент, преобразованный из отношения (например, с помощью **le**) или если это имя, рекомендуется использовать **pe** и поместить его после аргумента: **le gerku pe la .alis.** (_Собака Алисы_).
- опускание **pe** допустимо только при использовании местоимений без чисел перед ними: **le do gerku** (_твоя собака_), но не **le pa do gerku** (= **le pa do cu gerku** = _один из вас - собака_).

Гораздо безопаснее явно использовать **pe** и поместить его после аргумента, к которому он относится: **le gerku pe la .alis.** и **le gerku pe mi** - наиболее интуитивные конструкции.

### Цитирование текста на разных языках

**zoi** - это кавычка для цитирования текста на неложбанском языке. Его синтаксис выглядит так: **zoi X. текст .X**, где X - ложбанское слово (называемое ограничивающим словом), которое отделяется от цитируемого текста паузами и которое не встречается в написанном тексте или произносимом фонемном потоке внутри этой цитаты. Обычно, но не обязательно, используется имя какой-либо буквы, соответствующей ложбанскому названию цитируемого языка:

> **zoi gy. John is a man .gy. cu glico jufra**
> _«John is a man» - это предложение на английском языке._

glico
: $x_1$ - английский

где **gy.** означает **glico**. Другие популярные варианты ограничивающих слов - само слово _zoi_ и ложбанское слово, подсказывающее тему цитаты.

Ложбан строго избегает путаницы между вещами и их названиями:

> **zo .bob. cmene la .bob.**
> `Слово "Bob" - это имя некоего Боба.`

**zo .bob.** - это слово, в то время как **la .bob.** - это то, что названо этим словом. Краткие квалификаторы **la'e** и **lu'e**, расположенные перед термами, преобразуют ссылки и их объекты в обе стороны:

> **zo .bob. cmene la'e zo .bob.**
> _Слово "Боб" является именем, обозначающим существо с именем "Боб"._

<!-- -->

> **lu'e la .bob. cmene la .bob.**
> _Символ для Боба является именем Боба._

Последние два примера имеют одно и то же значение. Но это отличается:

> **la .bob. cu cmene la .bob.**
> _Боб - это имя Боба._

и говорит, что Боб является именем и вещью, которая названа, что маловероятно. Люди не являются именами.

**la'o** используется для обозначения не-лоджбанских имен, например, линнеевских биномиальных имен (например, "Homo sapiens"), которые являются международно стандартизированными именами для видов животных и растений.

Международно известные имена, которые легче узнать по написанию, а не по произношению, такие как _Гёте_, также могут появляться в тексте на лоджбан с помощью **la'o**:

> **la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.**
> _Гёте - это Homo sapiens._

Однако использование **la'o** для всех имен вместо адаптации их к лоджбану может сделать текст громоздким.

Все, что выражено в тексте, также должно быть выражено в речи и наоборот. Поэтому не может быть никакой пунктуации, которая не произносится. Это означает, что в лоджбане есть широкий спектр слов для цитирования других слов. Все лоджбан преобразуют текст в аргументный терм.

**lu** … **li'u** цитируют только грамматически правильный текст. Для цитирования любого лоджбанского текста мы используем цитаты **lo'u** … **le'u**.

> **— xu lo'u je le'u lojbo sumsmi**
> **— na ku sumsmi**
> _— Является ли "je" термом?_
> _— Нет._

<!-- -->

> **ma xe fanva zoi gy.What's up?.gy. la .lojban.**
> _Как перевести "What's up?" на лоджбан?_

### Внутренние термы

Используя **be**, вы можете заполнить не только слоты отношений, но также добавить модальные термы:

> **le xatra be de'i li vo cu se mrilu de'i li ze**
> _Это письмо, датированное 4-м, отправлено 7-го_

xatra
: $x_1$ - это письмо

Дата, помеченная как **de'i**, относится только к **xatra**. Сравните:

> **le xatra de'i li vo cu se mrilu de'i li ze**
> _Письмо, отправленное 4-го, доставляется 7-го_ (что бы это ни значило)

Без **be**, терм **de'i li vo** применялся бы ко всему отношению, а не к **xatra**. Мы хотим сказать, что первая дата относится только к письму, а вторая дата относится к отправке письма. Это означает, что в **le xatra be de'i li vo** часть **de'i li vo** (_4-е число, как дата_) применяется только к аргументу **le xatra**, а не ко всему предложению.

### Подробности о составных отношениях

Группировка термов в грамматике ложбана особенно важна, когда речь идет о tanru (составных отношениях). Способ, которым отношения группируются в tanru, определяет его значение. Например,

> _плохой музыкальный журнал_

имеет два значения на английском: плохой журнал о музыке или журнал о плохой музыке. В ложбане его эквивалент

> **le xlali zgike karni**

имеет только значение _журнал плохой музыки_, потому что первые два отношения (_xlali zgike_ — _плохая музыка_) группируются вместе. Важно изменить группировку отношений, чтобы tanru передавало задуманное значение. В ложбане есть несколько механизмов, чтобы tanru группировались правильно.

В русском мы используем скобки для структурирования текста. Аналогично, для tanru мы используем **ke** в качестве левой скобки и **ke'e** в качестве правой скобки.

**le xlali ke zgike karni** означает _плохой музыкальный журнал_.

Как видите, мы отделили **xlali** от остального tanru и сделали его применимым ко всему tanru. В конце tanru нет необходимости в **ke'e**, так как мы уже знаем, что он заканчивается здесь.

> **.i mi pu zi te vecnu le xlali ke zgike karni .i to'e zanru la'o gy.Eurythmics.gy.**
> _Я только что купил плохой музыкальный журнал. Он оскорбляет Eurythmics._

Это один из способов группировки компонентов в tanru. Другой способ - использовать **bo** в новой роли. Когда **bo** появляется между двумя компонентами, это означает, что эти компоненты группируются более плотно, чем все остальное. Таким образом, альтернативный способ сказать _плохой (музыкальный журнал)_ это

le xlali zgike bo karni
: плохой музыкальный-журналб плохой журнал музыки

**bo** здесь аналогично дефису в русском переводе. Это означает, что **zgike bo karni** должно считаться единым целым, к которому применяется **xlali** (_плохой_).

Таким образом, **bo** делает связи более плотными:

> **la .doris. e la .alis. o nai bo la .bob.**
> _Дорис и (либо Алиса, либо Боб)_

**ke** также может использоваться с союзами (хотя не с предложениями; у них есть свои скобки, **tu'e … tu'u**). Так что мы также можем сказать

> **la .doris. e ke la .alis. o nai la .bob.**

Помните, что правую скобку **ke'e** часто можно опустить без изменения значения (как в этом случае).

Предварительные союзы также часто используются, потому что они могут устранить необходимость в правых скобках:

> **ge la .doris. gi go nai la .alis. gi la .bob.**
> _Дорис и либо Алиса, либо Боб_

и

> **go nai ge la .doris. gi la .alis. gi la .bob.**
> _Либо Дорис и Алиса, либо Боб_

С предварительными союзами нет необходимости в **bo** или **ke**.

### «**co**» для изменения порядка в составных отношениях

Существует еще один способ переструктурирования составных отношений.

> **mi fanva se jibri**
> _Я профессиональный переводчик_

jibri
: $x_1$ - работа $x_2$

Если я хочу сказать, что я профессиональный переводчик с английского на немецкий, я могу использовать **be** и **bei**:

> **mi fanva be le dotco bei le glico be'o se jibri**
> _Я профессиональный переводчик на немецкий с английского._

dotco
: $x_1$ - немецкий

Факт того, что это было составное отношение, может быстро потеряться в речи из-за сложной структуры предложения. Здесь мы можем использовать слово **co**:

**co** - инвертирует составное отношение, делая правый компонент модифицирующим левый, а не наоборот. Любой предыдущий аргумент заполняет модифицируемый, любой следующий аргумент заполняет модификатор.

> **mi se jibri co fanva le dotco le glico**

Это то же самое отношение, что и предыдущее ложбанское, но намного проще понять. Обратите внимание, что любой аргумент перед составным отношением заполняет **se jibri**, в то время как любой следующий за ним заполняет только модифицирующий компонент: **fanva**.

Сила, с которой два компонента связаны с помощью **co**, очень слабая - даже слабее, чем обычная группировка составных отношений без использования группирующих слов. Это гарантирует, что в **co**-конструкции левый компонент всегда является модифицируемым компонентом, а правый компонент всегда модифицирует, даже если какая-либо из этих частей является составным отношением. Это делает **co**-конструкцию легкой для понимания:

> **ti pelxu plise co kukte**

читается как **ti (pelxu plise) co kukte**, что эквивалентно **ti kukte pelxu bo plise**. Это также означает, что **ke … ke'e** не может охватывать **co**.

Еще один пример:

> **mi merko limna co mutce certu**
> _Я очень опытный американский пловец._

merko
: $x_1$ - американец (в смысле США)

Вот список различных видов группировщиков в составных отношениях, от самого плотного до самого свободного:

1. **bo** и **ke … ke'e**
2. логические связки внутри составных отношений, такие как **je**
3. отсутствие группирующих слов
4. **co**

### Явное завершение аргументов

Маленькое слово **ku** может использоваться в конце аргумента, чтобы явно показать его правую границу. **ku** аналогично правой скобке в математике.

> **tu du le badna ku ui**
> **tu du le ui badna**
> _Это банан (ура!)_

В отличие от:

> **tu du le badna ui**
> _Это банан (ура, что это банан, а не что-то другое в природе!)_

### Избегание явного завершения
Еще один стиль речи включает избегание завершения. Вот некоторые общие случаи:

Удаление **li'u**, правой кавычки:

> **lu mi prami do li'u cu se cusku la .alis.**
> **lu mi prami do li'u se cusku la .alis.**
> **lu mi prami do cu se cusku la .alis.**
> _"Я тебя люблю", - сказала Алиса._

**li'u** может быть опущено здесь, потому что в одном предложении не может быть двух основных конструкций отношений. Поэтому мы сначала читаем часть **lu mi prami do**, а затем, когда видим **cu**, мы понимаем, что не можем продолжать эту цитату дальше. Мы предполагаем, что цитата закончилась, и продолжается внешнее предложение. Таким образом, не возникает никакой неоднозначности.

Устранение **ku'o**, правой границы придаточных предложений:

> **le prenu noi mi zgana ke'a ku'o ca tavla le pendo be mi**
> **le prenu noi mi zgana ke'a ca tavla le pendo be mi**
> *Человек, которого я наблюда, разговаривает сейчас с мои другом.*

**ku'o** может быть опущено здесь, когда придаточное предложение, которое нам нужно (**mi zgana ke'a**), заканчивается термом, в данном случае **ke'a**. После придаточного предложения начинается что-то другое, кроме терма, поэтому придаточное предложение не может продолжаться, и мы знаем, что оно успешно заканчивается без явных слов-ограничителей справа.

Аналогичный трюк заключается в том, чтобы всегда помещать **ke'a** в конце придаточного предложения:

> **le prenu noi ke'a melbi ku'o ca tavla le pendo be mi**
> **le prenu noi melbi fa ke'a ca tavla le pendo be mi**
> _The person who is pretty is now talking to my friend._

Однако в следующем случае требуется явное завершение:

> **le prenu noi mi zgana ke'a ku'o le pendo be mi ca tavla**
> _The person whom I'm observing is now talking to my friend._

потому что после придаточного предложения **mi zgana ke'a** мы выбрали поместить еще один терм (**le pendo be mi**), не относящийся к текущему придаточному предложению.

Полу-трюк здесь заключается в использовании **ce'e**:

> **le prenu noi mi ke'a zgana ce'e le pendo be mi ca tavla**
> _The person whom I'm observing is now talking to my friend._

Здесь мы завершаем придаточное предложение основной конструкцией **zgana**. Затем у нас есть союз **ce'e** и терм после (**le pendo be mi**). Поскольку **ce'e** может соединять только термы, мы знаем, что слева от **ce'e** у нас есть терм, который может быть только **le prenu noi mi ke'a**. Таким образом, сохраняется значение, и не возникает неоднозначности. Обратите внимание, что нам все равно нужно отдельное слово, **ce'e**, в таких случаях, поэтому, хотя мы устранили яркое слово-ограничитель, нам все равно пришлось ввести что-то другое.

Устранение **kei**, правой границы внутренних предложений:

> **mi cinmo le ka badri kei le tcini**
> **le ka badri cu se cinmo mi le tcini**
> **mi cinmo fi le tcini fe le ka badri**
> **mi cinmo le ka badri ce'e le tcini**
> _I feel sad regarding the situation._

> **mi stidi lo ka citka su'o da kei do**
> **mi stidi lo ka ce'u su'o da citka ce'e do**
> _Я предлагаю тебе что-нибудь съесть._

Как видите, никакой трюк не делает результат короче оригинала с использованием **kei**, поэтому для краткости вы можете использовать **kei**.

### Преобразование из множества в массу

> **le prenu cu pa moi le'i pendo be mi ku noi lu'o ke'a ca smaji**
> _Он первый среди моих друзей, которые молчат вместе._
> _Этот человек является первым среди множества моих друзей, которые сейчас, как толпа, молчат._

Квалификатор **lu'o**, помещенный перед аргументом, преобразует его в массу, состоящую из членов этого аргумента. В данном случае **ke'a** относится к множеству моих друзей **le'i pendo be mi**, а затем **lu'o** преобразует членов множества в массу, толпу моих друзей.

### Множества и подмножества

Некоторые инфинитивы могут подразумевать более одного **ce'u**:

> **le'i prenu cu simxu le ka prami**
> **le'i prenu cu simxu le ka ce'u prami ce'u**
> _Люди любят друг друга._

simxu
: члены множества $x_1$ взаимно делают $x_2$

Отношение **simxu** берет каждую возможную пару из указанного множества в аргументе $x_1$ и утверждает указанное отношение в аргументе $x_2$.

Если у нас есть три человека, это означает, что все они любят друг друга.

> **do ce la .alis. ce mi simxu le ka prami**
> **do ce la .alis. ce mi simxu le ka ce'u prami ce'u**
> _Ты, Алиса и я все любим друг друга._

ce
: союз: объединяет несколько аргументов в множество

Союз **ce** объединяет аргументы в множество. Таким образом, **do ce la .alis. ce mi** может быть более подробным способом представления **le'i prenu** из предыдущего примера, когда мы хотим назвать членов множества.

<pixra url="/assets/pixra/cilre/simxu_tunba.webp" caption="le'i ci prenu cu simxa le ka tunba" definition="The three people are all siblings to each other."></pixra>

Всего мы утверждаем 6 отношений:

1. Ты любишь Алису.
2. Ты любишь меня.
3. Алиса любит меня.
4. Алиса любит тебя.
5. Я люблю Алису.
6. Я люблю тебя.

Таким образом, **simxu** является удобным сокращением для выражения взаимных отношений.

Теперь рассмотрим пример:

> **le'i su'o cmima be le'i prenu cu simxu le ka prami**
> _Некоторые из людей любят друг друга._

cmima
: $x_1$ является членом множества $x_2$

В этом примере мы показываем, что подмножество людей вопроса (подмножество **le'i prenu**) имеет взаимную любовь.

Это позволяет нам передавать даже более сложные идеи:

> **le'i su'o citno cmima be le'i stati prenu cu simxu le ka prami**
> _Некоторые молодые члены группы умных людей любят друг друга._
> `Некоторые молодые члены группы умных людей любят друг друга.`

<!-- ## Логика второго порядка

Мы видели, что **da** (и **de**, **di**) является "переменной" в форме существительного с объявленными значениями, зависящими от заданных предложений.
Обычно он переводится как _существует X, существуют X такие, что …_

Однако, ради любопытства, я должен упомянуть серию глаголов, которые также служат цели "переменных", но в глагольной, то есть отношения форме:

>**su'o bu'a zo'u mi bu'a do**
>_Существует некоторое отношение или свойство: у меня есть это отношение к тебе._
> _Ты и я связаны хотя бы одним способом._

>**ro bu'a zo'u ga nai le'e mlatu cu bu'a gi la .dinas. bu'a**
>>_Для каждого возможного отношения или свойства: если у кошек оно есть, то у Дины оно тоже есть._ (Таким образом, мы предполагаем, что Дина - кошка.)

Основание для использования этих переменных-глаголов скрыто в формальной логике. Не нужно говорить, что они редко используются в речи, но вот один возможный пример:

su'o bu'a zo'u ge ge da na bu'a gi su'o da su'o de zo'u ge da .e de bu'a gi da manci de gi ro da ro de zo'u da bu'a .ije da manci de .inaja de bu'a
- исправьте предложение -->

<!-- ## Вещи, которые еще не формализованы в ложбане

Хотя ложбан может быть самым говоримым языком №1 в мире, его грамматика очень подробна. Тем не менее, есть некоторые вещи, которые еще не были формализованы.

Неизвестно, что означает **ta'e na** в отличие от **na ta'e**.

Неизвестно, как работать с **na go'i**.

Неизвестно, как работает xorlo, когда нам нужно явное преобразование между множествами и массами, как работать с множествами в общем, как использовать xorlo вместе со вторичной логикой, такой как bu'a.

postoxorlo работает с анафорой и внешними квантификаторами. -->

<!-- ## Нестандартная система связывания

Некоторые люди для связывания существительных вместо

- **a**, **e**, **o**, **u**

используют

- **ja**, **je**, **jo**, **ju**

То есть вместо

>**mi e do nelci le plise**
>_Мне нравятся яблоки, и тебе нравятся яблоки._

они говорят

>**mi je do nelci le plise**
>_Мне нравятся яблоки, и тебе нравятся яблоки._

Это нестандартный подход. Люди используют этот стиль, потому что в нем меньше союзов, которые нужно запоминать.

Но вам следует быть осторожными, чтобы не забыть **le** или числа для образования существительных: **mi nelci le plise je jisra** будет означать _Мне нравится что-то, что является яблоком (или яблоками) и соком_ (?!)

Правильное предложение использует **le** для образования каждого существительного:

>**mi nelci le plise je le jisra**
>_Мне нравятся яблоки и сок._

В стандартном подходе говорящий использует отдельный союз **e** при соединении существительных, и легче увидеть разницу и правильное значение:

>**mi nelci le plise .e le jisra**
>_Мне нравятся яблоки и сок._ -->