---
icon: 📕 
title: Грамматика
---

**CLL неофициальная** (в обиходе, *UnCLL*, *InCLL*) - это проект, организованный Глеки для регулярных экспериментальных неофициальных (не обязательно одобренных Logical Language Group) сборок книги «Complete Lojban Language».

*   Отправьте свой отзыв (обнаруженные ошибки, предложения, замечания) в одно из следующих мест:
    *   [Группа Lojban на Reddit](https://www.reddit.com/r/lojban/)
    *   [Группа Lojban на Facebook](https://www.facebook.com/groups/lojban)
    *   Прямой эфир: [чат в Telegram](https://t.me/lojban) или [чат в Discord](https://discord.gg/BVm4EYR)
    *   на <gleki.is.my.name@gmail.com> (Глеки&nbsp;Арксокуна), сопровождающий UnCLL.

## Релизы
### geklojban-1.2.15 Октябрь 2022
#### Скомпилированная версия
*   прочтите окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.15" и имеет название организации, опубликовавшей ее, отличное от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [в формате PDF](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [в формате HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [в формате HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
*   или прочтите так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.15 с UnCLL, версия 1.2.14 (опубликована в июле 2021 года). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочтите документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.14 июль 2021'

* исправлены опечатки и стилистические проблемы в хрестоматии (благодаря koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** заменено на **nunkilca'a** (благодаря up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) улучшен алгоритм тестирования tosmabru (благодаря vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) "matrix transpose" cmavo теперь использует верхний индекс T для оператора транспонирования
* Упоминания шрифта Helvetica заменены на упоминания шрифта Comic ("Comic" - это имя как минимум одного шрифта с открытым исходным кодом)
* исправлены другие незначительные опечатки (благодаря Matt Nazarian, mattfbacon, la-kanba)
* Изменения CSS, чтобы версии html лучше работали на устройствах в темном режиме (благодаря NathanHawks)
* UnCLL теперь имеет файлы визуальных различий от предыдущего релиза и отдельно для официального релиза.

[git исходный код UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Сравнение с версией 'geklojban-1.2.12 ноябрь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Сравнение между официальным изданием CLL v.1.1 (2016) и изданием UnCLL ноябрь 2020 года: git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* ["difference" PDF документ](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference_prefixed.pdf), который сравнивает geklojban-1.2.15 с официальным изданием CLL v.1.1 (2016). Вставки отмечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).

### geklojban-1.2.14 июль 2021

#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.14" и имя организации, опубликовавшей ее, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.14 с UnCLL, версия 1.2.12 (опубликована в ноябре 2020 года). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.11.1 октябрь 2020'

* это одно из главных улучшений. [Глоссарий слов Lojban](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) получил около 200 новых примеров предложений на Lojban с их переводом на английский язык. Учитывая, что количество основных слов в Lojban составляет около 2000, это означает, что выполнено ~10% этой задачи.
* исправлены ошибки с **bo**, **ke'e** в главе 5. 'Скалярная отрицательность selbri'
* исправлено неправильное имя одного аудиофайла
* больше улучшений в индексе: добавлены ZEhA и больше BAI
* лучше объяснить cmevla в соответствии с dotside
* добавлены недостающие точки в cmavo, где это необходимо
* исправлена пунктуация в переводе стихотворения 'Кубла-Хан'

[исходный код UnCLL в git](https://github.com/lojban/cll/compare/geklojban-master)

* [Сравнение с версией 'geklojban-1.2.12 ноябрь 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Сравнение между официальным изданием CLL v.1.1 (2016) и изданием UnCLL ноября 2020 года: git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.13 май 2021

#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что на титульной странице документ явно помечен как "geklojban-1.2.13", а имя организации, опубликовавшей его, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [в формате PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [в формате HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [в формате HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.13 с UnCLL, версия 1.2.12 (опубликована в ноябре 2020 года). В документе вставки помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли использовать Cmd+F или Ctrl+F, чтобы быстро найти различия в PDF-документе. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.11.1 октябрь 2020'

* добавлены новые красивые иллюстрации главы от [la-ninpre](https://github.com/la-ninpre)
* добавлен перевод стихотворения 'In Xanadu' в хрестоматию
* исправлена странная дата попытки аксиоматической теории множеств от [simpson](https://github.com/MostAwesomeDude)
* исправлено определение **toldi** (_бабочка_)
* исправлено неверное утверждение, которое подразумевало, что fuhivla не имеют rafsi
* сделано объяснение **le vi tavla ba klama** менее вводящим в заблуждение (исправление внес [mezohe](https://github.com/mezohe))
* Матрицы более чем двух измерений могут быть построены с использованием **pi'a** или **sa'i** с соответствующей подписью, обозначающей измерение... Метки могут быть любыми, что поддерживает **xi**, например **pa** или **mlatu bu**.
* Глава 5: восстановление упоминания о группировке **bo** в разделе NAhE и добавление **bo** в один пример (исправление внес [mezohe](https://github.com/mezohe))
* Глава 7: исправление утверждения о **ra'o** в примере 7.39 (исправление внес [mezohe](https://github.com/mezohe))
* Глава 2: исправление диаграммы (предикат -> предикация) (исправление внес [mezohe](https://github.com/mezohe))
* добавлены недостающие точки в cmavo
* исправлены другие незначительные ошибки, элементы индексов, скрипты компиляции и т.д.

[исходный код git UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [По сравнению с версией 'geklojban-1.2.12 ноябрь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Сравнение между официальным изданием CLL v.1.1 (2016) и изданием UnCLL ноябрь 2020 года: git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.12 ноябрь 2020

#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.12" и имя организации, опубликовавшей его, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.12 с CLL, опубликованным в 2016 году (релиз 2016-08-27). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.11.1 октябрь 2020'

* Добавлено стандартное произношение {u} в главе IPA (от [Vexatos](https://github.com/Vexatos))
* Подстрочные символы в глоссах обрабатываются соответствующим образом (ошибка замечена [gr-g](https://github.com/gr-g))
* Исправлена грамматическая ошибка в примере 17.36 (ошибка замечена [kotwys](https://github.com/kotwys))
* Частица **ri'u** отсутствовала в разделе 10.28 (как заметил [gr-g](https://github.com/gr-g)). Добавлено
* В примере 7.12 первое место **lafti** применяется к человеку. Предикат изменен на **lafmuvgau** (который находится в заметках к определению **lafti**)
* В английском тексте заменить .) на ). где необходимо
* Отображение квадратного корня, бесконечности и золотого сечения phi с фактическими символами
* Исправлена неправильный перевод **levi rozgu cu sofi'upanova'e xunre**
* другие незначительные исправления
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.12)

#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.11.1 октябрь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Сравнение с версией 'geklojban-1.2.3 январь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.12)

### geklojban-1.2.11.1 октябрь 2020
#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.11" и имеет название организации, опубликовавшей его, отличное от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    *   [формат HTML - вся книга в одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* или прочитайте так называемый документ "разница" в формате PDF, который сравнивает geklojban-1.2.11 с CLL, опубликованным в 2016 году (релиз от 27 августа 2016 года). В документе вставки помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия разницы без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ разницы в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.10 август 2020'

* Добавлены аудио ссылки (аудио от la tcakoi, la .lindar., la .aionys.) в HTML-версии книги "разбитой на разделы" и "разбитой на главы"
* исправлены несколько опечаток
* добавлены китайские иероглифы к одному примеру на китайском языке
* 1.2.11.1 исправление ошибок: сделать кнопки аудио на HTML-страницах действительно работающими
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.11)

#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.10 August 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Сравнение с версией 'geklojban-1.2.3 January 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)
### geklojban-1.2.10 August 2020
#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.10" и имеет название организации, опубликовавшей его, отличное от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    *   [формат HTML, одна страница - одна секция книги](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* или прочитайте так называемый документ "разница" в формате PDF, который сравнивает geklojban-1.2.10 с CLL, опубликованным в 2016 году (релиз от 27 августа 2016 года). В документе вставки помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия разницы без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ разницы в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.9 July 2020'

* Добавлен объем хрестоматии (выбранные тексты) после последней главы
* точки никогда не опускаются в словах, даже в индексе слов Lojban
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.10)
#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.9 July 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Сравнение с версией 'geklojban-1.2.3 January 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)

### geklojban-1.2.9 Июль 2020
#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.9" и имя организации, опубликовавшей его, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    *   [формат EPUB](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.9 с CLL, опубликованным в 2016 году (релиз 2016-08-27). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.8.1 Июнь 2020'

* Версия HTML теперь имеет таблицы и примеры, которые можно горизонтально прокручивать на узких (например, мобильных устройствах) экранах. Это делает версию HTML более удобной для мобильных устройств.
* EPUB снова генерируется (отсутствовал в версии 1.2.8.1)
* Корейские и китайские символы теперь отображаются с использованием шрифта Noto CJK
* места, такие как "$x_1$", теперь отображаются с индексированными числами
* Пример в разделе 16.9 {naku zo'u la djan. klama} не соответствовал другим примерам вокруг него, поэтому он был заменен на {naku zo'u mi klama le zarci} (ошибка, замеченная [Corbin Simpson](https://github.com/MostAwesomeDude))
* определение слова {bu'u} добавлено в список других грамматических частиц класса FAhA
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.9)

#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.8.1 июнь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Сравнение с версией 'geklojban-1.2.3 январь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.9)
### geklojban-1.2.8.1 июнь 2020
#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.8.1" и имеет название организации, опубликовавшей его, отличное от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [в формате PDF](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [в формате HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [в формате HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* или прочитайте так называемый документ "разница" в формате PDF, который сравнивает geklojban-1.2.8.1 с CLL, опубликованным в 2016 году (релиз от 27 августа 2016 года). В документе вставки помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия разницы без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ разницы в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.7 May 2020'

* Добавлена новая орфография "zbalermorna" с "диакритическими" знаками. Она явно указана как неофициальная. Её символы ("буквы") отображаются соответствующим шрифтом. Благодарности [Джеку Хамберту](https://jackhumbert.github.io/zbalermorna/) и его команде (la saski'o, la xaspeljba и другим) за шрифт и пересмотр объяснения орфографии.
* Индексы были пересмотрены (почти все их 4000 записей). Многие записи были изменены для удобства использования или перемещены из индекса слов Lojban в общий индекс или наоборот.
* Правило использования запятой [откатилось](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) обратно к версии из CLL 1.1
* Лучший алгоритм сравнения для просмотра различий между версиями (без лишнего беспорядка)
* Версия 1.2.8.1 исправление ошибок: исправлены проблемы с отображением символов zbalermorna в документе PDF
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)
#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.7 May 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Сравнение с версией 'geklojban-1.2.3 January 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)
### geklojban-1.2.7 May 2020

#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.7" и имя организации, опубликовавшей ее, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [формат EPUB](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.7 с CLL, опубликованным в 2016 году (релиз 2016-08-27). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в PDF-документе с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.6 April 2020'

* "Cmavo tu'a используется при формировании абстракций и подробно объясняется в разделе 11.11.", но в этом разделе он не упоминается. Изменена ссылка на раздел 11.10. Ошибку заметил [Robert Baruch](https://github.com/RobertBaruch).
* все ссылки на selma'o перемещены из индекса слов lojban в общий индекс в приложении.
* Раздел 10.18. Фраза "В отличие от -nai противоположной отрицательности, скалярная отрицательность временных форм не ограничивается PU и FAhA:" противоречила следующему тексту раздела. Заменено на "Пример скалярной отрицательности FAhA:"
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.7)#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.6 April 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Сравнение с версией 'geklojban-1.2.3 January 2020': git difference](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git difference](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)
### geklojban-1.2.6 April 2020

#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.6" и имя организации, опубликовавшей ее, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [формат EPUB](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.6 с CLL, опубликованным в 2016 году (релиз от 27 августа 2016 года). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с предыдущей версией 'geklojban-1.2.5 март 2020'

* новые красивые изображения высокого разрешения для нескольких глав, сделанные [la ninpre](https://github.com/la-ninpre) (возможное нарушение авторских прав отклонено)
* правило "запятые никогда не требуются" теперь временно ограничено запятыми, которые являются разделителями слогов
* добавлены ссылки на различные selma'o в индекс слов lojban
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.6)#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.5 март 2020': git различия](https://github.com/lojban/cll/compare/geklojban-1.2.5...geklojban-1.2.6)
* [Сравнение с версией 'geklojban-1.2.3 январь 2020': git различия](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.6)
### geklojban-1.2.5 март 2020

#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.5" и имя организации, опубликовавшей его, отличается от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [формат EPUB](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* или прочитайте так называемый документ "различий" в формате PDF, который сравнивает geklojban-1.2.5 с CLL, опубликованным в 2016 году (релиз от 27 августа 2016 года). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия различий без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ различий в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с версией 'geklojban-1.2.3 January 2020'
* временно убрано спорное использование ni+ce'u
* использован лучший пример для NU JA NU, удалено расширение NU JA NU (которое может быть неоднозначным в случае нескольких NU JA NU в одном bridi)
* добавлены китайские примеры с hanzi и более красивым pinyin
* Dotside: добавление начального глоттального звука в IPA-транскрипцию в одном примере
* добавлено "FA selma'o" в индекс lojban-слов
* правило "запятые никогда не требуются" временно ограничено только cmevla
* исправлены несколько опечаток
* UTF-символы добавлены так, как они есть (вместо их описаний)
*   Dotside реализован
*   понятия "cmene" и "cmevla" теперь разделены
*   **sumti tcita** переименовано в **sumtcita**
*   **mi kucli le jei broda** теперь **mi kucli tu'a le jei broda**
*   Словарь с примерами теперь технически возможен: глоссарий теперь может иметь примеры под определениями слов (и делает это для слова **coi** в качестве демонстрации)
*   rafsi для **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** изменены в соответствии с cmavo.txt с 2002 года.
*   исправлено огромное количество опечаток и мелких ошибок
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.5)

#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.4 февраль 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Сравнение с версией 'geklojban-1.2.3 январь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)

### geklojban-1.2.4 февраль 2020
#### Скомпилированная версия
*   прочитайте окончательный документ, который будет использоваться для печати и публикации. Обратите внимание, что титульная страница явно помечена как "geklojban-1.2.4" и имеет название организации, опубликовавшей его, отличное от LLG; это сделано для того, чтобы подчеркнуть, что это не публикация LLG:
    *   [формат PDF](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [формат EPUB](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [формат HTML, одна страница - один раздел книги](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [формат HTML - вся книга на одной очень длинной странице](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* или прочитайте так называемый документ "разница" в формате PDF, который сравнивает geklojban-1.2.4 с CLL, опубликованным в 2016 году (релиз от 27 августа 2016 года). Вставки в документе помечены зеленым цветом и префиксом "ins\`", а удаления - красным цветом и префиксом "del\`". Префиксы добавлены, чтобы вы могли быстро найти различия в документе PDF с помощью Cmd+F или Ctrl+F. Есть [альтернативная версия разницы без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (но тогда вам придется вручную прокручивать документ, чтобы найти различия).
*   или прочитайте документ разницы в формате HTML:
    *   [с префиксами](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [без префиксов](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Краткий список изменений по сравнению с версией 'geklojban-1.2.3 январь 2020'
* исправлены несколько опечаток
* добавлены символы UTF, как они есть (вместо их описаний)
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.4)
#### Сравнение исходного кода с предыдущими версиями
* [Сравнение с версией 'geklojban-1.2.3 январь 2020': git разница](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Сравнение с официальным изданием CLL v.1.1 (2016)': git разница](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)
### geklojban-1.2.3 январь 2020

#### Краткий список изменений

*   Реализован Dotside
*   Концепции "cmene" и "cmevla" теперь разделены
*   **sumti tcita** переименован в **sumtcita**
*   **mi kucli le jei broda** теперь **mi kucli tu'a le jei broda**
*   Словарь с примерами теперь технически возможен: глоссарий теперь может иметь примеры под определениями слов (и делает это для слова **coi** в качестве демонстрации)
*   rafsi для **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** изменены в соответствии с cmavo.txt от 2002 года.
*   исправлено огромное количество опечаток и мелких ошибок
#### [исходный код git](https://github.com/lojban/cll/compare/geklojban-1.2.3)