---
title: Сломаны ли глаголы в ложбане?
---

<div class="lojbo simple_blockquotes"></div>

## Вопрос

Кажется, что изучение определений глаголов в Lojban (языке ложбан), таких как

> *$x_1$ бежит по поверхности $x_2$, используя конечности $x_3$ с походкой $x_4$*

может быть сложным, потому что почти у каждого глагола есть своя уникальная структура мест. Нельзя ли было использовать падежи и предлоги, как в русском? Почему Lojban разработан таким образом?

## Ответ

Русский язык функционирует аналогично ложбану в прагматическом смысле. У него есть глаголы с подразумеваемой структурой мест. Основное отличие заключается в том, что словари ложбана явно указывают структуру мест глагола, в то время как большинство русских словарей этого не делают. Причина такой системы заключается в том, что иметь отдельный предлог для каждого места было бы еще более трудоёмким и иногда даже невыполнимым.

Наличие ограниченного набора предлогов сделало бы язык чрезвычайно субъективным и не универсальным. Например, в русском мы говорим

> Я завишу от тебя.

но на английский эта фраза переводится буквально как

> Я завишу на тебе.

а на испанский и португальский буквально как

> Я завишу тебя.

Некоторые предлоги, сочетающиеся с определенными глаголами, могут создавать необычные значения, что приводит к еще большей случайности, чем в текущей системе с $x_1$, $x_2$ и т.д.

Важно отметить, что большинство глаголов Lojban имеют только три места. Только около 30 основных глаголов (gismu) имеют пять мест. Кроме того, для того, чтобы говорить свободно на Lojban, вам не нужно знать структуру мест каждого основного глагола. Например, важно ли знать структуру мест для "тригонометрической синусной функции", когда речь идет о приготовлении пищи?

Действительно, "Я дарю тебе подарок" не требует предлогов, в то время как у других глаголов есть структуры мест. Однако здесь не требуется больше запоминания. Английский язык требует изучения метафор. Почему "Я даю ТЕБЕ" и "Я говорю ТЕБЕ", когда процессы совершенно разные?

Также рассмотрим следующие переводы:

> [Английский] *I think of you* *Я думаю тебя*

> [Русский] *Я думаю о тебе*

> [Испанский] *Yo pienso en ti* (Я думаю в тебе)

Некоторые структуры мест в Lojban менее прямолинейны, чем другие, как и в английском языке. Например, почему это "Этот фильм приятен мне", а не "Мне нравится этот фильм"?

Глаголы Lojban, как и глаголы английского языка, могут быть сгруппированы в рамки с идентичной структурой мест, например:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=mlatu&bangu=en&versio=masno">mlatu</a> - $x_1$ является кошкой вида $x_2$

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=gerku&bangu=en&versio=masno">gerku</a> - $x_1$ является собакой вида $x_2$

## Структура места легко изучается, но...

Часто структуру места легко изучить. Однако концепция движения представляет собой случайный набор структур мест. Рассмотрим следующее:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a> - $x_1$ (объект) перемещается к месту назначения/получателю $x_2$ [вдали] от начала $x_3$ по пути/маршруту $x_4$.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> - $x_1$ бегает на поверхности $x_2$, используя конечности $x_3$ с походкой $x_4$.

Почему бы не иметь одну структуру места для всех?

## Ответ

<a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a>, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> и <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=cadzu&bangu=en&versio=masno">cadzu</a> изображают похожий процесс с очень разных точек зрения. В <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> начало и конец не важны; акцент делается на форме. Это не "бегать куда-то откуда-то", как в английском языке. Пожалуйста, не путайте английские глоссы с фактическим процессом, который описывают глаголы Ложбана. Быть в состоянии <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> означает иметь определенную походку, касаясь поверхности конечностями и делать это быстро.

Человек, использующий беговую дорожку, не имеет никаких точек "куда" или "откуда", но просто бегает, оставаясь на одном месте. Это хороший пример состояния <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a>, не находясь в состоянии <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=klama&bangu=en&versio=masno">klama</a>.

В заключение, Ложбан не является копией русского или английского языка, хотя практика разгооворов на ложбане и русско-ложбанский словарь могут создать такое впечатление.

Проблема скорее заключается в неоднозначности русского языка, чем в самом языке Ложбан.

Наконец, можно использовать tanru, например, bajra klama (бежать-приходить), чтобы выразить и бег и приход в определенное место.