## Lição 9. Conjunções lógicas

As conjunções lógicas em Lojban são baseadas em 4 primitivas: **.a**, **.e**, **.o**, **.u**. Nesta lição, vamos cobri-las em detalhes.

### Conjunções lógicas para argumentos

Aqui estão as conjunções que combinam duas palavras: _este_ e _aquele_.

- **ti .a ta** = _este e/ou aquele_

 > **mi ba vitke le mamta .a le tamne**
 >_Eu vou visitar a mãe ou o primo._

 Note que **.a** também pode ser traduzido como _pelo menos um dos dois valores_, e assim deixa aberta a possibilidade de eu visitar ambos em algum momento.

- **ti .e ta** = _este e aquele_

 > **mi ralte le pa gerku .e le re mlatu**
 >_Eu tenho um cachorro e dois gatos._
 >`Eu tenho um cachorro e dois gatos.`

- **ti .o ta** = _ou este e aquele, ou nenhum_

 > **mi ba vitke le mamta .o le tamne**
 >_Eu vou visitar tanto a mãe quanto o primo, ou nenhum deles._

- **ti .u ta** = _este, e talvez aquele_, _este quer ou não aquele_

 > **mi ba vitke le mamta .u le tamne**
 >_Eu vou visitar a mãe quer eu visite o primo ou não._

 **.u** apenas enfatiza que o segundo valor não afeta a verdade da frase.

Colocar **nai** após uma conjunção nega o que está à direita dela. Colocar **na** antes de uma conjunção nega o que está à esquerda dela:

- **ti .e nai ta** = _este e não aquele_

 > **mi nelci la .bob. e nai la .alis.**
 >_Eu gosto do Bob, mas não da Alice._
 >`Eu gosto do Bob e não da Alice`

 Também podemos dizer **ti .e nai ku'i ta** (_este, mas não aquele_) adicionando um sabor de contraste para o segundo argumento.

- **ti na .e ta** = _não este, mas aquele_

 > **mi nelci la .alis. na .e la .bob.**
 >_Eu não gosto da Alice, mas gosto do Bob._
 >`Eu gosto da Alice não e do Bob`

 Isso pode soar um pouco estranho para falantes de português (`Eu gosto da Alice não...`), então você pode preferir trocar os argumentos e usar **.e nai** em vez disso: **mi nelci la .bob. e nai la .alis.** ou até mesmo **mi nelci la .bob. i mi na ku nelci la .alis.** terão o mesmo significado.

- **ti na .e nai ta** = _nem isso nem aquilo (nenhum)_

 > **mi nelci la .alis. na .e nai la .bob.**
 > *Eu não gosto nem da Alice nem do Bob*

Negar com outras conjunções primitivas pode não parecer intuitivamente utilizável, você pode apenas aprendê-las a partir de exemplos:
- **ti .a nai ta** = _isso se aquilo_, _para isso acontecer, a condição exclusiva é que_

 > **mi ba vitke le mamta .a nai le tamne**
 > *Eu visitarei a mãe, mas para isso acontecer, eu preciso visitar o primo.*

 Assim, **ti .a nai ta** significa que **ta** é necessário (mas pode não ser a única condição) para que **ti** seja aplicado.

- **ti .o nai ta** = _ou isso ou aquilo_

 > **mi ba vitke le mamta .o nai le tamne**
 > *Eu visitarei ou a mãe ou o primo.*

 Se eu quiser dizer que vou visitar ou a mãe ou o primo, mas não ambos, eu preciso de **.o nai** (_ou/ou_). É diferente de **.a** (_e/ou_), onde posso visitar ambos.

- **ti na .u ta** = não influencia _(não isso, mas talvez aquilo)_
- **ti na .u nai ta** = não influencia _(não isso, mas talvez aquilo)_

- **ti se .u ta** = _talvez isso, e aquilo_
- **ti se .u nai ta** = _talvez isso, mas não aquilo_

<!-- **se** é usado apenas para **.u** porque em outros casos não tem efeito no significado. -->

Esses são usados para conectar argumentos. Para conectar partes de relações compostas, usamos conjunções semelhantes: **ja**, **je**, **jo**, **ju**. Então, em vez do ponto (pausa), usamos **j** aqui.

<!-- É comum usar **ja**, **je**, **jo**, **ju** também para conectar argumentos. -->

### Conjunções lógicas para frases

Esta é uma forma mais concisa de dizer:

> **mi ralte le pa gerku .i je mi ralte le re mlatu**
> *Eu tenho um cachorro, e eu tenho dois gatos.*

**.i je** une duas frases com um _e_ lógico, mostrando que ambas as frases fazem parte de um pensamento e são verdadeiras.

Aqui estão exemplos de outras conjunções para frases:

> _**la .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os.**
> *Romeu ama Julieta, e Julieta ama Romeu.*

Isso significa que ambas as afirmações são verdadeiras, ou seja, Romeu e Julieta se amam.

O mesmo se aplica a outras conjunções:

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Romeu ama Julieta e/ou Julieta ama Romeu._

Isso significa que um deles ama o outro, e talvez ambos amem.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Ou Romeu ama Julieta ou Julieta ama Romeu._

Aqui, ou Romeu ama Julieta (mas Julieta não o ama), ou Julieta ama Romeu (mas ele não a ama).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _Para Romeu amar Julieta, é necessário que Julieta ame Romeu._

Isso significa que se Julieta ama Romeu, ele definitivamente a ama, mas ele pode amá-la de qualquer maneira (a única possibilidade impossível é Julieta amar Romeu, mas ele não a amar).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Ou Romeu ama Julieta e Julieta ama Romeu, ou nenhum dos dois eventos acontece._

Isso significa que se Julieta ama Romeu, ele a ama, e se ela não o ama, ele não a ama.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Romeu ama Julieta, independentemente de Julieta amar Romeu ou não._

Observe como "Romeo" foi adaptado para o Lojban: a combinação "eo" é impossível em Lojban, então usamos "e'o" e adicionamos uma consoante no final do nome dele.

Observe que **da** se refere à mesma entidade quando várias frases estão conectadas.

### Conjunções lógicas dentro de relações compostas

> **le melbi xunre fonxa**
> _telefones lindamente vermelhos_

<!-- -->

> **le melbi je xunre fonxa**
> _telefones bonitos e vermelhos_

Outras conjunções também fazem sentido:

> **mi nelci ro tu voi xajmi ja melbi prenu**
> _Eu gosto de todas as pessoas que são engraçadas ou bonitas (ou ambas)._

<!-- -->

> **mi nelci ro tu voi xajmi jo nai melbi prenu**
> _Eu gosto de todas as pessoas que são ou engraçadas ou bonitas._

Isso pode ser explicado, por exemplo, se eu considerar as qualidades de humor e boa aparência incompatíveis, ou seja, uma mistura dos dois seria demais.

> **mi nelci ro tu voi xajmi ju melbi nanmu**
> _Gosto de todas as pessoas que são engraçadas (sejam bonitas ou não)._

E mais uma vez, não devemos esquecer a diferença entre conectar argumentos e conectar partes de construções de relações compostas:

> **mi ba vitke le pa pendo .e le pa speni**
> _Eu visitarei um amigo e um cônjuge._

<!-- -->

> **mi ba vitke le pa pendo je speni**
> _Eu visitarei um amigo e cônjuge._

A última frase de Lojban significa que o amigo também é cônjuge.

### Conjunções lógicas para caudas de relações

> **pu ku mi uantida la .soker. gi'e klama le zdani gi'e citka le badna**
> *Eu joguei futebol, fui para casa, comi a banana.*

uantida
: relação não oficial: $x_1$ joga o jogo $x_2$, participa do jogo $x_2$

**gi'e** conecta várias relações em uma com alguns termos compartilhados. Veja isso: Ele se expande para **eu joguei futebol e eu fui para casa** ... o que seria mais longo.

Com **gi'e**, mantemos a cabeça da relação constante e especificamos os termos após cada construção de relação (**joguei futebol**, **fui para casa** ...).

Assim, ao usar **gi'e**, temos várias relações na cauda unidas, mas tendo uma cabeça comum.

**gi'e** tem a mesma vogal final que **je** e significa _e_.

Outras conjunções para unir caudas de relações:

- **gi'a** para _e/ou_
- **gi'o nai** para _ou … ou_
- **gi'u** para _seja ou não_ etc.

Essas conjunções têm o mesmo final que aquelas da série **.a**, **.o**, **.u**.

### Termos em frases com várias caudas

Observe que os tempos como termos e os tempos anexados à relação principal da relação fazem diferença quando aplicados a sentenças que contêm várias relações anexadas:

- Um termo no cabeçalho da frase é aplicado a todos os seus finais:

 >**mi ba'o cu citka le badna gi'e pinxe**
 >_Não como mais a banana e não bebo mais._

 Aqui, **ba'o** é aplicado a **citka le badna gi'e pinxe**.

- Uma palavra tensa que faz parte da relação é aplicada apenas a essa relação:

 >**mi ba'o citka le badna gi'e pinxe**
 >_Eu não como mais banana, mas bebo._

 Aqui, **ba'o** é aplicado apenas à relação implícita **mi citka le badna**, mas não à relação implícita **mi pinxe**.

### Perguntas de escolha

Outro tipo de "ou" em português pode ser encontrado em perguntas:

> **— xu do pinxe le tcati .o nai le ckafi?**
> **— pinxe**
> _— Você vai beber chá ou café?_
> _— Sim._

Essa é uma resposta peculiar, mas perfeitamente razoável: _Sim, eu vou beber chá ou café._

Isso acontece porque "ou" tem vários significados em português:

1. _A ou B_ pode significar _ou A, ou B, mas não ambos_. Usamos **.o nai** aqui.
2. _A ou B_ pode significar _A ou B ou ambos_. Usamos **.a** aqui.
3. _A ou B?_ pode ser uma pergunta significando _escolha entre A e B, qual deles você escolhe?_ Usamos **ji** aqui.

Assim, no último caso, usamos uma conjunção de pergunta separada **ji**:

> **— do pinxe le tcati ji le ckafi?**
> _— Você vai beber chá ou café?_

Possíveis respostas:

> **le tcati .e le ckafi**
> _Chá e café._

<!-- -->

> **le tcati**
> _Chá._

<!-- -->

> **le ckafi**
> _Café._

Também é possível usar conjunções ao responder:

> **.e** — <span>_Ambos_ (o primeiro e o segundo item são escolhidos)</span>

<!-- -->

> **.e nai** — <span>_O primeiro (chá)_ (apenas o primeiro item é escolhido)</span>

<!-- -->

> **na .e** — <span>_O segundo (café)_ (apenas o segundo item é escolhido)</span>

<!-- -->

> **na .e nai** — <span>_Nenhum_ (nem o primeiro nem o segundo item são escolhidos)</span>

Você pode fazer perguntas da mesma maneira sobre os outros tipos de conjunções que vimos. A conjunção interrogativa para relações de cauda é **gi'i**, para relações compostas — **je'i**, para sentenças — **.i je'i**.

Perguntas indiretas são feitas usando **ji kau**:

Considere que o garçom pergunta a um visitante:

> **- le'e dembi ji le'e rismi**
> _- Feijão ou arroz?_

Depois que o visitante responde, o garçom sabe se o visitante quer comer cordeiro ou carne bovina:

> **ba le nu le vitke cu spusku kei le bevri cu djuno le du'u le vitke cu djica le nu ri citka le'e dembi ji kau le'e rismi**
> _Depois que o visitante responde, o garçom sabe se o visitante quer comer feijão ou arroz._

### Conjunções de antecipação

> **ge do gi mi**
> _tanto você quanto eu_

<!-- -->

> **ge nai do gi mi**
> _Não você, mas eu_

<!-- -->

> **ge do gi nai mi**
> _Você, mas não eu_

<!-- -->

> **go nai do gi mi**
> _Ou você ou eu_

A conjunção de antecipação **ge** significa _e_, mas é colocada antes do primeiro termo do argumento, com **gi** separando os dois argumentos. Essa série é paralela a outras conjunções: **ga**, **ge**, **go**, **gu**, assim como **ga nai**, **ge nai**, **go nai**, etc. O separador **gi** é o mesmo para todas elas.

Usar essas conjunções é uma questão de conveniência:

> **mi citka ge nai le badna gi le plise**
> _Eu como não a banana, mas a maçã._

Aqui, assim como em português, _não_ é colocado antes do primeiro argumento.

**ge** e palavras dessa série também podem ser usadas para conectar relações:

> **ge mi dansu gi mi zgipli le pipno**
> _Eu tanto danço quanto toco piano._

zgipli
: $x_1$ toca o instrumento musical $x_2$

le pipno
: piano

> **.i ga nai pu zi carvi gi ca cilmo**
> _Se tem chovido recentemente, está molhado agora._