## Lição 7. Letras, referindo-se a relações, datas

### Nomes das letras em Lojban

Cada letra tem um nome em Lojban.

A tabela a seguir representa o alfabeto básico de Lojban e como pronunciar as letras (abaixo de cada letra):

<table>
<tbody><tr>
<td>'
</td>
<td><b><font  class="guibutton" color="#FF1493">a</font></b>
</td>
<td>b
</td>
<td>c
</td>
<td>d
</td>
<td><b><font  class="guibutton" color="#FF1493">e</font></b>
</td></tr>
<tr>
<td><b>.y'y.</b>
</td>
<td><b>.a bu</b>
</td>
<td><b>by.</b>
</td>
<td><b>cy.</b>
</td>
<td><b>dy.</b>
</td>
<td><b>.ebu</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>f
</td>
<td>g
</td>
<td><b><font  class="guibutton" color="#FF1493">i</font></b>
</td>
<td>j
</td>
<td>k
</td>
<td>l
</td></tr>
<tr>
<td><b>fy.</b>
</td>
<td><b>gy.</b>
</td>
<td><b>.i bu</b>
</td>
<td><b>jy.</b>
</td>
<td><b>ky.</b>
</td>
<td><b>ly.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>m
</td>
<td>n
</td>
<td><b><font class="guibutton" color="#FF1493">o</font></b>
</td>
<td>p
</td>
<td>r
</td>
<td>s
</td></tr>
<tr>
<td><b>my.</b>
</td>
<td><b>ny.</b>
</td>
<td><b>.o bu</b>
</td>
<td><b>py.</b>
</td>
<td><b>ry.</b>
</td>
<td><b>sy.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>t
</td>
<td><b><font  class="guibutton" color="#FF1493">u</font></b>
</td>
<td>v
</td>
<td>x
</td>
<td><b><font  class="guibutton" color="#FF1493">y</font></b>
</td>
<td>z
</td></tr>
<tr>
<td><b>ty.</b>
</td>
<td><b>.u bu</b>
</td>
<td><b>vy.</b>
</td>
<td><b>xy.</b>
</td>
<td><b>.y bu</b>
</td>
<td><b>zy.</b>
</td></tr></tbody></table>

Como você pode ver:

- para obter o nome de uma vogal, adicionamos a palavra **bu**.
- para obter o nome de uma consoante, adicionamos **y.** à consoante.
- a palavra para **'** (apóstrofo) é **.y'y**.

Podemos soletrar palavras usando esses nomes. Por exemplo, CNN será **cy. ny. ny.**

<!-- Uma letra maiúscula sozinha tem um significado especial. Ela denota o nome dessa letra:

**A** é o mesmo que **.abu**, **B** é o mesmo que **by.** e assim por diante. Eles têm o mesmo significado e até mesmo são pronunciados da mesma forma que **.abu**, **by.** etc. Então _CNN_ também pode ser escrito como **CNN** em Lojban e ainda será pronunciado e terá o mesmo significado que **cy. ny. ny.** -->

### Letras em vez de ‘_ele_’ e ‘_ela_’

Uma sequência de um ou mais nomes de letras pode funcionar como um pronome, fornecendo um método alternativo para se referir a argumentos mencionados anteriormente na fala.

> **la .alis. pu klama le nurma .i le nurma cu melbi la .alis.**
> **la .alis. pu klama le nurma .i ri melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi .a bu**
> _Alice foi para o campo. A área rural é bonita para Alice._
> _Alice foi para o campo. É bonito para ela._

Todas as variantes em Lojban acima têm o mesmo significado.

Como a primeira letra em **.alis.** é **a** (ignorando o ponto) e a primeira letra em **nurma** é **n**, podemos usar palavras de letras para se referir a esses argumentos correspondentes:

- **.a bu** se refere a **la .alis.**
- **ny.** se refere a **le nurma**

Esse método pode ser mais conveniente do que o português _el_ ou _ela_, ou até mesmo o Lojban **ri** ou **ra**. Ele nos permite tornar a fala mais concisa e precisa, sem precisar repetir nomes potencialmente longos ou outros termos de argumento repetidamente.

No entanto, é importante observar que pode haver situações em que queremos nos referir de volta, por exemplo, a **le nurma**, mas outro argumento começando com **n** aparece no meio tempo, tornando **ny.** incapaz de se referir à área rural. Nesses casos, a solução mais rápida é repetir todo o argumento, ou seja, dizer **le nurma**:

> **bu'u le nurma la .alis. pu penmi la .nik. i ri se zdani bu'u le nurma**
> _No campo, Alice encontrou Nick. Ele tem sua casa no campo._

zdani
: ...é uma casa para...

se zdani
: ...tem uma casa..., ...mora em...

Se um nome consistir em várias cmevla, você pode usar as primeiras letras delas para se referir a esse nome. O mesmo se aplica a relações compostas:

> **la .djan.smit. cu citka le glare stasu .i dy.sy. nelci fy.sy.**
> _John Smith está comendo a sopa quente. Ele gosta dela._

glare
: ...é quente

**dy.sy.** é um pronome único. O mesmo se aplica a **fy.sy.**.

Se você precisar colocar vários pronomes um após o outro, separe-os com a palavra **boi**:

> **mi klama la .paris. la .moskov.**
> _Eu vou de Moscou para Paris._

<!-- -->

> **mi klama py. boi my.**
> _Eu vou de M para P._

A frase **mi klama py. my.** significaria _Eu vou de PM_, o que teria um significado diferente.

> **la .tom.silver. pu zvati .i je'u ty. sy. boi .ui pu sidju mi**
> _Tom Silver estava presente. E na verdade, TS (yay!) me ajudou._

Se você colocar uma interjeição após essas letras, separe-as com **boi**. Sem **boi**, as interjeições se referirão à última letra.

### Diferentes formas de dizer 'nós' em Lojban

Em Lojban, existem vários pronomes com significado semelhante a 'nós':

mi'o
: você e eu

mi'a
: nós sem você

ma'a
: você, eu e outros

Portanto, ao falar, você precisa ter mais cuidado com o significado de 'nós' que você precisa.

E finalmente:

mi
: eu ou os falantes

**mi** também pode significar 'nós'! Lojban não faz distinção entre singular e plural por padrão. Portanto, se várias pessoas estiverem falando juntas, **mi** (que se refere a um ou mais falantes) é perfeitamente correto para 'nós'. Na prática, você geralmente encontrará **mi** usado assim quando uma pessoa está presumindo falar (ou com mais frequência, escrever) em nome de outros.

Alguns exemplos:

> **mi prami do**
> _Eu te amo._

<!-- -->

> **mi'a ba penmi do**
> _Nós vamos te encontrar._

<!-- -->

> **ma'a remna**
> _Nós todos somos humanos._

<!-- -->

> **mi djica le nu do cliva**
> _Nós queremos que você vá embora._

cliva
: $x_1$ sai

### «**ri**» em vez de ‘_ele_’ e ‘_ela_’

Anteriormente, aprendemos sobre o pronome **ri**:

ri
: pronome: refere-se ao argumento anterior que acabou de ser mencionado (ignorando pronomes estáveis como **mi**, **do**, palavras para _nós_)

> **mi catlu le nanmu .i ri melbi**
> _Eu olho para o homem. Ele é bonito._

melbi
: $x_1$ é bonito(a) / bonito(a) / bonito(a) para alguém $x_2$

**ri** refere-se ao argumento anterior completo usado no texto ou no discurso de alguém:

> **la .alis. cu sipna bu'u le sledi'u pe la .alis.**
> _Alice dorme no quarto de Alice._
> `Alice dorme-no o quarto-de-Alice.`

> **la .alis. cu sipna bu'u le sledi'u pe ri**
> _Alice dorme no seu quarto._
> `Alice dorme no quarto de [termo de argumento anterior].`

sledi'u
: $x_1$ é um quarto para o propósito $x_2$ (proposição)

O **ri** é equivalente a repetir o último argumento, que é **la .alis.** aqui.

Um aspecto a ser observado é que **ri** não repete **le sledi'u pe ri** (que também é um argumento), porque **ri** é parte desse argumento e, portanto, esse argumento não é "anterior", não está concluído quando **ri** aparece. Isso impede que **ri** se refira recursivamente a si mesmo.

Outro exemplo:

> **le du'u le prenu cu melbi cu se djuno ri**
> _Que a pessoa é bonita é conhecido por ela mesma._

O **ri** se refere a **le prenu** (e não a **le du'u le prenu cu melbi** embora ambos os argumentos estejam completos: **le prenu** começa por último, após o início de **le du'u le prenu cu melbi**).

A relação dentro de formas **sei** forma um texto paralelo. **ri** ignora argumentos dentro de relações **sei**:

> **mi viska la .lukas. sei la .doris. pu cusku .i ri jibni la .micel.**
> _Eu vejo Lucas, — disse Doris. Ele está perto de Michelle._

Neste exemplo, **ri** não pode se referir a **la .doris.** Simplesmente ignoramos toda a relação **sei la .doris. pu cusku** ao decidir a que **ri** deve se referir.

Pronomes que são estáveis ao longo do diálogo ou história são ignorados por **ri**. Nós os repetimos diretamente:

> **mi lumci mi**
> _Eu me lavo._
> `Eu lavo-me`

lumci
: $x_1$ lava $x_2$

> **mi prami mi**
> _Eu me amo._
> `Eu amo-me.`

No entanto:

- Os pronomes **ti**, **ta**, **tu** são substituídos por **ri** porque você pode ter mudado o que está apontando, então repetir **tu** pode não ser eficaz.
- Da mesma forma, **ri** em si (ou melhor, seu antecedente) pode ser repetido por um **ri** posterior. Na verdade, uma sequência de palavras **ri** sem outros argumentos intermediários sempre repetirá o mesmo argumento:

 >**la .alis. cu catlu le nanmu .i ri melbi .i ri co'a zgana .a bu**
 >_Alice percebe um homem. Ele é bonito. Ele percebe Alice._

zgana
: observar

co'a zgana
: começar a observar, notar

Neste exemplo, o segundo **ri** tem o primeiro **ri** como seu antecedente, que por sua vez tem **le nanmu** como seu antecedente. Todos os três se referem à mesma coisa: o homem.

No final, você decide o que, onde e quando usar na fala: o método com **le** + relação, o método com nomes de letras ou com **ri**.

<!-- ### "_Eu mesmo, eles mesmos_"

Em línguas eslavas, as pessoas dizem literalmente _Eu lavo a mim mesmo_. Para ficar mais próximo do estilo eslavo, podemos usar **lo nei**.

>**mi nelci mi**
>_Eu gosto de mim mesmo._

>`Eu gosto de mim.`

É o mesmo em significado que:

>**mi nelci lo nei**
>_Eu gosto de mim mesmo._

>**mi lumci mi**
>**mi lumci lo nei**
>_Eu lavo a mim mesmo._

>**la ian ca lumci lo nei**
>**la ian ca lumci ri**
>_Yan lava a si mesmo._

**lo nei** se refere ao primeiro substantivo da relação atual.

Lembre-se de que **ri** não pode se referir a pronomes como **mi**, então **lo nei** pode ser preferido no último exemplo. Ao alterar o primeiro substantivo, **lo nei** não muda, o que é bastante útil:

>**mi lumci lo nei i do lumci lo nei i la ian cu lumci lo nei**
>_Eu lavo a mim mesmo. Você lava a si mesmo. Yan lava a si mesmo._

>**la .doris. cu pensi lo nei**
>_Doris pensa em si mesma._

>**pa gerku cu batci lo nei**
>_Um cachorro morde a si mesmo._

---

**nei** funciona bem quando uma frase contém apenas uma relação. Mas quando ela tem várias relações embutidas, podemos precisar de algo diferente. Em

>**la .doris. cu djuno lo du'u la .alis. cu prami lo nei**
>_Doris sabe que Alice ama a si mesma._

**lo nei** se refere a **la .alis.**

E se quisermos nos referir a Doris? Aqui está uma solução:

>**la .doris. cu djuno lo du'u la .alis. cu prami vo'a**
>_Doris sabe que Alice a ama._

Portanto, enquanto **lo nei** se refere ao primeiro substantivo da relação atual, **vo'a** se refere ao primeiro substantivo da frase atual.

Quando não há relações incorporadas, essas duas palavras significam a mesma coisa:

>**la .alis. cu prami vo'a** é o mesmo que **la .alis. cu prami lo nei**
>_Alice se ama._

- **vo'a** se refere ao primeiro substantivo da frase atual.
- **vo'e** se refere ao segundo substantivo da frase atual.
- **vo'i** se refere ao terceiro substantivo da frase atual.
- **vo'o** se refere ao quarto substantivo da frase atual.
- **vo'u** se refere ao quinto substantivo da frase atual.

---

**lo nei** pode dar resultados engraçados quando aplicado a ações mútuas:

>**la .alis. e la .kevin. cu cinba lo nei**
>_Alice beija a si mesma, e Kevin beija a si mesmo._

Aqui está a solução:

>**la .alis. jo'u la .kevin. cu cinba zu'ai**
>_Alice e Kevin se beijam_

Significa a mesma coisa que:

>**la alis cu cinba la kevin i je la kevin cu cinba la alis**
>_Alice beija Kevin, e Kevin beija Alice._

**zu'ai** é colocado em segundo lugar no verbo. Ele mostra a ação mútua entre o primeiro lugar e o segundo lugar. Os membros dessa ação mútua são colocados no primeiro lugar e conectados com a conjunção **jo'u**. -->

### «**go'i**» para a relação anterior

> **la .alis. cu klama le barja .i la .alis. cu viska le nanmu**
> **la .alis. cu klama le barja .i le go'i cu viska le nanmu**
> _Alice vai ao bar. Ela vê um homem._

- **le go'i** se refere ao primeiro lugar da relação anterior.
  - **go'i** apresenta mais uma maneira de se referir de volta a um argumento que precisamos.
- **le se go'i** se refere ao segundo lugar da relação anterior.
- **le te go'i** se refere ao terceiro lugar, e assim por diante.

Exemplos:

> **.i la .alis. cu zgana le nanmu .i ri melbi**
> **.i la .alis. cu zgana le nanmu .i le se go'i cu melbi**
> _Alice observa um homem. Ele é bonito._

Aqui, **le se go'i** se refere ao segundo lugar ($x_2$) da relação anterior, que é **le nanmu**.

Outro exemplo:

> _Bill viu Nick. Ele o acertou._

O português não se preocupa com precisão aqui - _ele_ apenas significa _alguma pessoa do sexo masculino mencionada em algum lugar próximo no texto ou deduzida do contexto_. Bill acertou Bob, ou Bob acertou Bill? Não sabemos. Em Lojban, podemos dizer:

> **la .bil. pu viska la .nik. .i le se go'i cu darxi le go'i**
> _Bill viu Nick. Nick acertou Bill._

No entanto, na maioria dos casos, **ri** ou palavras de letra podem ser usadas:

> **la .bil. cu viska la .nik. i ri darxi la .bil.**
> **la .bil. cu viska la .nik. i ny. darxi by.**
> _Bill viu Nick. Nick acertou Bill._

**go'i** em si é uma palavra de relação e, portanto, possui uma estrutura de lugar:

> **mi tatpi .i do ji'a go'i**
> _Estou cansado. E você também._

Quando dizemos **do go'i**, repetimos a relação anterior, mas substituímos seu primeiro lugar por **do**. Em outras palavras, **do ji'a go'i** aqui é o mesmo que dizer **do ji'a tatpi**.

<!-- ### O que **go'i** copia?

Interjeições como **pei** (quando usadas sozinhas), **xu**, **.ui**, **.u'i**, **je'u** aquelas formadas com **sei** e a interjeição de pergunta não são partes de relações. Portanto, elas não são copiadas por **go'i**.

Termos como **na ku**, **pu**, negadores à esquerda como **na'e**, **no'e**, **to'e** são partes de relações.

Assim, **go'i** copia a relação anterior com essas partículas:

>— **la .bob. na ku prami la .alis.**
>— _**go'i**_

>— _Não é verdade que Bob ama Alice._

>— _Ele não (ama)._

> **— la .bob. na'e prami la .alis.**
> _— Bob não ama Alice._

> **— go'i**
> _— Ele não (ama)._

Para dizer "Não, ele realmente a ama", usamos o verbo necessário diretamente:

> **— la .bob. na ku prami la .alis.**
> _Bob não ama Alice._

> **— ja'a ku go'i**
> _Bob realmente a ama._

Aqui, **ja'a ku** substitui **na ku** na relação original. -->

### Hora do dia

> **— ma tcika ti**
> _Que horas são?_

<!-- -->

> **— li cacra bu pa pa**
> _Onze horas_

tcika
: $x_1$ (horas, minutos, segundos) é o tempo do evento $x_2$

Em Lojban, os tempos são sempre os tempos de algo. Então perguntamos qual é o tempo de **ti**, significando _este evento/coisa_, ou, em outras palavras, _agora_.

**li**, um prefixo para números, também é usado para indicar horários.

- **cacra bu** é um prefixo que indica que o número de horas segue em seguida. O horário de 24 horas é usado quase sempre em Lojban.
- **mentu bu** é um prefixo que indica que o número de minutos segue em seguida.
- **snidu bu** é um prefixo que indica que o número de segundos segue em seguida.

> **li cacra bu pa pa mentu bu pa no**
> _11:10 (Dez minutos depois das onze)_

<!-- -->

> **li cacra bu pa pa mentu bu pa no snidu bu pa ci**
> _11 horas, 10 minutos e 13 segundos._

<!-- -->

> **li cacra bu pa no mentu bu mu no**
> _10:50, dez para as onze_

Se quisermos dar o horário de um evento, em vez de apenas dizer a hora, preenchemos o segundo lugar:

> **li cacra bu pa no tcika le nu mi klama**
> _As dez horas é o horário em que eu chego._

Usando o termo **de'i**, podemos obter uma frase com uma sonoridade mais natural:

> **mi klama de'i li cacra bu pa no**
> _Eu estou chegando às dez horas._

de'i
: às... (hora), em... (data)

E um exemplo útil:

> **ca tcika le nu .ei sipna**
> _É hora de dormir._

### Datas

> **— ma detri ti**
> _Qual é a data de hoje?_

> **— li mastu bu ze djedi bu pa**
> _É 1º de julho._

detri
: $x_1$ (ano, mês, dia) é a data/horário do evento $x_2$

Outra opção:

> **— ma ca detri**
> _— Qual é a data agora?_

- **nanca bu** é um prefixo que indica que o ano segue em seguida.
- **masti bu** é um prefixo que indica que o mês segue em seguida.
- **jefydei bu** é um prefixo que indica que o dia da semana segue em seguida.
- **djedi bu** é um prefixo que indica que o dia segue em seguida.

Prefixos com números após eles podem ser usados em qualquer ordem (vamos usar dígitos para mostrar os números):

> **li djedi bu 2 ca detri**
> _Hoje é o segundo dia do mês._

<!-- -->

> **li masti bu 4 djedi bu 1 ca detri**
> _Hoje é 1º de abril._

<!-- -->

> **li djedi bu 5 masti bu 7 nanca bu 2005 detri le nu mi jbena**
> _O quinto dia de julho (sétimo mês), ano 2005 é quando eu nasci._

jbena
: $x_1$ nasce

Também podemos usar **de'i**:

> **mi ba klama de'i li masti bu pano**
> _Eu vou chegar em outubro._

Partículas em Lojban podem ser escritas sem espaços entre elas, como em **pano**, que é o mesmo que **pa no**.

Para os dias da semana, geralmente, segunda-feira é o primeiro dia:

> **mi gunka de'i li jefydei bu pa**
> *Eu trabalho na segunda-feira.*

<!-- -->

> **mi gunka ca ro se detri be li jefydei bu re**
> *Eu trabalho todas as terças-feiras.*

<!-- -->

> **xu do pu zvati la .paris. de'i li jefydei bu ci**
> *Você estava em Paris na quarta-feira?*

### Especificando intervalos de tempo

> **mi nanca li re re**
> *Eu tenho 22 anos.*

nanca
: $x_1$ tem duração de $x_2$ (número) anos

**nanca** especifica a duração e, para dizer _dois anos de duração_, preencha o segundo lugar com um número precedido por **li**.

> **le verba cu masti li re**
> *A criança tem dois meses de idade.*

masti
: $x_1$ tem duração de $x_2$ meses

> **le nu carvi cu djedi li ci**
> *Está chovendo há três dias.*

djedi
: $x_1$ (evento) tem duração de $x_2$ (número) dias inteiros

### Novos verbos a partir de uma escala: ‘_diferente de_’ — «**na'e**», ‘_anti-_’ — «**to'e**»

> **mi na'e nelci do**
> *Eu não gosto de você.*

Partículas "escalares à esquerda" (à qual **na'e** pertence) são colocadas à esquerda das construções que afetam, formando uma escala:

A própria escala pode ser especificada usando a etiqueta modal **ci'u**.

- **je'a** = _de fato (a posição afirmativa na escala)_. A palavra **je'a** confirma o significado de uma parte de uma frase. Geralmente, é omitida.

 > **mi je'a nelci do**
 > *Eu realmente gosto de você.*

- **je'a** = _de fato (a posição afirmativa na escala)_. A palavra **je'a** confirma o significado de uma parte de uma frase. Normalmente, é apenas omitido.

 > **mi je'a nelci do**
 > _Eu realmente gosto de você._

- **na'e** = _non- (exceto a posição afirmativa na escala)_

 > **mi na'e nelci do**
 > _Eu além de gostar de você._

 > **le stizu cu na'e xunre be ci'u le ka skari**
 > _A cadeira não é vermelha._
 > `A cadeira não é vermelha na escala de ter uma cor`

- **no'e** = _na verdade não (ponto médio da escala)_. A palavra **no'e** dá a uma parte de uma frase um significado intermediário.

 > **mi no'e nelci do**
 > _Quanto a te amo ou odeio, sou indiferente a você. Eu não gosto nem odeio você._

- **to'e** = _anti-, dis-, mis- etc. (oposto na escala)_. A palavra **to'e** dá a uma parte de uma frase um significado oposto. É semelhante ao prefixo português _anti-_.

 > **mi to'e nelci do**
 > _Eu te odeio._
 > `Eu anti-gosto de você`

**na'e** é mais vago do que **no'e** e **to'e**; pode significar qualquer um deles quando você não se importa com o significado exato.

### Termos modais complexos: ‘_porque_’ — «**ki'u**», ‘_apesar de_’ — «**to'e ki'u nai**»

Termos modais podem ser negados de duas maneiras para obter significados relacionados.

ki'u
: termo modal: porque, devido a uma explicação ..., que pode ser explicado pelo fato de ...

> **ki'u ma do cusku zo co'o**
> _Por que você diz adeus?_

Adicionando o sufixo **nai** muda o significado:

ki'u nai
: termo modal: não porque, que não pode ser explicado pelo fato de ...

> **mi se nabmi ki'u nai le nu mi laldo ce'e ki'u le nu mi na certu**
> _Estou com problemas não porque sou velho, mas porque não sou um especialista._

nabmi
: $x_1$ é um problema para $x_2$

se nabmi
: $x_1$ tem um problema $x_2$

laldo
: $x_1$ é velho ...

certu
: $x_1$ é um especialista, profissional em propriedade $x_2$

Adicionando **to'e** define a negação do significado:

to'e ki'u
: porque não, que pode ser explicado pelo fato de que não acontece que ...

> **mi jinga to'e ki'u le nu mi pu surla**
> _Eu ganhei porque não tinha descansado._

Combinando tanto **to'e** quanto **nai**, obtemos:

to'e ki'u nai
: apesar da razão ..., não porque não, que não pode ser explicado pelo fato de que não acontece ...

> **.i to'e ki'u nai le nu le mamta cu sanga su'o melbi kei le verba na snada lo ka sipna**
> _Apesar da mãe cantar lindamente, a criança não consegue dormir._

Usando **se** inverte a ordem dos argumentos. Caso contrário, o significado é preservado.

se ki'u
: portanto, o que explica o fato de ...

> **ra bilma se ki'u le nu ra na pu cusku zo coi do**
> _Ele está doente, o que explica por que ele não disse oi para você._

se ki'u nai
: mas não segue que ..., o que não explica o fato de ...

> **ra bilma se ki'u nai le nu ra klama le drata tcadu**
> _Ele está doente, o que não explica por que ele está indo para outra cidade._

se to'e ki'u
: ..., a ausência do qual explica o fato de ...

> **ra bilma se to'e ki'u le nu ra klama le drata tcadu**
> _Ele não está doente, e isso explica por que ele está indo para outra cidade._

se to'e ki'u nai
: ..., a ausência do qual não explica o fato de ...

> **ra bilma se to'e ki'u nai le nu ra penmi le mikce**
> _Ele não está doente, e isso não explica por que ele está encontrando o médico._

mikce
: $x_1$ é um médico