## Lição 5. Termos modais, «**da**», sua posição relativa

### Como os termos modais se referem à relação?

Alguns termos modais, como aqueles que descrevem o tempo (tensão), conectam a relação atual com aquela no argumento após eles:

> **mi cadzu ca le nu le cipni cu vofli**
> _Eu ando quando os pássaros voam._

cadzu
: … anda

le cipni
: o pássaro/os pássaros

vofli
: … voa para …

> **mi pu cadzu fa'a le rirxe**
> _Eu andei em direção ao rio._

<!-- -->

> **mi pu cadzu se ka'a le rirxe**
> _Eu andei até o rio._

se ka'a
: chegando a …

fa'a
: diretamente em direção a …

Termos modais não removem os lugares ordenados (**fa**, **fe**, **fi**, **fo**, **fu**) da relação:

> **mi klama se ka'a le rirxe le dinju**
> **mi klama fe le rirxe .e le dinju**
> _Eu vou para um rio, para uma casa._

No primeiro exemplo, **se ka'a** conecta **le rirxe** e então o segundo lugar de **klama** segue, sendo preenchido com **le dinju**. É o mesmo que preencher apenas o segundo lugar de **klama** duas vezes, conectando-os com **.e** — _e_.

No entanto, **se ka'a** é útil quando aplicado a outras relações como **cadzu** em um exemplo anterior.

> **le prenu pu cadzu tai le nu ri bevri su'o da poi tilju**
> _A pessoa andava como se estivesse carregando algo pesado._

bevri
: $x_1$ carrega $x_2$

tai
: termo modal: como …, parecido com …

<!--
- Alguns termos descrevem relações do primeiro lugar da relação com o substantivo após o termo:

>**mi jinga se rai le ka clani**
>_Eu venço sendo o mais alto._

se rai
: termo de **se traji**: sendo o mais em …

Aqui, $x_1$ da relação corresponde ao mais alto em comparação especificado após **se rai**.

- Por fim, alguns termos descrevem relações do primeiro lugar da relação e da própria relação com o substantivo após o termo:

>**Eu gosto mais de morangos do que de outras frutas.**
>_Out of berries, I like strawberries the most._

te rai
: termo de **te traji**: preferindo entre ...

lo fragari
: morangos

lo jbari
: frutas

$x_1$ da relação descreve o mais um nesta comparação, a própria relação descreve a comparação.

O dicionário explica esses casos complicados onde a relação definida pelo termo pode causar dificuldades. Na prática, a relação geralmente é clara a partir dos exemplos fornecidos. -->

### Usando «**ne**» + termo. «**se mau**» — ‘_mais do que ..._’

> **mi ne se mau do cu melbi**
> *Eu sou mais bonito(a) do que você.*

se mau
: termo de **se zmadu**: mais do que; a própria relação descreve a comparação

Este exemplo é semelhante a

> **mi zmadu do le ka melbi**
> *Eu excedo você em beleza.*

Em outras palavras, a relação principal **melbi** é semelhante ao terceiro lugar de **zmadu**, que especifica os critérios de comparação. Mais dois exemplos:

> **mi prami do ne se mau la .doris.**
> *Eu amo você mais do que a Doris.*

<!-- -->

> **mi ne se mau la .doris. cu prami do**
> _Eu te amo mais do que Doris._
> _Eu te amo mais do que Doris te ama._
> `Eu (mais do que Doris) te amo.`

Mais exemplos:

> **mi nelci le'e pesxu ne se mau le'e jisra**
> *Eu gosto mais de geleia do que de suco.*

pesxu
: ... é geleia

> **le'e pesxu cu zmadu le'e jisra le ka mi nelci**
> *Geleia excede suco em quanto eu gosto.*
> `A geléia excede o suco no quanto eu gosto.`

E agora uma frase interessante:

> _Bob gosta mais da Betty do que da Mary._

Isso pode ter dois significados diferentes em português!

1. Bob gosta da Betty e ele gosta menos da Mary.
2. Bob gosta da Betty, mas a Mary também gosta da Betty, embora não tanto quanto o Bob!

Estamos comparando a Betty com a Mary em relação a como o Bob gosta delas?

Ou, em vez disso, estamos comparando o Bob com a Mary em relação a como eles gostam da Betty?

O português é ambíguo nesse aspecto.

No Lojban, podemos diferenciar os dois significados anexando **se mau** aos argumentos adequados:

> **la.bob. ne se mau la .maris. cu nelci la .betis.**
> _Bob (comparado a Mary) gosta mais de Betty. Mary gosta menos de Betty._
> _Bob gosta mais de Betty do que de Mary._

<!-- -->

> **la .bob. cu nelci la .betis. ne se mau la .maris.**
> _Bob gosta de Betty, e ele gosta menos de Mary._
> _Bob gosta mais de Betty do que de Mary._

### Comparisons: ‘_igual_’, ‘_o mesmo_’

> **mi dunli le mensi be mi le ka mitre .i ku'i mi na ku du le mensi**
> *Eu sou tão grande quanto minha irmã, mas não sou ela.*
> _Eu sou igual à minha irmã em metros, mas não sou idêntico(a) a ela._

dunli
: $x_1$ (qualquer tipo) é igual a $x_2$ (qualquer tipo) em $x_3$ (propriedade de $x_1$ e $x_2$ com **kau**)

mitre
: $x_1$ tem $x_2$ metros de comprimento

du
: $x_1$ (qualquer tipo) é idêntico(a) a $x_2$ (qualquer tipo)

**dunli** compara dois lugares para uma única propriedade, enquanto **du** compara para identidade. Minha irmã e eu temos a mesma altura, mas não somos a mesma pessoa. Clark Kent e Superman têm admiradores diferentes, mas são a mesma pessoa.

O mesmo vale para esses dois verbos:

> **mi frica do le ka nelci ma kau**
> *Nós diferimos um do outro no que gostamos.*
> _Eu difiro de você no que gosto._

<!-- -->

> **le drata be mi cu kakne le ka sidju**
> *Alguém que não sou eu é capaz de ajudar.*

frica
: $x_1$ (qualquer tipo) difere de $x_2$ (qualquer tipo) em $x_3$ (propriedade de $x_1$ e $x_2$ com **kau**)

drata
: $x_1$ (qualquer tipo) não é o mesmo que $x_2$ (qualquer tipo)

### O conceito de ‘_apenas_’

> **mi .e no le pendo be mi cu nelci le'e badna**
> _Eu e nenhum dos meus amigos gostam de bananas._

O conceito de _não apenas_ é expresso de forma semelhante:

> **mi .e le su'o pendo be mi cu nelci le'e badna**
> _Não sou só eu que gosto de banana entre meus amigos._
> _Eu e alguns dos meus amigos gostamos de bananas._

<!-- Uma forma mais precisa:

> **Eu sou o único que gosta de bananas entre meus amigos.**
> _Eu sou o único que gosta de bananas entre meus amigos._ (aliás, implicando que você é amigo de si mesmo)

se steci
: $x_1$ é o único em $x_2$ (propriedade de $x_1$) entre $x_3$ (conjunto) -->

<!-- Note que esse exemplo implica que você é amigo de si mesmo :) Caso contrário, por favor, use uma afirmação ainda mais precisa:

> **Eu sou o único que gosta de bananas entre o conjunto de mim e meus amigos.** -->

<!-- Negando isso, temos:

> **não é verdade que apenas eu gosto de bananas.**
> _It's not true that only I like bananas._

— talvez ninguém goste de bananas, talvez eu + outros gostem. -->

<!-- Mais um exemplo interessante:

> **Apenas quem tenta tem sucesso.**
> _Only the one who tries succeeds._
> `Quem tenta é o único que tem sucesso.`

> **Apenas quem apenas tenta falha.**
> _The only who only tries fails._
> `Aquele que apenas tenta e nada mais falha.`

troci
: $x_1$ tenta fazer $x_2$ (propriedade de $x_1$)

snada
: $x_1$ tem sucesso em fazer $x_2$ (propriedade de $x_1$)
.
fliba
: $x_1$ falha em fazer $x_2$ (propriedade de $x_1$)

E mais uma solução:

> **Todos que têm sucesso tentaram.**
> _Everyone who succeeds tried._

ro
: número: cada, todo

Como você pode ver, o Lojban oferece diferentes maneiras de dizer o mesmo, algumas das quais podem diferir significativamente das formas em inglês. -->

### ‘_A maioria_’, ‘_muitos_’ e ‘_muito_’

Palavras como _a maioria_ e _muitos_ também são números em Lojban:

<table>
<tbody><tr>
<td><b>ro</b>
</td>
<td><i>cada</i>
</td></tr>
<tr>
<td><b>so'a</b>
</td>
<td><i>quase todos</i>
</td></tr>
<tr>
<td><b>so'e</b>
</td>
<td><i>a maioria</i>
</td></tr>
<tr>
<td><b>so'i</b>
</td>
<td><i>muitos</i>, <i>muitos</i>
</td></tr>
<tr>
<td><b>so'o</b>
</td>
<td><i>alguns</i>
</td></tr>
<tr>
<td><b>so'u</b>
</td>
<td><i>poucos</i>
</td></tr>
<tr>
<td><b>no</b>
</td>
<td><i>zero</i>, <i>nenhum</i>
</td></tr>
<tr>
<td><b>su'e</b>
</td>
<td><i>no máximo</i>
</td></tr>
<tr>
<td><b>su'o</b>
</td>
<td><i>no mínimo</i>
</td></tr>
<tr>
<td><b>za'u</b>
</td>
<td><i>mais de...</i>
</td></tr>
<tr>
<td><b>du'e</b>
</td>
<td><i>demais</i>
</td></tr></tbody></table>

Alguns exemplos:

> **su'e re no le prenu ba klama**
> *No máximo 20 pessoas virão.*

<!-- -->

> **su'o pa le prenu cu prami do**
> *Pelo menos uma pessoa te ama.*

### ‘_nunca_’ — «**no roi**», ‘_sempre_’ — «**ro roi**»

Termos que especificam o número de vezes:

- **no roi** = _nunca_
- **pa roi** = _uma vez_
- **re roi** = _duas vezes_
- **ci roi** = _três vezes_

...

- **so'i roi** = _muitas vezes_
- **so'u roi** = _algumas vezes_
- **du'e roi** = _muitas vezes demais_
- **ro roi** = _sempre_

> **mi du'e roi klama le zarci**
> _Eu vou ao mercado com muita frequência._

zarci
: $x_1$ é um mercado

> **mi pu re roi klama le zarci**
> _Eu fui ao mercado duas vezes._

Sem o **pu**, a construção **re roi** pode significar que fui ao mercado uma vez, mas a segunda vez que estarei lá só acontecerá no futuro. Essas partículas relacionadas ao tempo podem ser usadas com um argumento após elas:

> **mi klama ti pa roi le jeftu**
> _Eu venho aqui uma vez por semana._

### ‘_pela primeira vez_’ — «**pa re'u**», ‘_pela última vez_’ — «**ro re'u**»

- **pa re'u** = _pela primeira vez_
- **re re'u** = _pela segunda vez_

…

- **za'u re'u** = _novamente_
- **ro re'u** = _pela última vez_

A partícula relacionada ao tempo **re'u** funciona como **roi**, mas indica o número de iterações em que o evento ocorre.

Compare:

> **mi pa roi klama le muzga**
> _Eu visitei o museu uma vez._

<!-- -->

> **mi pa re'u klama le muzga**
> _Eu visitei o museu pela primeira vez._

<!-- -->

> **mi za'u roi klama le muzga**
> _Eu visitei o museu várias vezes._

<!-- -->

> **mi za'u re'u klama le muzga**
> _Eu visitei o museu novamente._

<!-- -->

> **mi za'u pa roi klama le muzga**
> _Eu visitei o museu mais de uma vez._

<!-- -->

> **mi za'u pa re'u klama le muzga**
> _Eu visitei o museu não pela primeira vez (talvez pela segunda/terceira etc.)_

vitke
: visitar (alguém ou algo)

Observe a diferença entre:

za'u re'u
: novamente, não pela primeira vez

re re'u
: pela segunda vez (aqui também, nenhum contexto é necessário e até o número exato de vezes é dado)

### Partículas modais: sua posição dentro de uma relação

> **le nu tcidu kei ca cu nandu**
> _Ler está difícil agora._

<!-- -->

> **ca ku le nu tcidu cu nandu**
> _Agora, ler está difícil._

Termos simples sem argumentos após eles podem ser movidos ao redor da frase adicionando **ku** depois deles.

**ku** impede que os termos de argumento seguintes sejam anexados a esses termos. Compare:

> **ca le nu tcidu cu nandu**
> _Quando estou lendo, é difícil._

Aqui estão vários lugares onde as partículas modais podem ser colocadas.

- O termo modal modifica a relação à direita dele:

 >**ca ku mi citka**
 >_Agora eu como._

 — aqui o termo é marcado com a palavra **ku** como sendo completo.

 >**ca le cabdei mi citka**
 >_Hoje eu como._

 — aqui o termo tem um argumento depois dele.

 >**mi ca citka**
 >_Eu como agora._

 — aqui a partícula modal é parte da construção da relação principal e sem um argumento.

- O termo modal é aplicado à relação inteira:

 >**mi citka ca**
 >_Eu como agora._

 — aqui o termo modal está no final da relação.

### Unindo declarações com modais

> **mi pinxe le jisra ca le nu do co'i klama le zdani**
> _Eu estou bebendo o suco quando você chega em casa._

<!-- -->

> **mi pinxe le jisra .i ca bo do co'i klama le zdani**
> _Eu estou bebendo o suco, e ao mesmo tempo você chega em casa._

Os dois exemplos transmitem o mesmo significado. A segunda opção é mais usada quando qualquer uma das relações originais soa pesada.

Outro uso é mover os termos modais para fora do escopo de outros termos modais:

> **mi na ku te vecnu ki'u le nu kargu**
> _Não é verdade que eu compro porque é caro._

Neste exemplo, pode-se supor que eu só compro coisas se forem caras. No entanto, esse não é o caso.

Aqui, **na ku** nega que _eu compro coisas porque são caras_. **na ku** é aplicado à relação inteira, assim ele "cobre" **ki'u**.

> **mi na ku te vecnu .i ki'u bo kargu**
> _Eu não compro. É porque é caro._

Neste caso, eu não compro coisas. Por quê? Porque são caras. Talvez eu prefira apenas coisas baratas.

Aqui, **ki'u** é colocado em outra frase. Assim, **na ku** não abrange ele.

Ambos os exemplos podem ser traduzidos como _Eu não compro porque é caro._ No entanto, eles têm significados diferentes.

Uma regra especial é usar **.i ba bo** e **.i pu bo**. Compare:

> **mi cadzu pu le nu mi citka**
> _Eu ando antes de comer._

<!-- -->

> **mi cadzu .i ba bo mi citka**
> _Eu ando, e então eu como._

**.i ba bo** significa _depois, então_. A frase após **.i ba bo** se refere a algo que ocorreu posteriormente ao que ocorreu na relação anterior.

**pu** é alterado para **ba**, e vice-versa. Essa regra especial para Lojban foi feita por analogia às línguas naturais. Portanto, você só precisa lembrar desse comportamento especial dessas duas palavras.

### Coisas existentes, '_há ..._'

Na verdade, existem três palavras na série **da**: **da**, **de** e **di**. Nós as usamos ao nos referirmos a objetos diferentes em um mesmo discurso:

> **ci le mlatu cu citka re le finpe**
> _Há três gatos, há dois peixes para cada gato, e cada gato come dois peixes._

Se você precisar de mais palavras desse tipo em um mesmo discurso, adicione um sufixo **xi** a elas e, em seguida, qualquer número (que podemos chamar de índice). Assim,

- **da xi pa** é o mesmo que simplesmente **da**,
- **da xi re** é o mesmo que **de**,
- **da xi ci** é o mesmo que **di**
- **da xi vo** é o quarto "algo" e assim por diante...

### Tópico e comentário. «**zo'u**»

Às vezes, é útil mostrar o tópico de uma relação e, em seguida, fazer um comentário sobre ele:

> **le'e finpe zo'u mi nelci le'e salmone**
> _Quanto aos peixes, eu gosto de salmão._

salmone
: ... é um salmão

zo'u
: encerra o tópico e inicia o comentário da relação

**zo'u** é mais útil quando um pronome como **da** é definido no tópico e, em seguida, usado no comentário:

> **su'o da zo'u mi viska da**
> _Existe uma coisa tal que eu a vejo._

<!-- -->

> **ro da poi gerku zo'u mi nelci da**
> _Para cada coisa que é um cachorro: eu gosto dela._
> _Eu gosto de todos os cachorros._

<!-- -->

> **da de zo'u da viska de**
> _Existem **da** e **de** tal que **da** vê **de**._

Os dois pronomes **da** e **de** indicam que existem duas coisas que estão na relação de uma ver a outra. Pode ser o caso de que as supostas duas coisas sejam na verdade apenas uma única coisa que se ama: nada na frase exclui essa interpretação, por isso a tradução coloquial não diz _Alguém vê outra pessoa._ As coisas referidas por diferentes pronomes da série **da** podem ser diferentes ou iguais.

É perfeitamente aceitável que esses pronomes apareçam mais de uma vez na mesma frase:

> **da zo'u da prami da**
> _Existe **da** tal que **da** ama **da**. Há alguém que se ama a si mesmo._

Não é necessário que um pronome seja o argumento direto da relação:

> **da zo'u le gerku pe da cu viska mi**
> _Existe **da** tal que o cachorro deles me vê. O cachorro de alguém me vê._

### '_qualquer_' e '_algum_' nos exemplos

As palavras _qualquer_ e _algum_, juntamente com seus derivados, têm muitos significados em português. Devemos ter cuidado ao traduzir o significado pretendido:

Traduzindo como **da**:

- _algum_/_alguém_: algo não especificado:

 >**da pu klama .i je ko smadi le du'u da me ma kau**
 >_Alguém veio. Adivinhe quem foi._

  <!-- -->

 >**mi pu tirna da .i je mi fliba le ka jimpe le du'u da mo kau**
 >_Eu ouvi algo, mas não consigo entender o que era._

- _algum_/_alguém_ em perguntas se transforma em _qualquer coisa_, _qualquer pessoa_; em Lojban, ainda é **da**:

 >**xu su'o da pu klama**
 >_Alguém veio?_

- _algum_/_alguém_ ao usar comandos, pedidos ou sugestões:

 >**.e'u mi'o pilno su'o da poi drata**
 >_Vamos tentar algo diferente. Vamos tentar outras coisas._

  <!-- -->

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Vamos tentar em outro lugar._

- _qualquer_ pode ser usado em relações internas:

 >**mi rivbi le ka jdice da**
 >_Eu evitei tomar qualquer decisão._

 Como em relações dentro de termos modais:

 >**ba le nu do zgana da kei ko klama**
 >_Depois que você notar qualquer coisa, venha!_

- Escopo: _qualquer_ é usado em português ao negar, enquanto Lojban usa **na ku** mas ainda **da**:

 >**mi na ku viska su'o da poi prenu**
 >_Eu não vejo ninguém._

- _qualquer_ é usado quando não fazemos distinção entre os membros sobre os quais falamos:

 >**.au nai mi tavla su'o da poi na ku slabu mi**
 >_Eu não quero falar com qualquer pessoa._

- Escopo: A negação deve ser usada em uma relação apropriada, como mostrado abaixo:

 >**mi jinvi le du'u na ku da jimpe**
 >_Eu não acho que alguém entenda._

 Isso pode ser reformulado como:

 >**mi jinvi le du'u no da jimpe**
 >_Eu acho que ninguém entende._

- Em comparações, _todo_ se transforma em _qualquer_ e é traduzido como **ro da**:

 >**do zmadu ro da le ka se canlu**
 >_Você é mais alto do que qualquer pessoa._
 >`Você excede a todos em tamanho.`

- Ao fornecer escolha, _qualquer_ é usado e traduzido como **ro da**:

 >**ro da poi do nelci zo'u .e'a do citka da**
 >_Você pode comer qualquer coisa que você goste._
 >`Para tudo que você gosta, eu permito que você coma isso.`

- Para termos como _qualquem_ e _em algum lugar_:

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Vamos tentar em outro lugar._

 Aqui, **su'o da poi drata** significa _qualquer outra coisa ou coisas, lugar ou lugares_. O número desses lugares não é especificado, embora qualquer lugar desse tipo possa servir.

 Para dizer _qualquer lugar, mas apenas um lugar_, use:

 >**.e'u mi'o troci bu'u pa da poi drata**
 >_Vamos tentar em outro lugar._

- Traduzindo _qualquer_ como **le'e** em declarações genéricas:

 >**le'e gerku cu se tuple le vo da**
 >_Qualquer cachorro tem quatro patas. Espera-se que os cachorros tenham quatro patas._

- Usando **le** ao descrever objetos, lugares ou eventos específicos:

 >**le drata zo'u .e'u mi'o pilno ri**
 >_A outra coisa, vamos usá-la._

 >**le drata stuzi zo'u .e'u mi'o troci bu'u ri**
 >_O outro lugar, vamos tentar lá._

### Resumo: quais construções são afetadas pelo escopo?

O escopo é criado apenas por:

- limites de relações,
- termos modais e partículas modais da construção da relação principal,
- termos de argumento que começam com números (como **pa le prenu** — _um dos indivíduos_).
<!-- - interjeições discursivas **po'o**, **ji'a**. -->

**da**, **de**, **di** se usados sem um prenexo e sem um número explícito na frente significam **su'o da**, **su'o de**, **su'o di** e, portanto, também criam escopo.

Assim, a ordem relativa dessas construções altera o significado:

> **pa le prenu ca ku zvati**
> _Existe uma pessoa que está presente agora._

> **ca ku pa le prenu ca zvati**
> _Agora existe uma pessoa._

O escopo não é relevante para construções de relação e para argumentos que começam com **le** (como **le prenu** ou **le re prenu**). Ambas as frases têm o mesmo significado:

> **le prenu ca ku zvati le zdani**
> **ca ku le prenu cu zvati le zdani**
> **ca ku fe le zdani fa le prenu cu zvati**
> _As pessoas estão presentes agora._

O escopo do termo modal vai desde onde ele é usado até a direita da relação até que a relação e todas as suas relações internas (se houver) terminem.

Aqui, **ki'u le nu kargu** está sob o escopo de **na ku**:

> **na ku mi te vecnu ki'u le nu kargu**
> _Não é verdade que: Eu compro porque é caro._

Mas aqui, **ki'u le ne kargu** não está sob o escopo de **na ku**. **ki'u** é aplicado a toda a frase anterior, incluindo **na ku**:

> **mi na ku te vecnu .i ki'u bo kargu**
> _Eu não compro. É porque é caro._