## Lição 4. Prática

Agora que conhecemos as partes mais importantes da gramática, podemos começar a acumular novas palavras por meio de situações.

### Expressões coloquiais

Aqui estão algumas estruturas comuns usadas por falantes fluentes de Lojban, juntamente com exemplos que ilustram seu uso.

Elas podem ajudá-lo a se acostumar mais rapidamente com o Lojban coloquial.

- <dl><dt>.i ku'i</dt><dd>Mas…</dd></dl>
 > **mi djuno .i ku'i mi na ku djica**
 > _Eu sei. Mas eu não quero._
- <dl><dt>mi djica le nu</dt><dd>Eu quero isso…</dd></dl>

 > **mi djica le nu mi sipna**
 > _Eu quero dormir._
 > `Eu quero dormir.`
- <dl><dt>mi djuno le du'u ma kau</dt><dd>Eu sei o que/quem…</dd></dl>

 > **mi djuno le du'u ma kau smuni zo coi**
 > _Eu sei qual é o significado de **coi**._

  <!-- -->

 > **mi na ku djuno**
 > _Eu não sei._
- <dl><dt>jinvi le du'u</dt><dd>… tem uma opinião que…</dd></dl>

 > **mi jinvi le du'u la .lojban. cu zabna**
 > _Acho que Lojban é legal._

  <!-- -->

 > **coi ro do**
 > _Olá a todos!_

  <!-- -->

 > **co'o ro do**
 > _Tchau pessoal!_
- <dl><dt>jinvi le du'u</dt><dd>… tem uma opinião que…</dd></dl>

 > **ai mi cliva .i co'o**
 > _Eu vou embora. Tchau!_
- <dl><dt>.ei mi</dt><dd>Eu deveria…</dd></dl>

 > **.ei mi citka .i co'o**
 > _Eu deveria comer. Tchau!_
- <dl><dt>ca le nu</dt><dd>quando…</dd></dl>

 > **mi pu bebna ca le nu mi citno**
 > _Eu era estúpido quando era jovem._
- <dl><dt>va'o le nu</dt><dd>desde que…</dd></dl>

 > **va'o le nu do djica kei mi ka'e ciksi**
 > _Se quiser eu posso explicar._
- <dl><dt>simlu le ka</dt><dd>… parece ser…</dd></dl>

 > **simlu le ka zabna**
 > _Parece ser legal._
- <dl><dt>ca le cabdei</dt><dd>hoje</dd></dl>

 > **pu ce'e ca le cabdei mi surla**
 > _Hoje descansei._
- <dl><dt>mi nelci</dt><dd>Eu gosto</dd></dl>

 > **mi nelci le mlatu**
 > _Eu gosto do gato._
- <dl><dt>le nu pilno</dt><dd>usando…</dd></dl>

 > **na ku le nu pilno le vlaste cu nandu**
 > _Usar dicionários não é difícil._
- <dl><dt>kakne le ka</dt><dd>capaz de…</dd></dl>

 > **xu do kakne le ka sutra tavla**
 > _Você consegue falar rápido?_
- <dl><dt>tavla fi</dt><dd>falar sobre…</dd></dl>

 > **.e'ei tavla fi le skami**
 > _Vamos falar sobre computadores!_
- <dl><dt>mutce le ka</dt><dd>muito…</dd></dl>

 > **mi mutce le ka se cinri**
 > _Estou muito interessado._
- <dl><dt>troci le ka</dt><dd>… tenta…</dd></dl>

 > **mi troci le ka tavla fo la .lojban.**
 > _Estou tentando falar em Lojban._
- <dl><dt>rinka le nu</dt><dd>(evento) leva a…</dd></dl>

 > **le nu mi tadni la .lojban. cu rinka le nu mi jimpe fi do**
 > _O fato de eu estudar Lojban me faz entender você._
- <dl><dt>gasnu le nu</dt><dd>(agente) causa…</dd></dl>

 > **mi pu gasnu le nu le skami pe mi co'a spofu**
 > _Eu fiz isso para que meu computador quebrasse._
- <dl><dt>xusra le du'u</dt><dd>afirme que…</dd></dl>

 > **xu do xusra le du'u mi na ku drani**
 > _Você afirma que não estou certo?_
- <dl><dt>kanpe le du'u</dt><dd>esperar (no sentido de avaliação, previsão) que…</dd></dl>

  <!-- -->

 > **mi na ku kanpe le du'u mi jinga**
 > _Não espero vencer._

### Um diálogo simples

> **coi la .alis.**
> _Olá, Alice!_
<!-- -->
> **coi la .doris.**
> _Olá, Dóris!_
<!-- -->
> **do mo**
>_Como você está?_
<!-- -->
> **mi kanro .i mi ca tadni la .lojban. .i mi troci le ka tavla do**
> _Estou saudável. Agora estudo Lojban. Estou tentando falar com você._

kanro
: estar saudável

tadni
: estudar … (algo)

troci
: tentar … (fazer algo)

tavla
: conversar [com alguém]

> **zabna .i ma tcima ca le bavlamdei**
> *Está bom. Como será o tempo amanhã?*

zabna
: … está bom, agradável

tcima
: … é o tempo

ca
: em (algum momento)

le bavlamdei
: dia de amanhã

> **mi na ku djuno .i le solri sei mi pacna**
> *Não sei. Espero que esteja ensolarado.*

djuno
: saber (fato)

le solri
: o sol

Observe que **le solri cu tcima** (literalmente _o sol é o tempo_) é a forma de usar **tcima** em Lojban.

sei
: início de comentário

pacna
: esperar (por algum evento)

> **mi jimpe**
> _I understand._

> **co'o**
> _Goodbye._

### Sentidos humanos

> **ju'i la .alis.**
> _Hey, Alice!_

ju'i
: vocativo que chama a atenção: _Ei! Psst! Ahem! Atenção!_

> **re'i**
> *Estou ouvindo.*

re'i
: vocativo: _Estou pronto para receber informações._

> *xu do viska ta*
> **Você vê aquilo perto de você?**

----

As relações que descrevem a percepção serão explicadas após o diálogo.

> **viska .i plise**
> **.i le plise cu xunre .i skari le ka xunre**
> _Sim. É uma maçã._
> _A maçã é vermelha. É de cor vermelha._

> **xu do viska le tarmi be le plise**
> _Você consegue ver a forma da maçã?_

<!-- -->

> **viska .i le plise cu barda**
> _Sim. A maçã é grande._

<!-- -->

> **xu do jinvi le du'u le plise ca makcu**
> _Você acha que a maçã está madura?_

makcu
: ... está madura

> **.au mi zgana le sefta be le plise**
> _Eu gostaria de apalpá-la._

> **.i ua xutla**
> _Oh, ela é lisa._

> **.i mi pacna le nu makcu ie**
> _Eu espero que esteja madura, sim._

> **panci pei**
> _E o cheiro?_

> **.i .e'o do sumne le plise**
> _Por favor, cheire._

> **le xrula cu panci**
> _Cheira a flores._

> **.i .au mi zgana le vrusi be le plise**
> _Eu gostaria de provar a maçã._

> **.i .oi nai le kukte cu vrusi**
> _Hum, tem um gosto doce._

> **.i .oi**
> _Oh, não._

le xrula
: a flor, as flores

<pixra url="/assets/pixra/cilre/xrula.webp" caption="xrula" definition="flor"></pixra>

> **ma pu fasnu**
> _O que aconteceu?_

> **mi pu farlu**
> _Eu caí._

farlu
: ... cai para ...

> **xu do cortu**
> _Você sente dor?_

> **cortu .i mi cortu le cidni**
> _Sim, sinto dor no joelho._

> **.i na ku ckape**
> _Não é perigoso._

> **.i ca ti mi ganse le nu da vi zvati**
> _E agora eu posso sentir a presença de alguém aqui._

> **doi la .alis. do cliva .e'o sai**
> _Alice, por favor, volte imediatamente!_

> **ko denpa .i mi ca tirna le sance**
> _Espere, eu consigo ouvir algum som._

> **le sance be ma**
> _Um som de quê?_

> **mi pu tirna le nu le prenu cu tavla**
> _Eu ouvi uma pessoa falando._

> **.i ca ti mi zgana le lenku**
> _Agora eu sinto frio._

> **ju'i la .alis.**
> _Ei, Alice!.._

Neste diálogo, foram abordados os conceitos mais importantes relacionados aos sentidos humanos. Nas seções seguintes, explicaremos as estruturas de lugar desses sentidos, juntamente com relações e exemplos adicionais.

#### Visão

viska
: $x_1$ vê $x_2$ (objeto, forma, cor)

skari
: $x_1$ é um objeto com a cor $x_2$ (propriedade)

tarmi
: $x_1$ é a forma de $x_2$

cukla
: $x_1$ é redondo (em forma)

<pixra url="/assets/pixra/cilre/coha_viska.webp" caption="le prenu co'a viska le cipni" definition="A pessoa percebe, começa a ver o pássaro."></pixra>

> **mi viska le plise**
> _Eu vejo a maçã._

> **mi viska le tarmi be le plise**
> _Eu vejo a forma da maçã._

> **.i le plise cu se tarmi le cukla**
> _A maçã é redonda._

<!-- -->
<!-- > **mi viska le se skari be le plise**
> _Eu vejo a cor da maçã._ -->

> **.i le plise cu skari le ka xunre**
> _A maçã é vermelha._

Observe: podemos dizer tanto "ver a forma da maçã" quanto "ver a maçã".

#### Audição

tirna
: $x_1$ ouve $x_2$ (objeto ou som)

<pixra url="/assets/pixra/cilre/le_prenu_cu_tirna_lei_djacu.webp" caption="le prenu cu tirna lei djacu" definition="A pessoa ouve as águas."></pixra>

> **mi tirna le palta**
> _Eu ouço o prato._

<!-- -->

> **mi tirna le sance be le palta poi ca'o porpi**
> _Eu ouço o som de um prato caindo._

> **.i le palta cu se sance le cladu**
> _Ele faz um som alto._

le palta
: o prato

cladu
: $x_1$ é alto (em som)

tolycladu
: $x_1$ é relativamente baixo (em som)

tonga
: $x_1$ é um tom de $x_2$

Podemos usar **cladu** e palavras similares diretamente:

> **mi tirna le cladu**
> _Eu ouço algo alto._

<!-- -->

> **mi tirna le tolycladu**
> _Eu ouço algo relativamente baixo._

<!-- -->

> **mi tirna le tonga be le palta poi farlu**
> _Eu ouço o tom do prato caindo._

Assim como na visão, podemos dizer "ouvir um som" e "ouvir algo produzindo o som":

> **— ma sance gi'e se tirna do**
> _— Que som você ouve?_

> **— le zgike**
> _— A música._

<!-- -->

> **— do tirna le sance be ma**
> _— Você ouve um som de quê?_

> **— le plise poi co'i farlu**
> _— A maçã que caiu._

#### Percepção em geral

Também podemos usar o vago **ganse** — _sentir estímulo_.

ganse
: $x_1$ sente o estímulo $x_2$ (objeto, evento) por meio de $x_3$

ganse le glare
: sentir o calor

ganse le lenku
: sentir o frio

> **mi ganse le plise**
> _Eu sinto a maçã._

<!-- -->

Para observar nossas percepções, podemos usar **zgana**:

<pixra url="/assets/pixra/cilre/zgana_le_sefta.webp" caption="le prenu cu zgana le sefta be le xrula" definition="The person palpates the surface of the flower."></pixra>

> **mi zgana le tarmi be le plise**
> _Eu observo a forma de uma maçã._

> **.i le plise cu se tarmi le'e cukla**
> _A maçã é redonda._

zgana
: $x_1$ percebe, observa, vê $x_2$. Não se limita à visão.

Alguns argumentos podem ser usados com diferentes relações sensoriais. Por exemplo, podemos

viska le sefta
: ver a superfície

zgana le sefta
: palpar a superfície

#### Sentido do olfato

sumne
: $x_1$ cheira $x_2$ (odor)

panci
: $x_1$ é um odor de $x_2$ (objeto)

<pixra url="/assets/pixra/cilre/sumne.webp" caption="le mlatu cu sumne le xrula" definition="O gato cheira a flor."></pixra>

> **mi sumne le xrula**
> _Eu cheiro a flor._

<!-- -->

> **mi sumne le panci be le za'u xrula**
> _Eu cheiro o odor das flores._

<!-- -->

> **mi sumne le panci be le plise**
> _Eu cheiro o odor da maçã._

> **.i le plise cu se panci le xrula**
> _A maçã cheira a flores._

Note que o português pode ser confuso quando se trata de distinguir entre cheirar um odor e cheirar um objeto que produz esse odor. Dizemos _cheirar a maçã_, _a maçã cheira a flores (tem o cheiro de flores)_. Essa distinção dupla é importante porque uma maçã produz partículas aromáticas que são distintas da própria maçã. O mesmo se aplica a um prato caindo e seu som - pode ser que não queiramos misturá-los.

No Lojban, podemos separar facilmente esses casos, como demonstrado nos exemplos acima.

#### Sentido do paladar

vrusi
: $x_1$ é um sabor de $x_2$

<pixra url="/assets/pixra/cilre/se_vrusi_lo_ka_kukte.webp" caption="le prenu cu zgana le vrusi be le grute" definition="A pessoa prova, observa o sabor da fruta."></pixra>

> **mi zgana le vrusi be le grute**
> _Eu provo a maçã._
> `Eu observo o sabor da fruta`

le grute
: a fruta, as frutas
<!-- -->

> **.i le plise cu se vrusi le titla**
> _A maçã tem um sabor doce._

titla
: ... é doce, ... é um docinho

#### Sentido do tato

sefta
: $x_1$ é uma superfície de $x_2$

> **mi zgana le sefta be le plise**
> _Eu palpo, sinto a superfície da maçã._

<!-- -->

> **.i le plise cu se sefta le xutla**
> _A maçã tem uma superfície lisa._

#### Dor

> **mi cortu le birka be mi**
> _Sinto dor no meu braço._
> _Meu braço dói._

<!-- -->

<pixra url="/assets/pixra/cilre/cortu.webp" caption="mi cortu le cidni be mi" definition="Meu joelho dói."></pixra>

> **mi cortu le cidni**
> _Sinto dor no meu joelho, meu joelho dói._

cortu
: $x_1$ sente dor em $x_2$ (órgão, parte do corpo de $x_1$)

cidni
: $x_1$ é um joelho de $x_2$

#### Cores

Diferentes idiomas usam diferentes conjuntos de palavras para denotar cores. Alguns idiomas simplesmente se referem às cores fazendo referência a outros objetos "protótipo" com cores, tons ou formas semelhantes. Em Lojban, usamos todas as opções:

> **ti xunre**
> _Isso é vermelho._

xunre
: $x_1$ é vermelho

> **ti skari le ka xunre**
> _Isso é vermelho. Isso tem a cor de coisas vermelhas._

<!-- -->

> **ti skari le ka ciblu**
> _Isso tem a cor do sangue._

le ciblu
: o sangue

Aqui estão alguns exemplos de cores que se alinham com a língua portuguêsa. Você também pode usar outras palavras para cores, refletindo a maneira como falantes de diferentes idiomas categorizam coisas.

> **le tsani cu xunre ca le cerni**
> _O céu está vermelho de manhã._

le tsani
: o céu

> **.i le solri cu simlu le ka narju**
> _O sol parece ser laranja._

le solri
: o Sol

<pixra url="/assets/pixra/cilre/tsani.webp" caption="tsani .i solri" definition="O céu. O sol."></pixra>

simlu
: $x_1$ parece com $x_2$ (propriedade de $x_1$)

> **.i le pelxu xrula cu se farna le solri**
> _As flores amarelas estão orientadas para o Sol._

se farna
: $x_1$ está orientado para $x_2$

farna
: $x_1$ é a direção de $x_2$

> **.i le pezli be le tricu cu crino**
> _As folhas das árvores são verdes._

pezli
: $x_1$ é uma folha de $x_2$

le tricu
: árvore

> **.i mi zvati le korbi be le blanu xamsi**
> _Estou na fronteira de um mar azul._

zvati
: ... está presente em ...

korbi
: $x_1$ é a fronteira de $x_2$

le xamsi
: mar

> **.i mi catlu le prenu noi dasni le zirpu taxfu**
> _Eu olho para uma pessoa que está usando um vestido violeta._

dasni
: $x_1$ está usando $x_2$ (algo)

xunre
: $x_1$ é vermelho

narju
: $x_1$ é laranja

pelxu
: $x_1$ é amarelo

crino
: $x_1$ é verde

blanu
: $x_1$ é azul

zirpu
: $x_1$ é violeta

Outras relações úteis:

> **le gusni be le manku pagbu pu na ku carmi**
> *A luz que ilumina áreas escuras não era intensa.*

<!-- -->

> **le gusni be fi le solri pu carmi**
> *A luz do Sol era intensa.*

gusni
: $x_1$ é uma luz que ilumina $x_2$ a partir da fonte de luz $x_3$

carmi
: $x_1$ é intenso, brilhante

manku
: $x_1$ é escuro

### «**sipna**» — ‘_dormir_’, «**sanji**» — ‘_estar consciente_’

Os exemplos a seguir ilustram alguns aspectos básicos da mente:

> **pu ku mi cikna gi'e ku'i na ganse le nu do klama**
> *Eu estava acordado, mas não percebi sua chegada.*

<!-- -->

> **pu ku ca le nu mi sipna kei mi ganse ku'i le nu do klama**
> *Enquanto eu estava dormindo, mesmo assim percebi você chegando.*

<!-- -->

<pixra url="/assets/pixra/cilre/le_prenu_cu_senva_tuha_le_nei.webp" caption="Eu estou dormindo e estou ciente de que estou dormindo." definition="Eu durmo e estou ciente de que estou dormindo."></pixra>

> **Eu estava dormindo e estava ciente de que estava dormindo.**
> _Eu estava tendo um sonho lúcido._

<!-- -->

> **Eu estou ciente de que estou ciente.**
> _Eu estou consciente de mim mesmo._

sipna
: $x_1$ dorme

cikna
: $x_1$ está acordado

ganse
: o observador $x_1$ percebe, nota algum estímulo (evento) por meio de meios $x_3$

sanji
: $x_1$ está consciente, ciente de $x_2$ (evento)

**ganse** não implica nenhum processamento mental; apenas descreve percepção, reconhecimento, detecção de algum estímulo por meio de canais sensoriais (especificados em $x_3$).

Por outro lado, **sanji** descreve a percepção passiva, que envolve processamento mental, mas não necessariamente por meio de entradas sensoriais (algumas relações mentais não são detectadas pelos sentidos).

### Emoções: «**cmila**» — ‘_rir_’, «**cisma**» — ‘_sorrir_’

> **coi**
> **.i ma nuzba**
> **.i do simlu le ka badri**
> *Oi.*
> *Qual é a novidade?*
> *Você parece estar triste.*

badri
: $x_1$ está triste sobre $x_2$

<pixra url="/assets/pixra/cilre/badri.webp" caption="A pessoa parece estar triste." definition="A pessoa parece estar triste."></pixra>

> **mi steba le nu le bruna be mi co'a speni le ninmu**
> _Estou frustrado porque meu irmão se casou com a mulher._

steba
: $x_1$ sente frustração em relação a $x_2$

> **mi se cfipu**
> **.i xu do na ku gleki le nu le bruna co'a speni**
> _Estou confuso._
> _Você não está feliz que o irmão se case?_

se cfipu
: $x_1$ está confuso sobre $x_2$

gleki
: $x_1$ está feliz sobre $x_2$

> **ie**
> **.i le ninmu cu pindi**
> **.i le ninmu na ku ponse le jdini**
> **.i mi na ku kakne le ka ciksi**
> _Sim._
> _A mulher é pobre._
> _Ela não tem dinheiro._
> _Não consigo explicar._

le jdini
: o dinheiro

kakne
: $x_1$ é capaz de $x_2$ (propriedade de $x_1$)

> **ua**
> **.i la'a do kanpe le nu le ninmu na ku prami le bruna**
> _Ah!_
> _Provavelmente você espera que a mulher não goste do irmão._

la'a
: interjeição: provavelmente, é provável

Kanpe
: $x_1$ espera $x_2$ (algum evento)

> **mi terpa le nu le ninmu ba tarti lo xlali**
> **.i ku'i le bruna cu cisma ca ro nu ri tavla le ninmu**
> **.i ri ta'e cmila**
> _Tenho medo que ela se comporte mal._
> _Mas o irmão sorri toda vez que fala com ela._
> _E ela geralmente ri._

terpa
: $x_1$ tem medo de $x_2$

cisma
: $x_1$ sorri

cmila
: $x_1$ ri

> **mi kucli le nu le ninmu cu prami le bruna**
> *Fico curioso se a garota gosta do irmão.*

kucli
: $x_1$ está curioso sobre $x_2$

> **mi na ku kanpe**
> *Eu não espero isso.*

kanpe
: $x_1$ espera que $x_2$ (evento) aconteça

> **ko surla**
> *Relaxe!*

surla
: $x_1$ relaxa fazendo $x_2$ (propriedade de $x_1$)

cinmo
: $x_1$ sente emoção $x_2$ (propriedade de $x_1$)

nelci
: $x_1$ gosta de $x_2$

manci
: $x_1$ sente admiração ou espanto por $x_2$

fengu
: $x_1$ está com raiva de $x_2$

xajmi
: $x_1$ acha que $x_2$ é engraçado

se zdile
: $x_1$ se diverte com $x_2$

zdile
: $x_1$ é divertido

djica
: $x_1$ deseja $x_2$

pacna
: $x_1$ espera que $x_2$ seja verdade

### Saúde

> **ca glare**
> *Está quente agora.*

<!-- -->

> **.i ku'i mi ganse le lenku**
> *Mas eu sinto frio.*

ku'i
: interjeição: mas, no entanto

> **xu do bilma**
> *Você está doente?*

<!-- -->

> **bilma**
> _Sim._

<!-- -->

> **xu do bilma fi le vidru**
> **.i .e'u do klama le mikce**
> _Você está com um vírus? Sugiro que vá ao médico._

le vidru
: o vírus

le mikce
: médico

> **mi bilma le ka cortu le galxe**
> **.i mi sruma le du'u mi bilma fi la .zukam.**
> _Meus sintomas são dor de garganta._
> _Eu acredito que estou resfriado._

cortu
: $x_1$ sente dor em $x_2$ (órgão, parte do corpo de $x_1$)

la .zukam.
: resfriado comum (doença)

> **ko kanro**
> _Melhore logo!_

kanro
: $x_1$ está saudável

> **ki'e**
> _Obrigado(a)._

bilma
: $x_1$ está doente com sintomas $x_2$ da doença $x_3$

Observe que o segundo lugar de **bilma** descreve os sintomas, como **le ka cortu le galxe** = _ter dor de garganta_. O terceiro lugar indica o nome da doença que causa esses sintomas. Obviamente, você pode optar por não preencher esses lugares de **bilma**.

### Corpo humano

> **le nanmu cu se xadni le clani**
> _O homem tem um corpo longo. O homem é alto._

se xadni
: $x_1$ tem o corpo $x_2$

xadni
: $x_1$ é o corpo de $x_2$

> **mi pu darxi fi le stedu .e le zunle xance**
> **.i ca ti le degji be le xance cu cortu**
> **.i ku'i le pritu xance na ku cortu**
> _Eu bati em algo com a cabeça e a mão esquerda. Agora o dedo da mão dói. Mas a mão direita não dói._

darxi
: $x_1$ bate em $x_2$ com $x_3$

A maioria das palavras para partes do corpo tem a mesma estrutura de lugar que **xadni**:

stedu
: $x_1$ é a cabeça de $x_2$

No entanto, algumas descrevem partes menores:

degji
: $x_1$ é um dedo/do dedo em parte $x_2$ (mão, pé)

> **le degji be le xance be le ninmu cu clani**
> _Os dedos da mulher são longos._
> `Dedos da mão da mulher são longos`

> **mi viska le jamfu .i ku'i mi na ku viska le degji be le jamfu**
> _Eu consigo ver os pés. Mas não vejo os dedos._

janco
: $x_1$ é uma articulação que conecta membros $x_2$

ctebi
: $x_1$ é um lábio da boca, orifício $x_2$

cidni
: $x_1$ é um joelho ou cotovelo do membro $x_2$

![](/assets/pixra/cilre/xadni1.svg)

![](/assets/pixra/cilre/xadni2.svg)

### Parentesco

> **coi do mi se cmene zo .adam.**
> **.i ti du la .alis.**
> **.i ri speni mi**
> _Olá para você. Me chamo "Adam"._
> _Esta é Alice._
> _Ela é minha esposa._

> **pluka fa le nu penmi do**
> **.i .e'o do klama le nenri be le dinju**
> _É um prazer te conhecer._
> _Por favor, entre na casa._

<!-- -->

> **ki'e**
> _Obrigado._

<!-- -->

> **.i .au gau mi do co'a slabu le lanzu be mi**
> **.i le re verba cu panzi mi**
> **.i le tixnu cu se cmene zo .flor.**
> **.i la .karl. cu du le bersa**
> _Gostaria que você conhecesse minha família._
> _Os dois filhos são meus descendentes._
> _A filha se chama "Flor"._
> _Karl é o filho._

<!-- -->

> **la .karl. cu mutce citno**
> _Karl é muito jovem._

<!-- -->

> **ie**
> _Sim._

<!-- -->

> **.i ji'a mi se tunba re da noi ca na ku zvati le dinju**
> **.i sa'e mi se tunba le pa bruna .e le pa mensi**
> _Além disso, tenho dois irmãos que não estão em casa agora._
> _Para ser preciso, tenho um irmão e uma irmã._

<!-- -->

> **ue**
> **.i le lanzu be do cu barda**
> _Uau!_
> _Sua família é grande._

<!-- -->

> **je'u pei**
> _Mesmo?_

je'u
: interjeição: realmente

As palavras para nomes de membros da família têm uma estrutura de lugar similar:

speni
: $x_1$ é marido/esposa de $x_2$

**co'a speni** significa _casar-se_:

> **mi co'a speni la .suzan.**
> _Eu me casei com Susan._

lanzu
: $x_1$ é uma família que inclui $x_2$

panzi
: $x_1$ é filho(a) de $x_2$

tixnu
: $x_1$ é filha de $x_2$

bersa
: $x_1$ é filho de $x_2$

tunba
: $x_1$ é irmão/irmã de $x_2$

bruna
: $x_1$ é irmão de $x_2$

mensi
: $x_1$ é irmã de $x_2$

Note que **panzi** pode ser aplicado a filhos adultos:

verba
: $x_1$ é uma criança, pessoa imatura de idade $x_2$ (evento)

panzi
: $x_1$ é uma criança, descendente de $x_2$

**verba** não necessariamente se refere à criança como um membro da família:

> **le bersa be le pendo be mi cu verba le nanca be li ci**
> _O filho do meu amigo é uma criança de três anos._

citno
: $x_1$ é jovem

laldo
: $x_1$ é velho, idoso

Pares de palavras tradicionais (apenas para humanos):

le ninmu
: mulher / mulheres

le nanmu
: homem / homens

le nixli
: as meninas

le nanla
: os meninos

le remna
: os humanos

Note que **le prenu** significa _as pessoas_ ou _os indivíduos_. Em contos de fadas e histórias fantásticas, não apenas humanos (**lo'e remna**), mas também animais ou seres alienígenas de outros planetas podem ser considerados pessoas.

Essas palavras podem ser usadas para descrever o sexo geneticamente determinado (tanto em animais quanto em humanos), em oposição ao gênero:

le fetsi
: a fêmea

le nakni
: macho

Essas palavras descrevem relações parentais (não necessariamente genéticas):

mamta
: $x_1$ é mãe de $x_2$, $x_1$ age maternalmente

patfu
: $x_1$ é pai de $x_2$

rirni
: $x_1$ é pai/mãe de $x_2$, $x_1$ cria $x_2$

### Na loja

> **ue**
> **do pu te vecnu le laldo karce**
> _Uau!_
> _Você comprou um carro antigo._

<!-- -->

> **ie**
> **.i ku'i mi na ku pu pleji le so'i jdini**
> _Sim._
> _Mas eu não paguei muito dinheiro._

<!-- -->

> **ma pu jdima le karce**
> _Qual foi o preço do carro?_

<!-- -->

> **mi pu pleji le rupnusudu be li pa ki'o le kagni le karce**
> _Eu paguei mil dólares para a empresa pelo carro._

<!-- -->

> **mi pu vecnu le laldo karce pe mi le pendo be mi**
> **.i le pendo pu pleji le rupne'uru be li re ki'o mi le karce**
> _Eu vendi um carro antigo meu para meu amigo._
> _O amigo pagou 2.000 euros pelo carro._

ki'o
: vírgula entre dígitos, então **pa ki'o** é _1.000_ (_mil_)

vecnu
: $x_1$ vende $x_2$ para $x_3$

te vecnu
: $x_1$ compra $x_2$ de $x_3$

pleji
: $x_1$ paga $x_2$ para $x_3$ por $x_4$

jdima
: $x_1$ é o preço de $x_2$

jdini
: $x_1$ é dinheiro

rupnusudu
: $x_1$ custa $x_2$ (número) dólares americanos

rupne'uru
: $x_1$ custa $x_2$ (número) euros

### Loja, edifícios

> **ma stuzi le zdani be do**
> _Qual é a localização da sua casa?_

<!-- -->

> **le korbi be le cmana**
> **.i mi se zdani le nurma**
> **.i le zdani be mi cu barda dinju gi'e se sledi'u ci da .e le vimstu .e le lumstu**
> _A beira da montanha._
> _Eu moro no campo._
> _Minha casa é uma casa grande e tem três quartos, além de um banheiro e uma sala de banho._

<!-- -->

> **je'e**
> **.i ku'i mi pu jbena le tcadu .i je ca ti mi se zdani le jarbu be la .paris.**
> **.i mi xabju ne'a le zarci**
> _Entendi._
> _Mas eu nasci na cidade e agora moro nos subúrbios de Paris._
> _Eu moro perto de uma loja._

stuzi
: $x_1$ é um lugar

dinju
: $x_1$ é um edifício, casa

sledi'u
: $x_1$ é um quarto, uma parte de um edifício $x_2$

vimstu
: $x_1$ é um banheiro, um lugar para excretar

lumstu
: $x_1$ é um banheiro, um lugar para lavar algo

zdani
: $x_1$ é uma casa de $x_2$

se zdani
: $x_1$ mora em $x_2$, $x_1$ habita $x_2$

tcadu
: $x_1$ é uma cidade

jarbu
: $x_1$ é uma área suburbana da cidade $x_2$

nurma
: $x_1$ é uma área rural, $x_1$ está no campo

zarci
: $x_1$ é uma loja