## Lição 3. Citações. Perguntas. Interjeições

### «**sei**»: comentários sobre o texto

A partícula **sei** permite inserir um comentário sobre nossa atitude em relação ao que é dito em uma relação:

> **do jinga sei mi gleki**
> _Você venceu! (Estou feliz com isso!)_

No entanto:

> **do jinga sei la .ian. cu gleki**
> _Você venceu! (E Yan está feliz com isso!)_

Assim como nos argumentos formados usando **le**, a relação formada com **sei** deve terminar em uma construção de relação.

> **la .alis. cu prami sei la .bob. cu gleki la .kevin.**

Vamos adicionar parênteses para facilitar a leitura.

> **la .alis. cu prami (sei la .bob. cu gleki) la .kevin.**
> _Alice ama (Bob está feliz) Kevin._
> _Alice ama Kevin (Bob está feliz)._

É claro que podemos adicionar mais argumentos à relação com **be** e **bei**, assim como fazemos dentro dos termos de argumento:

> **do jinga sei mi zausku be fo la fircku**
> _Você venceu! (Vou postar parabéns no Facebook)_

la fircku
: Facebook

zausku
: $x_1$ elogia $x_2$ para a audiência $x_3$ por meio $x_4$

### Aspas

Para citar um texto, colocamos a partícula de citação **lu** antes da citação e colocamos **li'u** depois dela. O resultado é um argumento que representa o texto citado:

> **mi cusku lu mi prami do li'u**
> _Eu digo "Eu te amo"._

cusku
: $x_1$ expressa/diz $x_2$ (citação) para a audiência $x_3$

Uma característica interessante do Lojban é que as marcas **lu** — «citação» e **li'u** — «desmarcação» são pronunciáveis. Isso é bastante útil, pois, no Lojban falado, você não precisa mudar a entonação para mostrar onde um texto citado começa e termina.

No entanto, em texto escrito que cita uma conversa, o autor frequentemente chama a atenção do leitor para o conteúdo das citações. Nesses casos, **sei** é preferido.

Também podemos aninhar citações, por exemplo:

> **la .ian. pu cusku lu la .djein. pu cusku lu coi li'u mi li'u**
> _Yan disse: "Jane disse 'Olá' para mim"._

que é similar a

> **la .ian. pu cusku lu la .djein. pu rinsa mi li'u**
> _Yan disse: "Jane me cumprimentou"._

rinsa
: $x_1$ cumprimenta alguém $x_2$

<pixra url="/assets/pixra/cilre/rinsa2.webp" caption="le prenu cu rinsa mi" definition="A pessoa me cumprimenta."></pixra>

Observe que em Lojban, distinguimos coisas e seus nomes:

> **lu le munje li'u cu cmalu**
> _"O universo" é pequeno._

<!-- -->

> **le munje na ku cmalu**
> _O universo não é pequeno._

le munje
: o universo, mundo

Aqui, o texto _"o universo"_ é pequeno, enquanto o universo não é.

---

Interjeições e vocativos funcionam como construções **sei**:

> **je'u mi jinga sei ra cusku**
> _Verdadeiramente, ele disse: "Eu venci"._

je'u
: interjeição: verdadeiramente

Como você pode ver, **je'u** não faz parte das palavras dele. Ele representa sua atitude em relação à relação. Se você quiser citar "**je'u mi jinga**", use aspas assim:

> **lu je'u mi jinga li'u se cusku ra**
> _"Verdadeiramente, eu venci", ele disse._

Percebe a diferença entre os dois exemplos?

Aqui estão várias palavras de relação comuns relacionadas à fala:

> **ra pu retsku lu do klama ma li'u**
> _Ela perguntou: "Para onde você vai?"_

<!-- -->

> **mi pu spusku lu mi klama le zdani li'u**
> _Eu respondi: "Eu estou indo para casa."_

<!-- -->

> **mi pu spuda le se retsku be ra le ka spusku lu mi klama le zdani li'u**
> _Eu respondi à pergunta dela dizendo: "Eu estou indo para casa."_

spuda
: $x_1$ responde a $x_2$ fazendo $x_3$ (propriedade de $x_1$)

As outras três palavras de relação têm a mesma estrutura de lugares:

cusku
: $x_1$ expressa/diz $x_2$ (citação) para a audiência $x_3$

retsku
: $x_1$ pergunta a $x_2$ (citação) para a audiência $x_3$

spusku
: $x_1$ responde/diz a resposta $x_2$ (citação) para a audiência $x_3$

### «**zo**» — citando uma palavra

**zo** é um marcador de citação, similar a **lu**. No entanto, **zo** cita apenas uma palavra imediatamente após ele. Isso significa que não é necessário uma palavra de desmarcação como **li'u**; já sabemos onde a citação termina. Fazendo isso, economizamos duas sílabas e tornamos nosso discurso mais conciso.

> **zo .robin. cmene mi**
> _"Robin" é meu nome._
> _Meu nome é Robin._

cmene
: $x_1$ (citação) é um nome de $x_2$ ...

Para se apresentar em Lojban usando seu nome em Lojbanizado, siga o exemplo acima. Se o seu nome consistir em mais de uma palavra, use **lu ... li'u**:

> **lu .robin.djonsyn. li'u cmene mi**
> _Robin Johnson é meu nome._

Outra abordagem é usar **me**:

> **mi me la .robin.djonsyn.**
> _Eu sou Robin Johnson._

Observe a diferença: _"Robin"_ entre aspas é um nome citado, enquanto Robin é uma pessoa.

Para mostrar isso melhor, aqui está uma variação boba:
> **zo .robin. cmene la .robin.**
> _"Robin" é o nome de Robin._
> _"Robin" é um nome de Robin._

O primeiro lugar de **cmene** é uma citação, um texto. Portanto, usamos **lu ... li'u** ou **zo** para criar uma citação e preencher o primeiro lugar de **cmene** com ela, em vez de **la** (prefixo para nomes).

### Verbos de fala

Aqui estão algumas relações que descrevem a fala:

> **mi pu skicu le purdi le pendo be mi lo ka bredi**
> _Eu contei ao meu amigo sobre meu jardim estar pronto._

skicu
: $x_1$ conta sobre $x_1$ (objeto/evento/estado) para $x_3$ com descrição $x_4$ (propriedade)

bredi
: ... está pronto para ...

> **mi pu cusku lu le purdi cu bredi li'u le pendo be mi lo ka cladu bacru**
> _Eu disse ao meu amigo: "O jardim está pronto", ao pronunciá-lo em voz alta._

cusku
: $x_1$ diz $x_2$ (texto) para a audiência $x_3$ através do meio $x_4$

cladu
: ... é alto

> **mi pu tavla le pendo be mi le nu le purdi cu bredi kei le lojbo**
> _Eu conversei com meu amigo em Lojban sobre o jardim estar pronto._

tavla
: $x_1$ conversa com $x_2$ sobre o assunto $x_3$ na língua $x_4$

Em resumo:

* **skicu** significa _contar_, _descrever com alguma descrição_,
* **cusku** significa _dizer algum texto_,
* **tavla** significa _conversar em uma língua_.

### Perguntas de conteúdo

O português tem várias palavras de pergunta — _quem_, _que_, _onde_ etc. Em Lojban, para ambos usamos uma palavra: **ma**. Essa palavra é um argumento (como **mi**, **le prenu** etc.) e é como uma sugestão para preencher o lugar vazio. Por exemplo:

> **— do klama ma**
> **— la .london.**
> _— Para onde você está indo?_
> _— Londres._

<!-- -->

> **— ma klama la .london.**
> **— la .kevin.**
> _— Quem está indo para Londres?_
> _— Kevin._

> **— mi plicru do ma**
> **— le plise**
> <span>_— Eu te dou o quê?_ (provavelmente significa _O que era para eu te dar?_)</span>
> _— A maçã._

Para traduzir _qual/que_, também usamos **ma**:

> **— ma gugde gi'e se xabju do**
> **— le gugde'usu**
> _— Em qual país você mora?_
> _— EUA_
> `— O que é um país e é habitado por você`
> `— EUA`

xabju
: … (alguém) habita … (algum lugar)

se xabju
: … (algum lugar) é habitado por … (alguém)

**mo** é similar a **ma**, mas é uma palavra de relação.

**mo** sugere preencher uma relação em vez de um argumento. É como perguntar _O que X faz?_ ou _O que é X?_ em português (Lojban não obriga a distinguir entre ser e fazer).

Podemos entender **mo** como pedir para alguém descrever a relação entre os argumentos na pergunta.

> **— do mo**
> _— Como você está? O que está acontecendo?_
> `— Você é o quê, você faz o quê?`

Esta é a forma mais comum de perguntar _Como você está?_ ou _Oi?_ em Lojban. Algumas respostas possíveis:

> **— mi gleki**
> _— Estou feliz._

gleki
: $x_1$ está feliz

> **— mi kanro**
> _— Estou saudável._

<!-- -->

> **mi tatpi**
> _Estou cansado._

<!-- -->

> **mi gunka**
> _Estou trabalhando._

Outra forma de perguntar _Como você está?_:

> **— do cinmo le ka mo**
> _— Como você se sente (emocionalmente)?_

cinmo
: $x_1$ sente $x_2$ (propriedade de $x_1$)

Outros exemplos:

> **ti mo**
> _O que é isso?_

<!-- -->

> **la .meilis. cu mo**
> _Quem é Mei Li? / O que é Mei Li? / O que Mei Li está fazendo?_

Possíveis respostas dependendo do contexto:

- **ninmu**: _Ela é uma mulher._
- **jungo**: _Ela é chinesa._
- **pulji**: _Ela é uma policial._
- **sanga**: _Ela é uma cantora_ ou _Ela está cantando._

> **do mo la .kevin.**
> _O que você é para o Kevin?_
> `Você é o quê (você faz o quê) para o Kevin.`

A resposta depende do contexto. Possíveis respostas para essa pergunta são:

- **nelci**: _Eu gosto dele._
- **pendo**: _Eu sou amigo dele._
- **prami**: _Eu adoro/estou apaixonado por ele._
- **xebni**: _Eu odeio ele._
- **fengu**: _Estou com raiva dele._
- **cinba**: _Eu beijei ele._

Note novamente que o tempo não é importante aqui: assim como **cinba** pode significar _beijar_, _beijou_, _vai beijar_ e assim por diante, **mo** não faz uma pergunta sobre um tempo específico.

Se quisermos diferenciar entre _fazer_ e _ser alguém ou algo_, usamos relações adicionais:

> **la meilis cu zukte ma**
> `Mei Li faz o quê?`
> _O que Mei Li faz?_

> **le ka lumci**
> _limpeza._

<!-- -->

> **la meilis cu zukte le ka lumci**
> _Mei Li está fazendo limpeza._

zukte
: $x_1$ faz $x_2$ (propriedade de $x_1$)

lumci
:... limpa ou lava... (alguma coisa)

<pixra url="/assets/pixra/cilre/lumci.webp" caption="ra lumci le zdani" definição="Ela limpa a casa."></pixra>

> **do du ma**
> `Você é quem?`

> **mi du le ctuca**
> _Eu sou o professor._

Usar termos modais com **ma** pode nos dar outras perguntas úteis:

<table>
<tbody><tr>
<th>palavra
</th>
<th>significado
</th>
<th><code>[literalmente]</code>
</th></tr>
<tr>
<td><b>ca ma</b>
</td>
<td>Quando?
</td>
<td>durante o quê
</td></tr>
<tr>
<td><b>bu'u ma</b>
</td>
<td>Onde?
</td>
<td>em quê
</td></tr>
<tr>
<td><b>ma prenu gi'e …</b>
</td>
<td>Quem?
</td>
<td>quem é uma pessoa e …
</td></tr>
<tr>
<td><b>ma dacti gi'e</b>
</td>
<td>O quê? (sobre objetos)
</td>
<td>o que é um objeto e …
</td></tr>
<tr>
<td><b>ri'a ma</b>
</td>
<td>Por quê?
</td>
<td>por causa de quê
</td></tr>
<tr>
<td><b>pe ma</b>
</td>
<td>De quem? Qual? Sobre o quê?
</td>
<td>pertencente a quê ou a quem
</td></tr>
<tr>
<td><b>le mlatu poi mo</b>
</td>
<td>Qual gato? Que tipo de gato?
</td>
<td>
</td></tr></tbody></table>

**pe ma** é anexado apenas a argumentos:

> **le penbi pe ma cu zvati le jubme**
> _De quem é a caneta em cima da mesa?_

### Perguntas de número

> **le xo prenu cu klama ti**
> _Quantas pessoas estão vindo aqui?_

<!-- -->

> **mu**
> _Cinco._

A palavra **xo** significa _Quantos?_ e, portanto, pergunta por um número. A resposta completa será:

> **le mu prenu cu klama ti**
> _As 5 pessoas estão vindo para este lugar._

A pessoa que está sendo perguntada deve colocar um valor apropriado no lugar de **xo**.

Aqui estão mais alguns exemplos:

> **le xo botpi cu kunti**
> _Quantas garrafas estão vazias?_

<!-- -->

> **do ralte le xo gerku**
> _Quantos cachorros você tem?_

### Verbos de fatos

Considere o exemplo:

> **mi djuno le du'u do stati**
> _Eu sei que você é inteligente._

djuno
: $x_1$ sabe $x_2$ (proposição) sobre $x_3$

> **mi jimpe le du'u do pu citka**
> _Eu entendo que você estava comendo._

jimpe
: $x_1$ compreende $x_2$ (proposição) sobre $x_3$

<pixra url="/assets/pixra/cilre/na_jimpe.webp" caption="mi na jimpe" definition="Eu não entendo."></pixra>

Em lugares que descrevem fatos, a partícula **du'u** é usada (em vez de **nu**).

**djuno** (_saber_) e **jimpe** (_entender_) descrevem fatos. Seria ilógico dizer, _Eu entendo que você estava comendo, mas na verdade, você não estava._

Observe que a relação iniciada com **du'u** não precisa ser verdadeira:

> **le du'u do mlatu cu jitfa**
> _Que você é um gato é falso._

jitfa
: $x_1$ (proposição) é falso

Quando você deve usar **du'u** e quando deve usar **nu**? Você pode consultar o dicionário:

- O rótulo _(du'u)_ ou _(proposição)_ marca os lugares onde **du'u** é recomendado.
- O rótulo _(nu)_ ou _(evento)_ marca os lugares onde **nu** é recomendado.

Se você usar **nu** em vez de **du'u** por engano, ainda será compreendido. No entanto, falantes fluentes de Lojban geralmente distinguem entre essas partículas.

### Perguntas indiretas

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Eu sei quem está estudando Lojban._

Isso é chamado de pergunta indireta. A palavra _quem_ aqui não é um pedido de informação, e não há ponto de interrogação. A resposta é presumida e, na verdade, você mesmo sabe a resposta para a pergunta _Quem está aprendendo Lojban?_

**kau** é uma interjeição que colocamos após uma palavra interrogativa para indicar que é uma pergunta indireta.

Se eu te fizer a pergunta **ma tadni la .lojban.**, você sabe qual valor preencher no espaço **ma**: **la .kevin.** Então você poderia simplesmente dizer

> **ma tadni la .lojban.**
> _Quem está estudando Lojban?_

<!-- -->

> **mi djuno le du'u ma kau tadni la .lojban.**
> _Eu sei quem está estudando Lojban. Eu sei a identidade da pessoa que está estudando Lojban._

<!-- -->

> **mi djica le nu ma tadni la .lojban.**
> _Quem eu quero que estude Lojban?_
> `Eu quero que quem estude Lojban?`

Isso nunca pode ser uma pergunta indireta: está pedindo uma resposta (mesmo que seja retoricamente).

Você pode colocá-lo após outras palavras interrogativas:

> **mi djuno le du'u le xo kau prenu cu tadni la .lojban.**
> *Eu sei quantas pessoas estudam Lojban.*

### Citações indiretas (discurso relatado): ‘_Eu disse que viria._’

Uma relação como _Alice disse, "Michelle disse, 'Olá' para mim"_ também pode ser expressa de uma forma mais sutil:

> **la.alis. pu cusku zo'e pe le nu la .micel. pu enxagua la .alis.**
> _Alice disse algo sobre Michelle cumprimentá-la antes._
> `Alice disse algo sobre o caso de Michelle cumprimentá-la.`

Alternativamente, você pode torná-lo mais curto:

> **la.alis. pu cusku le se du'u la .micel. pu enxagua la .alis.**
> _Alice disse que Michelle a cumprimentou._

A combinação **se du'u** permite a expressão do discurso indireto.

Aqui estão alguns exemplos de relações úteis para discurso relatado:

> **le ninmu pu retsku le se du'u mi klama ma kau**
> _Ela perguntou onde eu estava indo._

<!-- -->

> **mi pu spusku le se du'u mi klama le zdani**
> _Eu respondi que estava indo para casa._

<!-- -->

> **mi pu spuda le se retsku be le ninmu le ka spusku le se du'u mi klama le zdani**
> _Eu respondi à pergunta dela dizendo que estava indo para casa._

Perguntas no discurso relatado:

> **mi pu cusku le se du'u ma tadni la .lojban.**
> _Quem eu disse que está estudando Lojban?_
> `Eu perguntei quem está estudando Lojban?`

Assim, Lojban tem várias palavras para _que …_, dependendo do tipo de coisa que se quer dizer.

- Se _que …_ descreve o que pode ser visto, ouvido ou o que acontece, use **nu**.
- Se _que …_ descreve o que você pensa, algum fato ou informação, use **du'u**.
- Se _que …_ descreve o que você diz, use **se du'u**.
   - Mas se você precisar de uma citação literal, use **lu … li'u**.

### Interjeições emocionais: "_Uhu!_" = «**ui**», "_Concordo!_" = «**ie**», "_Ufa!_" = «**.o'u**»

Conhecemos essas interjeições como **ui** (_Uhu!_), **.a'o** (_Eu espero_).

> **do jinga ui**
> *Você venceu! (Estou feliz com isso!)*

ui
: interjeição: _Uhu!_, interjeição de felicidade

<pixra url="/assets/pixra/cilre/ui_jinga.webp" caption="ui mi jinga" definition="Yay! Eu venci!"></pixra>

Interjeições funcionam como **sei** com suas relações. **ui** significa o mesmo que **sei mi gleki**, então também poderíamos dizer **Você venceu sei mi gleki**, com o mesmo significado (embora seja um pouco mais longo).

Existem interjeições que expressam outros estados emocionais. Elas são semelhantes a emoticons como ;-) ou :-(, mas em Lojban, podemos ser mais específicos sobre nossas emoções, mantendo a concisão em nossa fala.

> **ie tu mlatu**
> _Sim, isso é um gato._

<!-- -->

> **ie nai .i tu na ku mlatu**
> _Não, eu não concordo. Isso não é um gato._

ie
: interjeição: _Sim! Concordo!_ (concordância)

ie nai
: interjeição: discordância

> **.ai mi vitke do**
> _Eu vou te visitar._

.ai
: interjeição: _Eu vou …_ (intenção)

> **.au do kanro**
> _Eu desejo que você esteja saudável._

.au
: interjeição de desejo

<pixra url="/assets/pixra/cilre/clira.webp" caption="mi clira klama" definition="Eu cheguei cedo."></pixra>

> **.a'o do clira klama**
> _Eu espero que você chegue cedo._

.a'o
: interjeição: Eu espero

clira
: $x_1$ acontece cedo

<pixra url="/assets/pixra/cilre/ciska.webp" caption=".ei mi ciska le xatra ti voi pelji ku'o le penbi" definition="Eu devo escrever a carta neste papel usando a caneta."></pixra>

> **.ei mi ciska le xatra le pelji le penbi**
> _Eu devo escrever a carta no papel usando a caneta._

.ei
: Eu devo … (obrigação)

ciska
: $x_1$ escreve $x_2$ em meio $x_4$

> **.i'e do pu gunka le vajni**
> _Muito bem! Você fez um trabalho importante._

.i'e
: interjeição: _Ótimo!_ (aprovação)

> **.o'u tu mlatu**
> _Ah, isso é apenas um gato._

.o'u
: interjeição: _Ufa!_ (alívio)

Nesse caso, você provavelmente pensou que era algo perigoso, mas é apenas um gato, então você está dizendo **.o'u**.

> **.u'i ti zmitci**
> _Ha-ha, isso é um robô._

.u'i
: interjeição: _Ha-ha!_ (diversão)

zmitci
: … é uma ferramenta automática

Você pode adicionar ou remover interjeições de uma frase sem correr o risco de quebrá-la.

Qualquer palavra que comece com uma vogal pura (excluindo **u** e **i** antes de vogais) é prefixada com um ponto em Lojban na escrita e com uma pausa na fala. Portanto, a grafia correta é **.a'o** e assim por diante. É comum omitir os pontos na escrita. No entanto, ao falar, você deve sempre mostrar esse ponto fazendo uma pequena pausa antes de dizer tal palavra para evitar a fusão de duas palavras vizinhas em uma só.

Como com **xu** ou **sei**-relações, podemos adicionar interjeições após qualquer argumento ou construção de relação, expressando assim nossa atitude em relação àquela parte da frase.

### Interjeições de urgência

Um grupo especial de interjeições "imperativas/hortativas" é usado para instigações, comandos e pedidos. Já encontramos **.e'o**:

> **.e'o mi ciksi da poi mi cusku djica**
> _Por favor, deixe-me explicar o que quero dizer._

.e'o
: interjeição: _Por favor ..._ (pedido)

> **— au mi klama le nenri**
> **— .e'a**
> _— Eu gostaria de entrar._
> _— Por favor, entre._

.e'a
: interjeição: _Eu permito, você pode ..._ (permissão)

le nenri
: o interior, o que está dentro

> **.e'ei do zukte**
> _Vamos lá, faça isso!_

.e'ei
: interjeição: _Vamos lá!_ (encorajamento, instigação, provocação). Palavra não oficial

> **.e'i do zutse doi le verba**
> _Sente-se, criança!_

.e'i
: interjeição: _Faça isso!_ (comando)

> **.e'u do pinxe le jisra**
> _Sugiro que você beba o suco. É melhor beber o suco._

.e'u
: interjeição: _Vamos ..._ (sugestão)

### «**ko**» para urgências rápidas

> **do bajra**
> _Você corre._

<!-- -->

> **bajra**
> _Alguém corre._

Em Lojban, **bajra** como uma frase significa _Alguém corre_ (ou _está correndo_ / _corria_, dependendo do contexto). **bajra** também pode significar um comando, _Corra!_, mas às vezes o contexto não é suficiente para determinar se é um incentivo para correr ou simplesmente uma afirmação de que alguém corre ou está correndo.

O pronome **ko** é usado em vez de **do** para fazer pedidos, sugestões ou comandos:

> **ko bajra**
> _Corra! Faça isso para que você corra!_

**ko** é uma alternativa mais vaga para **do .e'o**, **do .e'u**, **do .e'i**.

É perfeitamente aceitável dizer algo mais preciso, como:

> **do .e'o bajra**
> _Você, por favor, corra!_

colocando a ênfase em nossa cortesia em **do** (_você_).

Ao mover **ko** em uma relação, o comando/pedido é movido para essa parte. Por exemplo:

> **nelci ko**
> _Faça com que alguém goste de você!_

nelci
: ... gosta de ... (algo ou alguém)

Como você pode ver, precisamos reestruturar essa relação em português, o que ainda soa estranho. No entanto, você poderia usá-lo em Lojban no sentido de _Tente causar uma boa impressão_.

Observe que **prami** corresponde ao verbo em português _amar_, enquanto **nelci** corresponde ao verbo em português _gostar_.

Podemos até ter vários **ko** em uma única frase:

> **ko kurji ko**
> _Cuide de si mesmo._

kurji
: ...cuida de... (alguém ou algo)

### Interjeições discursivas

> **au mi citka le salta .e ji'a le grute**
> _Eu gostaria de comer a salada e também as frutas._

ji'a
: _adicionalmente, também_, significa que existem outras pessoas que também são iguais (_você_, neste caso) ou que fazem o mesmo

salta
: ...é uma salada

grute
: ...é uma fruta

> **mi si'a nelci do**
> `Eu também gosto de você`

<!-- -->
> **— mi nelci le'e mlatu**
> **— mi si'a nelci le'e mlatu**
> _— Eu gosto de gatos._
> _— Eu também gosto de gatos (Eu também)._

si'a
: _similarmente, também_, denota que algo é semelhante, embora seja diferente em outros aspectos não mencionados

### Estrutura das interjeições: «**nai**», «**sai**», «**pei**», «**dai**»

As interjeições podem consistir em:

1. a raiz, como **ui** (_Uau!_)
2. após ela, sufixos como **pei**, **dai**, **zo'o**:

 > **ui zo'o**
 > _Uau! (brincadeira, eu não estou realmente feliz)_

3. tanto a raiz quanto cada um dos sufixos podem ser modificados com partículas escalares como **nai**:

 > **ui nai**
 > _Ai!_

<!-- -->
 > **ui nai zo'o**
 > _Ai! (brincadeira, eu não estou falando sério sobre esse sentimento)_

<!-- -->
 > **ui nai zo'o nai**
 > _Ai, não estou brincando, estou me sentindo infeliz_

Alguns exemplos de como as partículas escalares funcionam.

- **ju'o** = _interjeição: tenho certeza (certeza)_
- **ju'o cu'i** = _interjeição: talvez, possivelmente (incerteza)_
- **ju'o nai** = _interjeição: não faço ideia!_

Exemplos comuns de interjeições:

- uma interjeição formada apenas pela raiz:

 > **ju'o le bruna co'i klama**
 > _Tenho certeza de que o irmão veio._

- a partícula escalar **cu'i** transforma uma interjeição de raiz nua em uma atitude intermediária:

 > **ju'o cu'i le bruna co'i klama**
 > _Talvez o irmão tenha vindo, não tenho certeza._

- a partícula escalar **nai** transforma a interjeição em uma atitude oposta:

 > **ju'o nai le bruna co'i klama**
 > _Talvez o irmão tenha vindo, talvez não, não faço ideia._

Da mesma forma, **ui** é _Whee! Yay!_, enquanto **ui nai** significa _Ai!_

Os significados precisos das interjeições que são significativas com suas partículas escalares **cu'i** e **nai** são fornecidos no dicionário.

- A partícula escalar **sai** denota uma intensidade forte da interjeição:

 > **.u'i sai**
 > _Ha-ha-ha!_

Vocativos também podem ser modificados com partículas escalares:

> **ki'e sai do**
> _Muito obrigado!_

Sufixos são adicionados após a raiz da interjeição (juntamente com suas partículas escalares, se as usarmos):

- O sufixo de interjeição **pei** transforma a interjeição em uma pergunta.

 > **— .au pei do .e mi klama le zarci**
 > **— .au cu'i**
 > _— Você quer que você e eu vamos à loja?_
 > _— Meh, eu não tenho preferências._

 <!-- -->

 > **— ie pei tu melbi**
 > **— ie**
 > _— Aquela é bonita, não é?_
 > _— Sim._

- O sufixo de interjeição **dai** mostra os sentimentos dos outros, não os sentimentos do falante:

 > **ui nai dai do na ku co'i jinga**
 > _Você deve estar triste, você não ganhou._

 <!-- -->

 > **.a'u**
 > _Isso é interessante!_

 <!-- -->

 > **.a'u dai**
 > _Isso deve ter sido interessante para você!_

- Interjeições simples expressam a atitude do falante. **ei do cliva** não significa _Você deve sair_, mas sim _Sinto a obrigação de você sair_. **dai** mostra que o falante está se colocando no lugar dos sentimentos de outra pessoa.

 > **.ei dai do cliva**
 > _Você sente a obrigação de você mesmo sair._

Observe que as interjeições não necessariamente mostram atitude em relação aos próprios falantes. Em vez disso, elas expressam a atitude dos falantes em relação a outras coisas.

- O sufixo de interjeição **zo'o** marca a atitude como não sendo séria:

 > **.e'u zo'o do pinxe ti**
 > _Eu sugiro que você beba isso (brincadeira)._

- Sufixos também podem ser modificados com partículas escalares:

 > **ie zo'o nai**
 > _Eu concordo (sem brincadeira)._

- **zo'o nai** é usado para mostrar que a informação não é uma piada:

 >**zo'o nai ra pu klama la .paris.**
 >_— Eu estou falando sério, ele foi para Paris._

- Sufixos podem ser usados por si só:
 - **pei** quando usado sozinho pede qualquer interjeição que o ouvinte considere apropriada:

 > **— pei le lunra cu crino**
 > **— .ie nai**
 > _— A lua é verde (qual é o seu sentimento sobre isso?)_
 > _— Discordo._

- Para outros sufixos, significa que a interjeição raiz **ju'a** (_Eu afirmo_) foi omitida:

 > **zo'o do kusru**
 > **ju'a zo'o do kusru**
 > _Você é cruel (brincadeira)._

ju'a
: interjeição: Eu afirmo (não confunda com **ju'o** (Eu tenho certeza))

### Apenas para referência: interjeições em tabelas

Aqui está uma visão mais abrangente: interjeições emocionais, de urgência e várias outras por série.

<table>
<tbody><tr>
<td><b>.au</b><br/><i>Desejo...</i>
</td>
<td><b>.ai</b><br/><i>Eu vou...</i>
</td>
<td><b>.ei</b><br/><i>Deveria ser...</i>
</td>
<td><b>.oi</b><br/><i>Ai!</i>
</td></tr>
<tr>
<td><b>.au cu'i</b><br/><i>meio assim</i><br/>indiferença
</td>
<td><b>.ai cu'i</b><br/>indecisão
</td>
<td><b>.ei cu'i</b>
</td>
<td><b>.oi cu'i</b>
</td></tr>
<tr>
<td><b>.au nai</b><br/><i>Não!</i><br/>desinteresse, relutância
</td>
<td><b>.ai nai</b><br/>acidentalmente
</td>
<td><b>.ei nai</b><br/>liberdade, como as coisas podem não precisar ser
</td>
<td><b>.oi nai</b><br/>prazer
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoção</th></tr></thead>
<tbody>
<tr>
<td><b>ua</b><br/><small>"uá" como em "<u>u</u>va", "<u>u</u>ma vez"</small><br/><i>Aha! Eureka!</i>
</td>
<td><b>ue</b><br/><small>"uê" como em "<u>u</u>va"</small><br/><i>Que surpresa!</i>
</td>
<td><b>ui</b><br/><small>"uí" como "ui"</small><br/><i>Viva!</i>
</td>
<td><b>uo</b><br/><small>"uô" como em "<u>u</u>mbigo", "<u>u</u>é"</small><br/><i>Voilà!</i>
</td>
<td><b>uu</b><br/><small>"uú" como "u"</small><br/><i>Coitadinho</i>
</td></tr>
<tr>
<td><b>ua cu'i</b><br/>&nbsp;
</td>
<td><b>ue cu'i</b><br/><i>Não estou realmente surpreso</i>
</td>
<td><b>ui cu'i</b><br/>&nbsp;
</td>
<td><b>uo cu'i</b><br/>&nbsp;
</td>
<td><b>uu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ua nai</b><br/><i>Ah! Eu não entendo!</i><br/>confusão
</td>
<td><b>ue nai</b><br/>expectativa, falta de surpresa
</td>
<td><b>ui nai</b><br/><i>Ai!</i><br/>sentindo-se infeliz
</td>
<td><b>uo nai</b><br/>sentindo-se incompleto
</td>
<td><b>uu nai</b><br/><i>Mwa ha ha!</i><br/>crueldade
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoção</th></tr></thead>
<tbody>
<tr>
<td><b>ia</b><br/><small>"yah" como em "<u>ya</u>rd"</small><br/><i>Acredito</i>
</td>
<td><b>ie</b><br/><small>"yeh" como em "<u>ye</u>s"</small><br/><i>sim! concordo!</i>
</td>
<td><b>ii</b><br/><small>"yeeh" como em "hear <u>ye</u>"</small><br/><i>ai!</i>
</td>
<td><b>io</b><br/><small>"yoh" como em "<u>yo</u>gurt"</small><br/><i>respeito</i>
</td>
<td><b>iu</b><br/><small>"yooh" como em "c<u>u</u>te, d<u>ew</u>"</small><br/><i>Eu amo isso</i>
</td></tr>
<tr>
<td><b>ia cu'i</b><br/>&nbsp;
</td>
<td><b>ie cu'i</b><br/>&nbsp;
</td>
<td><b>ii cu'i</b><br/>&nbsp;
</td>
<td><b>io cu'i</b><br/>&nbsp;
</td>
<td><b>iu cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>ia nai</b><br/><i>Pshaw!</i><br/>descrença
</td>
<td><b>ie nai</b><br/>discordância
</td>
<td><b>ii nai</b><br/><i>Me sinto seguro</i>
</td>
<td><b>io nai</b><br/>desrespeito
</td>
<td><b>iu nai</b><br/>ódio
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoção</th></tr></thead>
<tbody>
<tr>
<td><b>.u'a</b><br/><small>"oohah" como em "t<u>wo ha</u>lves"</small><br/><i>ganho</i>
</td>
<td><b>.u'e</b><br/><small>"ooheh" como em "t<u>wo hea</u>ds"</small><br/><i>que maravilha!</i>
</td>
<td><b>.u'i</b><br/><small>"ooheeh" como em "t<u>wo hee</u>ls"</small><br/><i>hahaha!</i>
</td>
<td><b>.u'o</b><br/><small>"oohoh" como em "t<u>wo haw</u>ks"</small><br/><i>coragem</i>
</td>
<td><b>.u'u</b><br/><small>"oohooh" como em "t<u>wo hoo</u>ds"</small><br/><i>desculpe!</i>
</td></tr>
<tr>
<td><b>.u'a cu'i</b><br/>&nbsp;
</td>
<td><b>.u'e cu'i</b><br/>&nbsp;
</td>
<td><b>.u'i cu'i</b><br/>&nbsp;
</td>
<td><b>.u'o cu'i</b><br/>timidez
</td>
<td><b>.u'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.u'a nai</b><br/>perda
</td>
<td><b>.u'e nai</b><br/><i>Pff!</i><br/>comum
</td>
<td><b>.u'i nai</b><br/><i>Blah</i><br/>cansaço
</td>
<td><b>.u'o nai</b><br/>covardia
</td>
<td><b>.u'u nai</b><br/>&nbsp;
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Atitude</th></tr></thead>
<tbody>
<tr>
<td><b>.i'a</b><br/><small>"eehah" como em "t<u>eaho</u>use"</small><br/><i>ok, eu aceito isso</i>
</td>
<td><b>.i'e</b><br/><small>"eeheh" como em "t<u>eahea</u>d"</small><br/><i>Eu aprovo!</i>
</small></td>
<td><b>.i'i</b><br/><small>"eeheeh" como em "w<u>e hea</u>t"</small><br/><i>Estou com você nisso</i>
</td>
<td><b>.i'o</b><br/><small>"eehoh" como em "w<u>e haw</u>"</small><br/><i>graças a isso</i>
</td>
<td><b>.i'u</b><br/><small>"eehooh" como em "w<u>e hoo</u>k"</small><br/><i>familiaridade</i>
</td></tr>
<tr>
<td><b>.i'a cu'i</b><br/>&nbsp;
</td>
<td><b>.i'e cu'i</b><br/>não aprovação
</td>
<td><b>.i'i cu'i</b><br/>&nbsp;
</td>
<td><b>.i'o cu'i</b><br/>&nbsp;
</td>
<td><b>.i'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.i'a nai</b><br/>resistência
</td>
<td><b>.i'e nai</b><br/><i>Boo!</i><br/>desaprovação
</td>
<td><b>.i'i nai</b><br/>sentimento de antagonismo
</td>
<td><b>.i'o nai</b><br/>inveja
</td>
<td><b>.i'u nai</b><br/>desconhecimento
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Anexo à situação</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.a'a</b><br/><small>"ahah" como "aha"</small><br/><i>Estou ouvindo</i>
</td>
<td><b>.a'e</b><br/><small>"aheh"</small><br/><i>atenção</i>
</td>
<td><b>.a'i</b><br/><small>"aheeh" como em "Sw<u>ahi</u>li"</small><br/><i>ufa!</i><br/>esforço
</td>
<td><b>.a'o</b><br/><small></small><br/><i>Espero</i>
</td>
<td><b>.a'u</b><br/><small></small><br/><i>Hmm, eu me pergunto...</i>
</td></tr>
<tr>
<td><b>.a'a cu'i</b><br/>desatentamente
</td>
<td><b>.a'e cu'i</b><br/>&nbsp;
</td>
<td><b>.a'i cu'i</b><br/>sem esforço especial
</td>
<td><b>.a'o cu'i</b><br/>&nbsp;
</td>
<td><b>.a'u cu'i</b><br/><i>Bocejo</i><br/>desinteresse
</td></tr>
<tr>
<td><b>.a'a nai</b><br/>evitando
</td>
<td><b>.a'e nai</b><br/><i>Estou cansado(a)</i>
</td>
<td><b>.a'i nai</b><br/>repouso
</td>
<td><b>.a'o nai</b><br/><i>Ah!</i><br/>desespero
</td>
<td><b>.a'u nai</b><br/><i>Eca! Nojo!</i><br/>repulsa
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Estímulo</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.e'a</b><br/><small>"ehah"</small><br/><i>você pode</i>
</td>
<td><b>.e'ei</b><br/><small>"ehey"</small><br/><i>vamos lá, faça!</i>
</td>
<td><b>.e'i</b><br/><small>"eheeh"</small><br/><i>faça!</i>
</td>
<td><b>.e'o</b><br/><small>"ehoh"</small><br/><i>por favor, faça</i>
</td>
<td><b>.e'u</b><br/><small>"ehooh"</small><br/><i>eu sugiro</i>
</td></tr>
<tr>
<td><b>.e'a cu'i</b><br/>&nbsp;
</td>
<td><b>.e'ei cu'i</b><br/>&nbsp;
</td>
<td><b>.e'i cu'i</b><br/>&nbsp;
</td>
<td><b>.e'o cu'i</b><br/>&nbsp;
</td>
<td><b>.e'u cu'i</b><br/>&nbsp;
</td></tr>
<tr>
<td><b>.e'a nai</b><br/>proibindo
</td>
<td><b>.e'ei nai</b><br/>expressando desânimo, desmoralização
</td>
<td><b>.e'i nai</b><br/>&nbsp;
</td>
<td><b>.e'o nai</b><br/>oferecendo, concedendo
</td>
<td><b>.e'u nai</b><br/>alertando, desaconselhando
</td></tr>
</tbody></table>

<table>
<thead><tr><th colspan="5">Emoção</th></tr></thead>
<tbody>
<tr>
</td>
<td><b>.o'a</b><br/><small>"ohah"</small><br/><i>orgulho</i>
</td>
<td><b>.o'e</b><br/><small>"oheh"</small><br/><i>Sinto que está próximo</i>
</td>
<td><b>.o'i</b><br/><small>"oheeh"</small><br/><i>perigo!</i>
</td>
<td><b>.o'o</b><br/><small>"ohoh" como em "s<u>awho</u>rse"</small><br/><i>paciência</i>
</td>
<td><b>.o'u</b><br/><small>"ohooh"</small><br/><i>relaxamento</i>
</td></tr>
<tr>
<td><b>.o'a cu'i</b><br/>modéstia, humildade
</td>
<td><b>.o'e cu'i</b><br/>&nbsp;
</td>
<td><b>.o'i cu'i</b><br/>&nbsp;
</td>
<td><b>.o'o cu'i</b><br/>mera tolerância
</td>
<td><b>.o'u cu'i</b><br/>compostura, equilíbrio
</td></tr>
<tr>
<td><b>.o'a nai</b><br/><i>Que vergonha.<br/>Isso me deixa envergonhado(a).</i>
</td>
<td><b>.o'e nai</b><br/>distância
</td>
<td><b>.o'i nai</b><br/>imprudência, temeridade
</td>
<td><b>.o'o nai</b><br/>impaciência, intolerância
</td>
<td><b>.o'u nai</b><br/>estresse, ansiedade
</td></tr></tbody></table>

Observe como uma emoção se transforma em sua oposta ao usar **nai**, e na emoção intermediária ao usar **cu'i**.

Por que algumas células de interjeições com **cu'i** e **nai** estão vazias? Porque o português não possui formas concisas de expressar essas emoções.

Além disso, muitas dessas interjeições são raramente usadas.

### Combinando interjeições

> **iu ui nai**
> _Infelizmente apaixonado._

<!-- -->

> **ue ui do jinga**
> _Ah, você venceu! Estou tão feliz!_

jinga
: ... vence

Neste caso, a vitória era improvável, então estou surpreso e feliz ao mesmo tempo.

Interjeições (ao contrário de partículas escalares e sufixos de interjeição) não se modificam entre si:

> **ue ui do jinga**
> **ui ue do jinga**
> _Ah, você venceu! Estou tão feliz!_

Aqui, duas interjeições modificam a mesma construção (a frase inteira), mas não se modificam entre si, então a ordem delas não importa.

> **pei .u'i le gerku cu sutra plipe**
> _(O que você sente?) Heh, o cachorro está pulando rapidamente._

Aqui, **pei** é usado sozinho e não modifica **.u'i**, que é colocado depois dele.

### Esqueceu de colocar uma interjeição no início?

> **do pu sidju mi ui**
> _Você me ajudou (yay!)_

**ui** modifica apenas o pronome **mi**, expressando a atitude apenas em relação a _mim_.

> **ui do pu sidju mi**
> _Yay, você me ajudou._

E se esquecermos de adicionar **ui** no início dessa frase?

Podemos explicitamente marcar a relação como completa com **vau** e então colocar a interjeição:

> **do pu sidju mi vau ui**
> _Você me ajudou, yay!_