## Lição 11. Tópicos mais complicados

### Know your first language too

Ao tentar se expressar em Lojban, é importante não torná-lo apenas uma cópia do português.

Considere a frase:

> _Terry, o tigre, visita a cidade grande._
Pode ser tentador usar a relação

vitke
: $x_1$ (convidado) visita $x_2$ (alguém) em $x_3$

No entanto, a frase _visita a cidade grande_ implica visitar um lugar, e não alguém naquele lugar, o que destaca o fato de que o verbo português _visitar_ pode ter vários significados.

Na verdade, por exemplo, se considerarmos o francês, vemos soluções separadas:

> Gostaria de visitar meus amigos.<br/>
> J'aimerais rendre visite mes amis.
<!-- -->

> Eu gostaria de visitar esta cidade.<br/>
> J'aimerais visitou esta cidade.

O francês usa _rendre visite_ ao visitar alguém e _visiter_ ao visitar um lugar.

Em Lojban traduzimos o significado, não apenas palavras.

Compreender as peculiaridades da sua própria língua também é importante ao tentar expressar algo em Lojban.

As soluções para o exemplo acima podem ser:

> **la .teris. poi tirxu cu klama le barda tcadu**
> _Terry, o tigre, chega à cidade grande._
Tirxu
: $x_1$ é um tigre

> **la .teris. poi tirxu cu pa roi klama le barda tcadu**
> _Terry, o tigre, uma vez chega à cidade grande._
<!-- -->

> **la .teris. poi tirxu cu pa re'u mo'u klama le barda tcadu**
> _Terry, o tigre, chega pela primeira vez na cidade grande._
<!-- -->

> **la .teris. poi tirxu cu co'a klama le barda tcadu**
> _Terry, o tigre, parte para a cidade grande._

### Quatro significados de ‘_você_’ em português

Já vimos dois pronomes pessoais, **mi** (_eu_ ou _me_) e **do** (_você_). No entanto, _você_ e _vocês_ em português pode ter vários significados, que são traduzidos para o Lojban de maneiras específicas:

- _você_ como _a pessoa com quem estou falando_:

 >**le pa do**<br/>
 >_você um_

 Sabemos que **le re prenu** significa _as duas pessoas_. Também é possível colocar números depois de **le** e antes dos pronomes.

- _vocês_ como _todas as pessoas com quem estou falando_:

 >**ro do**<br/>
 >_cada um de vocês_, _todos vocês_

 Também é possível usar números com **ko**:

 >**ro ko klama ti**<br/>
 >_Todos vocês, venham aqui._

- _vocês_ como _um número específico de pessoas com quem estou falando_:

 >**le re do**<br/>
 >_vocês dois_

 Por exemplo, alguém pode começar e-mails para seus pais com **coi le re do**.

 Observe que **re do** significa _dois de vocês_ e **re le ci do** significa _dois de vocês três_.

- _você_ como _a pessoa ou pessoas com quem estou falando mais outras pessoas_:

 >**do'o**<br/>
 >_você e outra pessoa_

- _você_ como _qualquer pessoa_ (por exemplo, _O dinheiro não pode comprar o amor para você._):

 Geralmente é expresso por:

 >**ro da**<br/>
 >_todos **da**_

 ou

 >**ro lo prenu**<br/>
 >_todas as pessoas_

 No entanto, muitas vezes você pode omiti-lo completamente ou colocar **zo'e** nessa posição.
<!-- O método recomendado é transformar os pronomes em verbos primeiro:

>**lo re me do ko klama ti**
>_Vocês dois, venham aqui._

É possível omitir **me** nessa posição e dizer **lo re do ko klama ti**, mas isso pode levar a confusão para iniciantes. -->

### Mais sobre orações relativas curtas

Orações relativas curtas com um pronome após elas podem ser colocadas imediatamente após **le**:

> **le gerku pe mi**
> _Meu cachorro_

Nesses casos, **pe** pode até ser omitido:

> **le gerku pe mi**
> **le mi gerku**
> _Meu cachorro_

**le mi gerku** signifie exactement la même chose que **le gerku pe mi**.

Assim, "**le** + argumento + construção de relação" é equivalente a "**le** + construção de relação + **pe** + argumento".

Algumas regras:

- se você quiser usar um argumento convertido de uma relação (por exemplo, com **le**) ou se for um nome, é aconselhável usar **pe** e colocá-lo após o argumento: **le gerku pe la .alis.** (_Cachorro da Alice_).
- omitir **pe** é aceitável apenas ao usar pronomes sem números na frente deles: **le do gerku** (_seu cachorro_), mas não **le pa do gerku** (= **le pa do cu gerku** = _um de vocês é um cachorro_).

É muito mais seguro usar **pe** explicitamente e colocá-lo após o argumento ao qual está ligado: **le gerku pe la .alis.** e **le gerku pe mi** são as construções mais intuitivas.

### Citação de texto em diferentes idiomas

**zoi** é uma marca de citação para citar texto não-lojban. Sua sintaxe é **zoi X. texto .X**, onde X é uma palavra lojban (chamada de palavra delimitadora) que é separada do texto citado por pausas e que não é encontrada no texto escrito ou na sequência fonêmica falada dentro dessa citação. É comum, mas não obrigatório, usar o nome de alguma letra, que corresponde ao nome lojban do idioma sendo citado:

> **zoi gy. John is a man .gy. cu glico jufra**
> _"John is a man" é uma frase em inglês._

glico
: $x_1$ é inglês

onde **gy.** representa **glico**. Outras escolhas populares de palavras delimitadoras são a própria palavra _zoi_ e uma palavra lojban que sugere o tópico da citação.

Lojban evita estritamente qualquer confusão entre coisas e os nomes das coisas:

> **zo .bob. cmene la .bob.**
> `A-palavra "Bob" é-o-nome-de aquele-chamado Bob.`

**zo .bob.** é a palavra, enquanto **la .bob.** é a coisa nomeada pela palavra. As palavras qualificadoras curtas **la'e** e **lu'e** colocadas antes dos termos convertem de volta e para frente entre referências e seus referentes:

> **zo .bob. cmene la'e zo .bob.**
> _A palavra "Bob" é o nome do referente da palavra "Bob"._

<!-- -->

> **lu'e la .bob. cmene la .bob.**
> _Um símbolo para Bob é o nome de Bob._

Os dois últimos exemplos significam a mesma coisa. Mas isso é diferente:

> **la .bob. cu cmene la .bob.**
> _Bob é o nome de Bob._

e diz que Bob é tanto o nome quanto a coisa nomeada, uma situação improvável. Pessoas não são nomes.

**la'o** serve para marcar nomes não-lojban, por exemplo, os nomes binomiais linneanos (como "Homo sapiens"), que são os nomes padronizados internacionalmente para espécies de animais e plantas.

Nomes internacionalmente conhecidos que podem ser reconhecidos mais facilmente pela grafia do que pela pronúncia, como _Goethe_, também podem aparecer em texto lojban com **la'o**:

> **la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.**
> _Goethe é um Homo sapiens._

No entanto, usar **la'o** para todos os nomes em vez de adaptá-los ao lojban pode tornar o texto complicado.

Tudo expresso em texto também deve ser expresso em fala e vice-versa. Portanto, não pode haver pontuação que não seja pronunciada. Isso significa que o lojban tem uma ampla variedade de palavras para citar outras palavras. Todos os lojban convertem um texto em um termo de argumento.

**lu** ... **li'u** citam apenas texto que seja gramaticalmente correto. Para citar qualquer texto lojban, usamos citações **lo'u** ... **le'u** em vez disso.

> **— xu lo'u je le'u lojbo sumsmi**
> **— na ku sumsmi**
> _— "je" é um termo?_
> _— Não._

<!-- -->

> **ma xe fanva zoi gy.What's up?.gy. la .lojban.**
> _Como traduzir "What's up?" para lojban?_

### Termos internos

Usando **be**, você pode preencher não apenas slots de relações, mas também adicionar termos modais:

> **le xatra be de'i li vo cu se mrilu de'i li ze**
> _Esta carta, datada do dia 4, é enviada no dia 7_

xatra
: $x_1$ é uma carta

Uma data marcada com **de'i** se aplica apenas ao **xatra**. Compare:

> **le xatra de'i li vo cu se mrilu de'i li ze**
> _A carta no dia 4 é enviada no dia 7_ (o que quer que isso signifique)

Sem o **be**, o termo **de'i li vo** se aplicaria à relação como um todo, e não ao **xatra**. O que queremos dizer é que a data anterior se aplica apenas à carta, e a data posterior se aplica ao envio da carta. Isso significa que em **le xatra be de'i li vo**, a parte **de'i li vo** (_o dia 4, como uma data_) se aplica apenas ao argumento **le xatra**, e não à frase inteira.

### Relações compostas em detalhes

A agrupação de termos na gramática Lojban é particularmente importante quando se trata de tanru (relações compostas). A forma como as relações se agrupam em um tanru determina o que esse tanru significa. Por exemplo,

> _a revista de música ruim_

tem duas interpretações em português: uma revista ruim sobre música ou uma revista sobre música ruim. Em Lojban, seu equivalente

> **le xlali zgike karni**

tem apenas a interpretação _a revista de música ruim_, porque as duas primeiras relações (_xlali zgike_ — _música ruim_) se agrupam primeiro. É importante modificar a agrupação das relações para garantir que o tanru transmita o significado pretendido. Por esse motivo, o Lojban possui alguns mecanismos para fazer com que os tanru se agrupem corretamente.

Em português, usamos colchetes para estruturar o texto. Da mesma forma, para tanru, usamos **ke** como colchete esquerdo e **ke'e** como colchete direito.

**le xlali ke zgike karni** significa _a revista ruim de música_.

Como você pode ver, separamos **xlali** do restante do tanru e o aplicamos a todo o tanru. Não há necessidade de **ke'e** no final do tanru, pois já sabemos que ele termina aqui.

> **.i mi pu zi te vecnu le xlali ke zgike karni .i to'e zanru la'o gy.Eurythmics.gy.**
> _Acabei de comprar uma revista de música ruim. Ela criticou o Eurythmics._

Essa é uma maneira de agrupar os componentes em um tanru. A outra maneira é usar **bo** em um novo papel. Quando **bo** aparece entre dois componentes, significa que esses componentes se agrupam mais firmemente do que qualquer outra coisa. Portanto, uma forma alternativa de dizer _revista de (música ruim)_ é...

le xlali zgike bo karni
: a revista de música ruim

**bo** aqui é semelhante ao hífen na tradução em português. Isso significa que **zgike bo karni** deve ser considerado como uma unidade, à qual se aplica **xlali** (_ruim_).

Então **bo** torna as conexões mais estreitas:

> **la .doris. e la .alis. o nai bo la .bob.**
> _Doris e (ou Alice ou Bob)_

**ke** também pode ser usado com conectivos (embora não com frases; elas têm seu próprio tipo de colchete, **tu'e ... tu'u**). Então também poderíamos dizer

> **la .doris. e ke la .alis. o nai la .bob.**

Lembre-se de que o colchete direito **ke'e** muitas vezes pode ser omitido sem alterar o significado (como neste caso).

Conjunções de antecipação também são frequentemente usadas porque podem eliminar a necessidade de colchetes direitos:

> **ge la .doris. gi go nai la .alis. gi la .bob.**
> _Doris e (ou Alice ou Bob)_

e

> **go nai ge la .doris. gi la .alis. gi la .bob.**
> _(Ou Doris e Alice) ou Bob_

Não há necessidade de **bo** ou **ke** com conjunções de antecipação.

### «**co**» para mudar a ordem em relações compostas

Há outra maneira de reestruturar relações compostas.

> **mi fanva se jibri**
> _Eu sou um tradutor profissional_

jibri
: $x_1$ é um trabalho de $x_2$

Se eu quisesse dizer que sou um tradutor profissional de português para alemão, poderia usar **be** e **bei**:

> **mi fanva be le dotco bei le glico be'o se jibri**
> _Eu sou um tradutor profissional de alemão para inglês._

dotco
: $x_1$ é alemão

O fato de ser uma relação composta pode ser rapidamente perdido na fala devido à estrutura complicada da frase. Aqui, podemos usar a palavra **co**:

**co** — inverte a relação composta, fazendo com que o componente mais à direita modifique o mais à esquerda em vez do contrário. Qualquer termo de argumento anterior preenche o modificado, qualquer termo de argumento seguinte preenche o modificador.

> **mi se jibri co fanva le dotco le glico**

É a mesma relação que a anterior em Lojban, mas muito mais fácil de entender. Observe que qualquer argumento antes da relação composta preenche **se jibri**, enquanto qualquer argumento após ela preenche apenas o componente modificador: **fanva**.

A força pela qual dois componentes são unidos com **co** é muito fraca - ainda mais fraca do que a relação composta normal sem palavras de agrupamento. Isso garante que, em uma co-construção, o componente mais à esquerda seja sempre o componente sendo modificado, e o componente mais à direita sempre modifica, mesmo que qualquer uma dessas partes seja uma relação composta. Isso torna uma co-construção fácil de entender:

> **ti pelxu plise co kukte**

é lido como **ti (pelxu plise) co kukte**, que é o mesmo que **ti kukte pelxu bo plise**. Isso também significa que um **ke ... ke'e** não pode abranger um **co**.

Outro exemplo:

> **mi merko limna co mutce certu**
> _Eu sou um nadador americano muito experiente._

merko
: $x_1$ é americano (sentido dos EUA)

Aqui está a lista de diferentes tipos de agrupadores em relações compostas, classificados do mais restrito ao mais solto:

1. **bo** e **ke ... ke'e**
2. conectivos lógicos dentro de relações compostas como **je**
3. não usar palavras de agrupamento
4. **co**

### Terminação explícita de argumentos

A pequena palavra **ku** pode ser usada no final de um argumento para mostrar explicitamente sua fronteira direita. **ku** é análogo ao colchete direito na matemática.

> **tu du le badna ku ui**
> **tu du le ui badna**
> _Aquela é a banana (yay!)_

Ao contrário de:

> **tu du le badna ui**
> _Aquela é a banana (yay, que é uma banana e não algo mais na natureza!)_

### Evitando a terminação explícita
Outro estilo de fala envolve evitar a terminação. Aqui estão alguns casos comuns:

Eliminação de **li'u**, a aspas direita:

> **lu mi prami do li'u cu se cusku la .alis.**
> **lu mi prami do li'u se cusku la .alis.**
> **lu mi prami do cu se cusku la .alis.**
> _"Eu te amo", disse Alice._

**li'u** pode ser omitido aqui porque não pode haver duas construções de relação principal em uma frase. Portanto, primeiro lemos a parte **lu mi prami do**, e então quando vemos o **cu**, percebemos que não podemos continuar essa frase citada. Assumimos que a citação terminou e a frase externa continua. Assim, não há ambiguidade.

Eliminação de **ku'o**, a borda direita de orações relativas:

> **le prenu noi mi zgana ke'a ku'o ca tavla le pendo be mi**
> **le prenu noi mi zgana ke'a ca tavla le pendo be mi**
> *A pessoa que estou observando está conversando com meu amigo.*

**ku'o** pode ser omitido aqui quando a oração relativa que precisamos (**mi zgana ke'a**) termina em um termo, **ke'a** neste caso. Após a oração relativa, algo diferente de um termo começa, então a oração relativa não pode ser continuada, e assim sabemos que ela termina com sucesso sem nenhuma palavra explícita de colchete direito.

Um truque semelhante seria sempre colocar **ke'a** no final da oração relativa:

> **le prenu noi ke'a melbi ku'o ca tavla le pendo be mi**
> **le prenu noi melbi fa ke'a ca tavla le pendo be mi**
> *A pessoa que é bonita está conversando com meu amigo.*

No entanto, no caso a seguir, a terminação é necessária:

> **le prenu noi mi zgana ke'a ku'o le pendo be mi ca tavla**
> *A pessoa que estou observando está conversando com meu amigo.*

porque após a oração relativa **mi zgana ke'a**, escolhemos colocar outro termo (**le pendo be mi**) que não pertence à oração relativa atual.

Um truque parcial aqui seria usar **ce'e**:

> **le prenu noi mi ke'a zgana ce'e le pendo be mi ca tavla**
> *A pessoa que estou observando e meu amigo estão conversando.*

Aqui, terminamos a oração relativa com o construto principal de relação **zgana**. Em seguida, temos a conjunção **ce'e** e um termo depois (**le pendo be mi**). Como **ce'e** só pode unir termos, sabemos que à esquerda de **ce'e**, temos um termo, que só pode ser **a pessoa que estou observando**. Portanto, o significado é mantido e nenhuma ambiguidade surge. Observe que ainda precisamos de uma palavra separada, **ce'e**, nesses casos, então, embora tenhamos eliminado a palavra de colchete direito, ainda tivemos que introduzir algo mais.

> **mi cinmo le ka badri kei le tcini**
> **le ka badri cu se cinmo mi le tcini**
> **mi cinmo fi le tcini fe le ka badri**
> **mi cinmo le ka badri ce'e le tcini**
> _Estou triste com a situação._

> **mi stidi lo ka citka su'o da kei do**
> **mi stidi lo ka ce'u su'o da citka ce'e do**
> _Sugiro que você coma alguma coisa._

Como você pode ver, nenhum truque torna o resultado mais curto que o original com **kei**, então para ser mais conciso, você pode querer usar **kei**.

### Conversão de conjuntos em massas

> **le prenu cu pa moi le'i pendo be mi ku noi lu'o ke'a ca smaji**
> _Ele é o primeiro entre meus amigos que guardam silêncio juntos._
> _A pessoa é a primeira entre o conjunto de meus amigos que agora estão, como uma multidão, em silêncio._

A palavra qualificadora **lu'o** colocada antes de um argumento converte-o em uma massa composta pelos membros desse argumento. Neste caso, **ke'a** se refere ao conjunto dos meus amigos **le'i pendo be mi** e, em seguida, **lu'o** converte os membros do conjunto em uma massa, a multidão dos meus amigos.

### Conjuntos e subconjuntos

Alguns infinitivos podem implicar mais de um **ce'u**:

> **le'i prenu cu simxu le ka prami**
> **le'i prenu cu simxu le ka ce'u prami ce'u**
> _As pessoas se amam._

simxu
: membros do conjunto $x_1$ fazem reciprocamente $x_2$

A relação **simxu** considera todos os pares possíveis do conjunto especificado no lugar $x_1$ e afirma a relação especificada em $x_2$.

Se tivermos três pessoas, isso significa que todas elas se amam.

> **do ce la .alis. ce mi simxu le ka prami**
> **do ce la .alis. ce mi simxu le ka ce'u prami ce'u**
> _Você, Alice e eu todos nos amamos._

ce
: conjunção: une vários argumentos em um conjunto

A conjunção **ce** mescla argumentos em um conjunto. Assim, **do ce la .alis. ce mi** pode ser uma forma mais detalhada de **le'i prenu** do exemplo anterior, quando queremos nomear os membros do conjunto.

<pixra url="/assets/pixra/cilre/simxu_tunba.webp" caption="le'i ci prenu cu simxa le ka tunba" definition="The three people are all siblings to each other."></pixra>

No total, afirmamos 6 relações:

1. Você ama a Alice.
2. Você me ama.
3. A Alice me ama.
4. A Alice ama você.
5. Eu amo a Alice.
6. Eu amo você.

Portanto, **simxu** é uma maneira prática de expressar relações mútuas.

Agora, considere o exemplo:

> **le'i su'o cmima be le'i prenu cu simxu le ka prami**
> _Algumas das pessoas se amam._

cmima
: $x_1$ é um membro do conjunto $x_2$

Neste exemplo, mostramos que um subconjunto das pessoas em questão (um subconjunto de **le'i prenu**) tem amor mútuo.

Isso nos permite transmitir ideias ainda mais complicadas:

> **le'i su'o citno cmima be le'i stati prenu cu simxu le ka prami**
> _Alguns jovens daqueles indivíduos inteligentes se amam._
> `Alguns membros jovens do conjunto de pessoas inteligentes se amam.`

<!-- ## Lógica de segunda ordem

Vimos que **da** (e **de**, **di**) pode ser uma "variável" na forma de substantivo com significados declarados dependendo das proposições fornecidas.
Geralmente é traduzido como _existe X, existem X tais que..._

No entanto, por curiosidade, devo mencionar a série de verbos que também servem como "variáveis", mas na forma de verbo, ou seja, na forma de relacionamento:

>**su'o bu'a zo'u mi bu'a do**
>_Existe algum relacionamento ou propriedade: Eu tenho esse relacionamento com você._
> _Você e eu estamos relacionados de pelo menos uma maneira._

>**ro bu'a zo'u ga nai le'e mlatu cu bu'a gi la .dinas. bu'a**
>>_Para cada relação ou propriedade possível: se os gatos têm isso, então Dinah também tem._ (Assim, assumimos que Dinah é um gato.)

A lógica por trás desses verbos variáveis está oculta na lógica formal. Desnecessário dizer que eles raramente são usados na fala, mas aqui está um exemplo possível:

su'o bu'a zo'u ge ge da na bu'a gi su'o da su'o de zo'u ge da .e de bu'a gi da manci de gi ro da ro de zo'u da bu'a .ije da manci de .inaja de bu'a
- corrigir a frase -->

<!-- ## Coisas ainda não formalizadas em Lojban

Embora o Lojban possa ser a língua falada nº 1 no mundo devido à sua gramática detalhada, ainda existem algumas coisas que não foram formalizadas.
Não se sabe o que **ta'e na** significa em oposição a **na ta'e**.

Não se sabe como lidar com **na go'i**.

Não se sabe como xorlo funciona quando precisamos de conversão explícita entre conjuntos e massas, como operar conjuntos em geral, como usar xorlo junto com lógica de segunda ordem como bu'a.

postoxorlo trabalhando com anáforas e quantificadores externos. -->

<!-- ## Sistema de conectivos não padrão

Algumas pessoas, em vez de usar

- **a**, **e**, **o**, **u**

para conectar substantivos, usam

- **ja**, **je**, **jo**, **ju**

Então, em vez de dizer

>**mi e do nelci le plise**
>_Eu gosto de maçãs, e você gosta de maçãs._

eles dizem

>**mi je do nelci le plise**
>_Eu gosto de maçãs, e você gosta de maçãs._

Esta é uma abordagem não convencional. As pessoas usam esse estilo porque nele há menos conjunções para lembrar.

Mas você deve ter cuidado para não esquecer **le** ou números para formar substantivos: **mi nelci le plise je jisra** significaria _Eu gosto de algo que é uma maçã (ou maçãs) e é suco_ (?!)

A frase correta usa **le** para formar cada substantivo:

>**mi nelci le plise je le jisra**
>_Eu gosto de maçãs e suco._

Na abordagem padrão, o falante usa a conjunção separada **e** ao conectar substantivos, e é mais fácil ver a diferença e o significado correto:

>**mi nelci le plise .e le jisra**
>_Eu gosto de maçãs e suco._ -->