---
title: alfabeto krulermorna
---

**la krulermorna** é uma ortografia alternativa que implementa de forma mais rigorosa a isomorfia áudio-visual da grafia do Lojban.

1. A maioria das letras é da ortografia original baseada no latim.
2. As semivogais **i** e **u** antes de vogais são consideradas consoantes e, portanto, são expressas por letras distintas:
    * **i** => **ɩ**
    * **u** => **w**
3. Ditongos que se comportam como outras vogais "puras" são expressos por letras distintas:
    * **au** => **ǎ**
    * **ai** => **ą**
    * **ei** => **ę**
    * **oi** => **ǫ**
4. Em outras posições, **i** e **u** são mantidos como estão na ortografia original em latim.
## Uso

la krulermorna é usada por um algoritmo no aplicativo [la sutysisku](https://la-lojban.github.io/sutysisku/en/ "la sutysisku") para buscar rimas para palavras em Lojban.

Também pode ajudar a entender a morfologia do Lojban.

Além disso, é principalmente um projeto artístico.

O número total de letras no alfabeto Lojban é aumentado de 26 na grafia oficial para 32 em la krulermorna, o que pode não ser desejável para pessoas que usam teclados pequenos em telas como os de dispositivos portáteis.
## la vlipa krulermorna

<figure class="wide">
	<img src="https://github.com/La-Lojban/suho-pixra-pe-la-jbotcan/blob/master/320px-la_vlipa_krulermorna.png?raw=true" alt="la vlipa krulermorna">
	<figcaption>
	.i coi do<br/>.i mi ca jai gau djuno fai do<br/>lo du'u wi mi ca pilno<br/>la krulermorna<br/>lo ka ciska dei<br/>.i ɩa ky. jai cinri
	</figcaption>
</figure>

_la vlipa krulermorna_ é uma modificação de la krulermorna onde a letra **ǎ** é substituída pelo Caractere Unicode 'LATIN SMALL LETTER AU'. Este último não é suportado na maioria das fontes usadas

## Representação alternativa

<div class="first_col">

|     | a          | e          | i            | o            | u           | ǎ      | ą      | ę          | ǫ              |
| --- | ---------- | ---------- | ------------ | ------------ | ----------- | ------ | ------ | ---------- | -------------- |
| .   |            |            |              |              |             | desejo | intenção | obrigação | queixa/dor |
| ɩ   | crença     | concordância  | medo         | respeito      | amor        |        |        |            |                |
| w   | descoberta  | surpresa   | felicidade    | conclusão   | pena        |        |        |            |                |
| .a' | atenção  | alerta  | esforço       | esperança         | interesse    |        |        |            |                |
| .e' | permissão | competência | restrição   | pedido      | sugestão  |        |        |            |                |
| .i' | aceitação | aprovação   | união | apreciação | familiaridade |        |        |            |                |
| .o' | orgulho      | proximidade  | cautela      | paciência     | relaxamento  |        |        |            |                |
| .u' | ganho       | admiração     | diversão    | coragem      | arrependimento  |        |        |            |                |

</div>