---
icon: 📕 
title: Idioma completo
---

**CLL não oficial** (colloquialmente, *UnCLL*, *InCLL*) é um projeto organizado por Gleki de compilações experimentais regulares não oficiais (necessariamente aprovadas pelo Logical Language Group) do livro Complete Lojban Language.

*   Envie seus comentários (bugs notados, propostas, sugestões) para um dos seguintes lugares:
    *   [Grupo Lojban Reddit](https://www.reddit.com/r/lojban/)
    *   [Grupo Lojban Facebook](https://www.facebook.com/groups/lojban)
    *   Chat ao vivo: [Chat Telegram](https://t.me/lojban) ou [Chat Discord](https://discord.gg/BVm4EYR)
    *   para <gleki.is.my.name@gmail.com> (Gleki&nbsp;Arxokuna), o mantenedor do UnCLL.

## Lançamentos
### geklojban-1.2.15 Outubro 2022
#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.15" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.15/cll.pdf)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.15/xhtml_no_chunks/)
* ou leia o chamado ["documento de diferença" em PDF](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference_prefixed.pdf) que compara geklojban-1.2.15 com o UnCLL, versão 1.2.14 (publicada em julho de 2021). O documento tem inserções marcadas com verde e prefixo "ins\`" e exclusões marcadas com vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Há [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_previous/difference.html).

#### Breve lista de mudanças em comparação com a versão anterior 'geklojban-1.2.14 julho de 2021'

* corrigir erros de digitação e problemas estilísticos na créstoma (obrigado a koyshi, gleki)
* [issue #475](https://github.com/lojban/cll/issues/475) **nunkilbra** alterado para **nunkilca'a** (obrigado up4kid)
* [issue #466](https://github.com/lojban/cll/issues/466) melhorado o algoritmo de teste tosmabru (obrigado vpbroman)
* [issue #473](https://github.com/lojban/cll/issues/473) "matrix transpose" cmavo agora usa o sobrescrito T para o operador de transposição
* Menções à fonte Helvetica foram substituídas por menções à fonte Comic ("Comic" é o nome de pelo menos uma fonte de código aberto)
* corrigidos outros erros menores de digitação (obrigado Matt Nazarian, mattfbacon, la-kanba)
* Mudanças de CSS para melhorar o funcionamento das versões HTML em dispositivos no modo escuro (obrigado a NathanHawks)
* O UnCLL agora possui arquivos de diferença visual em relação ao lançamento anterior e separadamente para o lançamento oficial.

[fonte git do UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparado com a versão 'geklojban-1.2.12 novembro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparação entre a edição oficial CLL v.1.1 (2016) e a edição UnCLL de novembro de 2020: diferença git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
* o documento PDF de "diferença" que compara geklojban-1.2.15 com a edição oficial CLL v.1.1 (2016). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Há [uma versão alternativa da diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.15/diff_from_official/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).

### geklojban-1.2.14 julho de 2021

#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.14" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.14/cll.pdf)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_no_chunks/)
* ou leia o chamado documento PDF de "diferença" que compara geklojban-1.2.14 com o UnCLL, versão 1.2.12 (publicado em novembro de 2020). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Há [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.14/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão anterior 'geklojban-1.2.11.1 outubro de 2020'

* é uma das principais melhorias. [Glossário de Palavras Lojban](https://la-lojban.github.io/uncll/uncll-1.2.14/xhtml_section_chunks/go01.html) recebeu cerca de 200 novos exemplos de frases em Lojban com sua tradução para o inglês. Como o número de palavras principais em Lojban é cerca de 2000, isso significa que ~10% dessa tarefa está concluída.
* corrigidos erros com **bo**, **ke'e** no Capítulo 5. 'Negação escalar de selbri'
* corrigir um nome incorreto de um arquivo de áudio
* mais melhorias no índice: adicionado ZEhA e mais BAI
* explicar melhor cmevla de acordo com o dotside
* adicionar pontos ausentes em cmavo quando necessário
* corrigir pontuação na tradução do poema 'Kubla Khan'

[fonte git do UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparado com a versão 'geklojban-1.2.12 novembro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.14)
* [Comparação entre a edição oficial CLL v.1.1 (2016) e a edição UnCLL de novembro de 2020: diferença git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.13 maio de 2021

#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.13" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll.pdf)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.13/xhtml_no_chunks/)
* ou leia o chamado documento ["diferença" em PDF](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference_prefixed.pdf) que compara geklojban-1.2.13 com o UnCLL, versão 1.2.12 (publicado em novembro de 2020). O documento tem inserções marcadas com verde e prefixo "ins\`" e exclusões marcadas com vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.13/cll_diffs/diff_new_xhtml_no_chunks/difference.html).

#### Breve lista de mudanças em comparação com a versão anterior 'geklojban-1.2.11.1 de outubro de 2020'

* adicionar novas imagens bonitas de capítulos por [la-ninpre](https://github.com/la-ninpre)
* adicionar uma tradução do poema 'In Xanadu' à chrestomathy
* corrigir uma tentativa estranhamente datada de teoria dos conjuntos por [simpson](https://github.com/MostAwesomeDude)
* corrigir a definição de **toldi** (_borboleta_)
* corrigir declaração incorreta que implicava que fuhivla não têm rafsi
* tornar a explicação de **le vi tavla ba klama** menos enganadora (correção implementada por [mezohe](https://github.com/mezohe))
* Matrizes com mais de duas dimensões podem ser construídas usando **pi'a** ou **sa'i** com um subscrito apropriado que rotula a dimensão... Os rótulos podem ser qualquer coisa que **xi** suporte, por exemplo, **pa** ou **mlatu bu**.
* Capítulo 5: restaurar menção ao agrupamento **bo** na seção sobre NAhE, e adicionar **bo** a um exemplo (correção implementada por [mezohe](https://github.com/mezohe))
* Capítulo 7: corrigir declaração sobre **ra'o** no exemplo 7.39 (correção implementada por [mezohe](https://github.com/mezohe))
* Capítulo 2: corrigir diagrama (predicado -> predicação) (correção implementada por [mezohe](https://github.com/mezohe))
* adicionar pontos ausentes em cmavo
* corrigir outros erros menores, elementos de índices, scripts de compilação, etc.

[fonte git do UnCLL](https://github.com/lojban/cll/compare/geklojban-master)

* [Comparado com a versão 'geklojban-1.2.12 de novembro de 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.12...geklojban-1.2.13)
* [Comparação entre a edição oficial CLL v.1.1 (2016) e a edição UnCLL de novembro de 2020: diferença no git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e.133ba18ef4868e056a...geklojban-1.2.12)
### geklojban-1.2.12 de novembro de 2020

#### Versão compilada
* leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.12" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    * [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.12/cll.pdf)
    * [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_section_chunks/)
    * [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.12/xhtml_no_chunks/)
* ou leia o chamado documento PDF de "diferença" que compara geklojban-1.2.12 com o CLL publicado em 2016 (versão de 27 de agosto de 2016). O documento tem inserções marcadas com verde e prefixo "ins\`" e exclusões marcadas com vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
* ou leia o documento de diferença em formato HTML em vez disso:
    * [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.12/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão anterior 'geklojban-1.2.11.1 outubro de 2020'

* Adicionada pronúncia padrão de {u} no capítulo IPA (por [Vexatos](https://github.com/Vexatos))
* Símbolos de subscrito em glossas são tratados adequadamente (bug notado por [gr-g](https://github.com/gr-g))
* Corrigido um erro gramatical no Exemplo 17.36 (bug notado por [kotwys](https://github.com/kotwys))
* A partícula **ri'u** estava faltando na Seção 10.28 (como notado por [gr-g](https://github.com/gr-g)). Adicionado
* No Exemplo 7.12, o primeiro lugar de **lafti** é aplicado a uma pessoa. O predicado muda para **lafmuvgau** (que está nas notas da definição de **lafti**)
* No texto em inglês, mude .) para ). onde necessário
* Exiba raiz quadrada, infinito e razão áurea phi com símbolos reais
* Corrigir tradução incorreta de **levi rozgu cu sofi'upanova'e xunre**
* outras correções menores
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.12)
#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.11.1 outubro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.11.1...geklojban-1.2.12)
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.12)
* [Comparado com a edição oficial CLL v.1.1 (2016)': diferença git](https://github

#### Versão compilada
* leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.11" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    * [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.11/cll.pdf)
    * [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_section_chunks/)
    * [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.11/xhtml_no_chunks/)
* ou leia o chamado documento PDF de "diferença" que compara geklojban-1.2.11 com o CLL publicado em 2016 (versão de 27 de agosto de 2016). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
* ou leia o documento de diferença em formato HTML em vez disso:
    * [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.11/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão anterior 'geklojban-1.2.10 agosto de 2020'

* Links de áudio (áudio por la tcakoi, la .lindar., la .aionys.) são adicionados às versões HTML "divididas por seções" e "divididas por capítulos" do livro
* corrigir vários erros de digitação
* adicionar caracteres hanzi a um exemplo em chinês
* versão de correção rápida 1.2.11.1: fazer com que os botões de áudio nas páginas HTML realmente funcionem
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.11)
#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.10 agosto de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.10...geklojban-1.2.11)
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.11)
* [Comparado com a edição oficial CLL v.1.1 (2016)': diferença git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.11)
### geklojban-1.2.10 agosto de 2020

#### Versão compilada
* leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.10" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    * [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.10/cll.pdf)
    * [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_section_chunks/)
    * [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.10/xhtml_no_chunks/)
* ou leia o chamado documento PDF de "diferença" que compara geklojban-1.2.10 com o CLL publicado em 2016 (versão de 27 de agosto de 2016). O documento tem inserções marcadas com verde e prefixo "ins\`" e exclusões marcadas com vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
* ou leia o documento de diferença em formato HTML em vez disso:
    * [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.10/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão anterior 'geklojban-1.2.9 julho de 2020'

* Volume de Créstoma (textos selecionados) adicionado após o último capítulo
* os pontos nunca são omitidos em palavras, nem mesmo no Índice de Palavras Lojban
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.10)
#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.9 julho de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.9...geklojban-1.2.10)
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.10)
* [Comparado com a edição oficial CLL v.1.1 (2016)': diferença git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.10)

### geklojban-1.2.9 julho de 2020

#### Versão compilada
* leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.9" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    * [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.pdf)
    * [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.9/cll.epub)
    * [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_section_chunks/)
    * [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.9/xhtml_no_chunks/)
* ou leia o chamado documento de ["diferença" em formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference_prefixed.pdf) que compara geklojban-1.2.9 com o CLL publicado em 2016 (versão de 2016-08-27). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
* ou leia o documento de diferença em formato HTML em vez disso:
    * [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    * [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.9/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão anterior 'geklojban-1.2.8.1 junho de 2020'

* A versão HTML agora tem tabelas e exemplos com rolagem horizontal em telas estreitas (por exemplo, dispositivos móveis). Isso torna a versão HTML mais amigável para dispositivos móveis.
* O EPUB é gerado novamente (estava faltando na versão 1.2.8.1)
* Símbolos coreanos e chineses agora são exibidos usando a fonte Noto CJK
* lugares como "$x_1$" agora são exibidos com números em subscrito
* Um exemplo na Seção 16.9 {naku zo'u la djan. klama} não correspondia aos outros exemplos ao redor, então foi substituído por {naku zo'u mi klama le zarci} (um bug notado por [Corbin Simpson](https://github.com/MostAwesomeDude))
* uma definição da palavra {bu'u} é adicionada à lista de outras partículas gramaticais da classe FAhA
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.9)
#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.8.1 junho de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1...geklojban-1.2.9)
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.9)
* [Comparado com a edição oficial

#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.8.1" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll.pdf)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.8.1/xhtml_no_chunks/)
* ou leia o chamado documento PDF de "diferença" que compara geklojban-1.2.8.1 com o CLL publicado em 2016 (versão de 27 de agosto de 2016). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.8.1/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão anterior 'geklojban-1.2.7 Maio 2020'

* Uma nova ortografia "diacrítica" chamada "zbalermorna" foi adicionada. É claramente mencionada como não oficial. Seus símbolos ("letras") são exibidos com uma fonte apropriada. Parabéns a [Jack Humbert](https://jackhumbert.github.io/zbalermorna/) e sua equipe (la saski'o, la xaspeljba e outros) pela fonte e pela revisão da explicação da ortografia.
* Os índices foram revisados (quase todas as suas 4000 entradas). Numerosas entradas foram modificadas para facilitar o uso ou movidas do Índice de Palavras Lojban para o Índice Geral ou vice-versa.
* a regra para o uso da vírgula foi [revertida](!https://github.com/lojban/cll/commit/b944ee1c8954175fc535a1285c38a5839a2c626d#diff-a81fd01b20e40cf4b0d02a734acf21fe) para a versão do CLL 1.1
* um algoritmo de diferença melhor para visualizar diferenças entre versões (sem bagunça extra)
* versão 1.2.8.1 lançamento de correção rápida: problemas corrigidos com a exibição dos símbolos zbalermorna no documento PDF
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.8.1)

#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.7 Maio 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.7...geklojban-1.2.8.1)
* [Comparado com a versão 'geklojban-1.2.3 Janeiro 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.8.1)
* [Comparado com a edição oficial CLL v.1.1 (2016)': diferença no git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.8.1)
### geklojban-1.2.7 Maio 2020
#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.7" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.pdf)
    *   [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.7/cll.epub)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.7/xhtml_no_chunks/)
* ou leia o chamado ["documento de diferença" em PDF](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference_prefixed.pdf) que compara geklojban-1.2.7 com o CLL publicado em 2016 (lançamento de 27 de agosto de 2016). O documento tem inserções marcadas com verde e prefixo "ins\`" e exclusões marcadas com vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Há [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.7/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista resumida de mudanças em comparação com a versão anterior 'geklojban-1.2.6 Abril 2020'

* "O cmavo tu'a é usado na formação de abstrações e é explicado mais detalhadamente na Seção 11.11." mas não é mencionado de forma alguma nessa seção. Alterada a referência para a Seção 11.10. O bug foi notado por [Robert Baruch](https://github.com/RobertBaruch).
* todas as referências a selma'o são movidas do índice de palavras lojban para o índice geral no apêndice.
* Seção 10.18. A frase "Ao contrário da negação contraditória -nai, a negação escalar de tempos não está limitada a PU e FAhA:" contradizia

#### Comparação do código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.6 abril de 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.6...geklojban-1.2.7)
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.7)
* [Comparado com a edição oficial CLL v.1.1 (2016)': diferença no git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.7)
### geklojban-1.2.6 abril de 2020
#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.6" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.pdf)
    *   [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.6/cll.epub)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.6/xhtml_no_chunks/)
* ou leia o chamado documento PDF de "diferença" que compara geklojban-1.2.6 com o CLL publicado em 2016 (lançamento de 27 de agosto de 2016). O documento tem inserções marcadas com verde e prefixo "ins\`" e exclusões marcadas com vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Há [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.6/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista resumida de mudanças em comparação com a versão anterior 'geklojban-1.2.5 março de 2020'

* novas imagens de alta resolução para vários capítulos feitas por [la ninpre](https://github.com/la-ninpre) (violação de direitos autorais possível rejeitada)
* a regra 'vírgulas nunca são necessárias' agora é temporariamente limitada a vírgulas que são separadores de sílabas
* adicionados mais links para vários selma'o no índice de palavras lojban
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.6)#### Comparação do código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.5 março de 2020': diferença no git](https://github.com/lojban/cll/compare/ge

#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.5" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.pdf)
    *   [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.5/cll.epub)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.5/xhtml_no_chunks/)
* ou leia o chamado documento de ["diferença" em PDF](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference_prefixed.pdf) que compara geklojban-1.2.5 com o CLL publicado em 2016 (versão de 27 de agosto de 2016). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Existe [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.5/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista curta de mudanças em comparação com a versão 'geklojban-1.2.3 janeiro de 2020'
* remover temporariamente o uso controverso de ni+ce'u
* usar um exemplo melhor para NU JA NU, remover a expansão de NU JA NU (que pode não ser ambígua no caso de vários NU JA NU em um bridi)
* adicionar hanzi e pinyin mais bonito aos exemplos chineses
* Dotside: Adicionar uma parada glotal inicial à transcrição IPA em um exemplo
* adicionar "FA selma'o" ao índice de palavras lojban
* a regra 'vírgulas nunca são necessárias' é temporariamente limitada apenas a cmevla
* corrigidos alguns erros de digitação
* símbolos UTF são adicionados como estão (em vez de suas descrições)
*   Dotside implementado
*   os conceitos "cmene" e "cmevla" agora estão separados
*   **sumti tcita** é renomeado para **sumtcita**
*   **mi kucli le jei broda** agora é **mi kucli tu'a le jei broda**
*   Dicionário com exemplos agora é tecnicamente possível: o glossário agora pode ter exemplos abaixo das definições das palavras (e faz isso para a palavra **coi** como exemplo)
*   rafsi para **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** são alterados de acordo com o cmavo.txt do ano 2002.
*   grande quantidade de erros de digitação e erros menores corrigidos
#### [Fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.5)

#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.4 fevereiro de 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.4...geklojban-1.2.5)
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.5)

### geklojban-1.2.4 fevereiro de 2020
#### Versão compilada
*   leia o documento final que será usado para impressão e publicação. Observe que a página de título tem o documento explicitamente marcado como "geklojban-1.2.4" e tem o nome da organização que o publicou diferente do LLG; isso é feito para enfatizar que não é uma publicação do LLG:
    *   [Formato PDF](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.pdf)
    *   [Formato EPUB](https://la-lojban.github.io/uncll/uncll-1.2.4/cll.epub)
    *   [Formato HTML, uma página é uma seção do livro](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_section_chunks/)
    *   [Formato HTML - o livro inteiro em uma única página muito longa](https://la-lojban.github.io/uncll/uncll-1.2.4/xhtml_no_chunks/)
* ou leia o chamado ["documento de diferença" em PDF](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference_prefixed.pdf) que compara geklojban-1.2.4 com o CLL publicado em 2016 (versão de 27 de agosto de 2016). O documento tem inserções marcadas em verde e prefixo "ins\`" e exclusões marcadas em vermelho e prefixo "del\`". Os prefixos são adicionados para que você possa usar Cmd+F ou Ctrl+F para encontrar rapidamente as diferenças no documento PDF. Há [uma versão alternativa de diferença sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/cll_difference.pdf) (mas então você terá que rolar manualmente o documento para encontrar as diferenças).
*   ou leia o documento de diferença em formato HTML em vez disso:
    *   [com prefixos](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference_prefixed.html),
    *   [sem prefixos](https://la-lojban.github.io/uncll/uncll-1.2.4/cll_diffs/diff_new_xhtml_no_chunks/difference.html).
#### Lista resumida de mudanças em comparação com a versão 'geklojban-1.2.3 janeiro de 2020'
* alguns erros de digitação foram corrigidos
* símbolos UTF são adicionados como estão (em vez de suas descrições)
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.4)
#### Comparação de código-fonte com versões anteriores
* [Comparado com a versão 'geklojban-1.2.3 janeiro de 2020': diferença no git](https://github.com/lojban/cll/compare/geklojban-1.2.3...geklojban-1.2.4)
* [Comparado com a edição oficial CLL v.1.1 (2016)': diferença no git](https://github.com/lojban/cll/compare/6c0556c7b17f96b3bf41e8123ba18ef4868e056a...geklojban-1.2.3)
### geklojban-1.2.3 janeiro de 2020

#### Breve lista de mudanças

*   Dotside implementado
*   Conceitos "cmene" e "cmevla" agora estão separados
*   **sumti tcita** é renomeado para **sumtcita**
*   Dicionário com exemplos agora é tecnicamente possível: o glossário agora pode ter exemplos abaixo das definições das palavras (e faz isso para a palavra **coi** como uma demonstração)
*   rafsi para **su'u**, **za'i**, **zu'o**, **pu'u**, **mu'e** são alterados de acordo com o cmavo.txt de 2002.
*   Grande quantidade de erros de digitação e erros menores corrigidos
#### [fonte git](https://github.com/lojban/cll/compare/geklojban-1.2.3)