---
title: Os Verbos em Lojban estão Quebrados?
---

<div class="lojbo simple_blockquotes"></div>

## Pergunta

Parece que aprender as definições dos verbos em Lojban, como

> *$x_1$ corre na superfície $x_2$ usando membros $x_3$ com passo $x_4$*

pode ser desafiador porque quase todo verbo tem sua própria estrutura de lugar distinta. Existe alguma maneira de tornar isso menos exigente mentalmente? Por que Lojban foi projetado dessa maneira?
## Resposta

O inglês funciona de maneira semelhante em um sentido pragmático. Ele tem verbos com sua estrutura de lugar implícita. A principal diferença é que os dicionários de Lojban explicitamente indicam a estrutura de lugar, enquanto a maioria dos dicionários em inglês não o faz. A razão para esse sistema é que ter uma preposição separada para cada lugar seria ainda mais oneroso e às vezes até inviável. Por exemplo:

> *Eu dependo de você (?!)*

Além disso, ter um conjunto limitado de preposições tornaria a linguagem altamente subjetiva e não universal. Por exemplo, em inglês dizemos

> *Eu dependo de você*

mas em russo isso se traduz para

> Eu dependo de você

Certas preposições combinadas com verbos específicos poderiam criar significados incomuns, levando a ainda mais aleatoriedade do que o sistema atual com $x_1$, $x_2$, etc.

É importante observar que a maioria dos verbos em Lojban tem apenas até três lugares. Apenas cerca de 30 verbos principais (lo gismu) têm cinco lugares. Além disso, você não precisa conhecer a estrutura de lugar de cada verbo principal para falar fluentemente Lojban. Por exemplo, é crucial saber a estrutura de lugar da 'função seno trigonométrica' ao discutir preparação de alimentos?

É verdade que "Eu te dou um presente" não requer preposições, enquanto as estruturas de lugar de outros verbos o fazem. No entanto, não há mais memorização envolvida. O inglês requer aprender metáforas. Por que é "Eu dou PARA você" e "Eu falo COM você" quando os processos são completamente diferentes?

Além disso, considere as seguintes traduções:

> [Inglês] *Eu penso em você*

> [Russo] *Ya dumayu o tebe* (Eu penso sobre você)

> [Espanhol] *Yo pienso en ti* (Eu penso em você)

Algumas estruturas de lugar em Lojban são menos diretas do que outras, assim como em inglês. Por exemplo, por que é "Este filme é agradável para mim" em vez de "Eu gosto deste filme"?

Os verbos em Lojban, assim como os verbos em inglês, podem ser agrupados em estruturas de lugar idênticas, por exemplo:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=mlatu&bangu=en&versio=masno">mlatu</a> - $x_1$ é um gato da espécie $x_2$

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=gerku&bangu=en&versio=masno">gerku</a> - $x_1$ é um cachorro da espécie $x_2$
## A Estrutura de Lugar é Fácil de Aprender, Mas...

Muitas vezes, a estrutura de lugar é fácil de aprender. No entanto, o conceito de movimento apresenta um conjunto aleatório de estruturas de lugar. Considere o seguinte:

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a> - $x_1$ (objeto) se move para o destino/receptor $x_2$ [afastando-se] da origem $x_3$ ao longo do caminho/rota $x_4$.

> <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu">bajra</a> - $x_1$ corre na superfície $x_2$ usando membros $x_3$ com marcha $x_4$.

## Resposta

<a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=muvdu&bangu=en&versio=masno">muvdu</a>, <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> e <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=cadzu&bangu=en&versio=masno">cadzu</a> descrevem um processo semelhante, mas de perspectivas muito diferentes. Em <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a>, a origem e o destino não são importantes; o foco está na forma. Não é "correr de para" como em inglês. Por favor, não confunda as traduções em inglês com o processo real que os verbos em Lojban descrevem. Estar em um estado de <a href="https://la-lojban.github.io/sutysisku/lojban/#seskari=cnano&sisku=bajra&bangu=en&versio=masno">bajra</a> significa ter uma certa forma de andar enquanto toca uma superfície com os membros e faz isso rapidamente.

Uma pessoa usando uma esteira não tem pontos "para" ou "de", mas simplesmente está correndo enquanto permanece no mesmo lugar. Isso é um bom exemplo de um estado de bajra sem estar em um estado de klama.

Em resumo, Lojban não é um inglês relexado, embora o uso comum e o dicionário Lojban-Inglês possam sugerir isso.

O problema está mais na ambiguidade do inglês do que na própria língua Lojban.

Por fim, é possível usar lo tanru, como bajra klama (correr-chegar), para expressar tanto correr quanto chegar a um lugar específico.