## Leçon 9. Conjonctions logiques

Les conjonctions logiques en lojban sont basées sur 4 primitives : **.a**, **.e**, **.o**, **.u**. Dans cette leçon, nous les couvrirons en détail.

### Conjonctions logiques pour les arguments

Voici les conjonctions combinant deux mots : _ceci_ et _cela_.

- **ti .a ta** = _ceci et/ou cela_

 > **mi ba vitke le mamta .a le tamne**
 >_Je vais rendre visite à la mère ou au cousin._

 Notez que **.a** peut également être traduit par _au moins une des deux valeurs_, laissant ainsi la possibilité que je finisse par rendre visite aux deux à un moment donné.

- **ti .e ta** = _ceci et cela_

 > **mi ralte le pa gerku .e le re mlatu**
 >_J'ai un chien et deux chats._
 >`Je garde un chien et deux chats.`

- **ti .o ta** = _soit ceci et cela, soit aucun_

 > **mi ba vitke le mamta .o le tamne**
 >_Je vais rendre visite soit à la mère et au cousin, soit à aucun d'eux._

- **ti .u ta** = _ceci, et peut-être cela_, _ceci que cela soit vrai ou non_

 > **mi ba vitke le mamta .u le tamne**
 >_Je vais rendre visite à la mère que je rende visite ou non au cousin._

 **.u** souligne simplement que la deuxième valeur n'affecte pas la vérité de la phrase.

Placer **nai** après une conjonction nie ce qui se trouve à droite de celle-ci. Placer **na** avant une conjonction nie ce qui se trouve à gauche de celle-ci :

- **ti .e nai ta** = _ceci et non cela_

 > **mi nelci la .bob. e nai la .alis.**
 >_J'aime Bob mais pas Alice._
 >`J'aime Bob et pas Alice`

 Nous pouvons également dire **ti .e nai ku'i ta** (_ceci mais pas cela_) en ajoutant une saveur de contraste pour le deuxième argument.

- **ti na .e ta** = _pas ceci mais cela_

 > **mi nelci la .alis. na .e la .bob.**
 >_Je n'aime pas Alice mais j'aime Bob._
 >`Je n'aime pas Alice et j'aime Bob`

 Cela peut sembler un peu étrange pour les anglophones (`I like Alice not…`) donc vous pouvez préférer échanger les arguments et utiliser **.e nai** à la place : **mi nelci la .bob. e nai la .alis.** ou même **mi nelci la .bob. i mi na ku nelci la .alis.** signifiera la même chose.

- **ti na .e nai ta** = _ni ceci ni cela (aucun)_

 > **mi nelci la .alis. na .e nai la .bob.**
 >_Je n'aime ni Alice ni Bob_

Nier avec d'autres conjonctions primitives peut ne pas sembler intuitivement utilisable, vous pouvez simplement les apprendre à partir d'exemples :
- **ti .a nai ta** = _ceci si cela_, _pour que ceci arrive, la condition exclusive est que cela arrive_

 > **mi ba vitke le mamta .a nai le tamne**
 > _Je vais rendre visite à la mère mais pour que cela arrive, j'ai besoin de rendre visite au cousin._

 Ainsi, **ti .a nai ta** signifie que **ta** est nécessaire (mais peut ne pas être la seule condition) pour que **ti** soit appliqué.

- **ti .o nai ta** = _soit ceci soit cela_

 > **mi ba vitke le mamta .o nai le tamne**
 > _Je vais rendre visite soit à la mère soit au cousin._

 Si je veux dire que je vais rendre visite soit à la mère soit au cousin mais pas aux deux, j'ai besoin de **.o nai** (_soit/ou_). C'est différent de **.a** (_et/ou_) où je peux rendre visite aux deux.

- **ti na .u ta** = n'influence pas _(pas ceci, mais peut-être cela)_
- **ti na .u nai ta** = n'influence pas _(pas ceci, mais peut-être cela)_

- **ti se .u ta** = _peut-être ceci, et cela_
- **ti se .u nai ta** = _peut-être ceci mais pas cela_

<!-- **se** est utilisé uniquement pour **.u** car dans d'autres cas, cela n'affecte pas le sens. -->

Ceux-ci sont utilisés pour connecter des arguments. Pour connecter des parties de verbes composés, nous utilisons des conjonctions similaires: **ja**, **je**, **jo**, **ju**. Donc, au lieu du point (pause), nous utilisons **j** ici.

<!-- Il est courant d'utiliser **ja**, **je**, **jo**, **ju** pour connecter également des arguments. -->

Voici le texte traduit :

### Conjonctions logiques à l'intérieur de relations composées

Ceci est une façon plus concise de dire :

> **mi ralte le pa gerku .i je mi ralte le re mlatu**
> _J'ai un chien, et j'ai deux chats._

**.i je** relie deux phrases avec un _et_ logique, montrant que les deux phrases font partie d'une même pensée et sont vraies.

Voici des exemples d'autres conjonctions pour les phrases :

> **la .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os.**
> _Roméo aime Juliette, <u>et</u> Juliette aime Roméo._

Cela signifie que les deux déclarations sont vraies, c'est-à-dire que Roméo et Juliette s'aiment.

Il en va de même pour les autres conjonctions :

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Roméo aime Juliette, et/ou Juliette aime Roméo._

Cela signifie que l'un d'eux aime l'autre, et peut-être les deux.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Soit Roméo aime Juliette, soit Juliette aime Roméo._

Ici, soit Roméo aime Juliette (mais Juliette ne l'aime pas), soit Juliette aime Roméo (mais il ne l'aime pas).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _Pour que Roméo aime Juliette, il est nécessaire que Juliette aime Roméo._

Cela signifie que si Juliette aime Roméo, il l'aime certainement, mais il peut l'aimer de toute façon (le seul résultat impossible est que Juliette aime Roméo mais qu'il ne l'aime pas).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Soit Roméo aime Juliette et Juliette aime Roméo, soit aucun des deux évènements ne se produit._

Cela signifie que si Juliette aime Roméo, il l'aime, et si elle ne l'aime pas, il ne l'aime pas.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Roméo aime Juliette que Juliette l'aime ou non._

Remarquez comment nous avons lojbanisé le nom "Roméo" : la combinaison "eo" est impossible en lojban, nous avons donc utilisé "e'o" et ajouté une consonne à la fin de son nom.

Notez que **da** fait référence à la même entité lorsque plusieurs phrases sont connectées.

### Conjonctions logiques pour les phrases

Ceci est une façon plus concise de dire :

> **mi ralte le pa gerku .i je mi ralte le re mlatu**
> _J'ai un chien, et j'ai deux chats._

**.i je** relie deux phrases avec un _et_ logique, montrant que les deux phrases font partie d'une même pensée et sont vraies.

Voici des exemples d'autres conjonctions pour les phrases :

> **la .rome'os. cu prami la .djuliet. i je la .djuliet. cu prami la .rome'os.**
> _Roméo aime Juliette, <u>et</u> Juliette aime Roméo._

Cela signifie que les deux déclarations sont vraies, c'est-à-dire que Roméo et Juliette s'aiment.

Il en va de même pour les autres conjonctions :

> **la .rome'os. cu prami la .djuliet. i ja la .djuliet. cu prami la .rome'os.**
> _Roméo aime Juliette, et/ou Juliette aime Roméo._

Cela signifie que l'un d'eux aime l'autre, et peut-être les deux.

> **la .rome'os. cu prami la .djuliet. i jo nai la .djuliet. cu prami la .rome'os.**
> _Soit Roméo aime Juliette, soit Juliette aime Roméo._

Ici, soit Roméo aime Juliette (mais Juliette ne l'aime pas), soit Juliette aime Roméo (mais il ne l'aime pas).

> **la .rome'os. cu prami la .djuliet. i ja nai la .djuliet. cu prami la .rome'os.**
> _Pour que Roméo aime Juliette, il est nécessaire que Juliette aime Roméo._

Cela signifie que si Juliette aime Roméo, il l'aime certainement, mais il peut l'aimer de toute façon (le seul résultat impossible est que Juliette aime Roméo mais qu'il ne l'aime pas).

> **la .rome'os. cu prami la .djuliet. i jo la .djuliet. cu prami la .rome'os.**
> _Soit Roméo aime Juliette et Juliette aime Roméo, soit aucun des deux évènements ne se produit._

Cela signifie que si Juliette aime Roméo, il l'aime, et si elle ne l'aime pas, il ne l'aime pas.

> **la .rome'os. cu prami la .djuliet. i ju la .djuliet. cu prami la .rome'os.**
> _Roméo aime Juliette que Juliette l'aime ou non._

Remarquez comment nous avons lojbanisé le nom "Roméo" : la combinaison "eo" est impossible en lojban, nous avons donc utilisé "e'o" et ajouté une consonne à la fin de son nom.

Notez que **da** fait référence à la même entité lorsque plusieurs phrases sont connectées.

### Conjonctions logiques pour les verbes composés

> **le melbi xunre fonxa**
> _beaux téléphones rouges_

<!-- -->

> **le melbi je xunre fonxa**
> _beaux et téléphones rouges_

D'autres conjonctions ont également du sens :

> **mi nelci ro tu voi xajmi ja melbi prenu**
> _J'aime toutes les personnes qui sont drôles ou belles (ou les deux)._

<!-- -->

> **mi nelci ro tu voi xajmi jo nai melbi prenu**
> _J'aime toutes les personnes qui sont soit drôles soit belles._

Cela pourrait s'expliquer si, par exemple, je trouve que les qualités d'humour et de beauté sont incompatibles, c'est-à-dire qu'un mélange des deux serait juste trop.

> **mi nelci ro tu voi xajmi ju melbi nanmu**
> _J'aime toutes les personnes qui sont drôles (qu'elles soient belles ou non)._

Et encore une fois, nous ne devons pas oublier la différence entre la connexion de noms et la connexion de parties de constructions de relations composées :

> **mi ba vitke le pa pendo .e le pa speni**
> _Je vais rendre visite à un ami et un conjoint._

<!-- -->

> **mi ba vitke le pa pendo je speni**
> _Je vais rendre visite à un ami-et-conjoint._

La dernière phrase en lojban signifie que l'ami est également un conjoint.

### Conjonctions logiques pour les queues de relation

> **pu ku mi uantida la .soker. gi'e klama le zdani gi'e citka le badna**
> _J'ai joué au soccer, suis rentré à la maison et ai mangé la banane._

uantida
: un mot de relation non officiel : $x_1$ joue au jeu $x_2$, participe au jeu $x_2$

**gi'e** connecte plusieurs relations en une avec certains termes partagés. Regardez ceci : cela se développe en **pu ku mi kelci la .soker. i je pu ku mi klama le zdani** … ce qui serait plus long.

Avec **gi'e**, nous gardons la tête de la relation constante et spécifions les termes après chacun des verbes (**kelci la .soker.**, **klama le zdani** …).

Ainsi, lors de l'utilisation de **gi'e**, nous avons plusieurs relations dans la queue jointes ensemble mais ayant une tête commune.

**gi'e** a la même voyelle finale que dans **je** et signifie donc _et_.

D'autres conjonctions pour joindre les queues de relation :

- **gi'a** pour _et/ou_
- **gi'o nai** pour _soit … soit_
- **gi'u** pour _que ce soit ou non_, etc.

Ces conjonctions ont la même terminaison que celles de la série **.a**, **.o**, **.u**.

### Termes dans les phrases avec plusieurs queues

Notez que les temps en tant que termes et les temps attachés à la relation principale de la relation font une différence lorsqu'ils sont appliqués aux phrases qui contiennent plusieurs relations attachées :

- Un terme dans la tête de la phrase est appliqué à toutes ses queues :

 > **mi ba'o cu citka le badna gi'e pinxe**
 > _Je ne mange plus la banane et ne bois plus._

 Ici, **ba'o** est appliqué à **citka le badna gi'e pinxe**.

- Un mot tendu qui fait partie de la relation s'applique uniquement à cette relation :

 > **mi ba'o citka le badna gi'e pinxe**
 > _Je ne mange plus la banane, mais je bois._

 Ici, **ba'o** est appliqué uniquement à la relation implicite **mi citka le badna** mais pas à la relation implicite **mi pinxe**.

### Questions à choix multiples

Un autre type de "ou" en anglais peut être trouvé dans les questions :

> **— xu do pinxe le tcati .o nai le ckafi ?**
> **— pinxe**
> _— Vas-tu boire du thé ou du café ?_
> _— Oui._

C'est une réponse étrange, mais parfaitement raisonnable : _Oui, je vais boire du thé ou du café._

Cela se produit parce que "ou" a plusieurs significations en anglais :

1. _A ou B_ peut signifier _soit A, soit B mais pas les deux_. Nous utilisons **.o nai** ici.
2. _A ou B_ peut signifier _A ou B ou les deux_. Nous utilisons **.a** ici.
3. _A ou B ?_ peut être une question signifiant _choisissez entre A et B, lequel choisissez-vous ?_ Nous utilisons **ji** ici.

Ainsi, dans le dernier cas, nous utilisons une conjonction de question séparée **ji** :

> **— do pinxe le tcati ji le ckafi ?**
> _— Vas-tu boire du thé ou du café ?_

Réponses possibles :

> **le tcati .e le ckafi**
> _Thé et café._

<!-- -->

> **le tcati**
> _Thé._

<!-- -->

> **le ckafi**
> _Café._

Il est également possible d'utiliser des conjonctions lors de la réponse :

> **.e** — <span>_Les deux_ (le premier et le deuxième élément sont choisis)</span>

<!-- -->

> **.e nai** — <span>_Le premier (thé)_ (le premier mais pas le deuxième est choisi)</span>

<!-- -->

> **na .e** — <span>_Le deuxième (café)_ (pas le premier mais le deuxième est choisi)</span>

<!-- -->

> **na .e nai** — <span>_Aucun_ (ni le premier ni le deuxième n'est choisi)</span>

Vous pouvez poser des questions de la même manière sur les autres types de conjonctions que nous avons examinés. La conjonction interrogative pour les queues de relation est **gi'i**, pour les relations composées — **je'i**, pour les phrases — **.i je'i**.

Les questions indirectes sont obtenues en utilisant **ji kau** :

Considérez que le serveur demande à un visiteur :

> **- le'e dembi ji le'e rismi**
> _- Les haricots ou le riz ?_

Une fois que le visiteur répond, le serveur sait si le visiteur veut manger de l'agneau ou du bœuf :

> **ba le nu le vitke cu spusku kei le bevri cu djuno le du'u le vitke cu djica le nu ri citka le'e dembi ji kau le'e rismi**
> _Après que le visiteur a répondu, le serveur sait si le visiteur veut manger les haricots ou le riz._

### Conjonctions de prévision

> **ge do gi mi**
> _toi et moi tous les deux_

<!-- -->

> **ge nai do gi mi**
> _Pas toi mais moi_

<!-- -->

> **ge do gi nai mi**
> _Toi mais pas moi_

<!-- -->

> **go nai do gi mi**
> _Soit toi soit moi_

La conjonction de prévision **ge** signifie _et_, mais elle est placée avant le premier terme-argument, avec **gi** qui sépare les deux arguments. Cette série est parallèle à d'autres conjonctions : **ga**, **ge**, **go**, **gu**, ainsi que **ga nai**, **ge nai**, **go nai**, etc. Le séparateur **gi** est le même pour tous.

L'utilisation de ces conjonctions est une question de commodité :

> **mi citka ge nai le badna gi le plise**
> _Je ne mange pas la banane mais la pomme._

Ici, comme en anglais, _pas_ est indiqué avant le premier argument.

**ge** et les mots de cette série peuvent également être utilisés pour connecter des relations :

> **ge mi dansu gi mi zgipli le pipno**
> _Je danse et je joue du piano._

zgipli
: $x_1$ joue d'un instrument de musique $x_2$

le pipno
: piano

> **.i ga nai pu zi carvi gi ca cilmo**
> _S'il a plu récemment, il est mouillé maintenant._