## Leçon 7. Lettres, faisant référence à des relations, des dates

### Noms des lettres en lojban

Chaque lettre a un nom en lojban.

Le tableau suivant représente l'alphabet de base en lojban et comment prononcer les lettres (sous chaque lettre) :

<table>
<tbody><tr>
<td>'
</td>
<td><b><font  class="guibutton" color="#FF1493">a</font></b>
</td>
<td>b
</td>
<td>c
</td>
<td>d
</td>
<td><b><font  class="guibutton" color="#FF1493">e</font></b>
</td></tr>
<tr>
<td><b>.y'y.</b>
</td>
<td><b>.a bu</b>
</td>
<td><b>by.</b>
</td>
<td><b>cy.</b>
</td>
<td><b>dy.</b>
</td>
<td><b>.ebu</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>f
</td>
<td>g
</td>
<td><b><font  class="guibutton" color="#FF1493">i</font></b>
</td>
<td>j
</td>
<td>k
</td>
<td>l
</td></tr>
<tr>
<td><b>fy.</b>
</td>
<td><b>gy.</b>
</td>
<td><b>.i bu</b>
</td>
<td><b>jy.</b>
</td>
<td><b>ky.</b>
</td>
<td><b>ly.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>m
</td>
<td>n
</td>
<td><b><font class="guibutton" color="#FF1493">o</font></b>
</td>
<td>p
</td>
<td>r
</td>
<td>s
</td></tr>
<tr>
<td><b>my.</b>
</td>
<td><b>ny.</b>
</td>
<td><b>.o bu</b>
</td>
<td><b>py.</b>
</td>
<td><b>ry.</b>
</td>
<td><b>sy.</b>
</td></tr>
<tr>
<td colspan="6">
</td></tr>
<tr>
<td>t
</td>
<td><b><font  class="guibutton" color="#FF1493">u</font></b>
</td>
<td>v
</td>
<td>x
</td>
<td><b><font  class="guibutton" color="#FF1493">y</font></b>
</td>
<td>z
</td></tr>
<tr>
<td><b>ty.</b>
</td>
<td><b>.u bu</b>
</td>
<td><b>vy.</b>
</td>
<td><b>xy.</b>
</td>
<td><b>.y bu</b>
</td>
<td><b>zy.</b>
</td></tr></tbody></table>

Comme vous pouvez le voir :

- pour obtenir le nom d'une voyelle, nous ajoutons le mot **bu**.
- pour obtenir le nom d'une consonne, nous ajoutons **y.** à la consonne.
- le mot pour **'** (apostrophe) est **.y'y**.

Nous pouvons épeler des mots en utilisant ces noms. Par exemple, CNN sera **cy. ny. ny.**

<!-- Une lettre majuscule seule a une signification spéciale. Elle désigne le nom de cette lettre :

**A** est identique à **.abu**, **B** est identique à **by.** et ainsi de suite. Ils signifient la même chose et sont même lus de la même manière que **.abu**, **by.** etc. Ainsi, _CNN_ peut également être écrit comme **CNN** en lojban et sera toujours prononcé et signifiera la même chose que **cy. ny. ny.** -->

### Des lettres à la place de « _el_ » et « _elle_ »

Une chaine d'un ou plusieurs noms de lettres peut fonctionner comme un pronom, offrant une méthode alternative pour se référer à des arguments précédemment mentionnés dans la parole.

> **la .alis. pu klama le nurma .i le nurma cu melbi la .alis.**
> **la .alis. pu klama le nurma .i ri melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi la .alis.**
> **la .alis. pu klama le nurma .i ny. melbi .a bu**
> _Alice est allée à la campagne. La zone rurale est belle pour Alice._
> _Alice est allée à la campagne. C'est beau pour elle._

Toutes les variantes lojban ci-dessus ont la même signification.

Puisque la première lettre dans **.alis.** est **a** (en ignorant le point) et la première lettre dans **nurma** est **n**, nous pouvons utiliser des mots de lettres pour se référer à ces arguments correspondamment:

- **.a bu** se réfère à **la .alis.**
- **ny.** se réfère à **le nurma**

Cette méthode pourrait être plus pratique que l'anglais _he_ ou _she_, ou même le Lojban **ri** ou **ra**. Cela nous permet de rendre le discours plus concis mais plus précis, sans avoir à répéter à plusieurs reprises des noms potentiellement longs ou d'autres termes argumentatifs.

Cependant, il est important de noter qu'il peut y avoir des situations où nous voulons nous référer à, par exemple, **le nurma**, mais un autre nom ou nom commençant par **n** apparait entre-temps, rendant **ny.** incapable de se référer à la zone rurale. Dans de tels cas, la solution la plus rapide est de répéter l'argument en entier, c'est-à-dire de dire **le nurma** :

> **bu'u le nurma la .alis. pu penmi la .nik. i ri se zdani bu'u le nurma**
> _Dans la campagne, Alice a rencontré Nick. Il a sa maison dans la campagne._

zdani
: … être une maison pour …

se zdani
: … avoir une maison …, … habiter à …

Si un nom est composé de plusieurs cmevla, vous pouvez utiliser les premières lettres pour vous référer à ce nom. Il en va de même pour les relations composées:

> **la .djan.smit. cu citka le glare stasu .i dy.sy. nelci fy.sy.**
> _John Smith mange la soupe chaude. Il l'aime._

glare
: … être chaud

**dy.sy.** est un seul pronom. Il en va de même pour **fy.sy.**.

Si vous devez mettre plusieurs pronoms l'un après l'autre, séparez-les avec le mot **boi**:

> **mi klama la .paris. la .moskov.**
> _Je vais à Paris depuis Moscou._

<!-- -->

> **mi klama py. boi my.**
> _Je vais à P depuis M._

La phrase **mi klama py. my.** signifierait _Je vais à PM_, ce qui signifierait quelque chose de différent.

> **la .tom.silver. pu zvati .i je'u ty. sy. boi .ui pu sidju mi**
> _Tom Silver était présent. Et en fait, TS (yay !) m'a aidé._

Si vous mettez une interjection après de telles lettres, séparez-les avec **boi**. Sans **boi**, les interjections se référeront à la dernière lettre.

### Différentes façons de dire « nous » en lojban

En lojban, il existe plusieurs pronoms proches en signification de « nous » :

mi'o
: toi et moi

mi'a
: nous sans toi

ma'a
: toi, moi et d'autres

Ainsi, lorsqu'on parle, il faut être plus attentif à la signification de « nous » dont on a besoin.

Et enfin :

mi
: moi ou les locuteurs

**mi** peut également signifier « nous » ! Le lojban ne fait pas de distinction entre le singulier et le pluriel par défaut. Ainsi, si plusieurs personnes parlent ensemble, **mi** (qui se réfère à un ou plusieurs locuteurs) est parfaitement correct pour « nous ». En pratique, on trouve généralement **mi** utilisé de cette manière lorsqu'une personne présume de parler (ou plus souvent, d'écrire) au nom des autres.

Quelques exemples :

> **mi prami do**
> _Je t'aime._

<!-- -->

> **mi'a ba penmi do**
> _Nous te rencontrerons._

<!-- -->

> **ma'a remna**
> _Nous sommes tous humains._

<!-- -->

> **mi djica le nu do cliva**
> _Nous voulons que tu partes._

cliva
: $x_1$ part

### « **ri** » au lieu de « _il_ » et « _elle_ »

Plus tôt, nous avons appris le pronom **ri** :

ri
: pronom : se réfère à l'argument précédent qui vient juste de finir (en sautant les pronoms stables comme **mi**, **do**, les mots pour _nous_)

> **mi catlu le nanmu .i ri melbi**
> _Je regarde l'homme. Il est beau._

melbi
: $x_1$ est beau / joli / séduisant pour quelqu'un $x_2$

**ri** se réfère à l'argument précédent utilisé dans le texte ou dans le discours de quelqu'un :

> **la .alis. cu sipna bu'u le sledi'u pe la .alis.**
> _Alice dort dans la chambre d'Alice._
> `Alice dort-dans la chambre-de-Alice.`

> **la .alis. cu sipna bu'u le sledi'u pe ri**
> _Alice dort dans sa chambre._
> `Alice dort dans la chambre de [l'argument précédent].`

sledi'u
: $x_1$ est une chambre pour la raison $x_2$ (proposition)

Le **ri** est équivalent à répéter le dernier argument, qui est **la .alis.** ici.

Un aspect à remarquer est que **ri** ne répète pas **le sledi'u pe ri** (qui est également un argument), car **ri** fait partie de cet argument et donc cet argument n'est pas "précédent", pas encore fini quand **ri** apparait. Cela empêche **ri** de se référer récursivement à lui-même.

Un autre exemple :

> **le du'u le prenu cu melbi cu se djuno ri**
> _Que la personne est belle est connu d'elle-même._

Le **ri** se réfère à **le prenu** (et non à **le du'u le prenu cu melbi** bien que les deux arguments soient complets : **le prenu** commence en dernier, après le début de **le du'u le prenu cu melbi**).

La relation à l'intérieur des formes **sei** forme un texte parallèle. **ri** saute les arguments à l'intérieur des relations **sei** :

> **mi viska la .lukas. sei la .doris. pu cusku .i ri jibni la .micel.**
> _Je vois Lucas, - a dit Doris. Il est près de Michelle._

Dans cet exemple, **ri** ne peut pas se référer à **la .doris.** Nous sautons simplement toute la relation **sei la .doris. pu cusku** lors de la décision de ce à quoi **ri** devrait se référer.

Les pronoms qui sont stables tout au long du dialogue ou de l'histoire sont ignorés par **ri**. Nous les répétons simplement directement :

> **mi lumci mi**
> _Je me lave._
> `Je me lave`

lumci
: $x_1$ lave $x_2$

> **mi prami mi**
> _Je m'aime._
> `Je m'aime.`

Cependant :

- les pronoms **ti**, **ta**, **tu** sont pris en compte par **ri** car vous pourriez avoir changé ce à quoi vous pointez, donc répéter **tu** peut ne pas être efficace.
- de même, **ri** lui-même (ou plutôt, son antécédent) peut être répété par un **ri** ultérieur. En fait, une chaine de mots **ri** sans autres arguments intermédiaires répétera toujours le même argument :

 > **la .alis. cu catlu le nanmu .i ri melbi .i ri co'a zgana .a bu**
 > _Alice remarque un homme. Il est beau. Elle remarque Alice._

zgana
: observer

co'a zgana
: commencer à observer, remarquer

Dans cet exemple, le deuxième **ri** a le premier **ri** comme antécédent, qui a lui-même **le nanmu** comme antécédent. Les trois se réfèrent à la même chose : l'homme.

En fin de compte, vous décidez quoi, où et quand utiliser dans la parole : la méthode avec les mots **le**+ relation, la méthode avec les noms de lettres, ou avec **ri**.

### « **go'i** » pour la relation précédente

> **la .alis. cu klama le barja .i la .alis. cu viska le nanmu**
> **la .alis. cu klama le barja .i le go'i cu viska le nanmu**
> _Alice va au bar. Elle voit un homme._

- **le go'i** se réfère à la première place de la relation précédente.
  - **go'i** présente une autre façon de se référer à un argument dont nous avons besoin.
- **le se go'i** se réfère à la deuxième place de la relation précédente.
- **le te go'i** se réfère à la troisième place, et ainsi de suite.

Exemples :

> **.i la .alis. cu zgana le nanmu .i ri melbi**
> **.i la .alis. cu zgana le nanmu .i le se go'i cu melbi**
> _Alice regarde un homme. Il est beau._

Ici, **le se go'i** se réfère à la deuxième place ($x_2$) de la relation précédente, qui est **le nanmu**.

Un autre exemple :

> _Bill a vu Nick. Il l'a frappé._

L'anglais ne se soucie pas de la précision ici - _he_ signifie simplement _une personne masculine mentionnée quelque part dans le texte ou déduite du contexte._ Bill a-t-il frappé Bob, ou Bob a-t-il frappé Bill ? Nous ne savons pas. En lojban, nous pouvons dire :

> **la .bil. pu viska la .nik. .i le se go'i cu darxi le go'i**
> _Bill a vu Nick. Nick a frappé Bill._

Cependant, dans la plupart des cas, **ri** ou des mots de lettre peuvent être utilisés :

> **la .bil. cu viska la .nik. i ri darxi la .bil.**
> **la .bil. cu viska la .nik. i ny. darxi by.**
> _Bill a vu Nick. Nick a frappé Bill._

**go'i** est lui-même un mot de relation, et il a donc une structure de place :

> **mi tatpi .i do ji'a go'i**
> _Je suis fatigué. Et toi aussi._

Lorsque nous disons **do go'i**, nous répétons la relation précédente mais remplaçons sa première place par **do**. En d'autres termes, **do ji'a go'i** ici est la même chose que de dire **do ji'a tatpi**.

<!-- ### Que copie **go'i** ?

Les interjections comme **pei** (lorsqu'elles sont utilisées seules), **xu**, **.ui**, **.u'i**, **je'u** celles formées avec **sei** et l'interjection de question ne sont pas des parties de relations. Ainsi, elles ne sont pas copiées par **go'i**.

Les termes comme **na ku**, **pu**, les négateurs de gauche comme **na'e**, **no'e**, **to'e** sont des parties de relations.

Ainsi, **go'i** copie la relation précédente avec ces particules :

>— **la .bob. na ku prami la .alis.**
>— _**go'i**_

>— _Il n'est pas vrai que Bob aime Alice._

>— _Il ne l'aime pas._

> **— la .bob. na'e prami la .alis.**
> _— Bob n'aime pas Alice._

> **— go'i**
> _— Il ne l'aime pas._

Pour dire "Non, il l'aime", nous utilisons directement le verbe nécessaire :

> **— la .bob. na ku prami la .alis.**
> _Bob n'aime pas Alice._

> **— ja'a ku go'i**
> _Bob aime Alice._

Ici, **ja'a ku** remplace **na ku** dans la relation originale. -->

### Heure de la journée

> **— ma tcika ti**
> _Quelle heure est-il ?_

<!-- -->

> **— li cacra bu pa pa**
> _Onze heures_

tcika
: $x_1$ (heures, minutes, secondes) est l'heure de l'évènement $x_2$

En lojban, les heures sont toujours les heures de quelque chose. Nous demandons donc quelle heure il est de **ti**, ce qui signifie _cet évènement/cette chose_, ou, en d'autres termes, _maintenant_.

**li**, un préfixe pour les nombres, est également utilisé pour les horodatages.

- **cacra bu** est un préfixe signalant que le nombre d'heures suit. Le temps de 24 heures est presque toujours utilisé en lojban.
- **mentu bu** est un préfixe signalant que le nombre de minutes suit.
- **snidu bu** est un préfixe signalant que le nombre de secondes suit.

> **li cacra bu pa pa mentu bu pa no**
> _11h10 (Dix minutes après onze heures)_

<!-- -->

> **li cacra bu pa pa mentu bu pa no snidu bu pa ci**
> _11 heures, 10 minutes et 13 secondes._

<!-- -->

> **li cacra bu pa no mentu bu mu no**
> _10h50, dix heures cinquante_

Si nous voulons donner l'heure d'un évènement, plutôt que simplement dire l'heure, la deuxième place est remplie :

> **li cacra bu pa no tcika le nu mi klama**
> _Dix heures est l'heure à laquelle je viens._

En utilisant le terme **de'i**, nous pouvons obtenir une phrase plus naturelle :

> **mi klama de'i li cacra bu pa no**
> _Je viens à 10 heures._

de'i
: à … (heure), le … (date)

Et un exemple utile :

> **ca tcika le nu .ei sipna**
> _Il est temps de dormir._

### Dates

> **— ma detri ti**
> _Quelle est la date aujourd'hui ?_

> **— li mastu bu ze djedi bu pa**
> _Nous sommes le 1er juillet._

detri
: $x_1$ (année, mois, jour) est la date/heure de l'évènement $x_2$

Une autre option :

> **— ma ca detri**
> _— Quelle est la date maintenant ?_

- **nanca bu** est un préfixe signalant que l'année suit.
- **masti bu** est un préfixe signalant que le mois suit.
- **jefydei bu** est un préfixe signalant que le jour de la semaine suit.
- **djedi bu** est un préfixe signalant que le jour suit.

Les préfixes avec des nombres après eux peuvent être utilisés dans n'importe quel ordre (utilisons des chiffres pour montrer les nombres) :

> **li djedi bu 2 ca detri**
> _Nous sommes le deuxième jour du mois maintenant._

<!-- -->

> **li masti bu 4 djedi bu 1 ca detri**
> _Nous sommes en avril, le premier maintenant._

<!-- -->

> **li djedi bu 5 masti bu 7 nanca bu 2005 detri le nu mi jbena**
> _Le cinquième juillet (septième mois), l'année 2005 est quand je suis né._

jbena
: $x_1$ est né

Nous pouvons également utiliser **de'i** :

> **mi ba klama de'i li masti bu pano**
> _Je viendrai en octobre._

Les particules en lojban peuvent être écrites sans espaces entre elles, comme dans ce **pano**, qui est identique à **pa no**.

Pour les jours de la semaine, généralement, le lundi est le premier jour :

> **mi gunka de'i li jefydei bu pa**
> _Je travaille le lundi._

<!-- -->

> **mi gunka ca ro se detri be li jefydei bu re**
> _Je travaille tous les mardis._

<!-- -->

> **xu do pu zvati la .paris. de'i li jefydei bu ci**
> _Étiez-vous à Paris mercredi ?_

### Spécification des intervalles de temps

> **mi nanca li re re**
> _J'ai 22 ans._

nanca
: $x_1$ a une durée de $x_2$ (nombre) années

**nanca** spécifie la durée, et pour dire _deux ans de long_, remplissez la deuxième place avec un nombre précédé de **li**.

> **le verba cu masti li re**
> _L'enfant a deux mois._

masti
: $x_1$ a une durée de $x_2$ mois

> **le nu carvi cu djedi li ci**
> _Il pleut depuis trois jours._

djedi
: $x_1$ (évènement) a une durée de $x_2$ jours complets

### Nouveaux verbes à partir d'une échelle : ‘_autre que_’ — « **na'e** », ‘_anti-_’ — « **to'e** »

> **mi na'e nelci do**
> _Je ne t'aime pas._

Les particules de l'échelle de gauche (à laquelle **na'e** appartient) sont placées à gauche des constructions qu'elles affectent, formant une échelle :

L'échelle elle-même peut être spécifiée à l'aide de l'étiquette modale **ci'u**.

- **je'a** = _en effet (la position affirmative sur l'échelle)_. Le mot **je'a** confirme le sens d'une partie d'une phrase. Habituellement, il est simplement omis.

 > **mi je'a nelci do**
 > _Je t'aime vraiment._

- **na'e** = _non- (autre que la position affirmative sur l'échelle)_

 > **mi na'e nelci do**
 > _Je ne t'aime pas._

 > **le stizu cu na'e xunre be ci'u le ka skari**
 > _La chaise n'est pas de couleur rouge._
 > `La chaise est autre que rouge sur l'échelle de la couleur`

- **no'e** = _pas vraiment (milieu de l'échelle)_. Le mot **no'e** donne à une partie d'une phrase un sens moyen.

 > **mi no'e nelci do**
 > _En ce qui concerne si je t'aime ou si je te déteste, je suis indifférent à toi. Je ne t'aime ni ne te déteste._

- **to'e** = _anti-, dis-, mis- etc. (opposé sur l'échelle)_. Le mot **to'e** donne à une partie d'une phrase un sens opposé. Il est similaire au préfixe anglais _anti-_.

 > **mi to'e nelci do**
 > _Je te déteste._
 > `Je suis anti-amoureux de toi`

**na'e** est plus vague que **no'e** et **to'e** ; cela peut signifier n'importe lequel d'entre eux lorsque vous ne vous souciez pas du sens exact.

### Termes modaux complexes : « _because_ » — « **ki'u** », « _despite_ » — « **to'e ki'u nai** »

Les termes modaux peuvent être négatifs de deux manières pour obtenir des significations connexes.

ki'u
: terme modal : parce que, en raison d'une explication …, qui peut être expliquée par le fait que …

> **ki'u ma do cusku zo co'o**
> _Pourquoi dis-tu au revoir ?_

Ajouter le suffixe **nai** change la signification :

ki'u nai
: terme modal : pas parce que, qui ne peut pas être expliqué par le fait que …

> **mi se nabmi ki'u nai le nu mi laldo ce'e ki'u le nu mi na certu**
> _Je suis en difficulté non pas parce que je suis vieux mais parce que je ne suis pas un expert._

nabmi
: $x_1$ est un problème pour $x_2$

se nabmi
: $x_1$ a un problème $x_2$

laldo
: $x_1$ est vieux …

certu
: $x_1$ est un expert, professionnel en propriété $x_2$

Ajouter **to'e** définit la négation de la signification :

to'e ki'u
: parce que non, qui peut être expliqué par le fait que cela ne se produit pas que …

> **mi jinga to'e ki'u le nu mi pu surla**
> _J'ai gagné parce que je ne m'étais pas reposé._

En combinant **to'e** et **nai**, nous obtenons :

to'e ki'u nai
: malgré la raison …, pas parce que non, qui ne peut pas être expliqué par le fait que cela ne se produit pas …, 

> **.i to'e ki'u nai le nu le mamta cu sanga su'o melbi kei le verba na snada lo ka sipna**
> _Malgré la belle chanson de la mère, l'enfant ne parvient pas à s'endormir._

En utilisant **se**, l'ordre des arguments est inversé. Sinon, la signification est préservée.

se ki'u
: donc, ce qui explique le fait que …

> **ra bilma se ki'u le nu ra na pu cusku zo coi do**
> _Il est malade, ce qui explique pourquoi il ne t'a pas salué._

se ki'u nai
: mais cela ne signifie pas que …, ce qui n'explique pas le fait que …

> **ra bilma se ki'u nai le nu ra klama le drata tcadu**
> _Il est malade, ce qui n'explique pas pourquoi il va dans une autre ville._

se to'e ki'u
: …, dont l'absence explique le fait que …

> **ra bilma se to'e ki'u le nu ra klama le drata tcadu**
> _Il n'est pas malade, et cela explique pourquoi il va dans une autre ville._

se to'e ki'u nai
: …, dont l'absence n'explique pas le fait que …

> **ra bilma se to'e ki'u nai le nu ra penmi le mikce**
> _Il n'est pas malade, et cela n'explique pas pourquoi il rencontre le médecin._

mikce
: $x_1$ est un médecin