## Leçon 5. Termes modaux, « **da** », leur position relative

### Comment les termes modaux se réfèrent-ils à la relation ?

Certains termes modaux, comme ceux qui décrivent le temps (tense), relient la relation actuelle à celle dans l'argument qui suit:

> **mi cadzu ca le nu le cipni cu vofli**
> _Je marche quand les oiseaux volent._

cadzu
: … marcher

le cipni
: l'oiseau/les oiseaux

vofli
: … voler vers …

> **mi pu cadzu fa'a le rirxe**
> _J'ai marché vers la rivière._

<!-- -->

> **mi pu cadzu se ka'a le rirxe**
> _J'ai marché jusqu'à la rivière._

se ka'a
: arriver à …

fa'a
: directement vers …

Les termes modaux ne suppriment pas les places ordonnées (**fa**, **fe**, **fi**, **fo**, **fu**) de la relation:

> **mi klama se ka'a le rirxe le dinju**
> **mi klama fe le rirxe .e le dinju**
> _Je vais vers une rivière, vers une maison._

Dans le premier exemple, **se ka'a** relie **le rirxe** et ensuite la deuxième place de **klama** suit, étant remplie avec **le dinju**. C'est la même chose que de remplir simplement la deuxième place de **klama** deux fois, en les reliant avec **.e** — _et_.

Cependant, **se ka'a** est utile lorsqu'il est appliqué à d'autres relations comme **cadzu** dans un exemple précédent.

> **le prenu pu cadzu tai le nu ri bevri su'o da poi tilju**
> _La personne a marché comme si elle portait quelque chose de lourd._

bevri
: $x_1$ porte $x_2$

tai
: terme modal: comme …, ressemblant à …

<!--
- Certains termes décrivent les relations de la première place de la relation avec le nom après le terme:

>**mi jinga se rai le ka clani**
>_Je gagne en étant le plus grand._

se rai
: terme de **se traji**: étant le plus dans …

Ici, $x_1$ de la relation correspond au plus grand en comparaison spécifié après **se rai**.

- Enfin, certains termes décrivent les relations de la première place de la relation et de la relation elle-même avec le nom après le terme:

>**le fragari cu se nelci mi te rai le'i jbari**
>_Parmi les baies, j'aime le plus les fraises._

te rai
: terme de **te traji**: préférant parmi …

lo fragari
: les fraises

lo jbari
: les baies

$x_1$ de la relation décrit le plus grand dans cette comparaison, la relation elle-même décrit la comparaison.

Le dictionnaire explique de tels cas délicats où la relation définie par le terme peut poser des difficultés. En pratique, la relation est souvent claire à partir des exemples fournis. -->

### Utilisation de « **ne**» + terme. « **se mau** » — ‘_plus que …_’

**mi ne se mau do cu melbi**
_Je suis plus joli que toi._

se mau
: terme de **se zmadu**: plus que; la relation elle-même décrit la comparaison

Cet exemple est similaire à

> **mi zmadu do le ka melbi**
> _Je te dépasse en beauté._

En d'autres termes, la relation principale **melbi** est similaire à la troisième place de **zmadu**, qui spécifie les critères de comparaison. Deux autres exemples :

> **mi prami do ne se mau la .doris.**
> _Je t'aime plus que Doris._

<!-- -->

> **mi ne se mau la .doris. cu prami do**
> _Je t'aime plus que Doris ne t'aime._
> _Je t'aime plus que Doris t'aime._
> `Je t'aime (plus que Doris).`

Plus d'exemples :

> **mi nelci le'e pesxu ne se mau le'e jisra**
> _J'aime la confiture plus que le jus._

pesxu
: … être de la confiture

> **le'e pesxu cu zmadu le'e jisra le ka mi nelci**
> _J'aime la confiture plus que le jus._
> `La confiture dépasse le jus en termes de mon appréciation.`

Et maintenant une phrase intéressante :

> _Bob aime Betty plus que Mary._

Cela peut signifier deux choses différentes en anglais !

1. Bob aime Betty et il aime Mary moins.
2. Bob aime Betty mais Mary aime aussi Betty, bien que pas autant que Bob !

Comparons-nous Betty avec Mary dans la façon dont Bob les aime ?

Ou bien comparons-nous Bob avec Mary dans la façon dont ils aiment Betty ?

L'anglais est ambigu à cet égard.

In Lojban, we can differentiate the two meanings by attaching **se mau** to suitable arguments:

> **la .bob. ne se mau la .maris. cu nelci la .betis.**
> _Bob (compared to Mary) likes Betty more. Mary likes Betty less._
> _Bob likes Betty more than Mary._

<!-- -->

> **la .bob. cu nelci la .betis. ne se mau la .maris.**
> _Bob likes Betty, and he like Mary less._
> _Bob likes Betty more than Mary._

### Comparaisons : ‘_égal_’, ‘_le même_’

> **mi dunli le mensi be mi le ka mitre .i ku'i mi na ku du le mensi**
> *Je suis aussi grand que ma sœur, mais je ne suis pas elle.*
> _Je suis égal à ma sœur en mètres, mais je ne suis pas identique à elle._

dunli
: $x_1$ (n'importe quel type) est égal à $x_2$ (n'importe quel type) en $x_3$ (propriété de $x_1$ et $x_2$ avec **kau**)

mitre
: $x_1$ mesure $x_2$ mètres de long

du
: $x_1$ (n'importe quel type) est identique à $x_2$ (n'importe quel type)

**dunli** compare deux endroits pour une seule propriété, tandis que **du** compare pour l'identité. Ma sœur et moi avons la même taille, mais nous ne sommes pas la même personne. Clark Kent et Superman ont des admirateurs différents, mais ils sont la même personne.

Il en va de même pour ces deux verbes :

> **mi frica do le ka nelci ma kau**
> *Nous différons les uns des autres dans ce que nous aimons.*
> _Je diffère de toi en aimant quoi._

<!-- -->

> **le drata be mi cu kakne le ka sidju**
> *Quelqu'un d'autre que moi est capable d'aider.*

frica
: $x_1$ (n'importe quel type) diffère de $x_2$ (n'importe quel type) en $x_3$ (propriété de $x_1$ et $x_2$ avec **kau**)

drata
: $x_1$ (n'importe quel type) n'est pas identique à $x_2$ (n'importe quel type)

### Le concept de « seulement »

> **mi .e no le pendo be mi cu nelci le'e badna**
> _Moi et aucun de mes amis n'aimons les bananes._
> _Parmi mes amis, je suis le seul à aimer les bananes._

Le concept de _non seulement_ est exprimé de manière similaire :

> **mi .e le su'o pendo be mi cu nelci le'e badna**
> _Ce n'est pas seulement moi qui aime les bananes parmi mes amis._
> _Moi et certains de mes amis aimons les bananes._

<!-- Une formulation plus précise :

> **mi se steci le ka nelci le'e badna kei le'i pendo be mi**
> _Je suis le seul à aimer les bananes parmi mes amis._ (ce qui implique que vous êtes votre propre ami)

se steci
: $x_1$ est le seul dans $x_2$ (propriété de $x_1$) parmi $x_3$ (ensemble) -->

<!-- Notez que cet exemple implique que vous êtes votre propre ami :) Sinon, veuillez utiliser une formulation encore plus précise :

> **mi se steci le ka nelci le'e badna kei le'i me mi .e le pendo be mi**
> _Je suis le seul à aimer les bananes parmi l'ensemble de moi et de mes amis._ -->

<!-- En niant cela, nous obtenons :

> **na ku mi se steci le ka nelci le'e badna**
> _Ce n'est pas vrai que je suis le seul à aimer les bananes._

— peut-être que personne n'aime les bananes, peut-être que moi + d'autres les aiment. -->

<!-- Un autre exemple intéressant :

> **le'e troci cu se steci le ka snada**
> _Seul celui qui essaie réussit._
> `Celui qui essaie est le seul à réussir.`

> **le'e po'o zukte be le ka troci cu fliba**
> _Le seul qui essaie échoue._
> `Celui qui essaie et rien d'autre échoue.`

troci
: $x_1$ essaie de faire $x_2$ (propriété de $x_1$)

snada
: $x_1$ réussit à faire $x_2$ (propriété de $x_1$)

fliba
: $x_1$ échoue à faire $x_2$ (propriété de $x_1$)

Et une autre solution :

> **ro snada pu troci**
> _Tout le monde qui réussit a essayé._

ro
: nombre : chaque, tout

Comme vous pouvez le voir, le lojban offre différentes méthodes pour dire la même chose, certaines pouvant différer considérablement des formes anglaises. -->
### « La plupart », « beaucoup » et « trop »

Des mots comme _la plupart_ et _beaucoup_ sont également des nombres en lojban :

<table>
<tbody><tr>
<td><b>ro</b>
</td>
<td><i>chaque</i>
</td></tr>
<tr>
<td><b>so'a</b>
</td>
<td><i>presque tous</i>
</td></tr>
<tr>
<td><b>so'e</b>
</td>
<td><i>la plupart</i>
</td></tr>
<tr>
<td><b>so'i</b>
</td>
<td><i>beaucoup</i>, <i>un grand nombre de</i>
</td></tr>
<tr>
<td><b>so'o</b>
</td>
<td><i>plusieurs</i>
</td></tr>
<tr>
<td><b>so'u</b>
</td>
<td><i>peu</i>
</td></tr>
<tr>
<td><b>no</b>
</td>
<td><i>zéro</i>, <i>aucun</i>
</td></tr>
<tr>
<td><b>su'e</b>
</td>
<td><i>au plus</i>
</td></tr>
<tr>
<td><b>su'o</b>
</td>
<td><i>au moins</i>
</td></tr>
<tr>
<td><b>za'u</b>
</td>
<td><i>plus de …</i>
</td></tr>
<tr>
<td><b>du'e</b>
</td>
<td><i>trop</i>
</td></tr></tbody></table>

Quelques exemples :

> **su'e re no le prenu ba klama**
> _Pas plus de 20 personnes viendront._

<!-- -->

> **su'o pa le prenu cu prami do**
> _Au moins une personne t'aime._

### ‘_never_’ — « **no roi** », ‘_always_’ — « **ro roi** »

Termes spécifiant le nombre de fois :

- **no roi** = _never_
- **pa roi** = _once_
- **re roi** = _twice_
- **ci roi** = _thrice_

…

- **so'i roi** = _many times_
- **so'u roi** = _a few times_
- **du'e roi** = _too many times_
- **ro roi** = _always_

> **mi du'e roi klama le zarci**
> _Je vais trop souvent au marché._

zarci
: $x_1$ est un marché

> **mi pu re roi klama le zarci**
> _Je suis allé au marché deux fois._

Sans **pu**, la construction **re roi** peut signifier que je suis allé au marché une fois mais que la deuxième fois n'arrivera que dans le futur. Ces particules liées au temps peuvent être utilisées avec un argument après elles :

> **mi klama ti pa roi le jeftu**
> _Je viens ici une fois par semaine._
### ‘_for the first time_’ — « **pa re'u** », ‘_for the last time_’ — « **ro re'u** »

- **pa re'u** = _for the first time_
- **re re'u** = _for the second time_

…

- **za'u re'u** = _again_
- **ro re'u** = _for the last time_

La particule liée au temps **re'u** fonctionne comme **roi**, mais indique le nombre d'itérations pour lesquelles l'évènement se produit.

Comparer :

> **mi pa roi klama le muzga**
> _J'ai visité le musée une fois._

<!-- -->

> **mi pa re'u klama le muzga**
> _J'ai visité le musée pour la première fois._

<!-- -->

> **mi za'u roi klama le muzga**
> _J'ai visité le musée plusieurs fois._

<!-- -->

> **mi za'u re'u klama le muzga**
> _J'ai visité le musée à nouveau._

<!-- -->

> **mi za'u pa roi klama le muzga**
> _J'ai visité le musée plus d'une fois._

<!-- -->

> **mi za'u pa re'u klama le muzga**
> _Je ne suis pas allé au musée pour la première fois (peut-être pour la deuxième/troisième, etc.)_

vitke
: visiter (quelqu'un ou quelque chose)

Notez la différence entre :

za'u re'u
: à nouveau, pas pour la première fois

re re'u
: pour la deuxième fois (ici aussi, aucun contexte n'est nécessaire, et même le nombre exact de fois est donné)
### Particules modales : leur emplacement au sein d'une relation


> **le nu tcidu kei ca cu nandu**
> _Lire est maintenant difficile._

<!-- -->

> **ca ku le nu tcidu cu nandu**
> _Maintenant, la lecture est difficile._

Les termes nus sans arguments après eux peuvent être déplacés dans la phrase en ajoutant **ku** après eux.

**ku** empêche les termes-arguments suivants de s'attacher à de tels termes. Comparer :

> **ca le nu tcidu cu nandu**
> _Quand on lit, c'est difficile._

Voici plusieurs endroits où les particules modales peuvent aller.

- Le terme modal modifie la relation à sa droite :

 >**ca ku mi citka**
 >_Maintenant, je mange._

  — ici, le terme est étiqueté avec le mot **ku** comme étant terminé.

 >**ca le cabdei mi citka**
 >_Aujourd'hui, je mange._

  — ici, le terme a un argument après lui.

 >**mi ca citka**
 >_Je mange maintenant._

  — ici, la particule modale fait partie de la construction de la relation principale et sans argument.

- Le terme modal s'applique à toute la relation :

 >**mi citka ca**
 >_Je mange maintenant._

  — ici, le terme modal est à la fin de la relation.

### Joindre des énoncés avec des modaux

> **mi pinxe le jisra ca le nu do co'i klama le zdani**
> _Je bois le jus quand tu rentres à la maison._

<!-- -->

> **mi pinxe le jisra .i ca bo do co'i klama le zdani**
> _Je bois le jus, et en même temps tu rentres à la maison._

Les deux exemples transmettent la même signification. La deuxième option est principalement utilisée lorsque l'une des relations originales semble encombrante.

Une autre utilisation est de déplacer les termes modaux hors de la portée d'autres termes modaux :

> **mi na ku te vecnu ki'u le nu kargu**
> _Ce n'est pas vrai que j'achète parce que c'est cher._

Dans cet exemple, on pourrait supposer que j'achète seulement des choses si elles sont chères. Cependant, ce n'est pas le cas.

Ici, **na ku** nie que _j'achète des choses parce qu'elles sont chères_. **na ku** est appliqué à toute la relation, donc il "couvre" **ki'u**.

> **mi na ku te vecnu .i ki'u bo kargu**
> _Je n'achète pas. C'est parce que c'est cher._

Dans ce cas, je n'achète pas de choses. Pourquoi ? Parce qu'elles sont chères. Peut-être que je préfère seulement les choses bon marché.

Ici, **ki'u** est placé dans une autre phrase. Ainsi, **na ku** ne s'étend pas dessus.

Les deux exemples pourraient être traduits par _Je n'achète pas parce que c'est cher._ Cependant, ils signifient des choses différentes.

Une règle spéciale est pour l'utilisation de **.i ba bo** et **.i pu bo**. Comparez :

> **mi cadzu pu le nu mi citka**
> _Je marche avant de manger._

<!-- -->

> **mi cadzu .i ba bo mi citka**
> _Je marche, puis je mange._

**.i ba bo** signifie _ensuite, puis_. La phrase après **.i ba bo** se réfère à quelque chose qui a eu lieu plus tard que ce qui s'est passé dans la relation avant.

**pu** est changé en **ba**, et vice versa. Cette règle spéciale pour le lojban a été faite par analogie avec les langues naturelles. Vous devez donc simplement vous souvenir de ce comportement spécial de ces deux mots.

### Choses existantes, '_il y a …_'

Il y a en fait trois mots dans la série **da** : **da**, **de** et **di**. Nous les utilisons lorsque nous nous référons à différents objets dans un discours :

> **ci le mlatu cu citka re le finpe**
> _Il y a trois chats, il y a deux poissons pour chaque chat, et chaque chat mange deux poissons._

Si vous avez besoin de plus de mots de ce type dans un discours, ajoutez un suffixe **xi** à ceux-ci, puis un nombre (que nous pouvons appeler un index). Ainsi,

- **da xi pa** est identique à **da** simple,
- **da xi re** est identique à **de**,
- **da xi ci** est identique à **di**
- **da xi vo** est le quatrième "quelque chose" et ainsi de suite…

### Sujet et commentaire. « zo'u »

Parfois, il est utile de montrer le sujet d'une relation et de faire un commentaire à ce sujet :

> **le'e finpe zo'u mi nelci le'e salmone**
> _En ce qui concerne le poisson, j'aime le saumon._

salmone
: … être un saumon

zo'u
: termine le sujet et commence le commentaire de la relation

**zo'u** est plus utile lorsqu'un pronom comme **da** est défini dans le sujet et ensuite utilisé dans le commentaire :

> **su'o da zo'u mi viska da**
> _Il y a une chose telle que je la vois._

<!-- -->

> **ro da poi gerku zo'u mi nelci da**
> _Pour chaque chose qui est un chien : je l'aime._
> _J'aime tous les chiens._

<!-- -->

> **da de zo'u da viska de**
> _Il y a **da** et **de** tels que **da** voit **de**._

Les deux pronoms **da** et **de** indiquent qu'il y a deux choses qui sont en relation, l'une voit l'autre. Il se peut que les deux choses supposées soient en réalité une seule chose qui s'aime elle-même : rien dans la phrase n'exclut cette interprétation, c'est pourquoi la traduction courante ne dit pas _Quelqu'un voit quelqu'un d'autre._ Les choses auxquelles se réfèrent les différents pronoms de la série **da** peuvent être différentes ou identiques.

Il est tout à fait acceptable que ces pronoms apparaissent plusieurs fois dans la même phrase :

> **da zo'u da prami da**
> _Il y a **da** tel que **da** s'aime lui-même. Il y a quelqu'un qui s'aime lui-même._

Il n'est pas nécessaire qu'un pronom soit l'argument direct de la relation :

> **da zo'u le gerku pe da cu viska mi**
> _Il y a **da** tel que son chien me voit. Le chien de quelqu'un me voit._

### ‘_any_’ et ‘_some_’ dans des exemples

Les mots _any_ et _some_, ainsi que leurs dérivés, ont de nombreuses significations en anglais. Nous devons être prudents lors de la traduction de la signification voulue :

Traduction en **da** :

- _some_ : quelque chose de non spécifié :

 >**da pu klama .i je ko smadi le du'u da me ma kau**
 >_Quelqu'un est venu. Devine qui c'était._

  <!-- -->

 >**mi pu tirna da .i je mi fliba le ka jimpe le du'u da mo kau**
 >_J'ai entendu quelque chose, mais je ne parviens pas à comprendre ce que c'était._

- _some_ dans les questions devient _anything_, _anybody_ ; en lojban, c'est toujours **da** :

 >**xu su'o da pu klama**
 >_Est-ce que quelqu'un est venu ?_

- _some_ lors de l'utilisation de commandes, de demandes ou de suggestions :

 >**.e'u mi'o pilno su'o da poi drata**
 >_Essayons autre chose. Essayons d'autres choses._

  <!-- -->

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Essayons ailleurs._

- _any_ peut être utilisé dans des relations internes :

 >**mi rivbi le ka jdice da**
 >_J'ai évité de prendre une décision._

 Comme dans les relations à l'intérieur des termes modaux :

 >**ba le nu do zgana da kei ko klama**
 >_Après avoir remarqué quelque chose, viens !_

- Portée : _any_ est utilisé en anglais lors de la négation, tandis que le lojban utilise **na ku** mais toujours **da** :

 >**mi na ku viska su'o da poi prenu**
 >_Je ne vois personne._

- _any_ est utilisé lorsqu'aucune distinction n'est faite parmi les membres dont nous parlons :

 >**.au nai mi tavla su'o da poi na ku slabu mi**
 >_Je ne veux pas parler à n'importe qui._

- Portée : La négation doit être utilisée dans une relation appropriée, comme indiqué ci-dessous :

 >**mi jinvi le du'u na ku da jimpe**
 >_Je ne pense pas que quelqu'un comprenne._

 Cela peut être reformulé comme suit :

 >**mi jinvi le du'u no da jimpe**
 >_Je pense que personne ne comprend._

- Dans les comparaisons, _every_ est transformé en _any_ et traduit par **ro da** :

 >**do zmadu ro da le ka se canlu**
 >_Tu es plus grand que n'importe qui._
 >`Tu dépasses tout le monde en taille.`

- Lorsqu'il s'agit de choix, _any_ est utilisé et traduit par **ro da** :

 >**ro da poi do nelci zo'u .e'a do citka da**
 >_Tu peux manger ce que tu veux._
 >`Pour tout ce que tu aimes, je te permets de le manger.`

- Pour des termes tels que _anyone_ et _somewhere_ :

 >**.e'u mi'o troci bu'u su'o da poi drata**
 >_Essayons ailleurs._

 Ici, **su'o da poi drata** signifie _n'importe quelle autre chose ou lieu_. Le nombre de ces endroits n'est pas spécifié, bien que n'importe quel endroit de ce type puisse convenir.

 Pour dire _n'importe quel endroit mais seulement un endroit_, utilisez :

 >**.e'u mi'o troci bu'u pa da poi drata**
 >_Essayons à un autre endroit._

- Traduction de _any_ en **le'e** dans des déclarations génériques :

 >**le'e gerku cu se tuple le vo da**
 >_Tout chien a quatre pattes. Les chiens sont censés avoir quatre pattes._

- Utilisation de **le** lors de la description d'objets, de lieux ou d'évènements spécifiques :

 >**le drata zo'u .e'u mi'o pilno ri**
 >_L'autre chose, utilisons-la._

 >**le drata stuzi zo'u .e'u mi'o troci bu'u ri**
 >_L'autre endroit, essayons là-bas._

### Résumé : quels sont les éléments affectés par la portée ?

La portée est créée uniquement par :

- les limites des relations,
- les termes modaux et les particules modales du constructeur de relation principal,
- les terms-arguments commençant par des nombres (comme **pa le prenu** - _l'un des individus_).
<!-- - les interjections discursives **po'o**, **ji'a**. -->

**da**, **de**, **di** s'ils sont utilisés sans préfixe et sans nombre explicite devant sont censés signifier **su'o da**, **su'o de**, **su'o di** et créent donc également une portée.

Ainsi, l'ordre relatif de ces constructions change le sens :

> **pa le prenu ca ku zvati**
> _Il y a une personne qui est maintenant présente._

> **ca ku pa le prenu ca zvati**
> _Maintenant, il y a une personne._

La portée n'est pas pertinente pour les constructions de relation et les arguments commençant par **le** (comme **le prenu** ou **le re prenu**). Les deux phrases signifient la même chose :

> **le prenu ca ku zvati le zdani**
> **ca ku le prenu cu zvati le zdani**
> **ca ku fe le zdani fa le prenu cu zvati**
> _Les gens sont maintenant présents._

La portée du terme modal s'étend de l'endroit où il est utilisé jusqu'à la fin de la relation et de toutes ses relations internes (si elles sont présentes).

Ici, **ki'u le nu kargu** est sous la portée de **na ku** :

> **na ku mi te vecnu ki'u le nu kargu**
> _Ce n'est pas vrai que : j'achète parce que c'est cher._

Mais ici, **ki'u le ne kargu** n'est pas sous la portée de **na ku**. **ki'u** s'applique à toute la phrase précédente, y compris **na ku** :

> **mi na ku te vecnu .i ki'u bo kargu**
> _Je n'achète pas. C'est parce que c'est cher._