## Leçon 4. Pratique

Maintenant que nous connaissons les parties les plus importantes de la grammaire, nous pouvons commencer à accumuler de nouveaux mots à travers des situations.

### Expressions courantes

Voici quelques structures courantes utilisées par les locuteurs courants de lojban, ainsi que des exemples illustrant leur utilisation.

Ils peuvent vous aider à vous habituer plus rapidement au lojban courant.

- <dl><dt>.i ku'i</dt><dd>Mais…</dd></dl>
 > **mi djuno .i ku'i mi na ku djica**
 > _Je sais. Mais je ne veux pas._
- <dl><dt>mi djica le nu</dt><dd>Je veux que …</dd></dl>

 > **mi djica le nu mi sipna**
 > _Je veux dormir._
 > `Je veux que je dorme.`
- <dl><dt>mi djuno le du'u ma kau</dt><dd>Je sais quoi/qui …</dd></dl>

 > **mi djuno le du'u ma kau smuni zo coi**
 > _Je sais ce que signifie **coi**._

 <!-- -->

 > **mi na ku djuno**
 > _Je ne sais pas._
- <dl><dt>jinvi le du'u</dt><dd>… a une opinion que …</dd></dl>

 > **mi jinvi le du'u la .lojban. cu zabna**
 > _Je pense que le lojban est cool._

 <!-- -->

 > **coi ro do**
 > _Bonjour tout le monde !_

 <!-- -->

 > **co'o ro do**
 > _Au revoir tout le monde !_
- <dl><dt>jinvi le du'u</dt><dd>… a une opinion que …</dd></dl>

 > **ai mi cliva .i co'o**
 > _Je vais partir. Au revoir !_
- <dl><dt>.ei mi</dt><dd>Je devrais …</dd></dl>

 > **.ei mi citka .i co'o**
 > _Je devrais manger. Au revoir !_
- <dl><dt>ca le nu</dt><dd>quand …</dd></dl>

 > **mi pu bebna ca le nu mi citno**
 > _J'étais stupide quand j'étais jeune._
- <dl><dt>va'o le nu</dt><dd>à condition que …</dd></dl>

 > **va'o le nu do djica kei mi ka'e ciksi**
 > _Si vous voulez, je peux expliquer._
- <dl><dt>simlu le ka</dt><dd>… semble être …</dd></dl>

 > **simlu le ka zabna**
 > _Ça semble cool._
- <dl><dt>ca le cabdei</dt><dd>aujourd'hui</dd></dl>

 > **pu ce'e ca le cabdei mi surla**
 > _Aujourd'hui, j'ai pris un repos._
- <dl><dt>mi nelci</dt><dd>J'aime</dd></dl>

 > **mi nelci le mlatu**
 > _J'aime le chat._
- <dl><dt>le nu pilno</dt><dd>en utilisant …</dd></dl>

 > **na ku le nu pilno le vlaste cu nandu**
 > _Utiliser des dictionnaires n'est pas difficile._
- <dl><dt>kakne le ka</dt><dd>capable de …</dd></dl>

 > **xu do kakne le ka sutra tavla**
 > _Pouvez-vous parler rapidement ?_
- <dl><dt>tavla fi</dt><dd>parler de …</dd></dl>

 > **.e'ei tavla fi le skami**
 > _Parlons d'ordinateurs !_
- <dl><dt>mutce le ka</dt><dd>très …</dd></dl>

 > **mi mutce le ka se cinri**
 > _Je suis très intéressé._
- <dl><dt>troci le ka</dt><dd>… essaie de …</dd></dl>

 > **mi troci le ka tavla fo la .lojban.**
 > _J'essaie de parler en lojban._
- <dl><dt>rinka le nu</dt><dd>(évènement) conduit à …</dd></dl>

 > **le nu mi tadni la .lojban. cu rinka le nu mi jimpe fi do**
 > _Le fait que j'étudie le lojban me fait vous comprendre._
- <dl><dt>gasnu le nu</dt><dd>(agent) cause …</dd></dl>

 > **mi pu gasnu le nu le skami pe mi co'a spofu**
 > _J'ai fait en sorte que mon ordinateur soit cassé._
- <dl><dt>xusra le du'u</dt><dd>affirmer que …</dd></dl>

 > **xu do xusra le du'u mi na ku drani**
 > _Affirmez-vous que je n'ai pas raison ?_

- <dl><dt>kanpe le du'u</dt><dd>s'attendre (dans le sens d'évaluation, de prédiction) que …</dd></dl>

 <!-- -->

 > **mi na ku kanpe le du'u mi jinga**
 > _Je ne m'attends pas à gagner._

### Un dialogue simple

> **coi la .alis.**
> _Salut, Alice !_
<!-- -->
> **coi la .doris.**
> _Salut, Doris !_
<!-- -->
> **do mo**
> _Comment vas-tu ?_
<!-- -->
> **mi kanro .i mi ca tadni la .lojban. .i mi troci le ka tavla do**
> _Je suis en bonne santé. J'étudie maintenant le lojban. J'essaie de te parler._

kanro
: être en bonne santé

tadni
: étudier … (quelque chose)

troci
: essayer de … (faire quelque chose)

tavla
: parler [à quelqu'un]

> **zabna .i ma tcima ca le bavlamdei**
> _Bien. Quel temps fera-t-il demain ?_

zabna
: … être agréable, frais

tcima
: … être le temps, être du temps

ca
: à (un moment)

le bavlamdei
: jour de demain (jour comme événement)

> **mi na ku djuno .i le solri sei mi pacna**
> _Je ne sais pas. Il fera ensoleillé, j'espère._

djuno
: savoir (un fait)

le solri
: le soleil

Notez que **le solri cu tcima** (littéralement _le soleil est le temps_) est la façon d'utiliser **tcima** en lojban.

sei
: commentaire commence

pacna
: espérer (pour un évènement)

> **mi jimpe**
> _Je comprends._

> **co'o**
> _Au revoir._

### Sens humains

> **ju'i la .alis.**
> _Hé, Alice !_

ju'i
: vocatif qui attire l'attention : _Hé ! Psst ! Ahem ! Attention !_

> **re'i**
> _J'écoute._

re'i
: vocatif : _Je suis prêt à recevoir de l'information._

> **xu do viska ta**
> _Tu vois cette chose près de toi ?_

En anglais, on dit _Can you see_, en lojban on dit simplement **xu do viska** — _Tu vois ?_

----

Les relations liés à la perception seront expliqués après le dialogue.

> **viska .i plise**
> **.i le plise cu xunre .i skari le ka xunre**
> _Oui. C'est une pomme._
> _La pomme est rouge. Elle est de couleur rouge._

> **xu do viska le tarmi be le plise**
> _Peux-tu voir la forme de la pomme ?_

<!-- -->

> **viska .i le plise cu barda**
> _Oui. La pomme est grande._

<!-- -->

> **xu do jinvi le du'u le plise ca makcu**
> _Penses-tu que la pomme est mure ?_

makcu
: … être mûr

> **.au mi zgana le sefta be le plise**
> _J'aimerais la palper._

> **.i ua xutla**
> _Oh, elle est lisse._

> **.i mi pacna le nu makcu ie**
> _J'espère qu'elle est mure, ouais._

<!-- -->

> **panci pei**
> _Et l'odeur ?_

> **.i .e'o do sumne le plise**
> _S'il te plait, sens-la._

<!-- -->

> **le xrula cu panci**
> _Ça sent les fleurs._

> **.i .au mi zgana le vrusi be le plise**
> _J'aimerais gouter la pomme._

> **.i .oi nai le kukte cu vrusi**
> _Miam, elle a un gout sucré._

> **.i .oi**
> _Oh-non._

le xrula
: la/les fleur(s)

<pixra url="/assets/pixra/cilre/xrula.webp" caption="xrula" definition="fleur"></pixra>

> **ma pu fasnu**
> _Qu'est-ce qui s'est passé ?_

<!-- -->

> **mi pu farlu**
> _Je suis tombé._

farlu
: ... tombe à ...

<!-- -->

> **xu do cortu**
> _As-tu mal ?_

<!-- -->

> **cortu .i mi cortu le cidni**
> _Oui, j'ai mal au genou._

> **.i na ku ckape**
> _Ce n'est pas dangereux._

> **.i ca ti mi ganse le nu da vi zvati**
> _Et maintenant, je sens la présence de quelqu'un ici._

<!-- -->

> **doi la .alis. do cliva .e'o sai**
> _Alice, s'il te plait, reviens immédiatement !_

<!-- -->

> **ko denpa .i mi ca tirna le sance**
> _Attends, j'entends un son._

<!-- -->

> **le sance be ma**
> _Un son de quoi ?_

<!-- -->

> **mi pu tirna le nu le prenu cu tavla**
> _J'ai entendu une personne parler._

> **.i ca ti mi zgana le lenku**
> _Maintenant, j'ai froid._

<!-- -->

> **ju'i la .alis.**
> _Hé, Alice !.._

Dans ce dialogue, les concepts les plus importants pour les sens humains ont été abordés. Dans les sections suivantes, nous expliquerons leurs structures de place, ainsi que des relations et des exemples supplémentaires.

#### Vision

viska
: $x_1$ voit $x_2$ (objet, forme, couleur)

skari
: $x_1$ est un objet de couleur $x_2$ (propriété)

tarmi
: $x_1$ est la forme de $x_2$

cukla
: $x_1$ est rond (en forme)

<pixra url="/assets/pixra/cilre/coha_viska.webp" caption="le prenu co'a viska le cipni" definition="La personne remarque, commence à voir l'oiseau."></pixra>

> **mi viska le plise**
> _Je vois la pomme._

> **mi viska le tarmi be le plise**
> _Je vois la forme de la pomme._

> **.i le plise cu se tarmi le cukla**
> _La pomme est ronde._

<!-- -->
<!-- > **mi viska le se skari be le plise**
> _Je vois la couleur de la pomme._ -->

> **.i le plise cu skari le ka xunre**
> _La pomme est de couleur rouge._

Note: nous pouvons dire à la fois "voir la forme de la pomme" et "voir la pomme".
#### Hearing

tirna
: $x_1$ entend $x_2$ (objet ou son)

<pixra url="/assets/pixra/cilre/le_prenu_cu_tirna_lei_djacu.webp" caption="le prenu cu tirna lei djacu" definition="La personne entend les eaux."></pixra>

> **mi tirna le palta**
> _J'entends l'assiette._

<!-- -->

> **mi tirna le sance be le palta poi ca'o porpi**
> _J'entends le son d'une assiette qui tombe._

> **.i le palta cu se sance le cladu**
> _Ça sonne fort._

le palta
: l'assiette

cladu
: $x_1$ est fort

tolycladu
: $x_1$ est assez doux

tonga
: $x_1$ est une tonalité de $x_2$

Nous pouvons utiliser **cladu** et des mots similaires directement :

> **mi tirna le cladu**
> _J'entends quelque chose de fort._

<!-- -->

> **mi tirna le tolycladu**
> _J'entends quelque chose de plutôt doux._

<!-- -->

> **mi tirna le tonga be le palta poi farlu**
> _J'entends la tonalité de l'assiette qui tombe._

De même que pour la vision, nous pouvons dire "entendre un son" et "entendre quelque chose produisant le son" :

> **— ma sance gi'e se tirna do**
> _— Quel son entends-tu ?_

> **— le zgike**
> _— La musique._

<!-- -->

> **— do tirna le sance be ma**
> _— Tu entends un son de quoi ?_

> **— le plise poi co'i farlu**
> _— La pomme qui est tombée._
#### Perception en général

Nous pouvons également utiliser le vague **ganse** — _percevoir un stimulus_.

ganse
: $x_1$ perçoit le stimulus $x_2$ (objet, évènement) par le moyen $x_3$

ganse le glare
: ressentir la chaleur

ganse le lenku
: ressentir le froid

> **mi ganse le plise**
> _Je perçois la pomme._

<!-- -->

Pour observer nos perceptions, nous pouvons utiliser **zgana** :

<pixra url="/assets/pixra/cilre/zgana_le_sefta.webp" caption="le prenu cu zgana le sefta be le xrula" definition="The person palpates the surface of the flower."></pixra>

> **mi zgana le tarmi be le plise**
> _J'observe la forme d'une pomme._

> **.i le plise cu se tarmi le'e cukla**
> _La pomme est ronde._

zgana
: $x_1$ remarque, observe, regarde $x_2$. Pas limité à la vision

Certains arguments peuvent être utilisés avec différents verbes sensoriels. Par exemple, nous pouvons

viska le sefta
: voir la surface

zgana le sefta
: palper la surface

#### Sens de l'odorat

sumne
: $x_1$ sent $x_2$ (odeur)

panci
: $x_1$ est une odeur de $x_2$ (objet)

<pixra url="/assets/pixra/cilre/sumne.webp" caption="le mlatu cu sumne le xrula" definition="Le chat sent la fleur."></pixra>

> **mi sumne le xrula**
> _Je sens la fleur._

<!-- -->

> **mi sumne le panci be le za'u xrula**
> _Je sens l'odeur des fleurs._

<!-- -->

> **mi sumne le panci be le plise**
> _Je sens l'odeur de la pomme._

> **.i le plise cu se panci le xrula**
> _La pomme sent la fleur._

Notez que l'anglais peut être déroutant lorsqu'il s'agit de distinguer entre sentir une odeur et sentir un objet qui produit cette odeur. Nous disons _sentir la pomme_, _la pomme sent les fleurs (a l'odeur des fleurs)_. Cette distinction est importante car une pomme produit des particules aromatiques qui sont distinctes de la pomme elle-même. Il en va de même pour une assiette qui tombe et son bruit — nous ne voulons peut-être pas les mélanger.

En lojban, nous pouvons facilement séparer ces cas, comme le montrent les exemples ci-dessus.

#### Sens du gout

vrusi
: $x_1$ est un gout de $x_2$

<pixra url="/assets/pixra/cilre/se_vrusi_lo_ka_kukte.webp" caption="le prenu cu zgana le vrusi be le grute" definition="La personne goute, observe le gout du fruit."></pixra>

> **mi zgana le vrusi be le grute**
> _Je goute la pomme._
> `J'observe le gout du fruit`

le grute
: le fruit, les fruits
<!-- -->

> **.i le plise cu se vrusi le titla**
> _La pomme a un gout sucré._

titla
: … être sucré, … être un bonbon
#### Sens du toucher

sefta
: $x_1$ est une surface de $x_2$

> **mi zgana le sefta be le plise**
> _Je palpe, je touche la surface de la pomme._

<!-- -->

> **.i le plise cu se sefta le xutla**
> _La pomme a une surface lisse._
#### Douleur

> **mi cortu le birka be mi**
> _J'ai mal au bras._
> _Mon bras fait mal._

<!-- -->

<pixra url="/assets/pixra/cilre/cortu.webp" caption="mi cortu le cidni be mi" definition="Mon genou me fait mal."></pixra>

> **mi cortu le cidni**
> _J'ai mal au genou._

cortu
: $x_1$ ressent de la douleur dans $x_2$ (organe, partie du corps de $x_1$)

cidni
: $x_1$ est un genou de $x_2$

#### Couleurs

Différentes langues utilisent différents ensembles de mots pour désigner les couleurs. Certaines langues se réfèrent simplement aux couleurs en faisant référence à d'autres objets "prototypes" ayant des couleurs, des nuances ou des formes similaires. En lojban, nous utilisons toutes les options :

> **ti xunre**
> _Ceci est rouge._

xunre
: $x_1$ est rouge

> **ti skari le ka xunre**
> _Ceci est rouge. Ceci a la couleur des choses rouges._

<!-- -->

> **ti skari le ka ciblu**
> _Ceci a la couleur du sang._

le ciblu
: le sang

Voici quelques exemples de couleurs qui correspondent à la langue anglaise. Vous pouvez également utiliser d'autres mots de couleur, reflétant la façon dont les locuteurs de différentes langues catégorisent généralement les choses.

> **le tsani cu xunre ca le cerni**
> _Le ciel est rouge le matin._

le tsani
: le ciel

> **.i le solri cu simlu le ka narju**
> _Le soleil semble être orange._

le solri
: le Soleil

<pixra url="/assets/pixra/cilre/tsani.webp" caption="tsani .i solri" definition="Le ciel. Le soleil."></pixra>

simlu
: $x_1$ ressemble à $x_2$ (propriété de $x_1$)

> **.i le pelxu xrula cu se farna le solri**
> _Les fleurs jaunes sont orientées vers le Soleil._

se farna
: $x_1$ est orienté vers $x_2$

farna
: $x_1$ est la direction de $x_2$

> **.i le pezli be le tricu cu crino**
> _Les feuilles des arbres sont vertes._

pezli
: $x_1$ est une feuille de $x_2$

le tricu
: arbre

> **.i mi zvati le korbi be le blanu xamsi**
> _Je suis à la frontière d'une mer bleue._

zvati
: … être présent à …

korbi
: $x_1$ est la frontière de $x_2$

le xamsi
: mer

> **.i mi catlu le prenu noi dasni le zirpu taxfu**
> _Je regarde une personne qui porte une robe violette._

dasni
: $x_1$ porte $x_2$ (quelque chose)

xunre
: $x_1$ est rouge

narju
: $x_1$ est orange

pelxu
: $x_1$ est jaune

crino
: $x_1$ est vert

blanu
: $x_1$ est bleu

zirpu
: $x_1$ est violet

Autres relations utiles :

> **le gusni be le manku pagbu pu na ku carmi**
> _La lumière illuminant les zones sombres n'était pas intense._

<!-- -->

> **le gusni be fi le solri pu carmi**
> _La lumière du Soleil était intense._

gusni
: $x_1$ est une lumière illuminant $x_2$ depuis la source de lumière $x_3$

carmi
: $x_1$ est intense, brillant

manku
: $x_1$ est sombre

### « **sipna** » — ‘_dormir_’, « **sanji** » — ‘_être conscient_’

Les exemples suivants illustrent certains aspects fondamentaux de l'esprit :

> **pu ku mi cikna gi'e ku'i na ganse le nu do klama**
> _J'étais éveillé mais je n'ai pas senti votre arrivée._

<!-- -->

> **pu ku ca le nu mi sipna kei mi ganse ku'i le nu do klama**
> _Pendant que je dormais, j'ai néanmoins senti que vous veniez._

<!-- -->

<pixra url="/assets/pixra/cilre/le_prenu_cu_senva_tuha_le_nei.webp" caption="mi ca'o sipna gi'e sanji le nu mi sipna" definition="Je dors et je suis conscient que je dors."></pixra>

> **pu ku mi ca'o sipna gi'e sanji le nu mi sipna**
> _Je dormais et j'étais conscient que je dormais._
> _Je faisais un rêve lucide._

<!-- -->

> **mi sanji le nu mi sanji**
> _Je suis conscient que je suis conscient._
> _Je suis conscient de moi-même._

sipna
: $x_1$ dort

cikna
: $x_1$ est éveillé

ganse
: l'observateur $x_1$ perçoit, remarque un stimulus (évènement) par l'intermédiaire de $x_3$

sanji
: $x_1$ est conscient, conscient de $x_2$ (évènement)

**ganse** n'implique aucun traitement mental ; il décrit simplement la perception, la reconnaissance, la détection d'un stimulus via des canaux sensoriels (spécifiés dans $x_3$).

D'autre part, **sanji** décrit la perception passive, qui implique un traitement mental mais pas nécessairement via des entrées sensorielles du tout (certaines relations mentales ne sont pas détectées par les sens). 

### Émotions : « **cmila** » — ‘_rire_’, « **cisma** » — ‘_sourire_’

> **coi**
> **.i ma nuzba**
> **.i do simlu le ka badri**
> _Salut._
> _Quoi de neuf ?_
> _Tu sembles triste._

badri
: $x_1$ est triste à propos de $x_2$

<pixra url="/assets/pixra/cilre/badri.webp" caption="le prenu cu simlu lo ka badri" definition="La personne semble être triste."></pixra>

> **mi steba le nu le bruna be mi co'a speni le ninmu**
> _Je suis frustré que mon frère épouse la femme._

steba
: $x_1$ ressent de la frustration à propos de $x_2$

> **mi se cfipu**
> **.i xu do na ku gleki le nu le bruna co'a speni**
> _Je suis confus._
> _Tu n'es pas heureux que ton frère se marie ?_

se cfipu
: $x_1$ est confus à propos de $x_2$

gleki
: $x_1$ est heureux à propos de $x_2$

> **ie**
> **.i le ninmu cu pindi**
> **.i le ninmu na ku ponse le jdini**
> **.i mi na ku kakne le ka ciksi**
> _Oui._
> _La femme est pauvre._
> _Elle n'a pas d'argent._
> _Je ne peux pas expliquer._

le jdini
: l'argent

kakne
: $x_1$ est capable de $x_2$ (propriété de $x_1$)

> **ua**
> **.i la'a do kanpe le nu le ninmu na ku prami le bruna**
> _Ah !_
> _Probablement, tu t'attends à ce que la femme n'aime pas le frère._

la'a
: interjection : probablement, c'est probable

kanpe
: $x_1$ s'attend à $x_2$ (un évènement)

> **mi terpa le nu le ninmu ba tarti lo xlali**
> **.i ku'i le bruna cu cisma ca ro nu ri tavla le ninmu**
> **.i ri ta'e cmila**
> _J'ai peur qu'elle se comporte mal._
> _Mais le frère sourit à chaque fois qu'il parle avec elle._
> _Et elle rit habituellement._

terpa
: $x_1$ a peur de $x_2$

cisma
: $x_1$ sourit

cmila
: $x_1$ rit

> **mi kucli le nu le ninmu cu prami le bruna**
> _Je me demande si la fille aime le frère._

kucli
: $x_1$ est curieux de $x_2$

> **mi na ku kanpe**
> _Je ne m'attends pas à ça._

kanpe
: $x_1$ s'attend à ce que $x_2$ (un évènement) se produise

> **ko surla**
> _Détends-toi !_

surla
: $x_1$ se détend en faisant $x_2$ (propriété de $x_1$)

cinmo
: $x_1$ ressent l'émotion $x_2$ (propriété de $x_1$)

nelci
: $x_1$ aime $x_2$

manci
: $x_1$ ressent de l'admiration ou de l'émerveillement à propos de $x_2$

fengu
: $x_1$ est en colère à propos de $x_2$

xajmi
: $x_1$ pense que $x_2$ est drôle

se zdile
: $x_1$ est amusé par $x_2$

zdile
: $x_1$ est amusant

djica
: $x_1$ désire $x_2$

pacna
: $x_1$ espère que $x_2$ est vrai

### Santé

> **ca glare**
> _Il fait chaud maintenant._

<!-- -->

> **.i ku'i mi ganse le lenku**
 _Mais j'ai froidku'i
: inter : mais, cependant

> **xu do bilma**
> _Es-tu malade ?_

<!-- -->

> **bilma**
> _Oui._

<!-- -->

> **xu do bilma fi le vidru**
> **.i .e'u do klama le mikce**
> _As-tu un virus ? Je te suggère d'aller chez un médecin._

le vidru
: le virus

le mikce
: médecin

> **mi bilma le ka cortu le galxe**
> **.i mi sruma le du'u mi bilma fi la .zukam.**
> _Mes symptômes sont que j'ai mal à la gorge._
> _Je suppose que j'ai un rhume._

cortu
: $x_1$ a mal à $x_2$ (organe, partie du corps de $x_1$)

la .zukam.
: rhume (maladie)

> **ko kanro**
> _Remets-toi bien !_

kanro
: $x_1$ est en bonne santé

> **ki'e**
> _Merci._

bilma
: $x_1$ est malade ou souffre de symptômes $x_2$ de la maladie $x_3$

Notez que le deuxième endroit de **bilma** décrit les symptômes, tels que **le ka cortu le galxe** = _avoir mal à la gorge_. Le troisième endroit indique le nom de la maladie qui cause ces symptômes. Vous pouvez évidemment choisir de ne pas remplir ces endroits de **bilma**.

### Corps humain

> **le nanmu cu se xadni le clani**
> _L'homme a un corps long. L'homme est grand._

se xadni
: $x_1$ a le corps $x_2$

xadni
: $x_1$ est le corps de $x_2$

> **mi pu darxi fi le stedu .e le zunle xance**
> **.i ca ti le degji be le xance cu cortu**
> **.i ku'i le pritu xance na ku cortu**
> _J'ai frappé quelque chose avec la tête et la main gauche. Maintenant, le doigt de la main me fait mal. Mais la main droite ne fait pas mal._

darxi
: $x_1$ frappe $x_2$ avec $x_3$

La plupart des mots pour les parties du corps ont la même structure de place que **xadni** :

stedu
: $x_1$ est une tête de $x_2$

Cependant, certains décrivent des parties plus petites :

degji
: $x_1$ est un doigt/orteil sur la partie $x_2$ (main, pied)

> **le degji be le xance be le ninmu cu clani**
> _Les doigts de la femme sont longs._
> `Les doigts de la main de la femme sont longs`

> **mi viska le jamfu .i ku'i mi na ku viska le degji be le jamfu**
> _Je peux voir les pieds. Mais je ne vois pas les orteils._

janco
: $x_1$ est une articulation reliant les membres $x_2$

ctebi
: $x_1$ est une lèvre de la bouche, orifice $x_2$

cidni
: $x_1$ est un genou ou un coude du membre $x_2$

![](/assets/pixra/cilre/xadni1.svg)

![](/assets/pixra/cilre/xadni2.svg)

### Parenté

> **coi do mi se cmene zo .adam.**
> **.i ti du la .alis.**
> **.i ri speni mi**
> _Bonjour à vous. Je m'appelle "Adam"._
> _Voici Alice._
> _Elle est ma femme._

<!-- -->

> **pluka fa le nu penmi do**
> **.i .e'o do klama le nenri be le dinju**
> _Ravi de vous rencontrer._
> _S'il vous plait, entrez dans la maison._

<!-- -->

> **ki'e**
> _Merci._

<!-- -->

> **.i .au gau mi do co'a slabu le lanzu be mi**
> **.i le re verba cu panzi mi**
> **.i le tixnu cu se cmene zo .flor.**
> **.i la .karl. cu du le bersa**
> _J'aimerais que vous fassiez connaissance avec ma famille._
> _Les deux enfants sont mes descendants._
> _La fille s'appelle "Flor"._
> _Karl est le fils._

<!-- -->

> **la .karl. cu mutce citno**
> _Karl est très jeune._

<!-- -->

> **ie**
> _Oui._

<!-- -->

> **.i ji'a mi se tunba re da noi ca na ku zvati le dinju**
> **.i sa'e mi se tunba le pa bruna .e le pa mensi**
> _J'ai aussi deux frères et sœurs qui ne sont pas actuellement dans la maison._
> _Pour être précis, j'ai un frère et une sœur._

<!-- -->

> **ue**
> **.i le lanzu be do cu barda**
> _Wow !_
> _Votre famille est grande._

<!-- -->

> **je'u pei**
> _Vraiment ?_

je'u
: interjection: vraiment

Les mots pour les noms de membres de la famille ont une structure de lieu similaire:

speni
: $x_1$ est un mari / une femme de $x_2$

**co'a speni** signifie _se marier_ :

> **mi co'a speni la .suzan.**
> _J'ai épousé Susan._

lanzu
: $x_1$ est une famille comprenant $x_2$

panzi
: $x_1$ est un enfant de $x_2$

tixnu
: $x_1$ est une fille de $x_2$

bersa
: $x_1$ est un fils de $x_2$

tunba
: $x_1$ est un frère / une sœur de $x_2$

bruna
: $x_1$ est un frère de $x_2$

mensi
: $x_1$ est une sœur de $x_2$

Notez que **panzi** peut s'appliquer aux enfants adultes :

verba
: $x_1$ est un enfant, une personne immature de l'âge $x_2$ (évènement)

panzi
: $x_1$ est un enfant, un descendant de $x_2$

**verba** ne parle pas nécessairement de l'enfant comme d'un membre de la famille :

> **le bersa be le pendo be mi cu verba le nanca be li ci**
> _Le fils de mon ami est un enfant de trois ans._

citno
: $x_1$ est jeune

laldo
: $x_1$ est vieux, âgé

Paires de mots traditionnels (pour les humains seulement) :

le ninmu
: femme / femmes

le nanmu
: homme mâle / hommes mâles

le nixli
: les filles

le nanla
: les garçons

le remna
: les humains

Notez que **le prenu** signifie _les gens_ ou _les personnes_. Dans les contes de fées et les histoires fantastiques, non seulement les humains (**lo'e remna**) mais aussi les animaux ou les êtres extraterrestres d'autres planètes peuvent être considérés comme des personnes.

Ces mots peuvent être utilisés pour décrire le sexe déterminé génétiquement (chez les animaux et les humains) par opposition au genre :

le fetsi
: la femelle

le nakni
: mâle

Ces mots décrivent les relations parentales (pas nécessairement génétiques) :

mamta
: $x_1$ est une mère de $x_2$, $x_1$ agit maternellement

patfu
: $x_1$ est un père de $x_2$

rirni
: $x_1$ est un parent de $x_2$, $x_1$ élève $x_2$

### Dans le magasin

> **ue**
> **do pu te vecnu le laldo karce**
> _Waouh !_
> _Tu as acheté une vieille voiture._

<!-- -->

> **ie**
> **.i ku'i mi na ku pu pleji le so'i jdini**
> _Oui._
> _Mais je n'ai pas payé beaucoup d'argent._

<!-- -->

> **ma pu jdima le karce**
> _Quel était le prix de la voiture ?_

<!-- -->

> **mi pu pleji le rupnusudu be li pa ki'o le kagni le karce**
> _J'ai payé mille dollars à la compagnie pour la voiture._

<!-- -->

> **mi pu vecnu le laldo karce pe mi le pendo be mi**
> **.i le pendo pu pleji le rupne'uru be li re ki'o mi le karce**
> _J'ai vendu une vieille voiture à mon ami._
> _L'ami a payé 2 000 euros pour la voiture._

ki'o
: virgule entre les chiffres pour que **pa ki'o** soit _1 000_ (_mille_)

vecnu
: $x_1$ vend $x_2$ à $x_3$

te vecnu
: $x_1$ achète $x_2$ de $x_3$

pleji
: $x_1$ paie $x_2$ à $x_3$ pour $x_4$

jdima
: $x_1$ est le prix de $x_2$

jdini
: $x_1$ est de l'argent

rupnusudu
: $x_1$ coute $x_2$ (nombre) dollars américains

rupne'uru
: $x_1$ coute $x_2$ (nombre) euros
### Magasin, bâtiments

> **ma stuzi le zdani be do**
> _Où se trouve ta maison ?_

<!-- -->

> **le korbi be le cmana**
> **.i mi se zdani le nurma**
> **.i le zdani be mi cu barda dinju gi'e se sledi'u ci da .e le vimstu .e le lumstu**
> _Le bord de la montagne._
> _Je vis à la campagne._
> _Ma maison est une grande maison et a trois chambres plus des toilettes plus une salle de bain._

<!-- -->

> **je'e**
> **.i ku'i mi pu jbena le tcadu .i je ca ti mi se zdani le jarbu be la .paris.**
> **.i mi xabju ne'a le zarci**
> _Je vois._
> _Mais je suis né en ville, et maintenant je vis dans la banlieue de Paris._
> _Je vis près d'un magasin._

stuzi
: $x_1$ est un endroit

dinju
: $x_1$ est un bâtiment, une maison

sledi'u
: $x_1$ est une chambre, une partie d'un bâtiment $x_2$

vimstu
: $x_1$ est des toilettes, un endroit pour excreter

lumstu
: $x_1$ est une salle de bain, un endroit pour se laver

zdani
: $x_1$ est une maison de $x_2$

se zdani
: $x_1$ habite dans $x_2$, $x_1$ habite $x_2$

tcadu
: $x_1$ est une ville ou une ville

jarbu
: $x_1$ est une zone suburbaine de la ville/village $x_2$

nurma
: $x_1$ est une zone rurale, $x_1$ est à la campagne

zarci
: $x_1$ est un magasin